# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ChannelArgs', 'Channel']

@pulumi.input_type
class ChannelArgs:
    def __init__(__self__, *,
                 channel_class: pulumi.Input[_builtins.str],
                 destinations: pulumi.Input[Sequence[pulumi.Input['ChannelDestinationArgs']]],
                 encoder_settings: pulumi.Input['ChannelEncoderSettingsArgs'],
                 input_attachments: pulumi.Input[Sequence[pulumi.Input['ChannelInputAttachmentArgs']]],
                 input_specification: pulumi.Input['ChannelInputSpecificationArgs'],
                 cdi_input_specification: Optional[pulumi.Input['ChannelCdiInputSpecificationArgs']] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input['ChannelMaintenanceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 start_channel: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc: Optional[pulumi.Input['ChannelVpcArgs']] = None):
        """
        The set of arguments for constructing a Channel resource.
        :param pulumi.Input[_builtins.str] channel_class: Concise argument description.
        :param pulumi.Input[Sequence[pulumi.Input['ChannelDestinationArgs']]] destinations: Destinations for channel. See Destinations for more details.
        :param pulumi.Input['ChannelEncoderSettingsArgs'] encoder_settings: Encoder settings. See Encoder Settings for more details.
        :param pulumi.Input[Sequence[pulumi.Input['ChannelInputAttachmentArgs']]] input_attachments: Input attachments for the channel. See Input Attachments for more details.
        :param pulumi.Input['ChannelInputSpecificationArgs'] input_specification: Specification of network and file inputs for the channel.
        :param pulumi.Input['ChannelCdiInputSpecificationArgs'] cdi_input_specification: Specification of CDI inputs for this channel. See CDI Input Specification for more details.
        :param pulumi.Input[_builtins.str] log_level: The log level to write to Cloudwatch logs.
        :param pulumi.Input['ChannelMaintenanceArgs'] maintenance: Maintenance settings for this channel. See Maintenance for more details.
        :param pulumi.Input[_builtins.str] name: Name of the Channel.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Concise argument description.
        :param pulumi.Input[_builtins.bool] start_channel: Whether to start/stop channel. Default: `false`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['ChannelVpcArgs'] vpc: Settings for the VPC outputs. See VPC for more details.
        """
        pulumi.set(__self__, "channel_class", channel_class)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "encoder_settings", encoder_settings)
        pulumi.set(__self__, "input_attachments", input_attachments)
        pulumi.set(__self__, "input_specification", input_specification)
        if cdi_input_specification is not None:
            pulumi.set(__self__, "cdi_input_specification", cdi_input_specification)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if start_channel is not None:
            pulumi.set(__self__, "start_channel", start_channel)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @_builtins.property
    @pulumi.getter(name="channelClass")
    def channel_class(self) -> pulumi.Input[_builtins.str]:
        """
        Concise argument description.
        """
        return pulumi.get(self, "channel_class")

    @channel_class.setter
    def channel_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "channel_class", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input['ChannelDestinationArgs']]]:
        """
        Destinations for channel. See Destinations for more details.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input['ChannelDestinationArgs']]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter(name="encoderSettings")
    def encoder_settings(self) -> pulumi.Input['ChannelEncoderSettingsArgs']:
        """
        Encoder settings. See Encoder Settings for more details.
        """
        return pulumi.get(self, "encoder_settings")

    @encoder_settings.setter
    def encoder_settings(self, value: pulumi.Input['ChannelEncoderSettingsArgs']):
        pulumi.set(self, "encoder_settings", value)

    @_builtins.property
    @pulumi.getter(name="inputAttachments")
    def input_attachments(self) -> pulumi.Input[Sequence[pulumi.Input['ChannelInputAttachmentArgs']]]:
        """
        Input attachments for the channel. See Input Attachments for more details.
        """
        return pulumi.get(self, "input_attachments")

    @input_attachments.setter
    def input_attachments(self, value: pulumi.Input[Sequence[pulumi.Input['ChannelInputAttachmentArgs']]]):
        pulumi.set(self, "input_attachments", value)

    @_builtins.property
    @pulumi.getter(name="inputSpecification")
    def input_specification(self) -> pulumi.Input['ChannelInputSpecificationArgs']:
        """
        Specification of network and file inputs for the channel.
        """
        return pulumi.get(self, "input_specification")

    @input_specification.setter
    def input_specification(self, value: pulumi.Input['ChannelInputSpecificationArgs']):
        pulumi.set(self, "input_specification", value)

    @_builtins.property
    @pulumi.getter(name="cdiInputSpecification")
    def cdi_input_specification(self) -> Optional[pulumi.Input['ChannelCdiInputSpecificationArgs']]:
        """
        Specification of CDI inputs for this channel. See CDI Input Specification for more details.
        """
        return pulumi.get(self, "cdi_input_specification")

    @cdi_input_specification.setter
    def cdi_input_specification(self, value: Optional[pulumi.Input['ChannelCdiInputSpecificationArgs']]):
        pulumi.set(self, "cdi_input_specification", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log level to write to Cloudwatch logs.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input['ChannelMaintenanceArgs']]:
        """
        Maintenance settings for this channel. See Maintenance for more details.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input['ChannelMaintenanceArgs']]):
        pulumi.set(self, "maintenance", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Channel.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Concise argument description.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="startChannel")
    def start_channel(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to start/stop channel. Default: `false`
        """
        return pulumi.get(self, "start_channel")

    @start_channel.setter
    def start_channel(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_channel", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input['ChannelVpcArgs']]:
        """
        Settings for the VPC outputs. See VPC for more details.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input['ChannelVpcArgs']]):
        pulumi.set(self, "vpc", value)


@pulumi.input_type
class _ChannelState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 cdi_input_specification: Optional[pulumi.Input['ChannelCdiInputSpecificationArgs']] = None,
                 channel_class: Optional[pulumi.Input[_builtins.str]] = None,
                 channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelDestinationArgs']]]] = None,
                 encoder_settings: Optional[pulumi.Input['ChannelEncoderSettingsArgs']] = None,
                 input_attachments: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelInputAttachmentArgs']]]] = None,
                 input_specification: Optional[pulumi.Input['ChannelInputSpecificationArgs']] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input['ChannelMaintenanceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 start_channel: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc: Optional[pulumi.Input['ChannelVpcArgs']] = None):
        """
        Input properties used for looking up and filtering Channel resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Channel.
        :param pulumi.Input['ChannelCdiInputSpecificationArgs'] cdi_input_specification: Specification of CDI inputs for this channel. See CDI Input Specification for more details.
        :param pulumi.Input[_builtins.str] channel_class: Concise argument description.
        :param pulumi.Input[_builtins.str] channel_id: ID of the Channel.
        :param pulumi.Input[Sequence[pulumi.Input['ChannelDestinationArgs']]] destinations: Destinations for channel. See Destinations for more details.
        :param pulumi.Input['ChannelEncoderSettingsArgs'] encoder_settings: Encoder settings. See Encoder Settings for more details.
        :param pulumi.Input[Sequence[pulumi.Input['ChannelInputAttachmentArgs']]] input_attachments: Input attachments for the channel. See Input Attachments for more details.
        :param pulumi.Input['ChannelInputSpecificationArgs'] input_specification: Specification of network and file inputs for the channel.
        :param pulumi.Input[_builtins.str] log_level: The log level to write to Cloudwatch logs.
        :param pulumi.Input['ChannelMaintenanceArgs'] maintenance: Maintenance settings for this channel. See Maintenance for more details.
        :param pulumi.Input[_builtins.str] name: Name of the Channel.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Concise argument description.
        :param pulumi.Input[_builtins.bool] start_channel: Whether to start/stop channel. Default: `false`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['ChannelVpcArgs'] vpc: Settings for the VPC outputs. See VPC for more details.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cdi_input_specification is not None:
            pulumi.set(__self__, "cdi_input_specification", cdi_input_specification)
        if channel_class is not None:
            pulumi.set(__self__, "channel_class", channel_class)
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if encoder_settings is not None:
            pulumi.set(__self__, "encoder_settings", encoder_settings)
        if input_attachments is not None:
            pulumi.set(__self__, "input_attachments", input_attachments)
        if input_specification is not None:
            pulumi.set(__self__, "input_specification", input_specification)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if start_channel is not None:
            pulumi.set(__self__, "start_channel", start_channel)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Channel.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="cdiInputSpecification")
    def cdi_input_specification(self) -> Optional[pulumi.Input['ChannelCdiInputSpecificationArgs']]:
        """
        Specification of CDI inputs for this channel. See CDI Input Specification for more details.
        """
        return pulumi.get(self, "cdi_input_specification")

    @cdi_input_specification.setter
    def cdi_input_specification(self, value: Optional[pulumi.Input['ChannelCdiInputSpecificationArgs']]):
        pulumi.set(self, "cdi_input_specification", value)

    @_builtins.property
    @pulumi.getter(name="channelClass")
    def channel_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Concise argument description.
        """
        return pulumi.get(self, "channel_class")

    @channel_class.setter
    def channel_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel_class", value)

    @_builtins.property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Channel.
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel_id", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChannelDestinationArgs']]]]:
        """
        Destinations for channel. See Destinations for more details.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter(name="encoderSettings")
    def encoder_settings(self) -> Optional[pulumi.Input['ChannelEncoderSettingsArgs']]:
        """
        Encoder settings. See Encoder Settings for more details.
        """
        return pulumi.get(self, "encoder_settings")

    @encoder_settings.setter
    def encoder_settings(self, value: Optional[pulumi.Input['ChannelEncoderSettingsArgs']]):
        pulumi.set(self, "encoder_settings", value)

    @_builtins.property
    @pulumi.getter(name="inputAttachments")
    def input_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChannelInputAttachmentArgs']]]]:
        """
        Input attachments for the channel. See Input Attachments for more details.
        """
        return pulumi.get(self, "input_attachments")

    @input_attachments.setter
    def input_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelInputAttachmentArgs']]]]):
        pulumi.set(self, "input_attachments", value)

    @_builtins.property
    @pulumi.getter(name="inputSpecification")
    def input_specification(self) -> Optional[pulumi.Input['ChannelInputSpecificationArgs']]:
        """
        Specification of network and file inputs for the channel.
        """
        return pulumi.get(self, "input_specification")

    @input_specification.setter
    def input_specification(self, value: Optional[pulumi.Input['ChannelInputSpecificationArgs']]):
        pulumi.set(self, "input_specification", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log level to write to Cloudwatch logs.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input['ChannelMaintenanceArgs']]:
        """
        Maintenance settings for this channel. See Maintenance for more details.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input['ChannelMaintenanceArgs']]):
        pulumi.set(self, "maintenance", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Channel.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Concise argument description.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="startChannel")
    def start_channel(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to start/stop channel. Default: `false`
        """
        return pulumi.get(self, "start_channel")

    @start_channel.setter
    def start_channel(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_channel", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input['ChannelVpcArgs']]:
        """
        Settings for the VPC outputs. See VPC for more details.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input['ChannelVpcArgs']]):
        pulumi.set(self, "vpc", value)


@pulumi.type_token("aws:medialive/channel:Channel")
class Channel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdi_input_specification: Optional[pulumi.Input[Union['ChannelCdiInputSpecificationArgs', 'ChannelCdiInputSpecificationArgsDict']]] = None,
                 channel_class: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelDestinationArgs', 'ChannelDestinationArgsDict']]]]] = None,
                 encoder_settings: Optional[pulumi.Input[Union['ChannelEncoderSettingsArgs', 'ChannelEncoderSettingsArgsDict']]] = None,
                 input_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelInputAttachmentArgs', 'ChannelInputAttachmentArgsDict']]]]] = None,
                 input_specification: Optional[pulumi.Input[Union['ChannelInputSpecificationArgs', 'ChannelInputSpecificationArgsDict']]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[Union['ChannelMaintenanceArgs', 'ChannelMaintenanceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 start_channel: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc: Optional[pulumi.Input[Union['ChannelVpcArgs', 'ChannelVpcArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS MediaLive Channel.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.medialive.Channel("example",
            name="example-channel",
            channel_class="STANDARD",
            role_arn=example_aws_iam_role["arn"],
            input_specification={
                "codec": "AVC",
                "input_resolution": "HD",
                "maximum_bitrate": "MAX_20_MBPS",
            },
            input_attachments=[{
                "input_attachment_name": "example-input",
                "input_id": example_aws_medialive_input["id"],
            }],
            destinations=[{
                "id": "destination",
                "settings": [
                    {
                        "url": f"s3://{main['id']}/test1",
                    },
                    {
                        "url": f"s3://{main2['id']}/test2",
                    },
                ],
            }],
            encoder_settings={
                "timecode_config": {
                    "source": "EMBEDDED",
                },
                "audio_descriptions": [{
                    "audio_selector_name": "example audio selector",
                    "name": "audio-selector",
                }],
                "video_descriptions": [{
                    "name": "example-video",
                }],
                "output_groups": [{
                    "output_group_settings": {
                        "archive_group_settings": [{
                            "destination": {
                                "destination_ref_id": "destination",
                            },
                        }],
                    },
                    "outputs": [{
                        "output_name": "example-name",
                        "video_description_name": "example-video",
                        "audio_description_names": ["audio-selector"],
                        "output_settings": {
                            "archive_output_settings": {
                                "name_modifier": "_1",
                                "extension": "m2ts",
                                "container_settings": {
                                    "m2ts_settings": {
                                        "audio_buffer_model": "ATSC",
                                        "buffer_model": "MULTIPLEX",
                                        "rate_mode": "CBR",
                                    },
                                },
                            },
                        },
                    }],
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import MediaLive Channel using the `channel_id`. For example:

        ```sh
        $ pulumi import aws:medialive/channel:Channel example 1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ChannelCdiInputSpecificationArgs', 'ChannelCdiInputSpecificationArgsDict']] cdi_input_specification: Specification of CDI inputs for this channel. See CDI Input Specification for more details.
        :param pulumi.Input[_builtins.str] channel_class: Concise argument description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ChannelDestinationArgs', 'ChannelDestinationArgsDict']]]] destinations: Destinations for channel. See Destinations for more details.
        :param pulumi.Input[Union['ChannelEncoderSettingsArgs', 'ChannelEncoderSettingsArgsDict']] encoder_settings: Encoder settings. See Encoder Settings for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ChannelInputAttachmentArgs', 'ChannelInputAttachmentArgsDict']]]] input_attachments: Input attachments for the channel. See Input Attachments for more details.
        :param pulumi.Input[Union['ChannelInputSpecificationArgs', 'ChannelInputSpecificationArgsDict']] input_specification: Specification of network and file inputs for the channel.
        :param pulumi.Input[_builtins.str] log_level: The log level to write to Cloudwatch logs.
        :param pulumi.Input[Union['ChannelMaintenanceArgs', 'ChannelMaintenanceArgsDict']] maintenance: Maintenance settings for this channel. See Maintenance for more details.
        :param pulumi.Input[_builtins.str] name: Name of the Channel.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Concise argument description.
        :param pulumi.Input[_builtins.bool] start_channel: Whether to start/stop channel. Default: `false`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['ChannelVpcArgs', 'ChannelVpcArgsDict']] vpc: Settings for the VPC outputs. See VPC for more details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS MediaLive Channel.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.medialive.Channel("example",
            name="example-channel",
            channel_class="STANDARD",
            role_arn=example_aws_iam_role["arn"],
            input_specification={
                "codec": "AVC",
                "input_resolution": "HD",
                "maximum_bitrate": "MAX_20_MBPS",
            },
            input_attachments=[{
                "input_attachment_name": "example-input",
                "input_id": example_aws_medialive_input["id"],
            }],
            destinations=[{
                "id": "destination",
                "settings": [
                    {
                        "url": f"s3://{main['id']}/test1",
                    },
                    {
                        "url": f"s3://{main2['id']}/test2",
                    },
                ],
            }],
            encoder_settings={
                "timecode_config": {
                    "source": "EMBEDDED",
                },
                "audio_descriptions": [{
                    "audio_selector_name": "example audio selector",
                    "name": "audio-selector",
                }],
                "video_descriptions": [{
                    "name": "example-video",
                }],
                "output_groups": [{
                    "output_group_settings": {
                        "archive_group_settings": [{
                            "destination": {
                                "destination_ref_id": "destination",
                            },
                        }],
                    },
                    "outputs": [{
                        "output_name": "example-name",
                        "video_description_name": "example-video",
                        "audio_description_names": ["audio-selector"],
                        "output_settings": {
                            "archive_output_settings": {
                                "name_modifier": "_1",
                                "extension": "m2ts",
                                "container_settings": {
                                    "m2ts_settings": {
                                        "audio_buffer_model": "ATSC",
                                        "buffer_model": "MULTIPLEX",
                                        "rate_mode": "CBR",
                                    },
                                },
                            },
                        },
                    }],
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import MediaLive Channel using the `channel_id`. For example:

        ```sh
        $ pulumi import aws:medialive/channel:Channel example 1234567
        ```

        :param str resource_name: The name of the resource.
        :param ChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdi_input_specification: Optional[pulumi.Input[Union['ChannelCdiInputSpecificationArgs', 'ChannelCdiInputSpecificationArgsDict']]] = None,
                 channel_class: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelDestinationArgs', 'ChannelDestinationArgsDict']]]]] = None,
                 encoder_settings: Optional[pulumi.Input[Union['ChannelEncoderSettingsArgs', 'ChannelEncoderSettingsArgsDict']]] = None,
                 input_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelInputAttachmentArgs', 'ChannelInputAttachmentArgsDict']]]]] = None,
                 input_specification: Optional[pulumi.Input[Union['ChannelInputSpecificationArgs', 'ChannelInputSpecificationArgsDict']]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[Union['ChannelMaintenanceArgs', 'ChannelMaintenanceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 start_channel: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc: Optional[pulumi.Input[Union['ChannelVpcArgs', 'ChannelVpcArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelArgs.__new__(ChannelArgs)

            __props__.__dict__["cdi_input_specification"] = cdi_input_specification
            if channel_class is None and not opts.urn:
                raise TypeError("Missing required property 'channel_class'")
            __props__.__dict__["channel_class"] = channel_class
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            if encoder_settings is None and not opts.urn:
                raise TypeError("Missing required property 'encoder_settings'")
            __props__.__dict__["encoder_settings"] = encoder_settings
            if input_attachments is None and not opts.urn:
                raise TypeError("Missing required property 'input_attachments'")
            __props__.__dict__["input_attachments"] = input_attachments
            if input_specification is None and not opts.urn:
                raise TypeError("Missing required property 'input_specification'")
            __props__.__dict__["input_specification"] = input_specification
            __props__.__dict__["log_level"] = log_level
            __props__.__dict__["maintenance"] = maintenance
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["start_channel"] = start_channel
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc"] = vpc
            __props__.__dict__["arn"] = None
            __props__.__dict__["channel_id"] = None
            __props__.__dict__["tags_all"] = None
        super(Channel, __self__).__init__(
            'aws:medialive/channel:Channel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            cdi_input_specification: Optional[pulumi.Input[Union['ChannelCdiInputSpecificationArgs', 'ChannelCdiInputSpecificationArgsDict']]] = None,
            channel_class: Optional[pulumi.Input[_builtins.str]] = None,
            channel_id: Optional[pulumi.Input[_builtins.str]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelDestinationArgs', 'ChannelDestinationArgsDict']]]]] = None,
            encoder_settings: Optional[pulumi.Input[Union['ChannelEncoderSettingsArgs', 'ChannelEncoderSettingsArgsDict']]] = None,
            input_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelInputAttachmentArgs', 'ChannelInputAttachmentArgsDict']]]]] = None,
            input_specification: Optional[pulumi.Input[Union['ChannelInputSpecificationArgs', 'ChannelInputSpecificationArgsDict']]] = None,
            log_level: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance: Optional[pulumi.Input[Union['ChannelMaintenanceArgs', 'ChannelMaintenanceArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            start_channel: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc: Optional[pulumi.Input[Union['ChannelVpcArgs', 'ChannelVpcArgsDict']]] = None) -> 'Channel':
        """
        Get an existing Channel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Channel.
        :param pulumi.Input[Union['ChannelCdiInputSpecificationArgs', 'ChannelCdiInputSpecificationArgsDict']] cdi_input_specification: Specification of CDI inputs for this channel. See CDI Input Specification for more details.
        :param pulumi.Input[_builtins.str] channel_class: Concise argument description.
        :param pulumi.Input[_builtins.str] channel_id: ID of the Channel.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ChannelDestinationArgs', 'ChannelDestinationArgsDict']]]] destinations: Destinations for channel. See Destinations for more details.
        :param pulumi.Input[Union['ChannelEncoderSettingsArgs', 'ChannelEncoderSettingsArgsDict']] encoder_settings: Encoder settings. See Encoder Settings for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ChannelInputAttachmentArgs', 'ChannelInputAttachmentArgsDict']]]] input_attachments: Input attachments for the channel. See Input Attachments for more details.
        :param pulumi.Input[Union['ChannelInputSpecificationArgs', 'ChannelInputSpecificationArgsDict']] input_specification: Specification of network and file inputs for the channel.
        :param pulumi.Input[_builtins.str] log_level: The log level to write to Cloudwatch logs.
        :param pulumi.Input[Union['ChannelMaintenanceArgs', 'ChannelMaintenanceArgsDict']] maintenance: Maintenance settings for this channel. See Maintenance for more details.
        :param pulumi.Input[_builtins.str] name: Name of the Channel.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Concise argument description.
        :param pulumi.Input[_builtins.bool] start_channel: Whether to start/stop channel. Default: `false`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['ChannelVpcArgs', 'ChannelVpcArgsDict']] vpc: Settings for the VPC outputs. See VPC for more details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChannelState.__new__(_ChannelState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["cdi_input_specification"] = cdi_input_specification
        __props__.__dict__["channel_class"] = channel_class
        __props__.__dict__["channel_id"] = channel_id
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["encoder_settings"] = encoder_settings
        __props__.__dict__["input_attachments"] = input_attachments
        __props__.__dict__["input_specification"] = input_specification
        __props__.__dict__["log_level"] = log_level
        __props__.__dict__["maintenance"] = maintenance
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["start_channel"] = start_channel
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc"] = vpc
        return Channel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Channel.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="cdiInputSpecification")
    def cdi_input_specification(self) -> pulumi.Output[Optional['outputs.ChannelCdiInputSpecification']]:
        """
        Specification of CDI inputs for this channel. See CDI Input Specification for more details.
        """
        return pulumi.get(self, "cdi_input_specification")

    @_builtins.property
    @pulumi.getter(name="channelClass")
    def channel_class(self) -> pulumi.Output[_builtins.str]:
        """
        Concise argument description.
        """
        return pulumi.get(self, "channel_class")

    @_builtins.property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Channel.
        """
        return pulumi.get(self, "channel_id")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence['outputs.ChannelDestination']]:
        """
        Destinations for channel. See Destinations for more details.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter(name="encoderSettings")
    def encoder_settings(self) -> pulumi.Output['outputs.ChannelEncoderSettings']:
        """
        Encoder settings. See Encoder Settings for more details.
        """
        return pulumi.get(self, "encoder_settings")

    @_builtins.property
    @pulumi.getter(name="inputAttachments")
    def input_attachments(self) -> pulumi.Output[Sequence['outputs.ChannelInputAttachment']]:
        """
        Input attachments for the channel. See Input Attachments for more details.
        """
        return pulumi.get(self, "input_attachments")

    @_builtins.property
    @pulumi.getter(name="inputSpecification")
    def input_specification(self) -> pulumi.Output['outputs.ChannelInputSpecification']:
        """
        Specification of network and file inputs for the channel.
        """
        return pulumi.get(self, "input_specification")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> pulumi.Output[_builtins.str]:
        """
        The log level to write to Cloudwatch logs.
        """
        return pulumi.get(self, "log_level")

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> pulumi.Output['outputs.ChannelMaintenance']:
        """
        Maintenance settings for this channel. See Maintenance for more details.
        """
        return pulumi.get(self, "maintenance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Channel.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Concise argument description.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="startChannel")
    def start_channel(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to start/stop channel. Default: `false`
        """
        return pulumi.get(self, "start_channel")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> pulumi.Output[Optional['outputs.ChannelVpc']]:
        """
        Settings for the VPC outputs. See VPC for more details.
        """
        return pulumi.get(self, "vpc")

