# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterClusterEndpointArgs',
    'ClusterClusterEndpointArgsDict',
    'ClusterShardArgs',
    'ClusterShardArgsDict',
    'ClusterShardNodeArgs',
    'ClusterShardNodeArgsDict',
    'ClusterShardNodeEndpointArgs',
    'ClusterShardNodeEndpointArgsDict',
    'MultiRegionClusterTimeoutsArgs',
    'MultiRegionClusterTimeoutsArgsDict',
    'ParameterGroupParameterArgs',
    'ParameterGroupParameterArgsDict',
    'SnapshotClusterConfigurationArgs',
    'SnapshotClusterConfigurationArgsDict',
    'UserAuthenticationModeArgs',
    'UserAuthenticationModeArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterClusterEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[_builtins.str]]
        """
        DNS hostname of the node.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
elif False:
    ClusterClusterEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterClusterEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] address: DNS hostname of the node.
        :param pulumi.Input[_builtins.int] port: The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS hostname of the node.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class ClusterShardArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeArgsDict']]]]
        """
        Set of nodes in this shard.
        """
        num_nodes: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of individual nodes in this shard.
        """
        slots: NotRequired[pulumi.Input[_builtins.str]]
        """
        Keyspace for this shard. Example: `0-16383`.
        """
elif False:
    ClusterShardArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterShardArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeArgs']]]] = None,
                 num_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 slots: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeArgs']]] nodes: Set of nodes in this shard.
        :param pulumi.Input[_builtins.int] num_nodes: Number of individual nodes in this shard.
        :param pulumi.Input[_builtins.str] slots: Keyspace for this shard. Example: `0-16383`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if num_nodes is not None:
            pulumi.set(__self__, "num_nodes", num_nodes)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeArgs']]]]:
        """
        Set of nodes in this shard.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of individual nodes in this shard.
        """
        return pulumi.get(self, "num_nodes")

    @num_nodes.setter
    def num_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_nodes", value)

    @_builtins.property
    @pulumi.getter
    def slots(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Keyspace for this shard. Example: `0-16383`.
        """
        return pulumi.get(self, "slots")

    @slots.setter
    def slots(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slots", value)


if not MYPY:
    class ClusterShardNodeArgsDict(TypedDict):
        availability_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Availability Zone in which the node resides.
        """
        create_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
        """
        endpoints: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeEndpointArgsDict']]]]
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
elif False:
    ClusterShardNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterShardNodeArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeEndpointArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] availability_zone: The Availability Zone in which the node resides.
        :param pulumi.Input[_builtins.str] create_time: The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
        :param pulumi.Input[_builtins.str] name: Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Availability Zone in which the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeEndpointArgs']]]]:
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterShardNodeEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class ClusterShardNodeEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[_builtins.str]]
        """
        DNS hostname of the node.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
elif False:
    ClusterShardNodeEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterShardNodeEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] address: DNS hostname of the node.
        :param pulumi.Input[_builtins.int] port: The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS hostname of the node.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class MultiRegionClusterTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[_builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[_builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        update: NotRequired[pulumi.Input[_builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    MultiRegionClusterTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MultiRegionClusterTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.str]] = None,
                 update: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[_builtins.str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[_builtins.str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update", value)


if not MYPY:
    class ParameterGroupParameterArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the parameter.
        """
        value: pulumi.Input[_builtins.str]
        """
        The value of the parameter.
        """
elif False:
    ParameterGroupParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ParameterGroupParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The name of the parameter.
        :param pulumi.Input[_builtins.str] value: The value of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class SnapshotClusterConfigurationArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description for the cluster.
        """
        engine: NotRequired[pulumi.Input[_builtins.str]]
        """
        The engine that will run on cluster nodes.
        """
        engine_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Version number of the engine used by the cluster.
        """
        maintenance_window: NotRequired[pulumi.Input[_builtins.str]]
        """
        The weekly time range during which maintenance on the cluster is performed.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the snapshot. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        node_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Compute and memory capacity of the nodes in the cluster.
        """
        num_shards: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of shards in the cluster.
        """
        parameter_group_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the parameter group associated with the cluster.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Port number on which the cluster accepts connections.
        """
        snapshot_retention_limit: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of days for which MemoryDB retains automatic snapshots before deleting them.
        """
        snapshot_window: NotRequired[pulumi.Input[_builtins.str]]
        """
        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
        """
        subnet_group_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the subnet group used by the cluster.
        """
        topic_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        ARN of the SNS topic to which cluster notifications are sent.
        """
        vpc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The VPC in which the cluster exists.
        """
elif False:
    SnapshotClusterConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SnapshotClusterConfigurationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[_builtins.int]] = None,
                 parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] description: Description for the cluster.
        :param pulumi.Input[_builtins.str] engine: The engine that will run on cluster nodes.
        :param pulumi.Input[_builtins.str] engine_version: Version number of the engine used by the cluster.
        :param pulumi.Input[_builtins.str] maintenance_window: The weekly time range during which maintenance on the cluster is performed.
        :param pulumi.Input[_builtins.str] name: Name of the snapshot. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] node_type: Compute and memory capacity of the nodes in the cluster.
        :param pulumi.Input[_builtins.int] num_shards: Number of shards in the cluster.
        :param pulumi.Input[_builtins.str] parameter_group_name: Name of the parameter group associated with the cluster.
        :param pulumi.Input[_builtins.int] port: Port number on which the cluster accepts connections.
        :param pulumi.Input[_builtins.int] snapshot_retention_limit: Number of days for which MemoryDB retains automatic snapshots before deleting them.
        :param pulumi.Input[_builtins.str] snapshot_window: The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
        :param pulumi.Input[_builtins.str] subnet_group_name: Name of the subnet group used by the cluster.
        :param pulumi.Input[_builtins.str] topic_arn: ARN of the SNS topic to which cluster notifications are sent.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC in which the cluster exists.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if num_shards is not None:
            pulumi.set(__self__, "num_shards", num_shards)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if subnet_group_name is not None:
            pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine that will run on cluster nodes.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of the engine used by the cluster.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The weekly time range during which maintenance on the cluster is performed.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the snapshot. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compute and memory capacity of the nodes in the cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of shards in the cluster.
        """
        return pulumi.get(self, "num_shards")

    @num_shards.setter
    def num_shards(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_shards", value)

    @_builtins.property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the parameter group associated with the cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter_group_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port number on which the cluster accepts connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days for which MemoryDB retains automatic snapshots before deleting them.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @_builtins.property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
        """
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_window", value)

    @_builtins.property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subnet group used by the cluster.
        """
        return pulumi.get(self, "subnet_group_name")

    @subnet_group_name.setter
    def subnet_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_group_name", value)

    @_builtins.property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the SNS topic to which cluster notifications are sent.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC in which the cluster exists.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class UserAuthenticationModeArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the authentication type. Valid values are: `password` or `iam`.
        """
        password_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of passwords belonging to the user if `type` is set to `password`.
        """
        passwords: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
        """
elif False:
    UserAuthenticationModeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserAuthenticationModeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 password_count: Optional[pulumi.Input[_builtins.int]] = None,
                 passwords: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the authentication type. Valid values are: `password` or `iam`.
        :param pulumi.Input[_builtins.int] password_count: Number of passwords belonging to the user if `type` is set to `password`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passwords: Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
        """
        pulumi.set(__self__, "type", type)
        if password_count is not None:
            pulumi.set(__self__, "password_count", password_count)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the authentication type. Valid values are: `password` or `iam`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="passwordCount")
    def password_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of passwords belonging to the user if `type` is set to `password`.
        """
        return pulumi.get(self, "password_count")

    @password_count.setter
    def password_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_count", value)

    @_builtins.property
    @pulumi.getter
    def passwords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
        """
        return pulumi.get(self, "passwords")

    @passwords.setter
    def passwords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passwords", value)


