# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBrokerEngineTypesResult',
    'AwaitableGetBrokerEngineTypesResult',
    'get_broker_engine_types',
    'get_broker_engine_types_output',
]

@pulumi.output_type
class GetBrokerEngineTypesResult:
    """
    A collection of values returned by getBrokerEngineTypes.
    """
    def __init__(__self__, broker_engine_types=None, engine_type=None, id=None, region=None):
        if broker_engine_types and not isinstance(broker_engine_types, list):
            raise TypeError("Expected argument 'broker_engine_types' to be a list")
        pulumi.set(__self__, "broker_engine_types", broker_engine_types)
        if engine_type and not isinstance(engine_type, str):
            raise TypeError("Expected argument 'engine_type' to be a str")
        pulumi.set(__self__, "engine_type", engine_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="brokerEngineTypes")
    def broker_engine_types(self) -> Sequence['outputs.GetBrokerEngineTypesBrokerEngineTypeResult']:
        """
        List of available engine types and versions. See Engine Types.
        """
        return pulumi.get(self, "broker_engine_types")

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[_builtins.str]:
        """
        Broker's engine type.
        """
        return pulumi.get(self, "engine_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetBrokerEngineTypesResult(GetBrokerEngineTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBrokerEngineTypesResult(
            broker_engine_types=self.broker_engine_types,
            engine_type=self.engine_type,
            id=self.id,
            region=self.region)


def get_broker_engine_types(engine_type: Optional[_builtins.str] = None,
                            region: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBrokerEngineTypesResult:
    """
    Provides details about available MQ broker engine types. Use this data source to retrieve supported engine types and their versions for Amazon MQ brokers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.mq.get_broker_engine_types(engine_type="ACTIVEMQ")
    ```


    :param _builtins.str engine_type: MQ engine type to return version details for.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['engineType'] = engine_type
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:mq/getBrokerEngineTypes:getBrokerEngineTypes', __args__, opts=opts, typ=GetBrokerEngineTypesResult).value

    return AwaitableGetBrokerEngineTypesResult(
        broker_engine_types=pulumi.get(__ret__, 'broker_engine_types'),
        engine_type=pulumi.get(__ret__, 'engine_type'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_broker_engine_types_output(engine_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBrokerEngineTypesResult]:
    """
    Provides details about available MQ broker engine types. Use this data source to retrieve supported engine types and their versions for Amazon MQ brokers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.mq.get_broker_engine_types(engine_type="ACTIVEMQ")
    ```


    :param _builtins.str engine_type: MQ engine type to return version details for.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['engineType'] = engine_type
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:mq/getBrokerEngineTypes:getBrokerEngineTypes', __args__, opts=opts, typ=GetBrokerEngineTypesResult)
    return __ret__.apply(lambda __response__: GetBrokerEngineTypesResult(
        broker_engine_types=pulumi.get(__response__, 'broker_engine_types'),
        engine_type=pulumi.get(__response__, 'engine_type'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
