# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClusterInstanceArgs', 'ClusterInstance']

@pulumi.input_type
class ClusterInstanceArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[_builtins.str],
                 instance_class: pulumi.Input[_builtins.str],
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 neptune_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 neptune_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_tier: Optional[pulumi.Input[_builtins.int]] = None,
                 publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ClusterInstance resource.
        :param pulumi.Input[_builtins.str] cluster_identifier: The identifier of the `neptune.Cluster` in which to launch this instance.
        :param pulumi.Input[_builtins.str] instance_class: The instance class to use.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any instance modifications
               are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[_builtins.bool] auto_minor_version_upgrade: Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
        :param pulumi.Input[_builtins.str] availability_zone: The EC2 Availability Zone that the neptune instance is created in.
        :param pulumi.Input[_builtins.str] engine: The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
        :param pulumi.Input[_builtins.str] engine_version: The neptune engine version. Currently configuring this argumnet has no effect.
        :param pulumi.Input[_builtins.str] identifier: The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
        :param pulumi.Input[_builtins.str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[_builtins.str] neptune_parameter_group_name: The name of the neptune parameter group to associate with this instance.
        :param pulumi.Input[_builtins.str] neptune_subnet_group_name: A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `neptune.Cluster`.
        :param pulumi.Input[_builtins.int] port: The port on which the DB accepts connections. Defaults to `8182`.
        :param pulumi.Input[_builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
        :param pulumi.Input[_builtins.str] preferred_maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[_builtins.int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        :param pulumi.Input[_builtins.bool] publicly_accessible: Bool to control if instance is publicly accessible. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_final_snapshot: Determines whether a final DB snapshot is created before the DB instance is deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        pulumi.set(__self__, "instance_class", instance_class)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if identifier_prefix is not None:
            pulumi.set(__self__, "identifier_prefix", identifier_prefix)
        if neptune_parameter_group_name is not None:
            pulumi.set(__self__, "neptune_parameter_group_name", neptune_parameter_group_name)
        if neptune_subnet_group_name is not None:
            pulumi.set(__self__, "neptune_subnet_group_name", neptune_subnet_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if promotion_tier is not None:
            pulumi.set(__self__, "promotion_tier", promotion_tier)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the `neptune.Cluster` in which to launch this instance.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_identifier", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Input[_builtins.str]:
        """
        The instance class to use.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether any instance modifications
        are applied immediately, or during the next maintenance window. Default is`false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EC2 Availability Zone that the neptune instance is created in.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The neptune engine version. Currently configuring this argumnet has no effect.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @identifier_prefix.setter
    def identifier_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier_prefix", value)

    @_builtins.property
    @pulumi.getter(name="neptuneParameterGroupName")
    def neptune_parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the neptune parameter group to associate with this instance.
        """
        return pulumi.get(self, "neptune_parameter_group_name")

    @neptune_parameter_group_name.setter
    def neptune_parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "neptune_parameter_group_name", value)

    @_builtins.property
    @pulumi.getter(name="neptuneSubnetGroupName")
    def neptune_subnet_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `neptune.Cluster`.
        """
        return pulumi.get(self, "neptune_subnet_group_name")

    @neptune_subnet_group_name.setter
    def neptune_subnet_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "neptune_subnet_group_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which the DB accepts connections. Defaults to `8182`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @_builtins.property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The window to perform maintenance in.
        Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        """
        return pulumi.get(self, "promotion_tier")

    @promotion_tier.setter
    def promotion_tier(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "promotion_tier", value)

    @_builtins.property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Bool to control if instance is publicly accessible. Default is `false`.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether a final DB snapshot is created before the DB instance is deleted.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterInstanceState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 dbi_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 neptune_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 neptune_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_tier: Optional[pulumi.Input[_builtins.int]] = None,
                 publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 writer: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ClusterInstance resources.
        :param pulumi.Input[_builtins.str] address: The hostname of the instance. See also `endpoint` and `port`.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any instance modifications
               are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of neptune instance
        :param pulumi.Input[_builtins.bool] auto_minor_version_upgrade: Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
        :param pulumi.Input[_builtins.str] availability_zone: The EC2 Availability Zone that the neptune instance is created in.
        :param pulumi.Input[_builtins.str] cluster_identifier: The identifier of the `neptune.Cluster` in which to launch this instance.
        :param pulumi.Input[_builtins.str] dbi_resource_id: The region-unique, immutable identifier for the neptune instance.
        :param pulumi.Input[_builtins.str] endpoint: The connection endpoint in `address:port` format.
        :param pulumi.Input[_builtins.str] engine: The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
        :param pulumi.Input[_builtins.str] engine_version: The neptune engine version. Currently configuring this argumnet has no effect.
        :param pulumi.Input[_builtins.str] identifier: The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
        :param pulumi.Input[_builtins.str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[_builtins.str] instance_class: The instance class to use.
        :param pulumi.Input[_builtins.str] kms_key_arn: The ARN for the KMS encryption key if one is set to the neptune cluster.
        :param pulumi.Input[_builtins.str] neptune_parameter_group_name: The name of the neptune parameter group to associate with this instance.
        :param pulumi.Input[_builtins.str] neptune_subnet_group_name: A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `neptune.Cluster`.
        :param pulumi.Input[_builtins.int] port: The port on which the DB accepts connections. Defaults to `8182`.
        :param pulumi.Input[_builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
        :param pulumi.Input[_builtins.str] preferred_maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[_builtins.int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        :param pulumi.Input[_builtins.bool] publicly_accessible: Bool to control if instance is publicly accessible. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_final_snapshot: Determines whether a final DB snapshot is created before the DB instance is deleted.
        :param pulumi.Input[_builtins.bool] storage_encrypted: Specifies whether the neptune cluster is encrypted.
        :param pulumi.Input[_builtins.str] storage_type: Storage type associated with the cluster `standard/iopt1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] writer: Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if dbi_resource_id is not None:
            pulumi.set(__self__, "dbi_resource_id", dbi_resource_id)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if identifier_prefix is not None:
            pulumi.set(__self__, "identifier_prefix", identifier_prefix)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if neptune_parameter_group_name is not None:
            pulumi.set(__self__, "neptune_parameter_group_name", neptune_parameter_group_name)
        if neptune_subnet_group_name is not None:
            pulumi.set(__self__, "neptune_subnet_group_name", neptune_subnet_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if promotion_tier is not None:
            pulumi.set(__self__, "promotion_tier", promotion_tier)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if writer is not None:
            pulumi.set(__self__, "writer", writer)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname of the instance. See also `endpoint` and `port`.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether any instance modifications
        are applied immediately, or during the next maintenance window. Default is`false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of neptune instance
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EC2 Availability Zone that the neptune instance is created in.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the `neptune.Cluster` in which to launch this instance.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_identifier", value)

    @_builtins.property
    @pulumi.getter(name="dbiResourceId")
    def dbi_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region-unique, immutable identifier for the neptune instance.
        """
        return pulumi.get(self, "dbi_resource_id")

    @dbi_resource_id.setter
    def dbi_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbi_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection endpoint in `address:port` format.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The neptune engine version. Currently configuring this argumnet has no effect.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @identifier_prefix.setter
    def identifier_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier_prefix", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance class to use.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN for the KMS encryption key if one is set to the neptune cluster.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="neptuneParameterGroupName")
    def neptune_parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the neptune parameter group to associate with this instance.
        """
        return pulumi.get(self, "neptune_parameter_group_name")

    @neptune_parameter_group_name.setter
    def neptune_parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "neptune_parameter_group_name", value)

    @_builtins.property
    @pulumi.getter(name="neptuneSubnetGroupName")
    def neptune_subnet_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `neptune.Cluster`.
        """
        return pulumi.get(self, "neptune_subnet_group_name")

    @neptune_subnet_group_name.setter
    def neptune_subnet_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "neptune_subnet_group_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which the DB accepts connections. Defaults to `8182`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @_builtins.property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The window to perform maintenance in.
        Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        """
        return pulumi.get(self, "promotion_tier")

    @promotion_tier.setter
    def promotion_tier(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "promotion_tier", value)

    @_builtins.property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Bool to control if instance is publicly accessible. Default is `false`.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether a final DB snapshot is created before the DB instance is deleted.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the neptune cluster is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage type associated with the cluster `standard/iopt1`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def writer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        return pulumi.get(self, "writer")

    @writer.setter
    def writer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "writer", value)


@pulumi.type_token("aws:neptune/clusterInstance:ClusterInstance")
class ClusterInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 neptune_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 neptune_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_tier: Optional[pulumi.Input[_builtins.int]] = None,
                 publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        A Cluster Instance Resource defines attributes that are specific to a single instance in a Neptune Cluster.

        You can simply add neptune instances and Neptune manages the replication. You can use the count
        meta-parameter to make multiple instances and join them all to the same Neptune Cluster, or you may specify different Cluster Instance resources with various `instance_class` sizes.

        ## Example Usage

        The following example will create a neptune cluster with two neptune instances(one writer and one reader).

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.neptune.Cluster("default",
            cluster_identifier="neptune-cluster-demo",
            engine="neptune",
            backup_retention_period=5,
            preferred_backup_window="07:00-09:00",
            skip_final_snapshot=True,
            iam_database_authentication_enabled=True,
            apply_immediately=True)
        example = []
        for range in [{"value": i} for i in range(0, 2)]:
            example.append(aws.neptune.ClusterInstance(f"example-{range['value']}",
                cluster_identifier=default.id,
                engine="neptune",
                instance_class="db.r4.large",
                apply_immediately=True))
        ```

        ## Import

        Using `pulumi import`, import `aws_neptune_cluster_instance` using the instance identifier. For example:

        ```sh
        $ pulumi import aws:neptune/clusterInstance:ClusterInstance example my-instance
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any instance modifications
               are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[_builtins.bool] auto_minor_version_upgrade: Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
        :param pulumi.Input[_builtins.str] availability_zone: The EC2 Availability Zone that the neptune instance is created in.
        :param pulumi.Input[_builtins.str] cluster_identifier: The identifier of the `neptune.Cluster` in which to launch this instance.
        :param pulumi.Input[_builtins.str] engine: The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
        :param pulumi.Input[_builtins.str] engine_version: The neptune engine version. Currently configuring this argumnet has no effect.
        :param pulumi.Input[_builtins.str] identifier: The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
        :param pulumi.Input[_builtins.str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[_builtins.str] instance_class: The instance class to use.
        :param pulumi.Input[_builtins.str] neptune_parameter_group_name: The name of the neptune parameter group to associate with this instance.
        :param pulumi.Input[_builtins.str] neptune_subnet_group_name: A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `neptune.Cluster`.
        :param pulumi.Input[_builtins.int] port: The port on which the DB accepts connections. Defaults to `8182`.
        :param pulumi.Input[_builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
        :param pulumi.Input[_builtins.str] preferred_maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[_builtins.int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        :param pulumi.Input[_builtins.bool] publicly_accessible: Bool to control if instance is publicly accessible. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_final_snapshot: Determines whether a final DB snapshot is created before the DB instance is deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cluster Instance Resource defines attributes that are specific to a single instance in a Neptune Cluster.

        You can simply add neptune instances and Neptune manages the replication. You can use the count
        meta-parameter to make multiple instances and join them all to the same Neptune Cluster, or you may specify different Cluster Instance resources with various `instance_class` sizes.

        ## Example Usage

        The following example will create a neptune cluster with two neptune instances(one writer and one reader).

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.neptune.Cluster("default",
            cluster_identifier="neptune-cluster-demo",
            engine="neptune",
            backup_retention_period=5,
            preferred_backup_window="07:00-09:00",
            skip_final_snapshot=True,
            iam_database_authentication_enabled=True,
            apply_immediately=True)
        example = []
        for range in [{"value": i} for i in range(0, 2)]:
            example.append(aws.neptune.ClusterInstance(f"example-{range['value']}",
                cluster_identifier=default.id,
                engine="neptune",
                instance_class="db.r4.large",
                apply_immediately=True))
        ```

        ## Import

        Using `pulumi import`, import `aws_neptune_cluster_instance` using the instance identifier. For example:

        ```sh
        $ pulumi import aws:neptune/clusterInstance:ClusterInstance example my-instance
        ```

        :param str resource_name: The name of the resource.
        :param ClusterInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 neptune_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 neptune_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
                 promotion_tier: Optional[pulumi.Input[_builtins.int]] = None,
                 publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterInstanceArgs.__new__(ClusterInstanceArgs)

            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["availability_zone"] = availability_zone
            if cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_identifier'")
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["identifier_prefix"] = identifier_prefix
            if instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'instance_class'")
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["neptune_parameter_group_name"] = neptune_parameter_group_name
            __props__.__dict__["neptune_subnet_group_name"] = neptune_subnet_group_name
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_backup_window"] = preferred_backup_window
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["promotion_tier"] = promotion_tier
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["region"] = region
            __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
            __props__.__dict__["tags"] = tags
            __props__.__dict__["address"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["dbi_resource_id"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["kms_key_arn"] = None
            __props__.__dict__["storage_encrypted"] = None
            __props__.__dict__["storage_type"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["writer"] = None
        super(ClusterInstance, __self__).__init__(
            'aws:neptune/clusterInstance:ClusterInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            apply_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            auto_minor_version_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            dbi_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            identifier_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            instance_class: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            neptune_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            neptune_subnet_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            preferred_backup_window: Optional[pulumi.Input[_builtins.str]] = None,
            preferred_maintenance_window: Optional[pulumi.Input[_builtins.str]] = None,
            promotion_tier: Optional[pulumi.Input[_builtins.int]] = None,
            publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            skip_final_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            writer: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ClusterInstance':
        """
        Get an existing ClusterInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The hostname of the instance. See also `endpoint` and `port`.
        :param pulumi.Input[_builtins.bool] apply_immediately: Specifies whether any instance modifications
               are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of neptune instance
        :param pulumi.Input[_builtins.bool] auto_minor_version_upgrade: Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
        :param pulumi.Input[_builtins.str] availability_zone: The EC2 Availability Zone that the neptune instance is created in.
        :param pulumi.Input[_builtins.str] cluster_identifier: The identifier of the `neptune.Cluster` in which to launch this instance.
        :param pulumi.Input[_builtins.str] dbi_resource_id: The region-unique, immutable identifier for the neptune instance.
        :param pulumi.Input[_builtins.str] endpoint: The connection endpoint in `address:port` format.
        :param pulumi.Input[_builtins.str] engine: The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
        :param pulumi.Input[_builtins.str] engine_version: The neptune engine version. Currently configuring this argumnet has no effect.
        :param pulumi.Input[_builtins.str] identifier: The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
        :param pulumi.Input[_builtins.str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[_builtins.str] instance_class: The instance class to use.
        :param pulumi.Input[_builtins.str] kms_key_arn: The ARN for the KMS encryption key if one is set to the neptune cluster.
        :param pulumi.Input[_builtins.str] neptune_parameter_group_name: The name of the neptune parameter group to associate with this instance.
        :param pulumi.Input[_builtins.str] neptune_subnet_group_name: A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `neptune.Cluster`.
        :param pulumi.Input[_builtins.int] port: The port on which the DB accepts connections. Defaults to `8182`.
        :param pulumi.Input[_builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
        :param pulumi.Input[_builtins.str] preferred_maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[_builtins.int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        :param pulumi.Input[_builtins.bool] publicly_accessible: Bool to control if instance is publicly accessible. Default is `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_final_snapshot: Determines whether a final DB snapshot is created before the DB instance is deleted.
        :param pulumi.Input[_builtins.bool] storage_encrypted: Specifies whether the neptune cluster is encrypted.
        :param pulumi.Input[_builtins.str] storage_type: Storage type associated with the cluster `standard/iopt1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] writer: Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterInstanceState.__new__(_ClusterInstanceState)

        __props__.__dict__["address"] = address
        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["dbi_resource_id"] = dbi_resource_id
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["identifier_prefix"] = identifier_prefix
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["neptune_parameter_group_name"] = neptune_parameter_group_name
        __props__.__dict__["neptune_subnet_group_name"] = neptune_subnet_group_name
        __props__.__dict__["port"] = port
        __props__.__dict__["preferred_backup_window"] = preferred_backup_window
        __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
        __props__.__dict__["promotion_tier"] = promotion_tier
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["region"] = region
        __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
        __props__.__dict__["storage_encrypted"] = storage_encrypted
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["writer"] = writer
        return ClusterInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname of the instance. See also `endpoint` and `port`.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether any instance modifications
        are applied immediately, or during the next maintenance window. Default is`false`.
        """
        return pulumi.get(self, "apply_immediately")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of neptune instance
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The EC2 Availability Zone that the neptune instance is created in.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the `neptune.Cluster` in which to launch this instance.
        """
        return pulumi.get(self, "cluster_identifier")

    @_builtins.property
    @pulumi.getter(name="dbiResourceId")
    def dbi_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region-unique, immutable identifier for the neptune instance.
        """
        return pulumi.get(self, "dbi_resource_id")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The connection endpoint in `address:port` format.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        The neptune engine version. Currently configuring this argumnet has no effect.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[_builtins.str]:
        """
        The instance class to use.
        """
        return pulumi.get(self, "instance_class")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN for the KMS encryption key if one is set to the neptune cluster.
        """
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="neptuneParameterGroupName")
    def neptune_parameter_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the neptune parameter group to associate with this instance.
        """
        return pulumi.get(self, "neptune_parameter_group_name")

    @_builtins.property
    @pulumi.getter(name="neptuneSubnetGroupName")
    def neptune_subnet_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `neptune.Cluster`.
        """
        return pulumi.get(self, "neptune_subnet_group_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The port on which the DB accepts connections. Defaults to `8182`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[_builtins.str]:
        """
        The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
        """
        return pulumi.get(self, "preferred_backup_window")

    @_builtins.property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[_builtins.str]:
        """
        The window to perform maintenance in.
        Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @_builtins.property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        """
        return pulumi.get(self, "promotion_tier")

    @_builtins.property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Bool to control if instance is publicly accessible. Default is `false`.
        """
        return pulumi.get(self, "publicly_accessible")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines whether a final DB snapshot is created before the DB instance is deleted.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @_builtins.property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether the neptune cluster is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        Storage type associated with the cluster `standard/iopt1`.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def writer(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        return pulumi.get(self, "writer")

