# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEngineVersionResult',
    'AwaitableGetEngineVersionResult',
    'get_engine_version',
    'get_engine_version_output',
]

@pulumi.output_type
class GetEngineVersionResult:
    """
    A collection of values returned by getEngineVersion.
    """
    def __init__(__self__, default_character_set=None, default_only=None, engine=None, engine_description=None, exportable_log_types=None, has_major_target=None, has_minor_target=None, id=None, latest=None, parameter_group_family=None, preferred_major_targets=None, preferred_upgrade_targets=None, preferred_versions=None, region=None, supported_character_sets=None, supported_timezones=None, supports_global_databases=None, supports_log_exports_to_cloudwatch=None, supports_read_replica=None, valid_major_targets=None, valid_minor_targets=None, valid_upgrade_targets=None, version=None, version_actual=None, version_description=None):
        if default_character_set and not isinstance(default_character_set, str):
            raise TypeError("Expected argument 'default_character_set' to be a str")
        pulumi.set(__self__, "default_character_set", default_character_set)
        if default_only and not isinstance(default_only, bool):
            raise TypeError("Expected argument 'default_only' to be a bool")
        pulumi.set(__self__, "default_only", default_only)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_description and not isinstance(engine_description, str):
            raise TypeError("Expected argument 'engine_description' to be a str")
        pulumi.set(__self__, "engine_description", engine_description)
        if exportable_log_types and not isinstance(exportable_log_types, list):
            raise TypeError("Expected argument 'exportable_log_types' to be a list")
        pulumi.set(__self__, "exportable_log_types", exportable_log_types)
        if has_major_target and not isinstance(has_major_target, bool):
            raise TypeError("Expected argument 'has_major_target' to be a bool")
        pulumi.set(__self__, "has_major_target", has_major_target)
        if has_minor_target and not isinstance(has_minor_target, bool):
            raise TypeError("Expected argument 'has_minor_target' to be a bool")
        pulumi.set(__self__, "has_minor_target", has_minor_target)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest and not isinstance(latest, bool):
            raise TypeError("Expected argument 'latest' to be a bool")
        pulumi.set(__self__, "latest", latest)
        if parameter_group_family and not isinstance(parameter_group_family, str):
            raise TypeError("Expected argument 'parameter_group_family' to be a str")
        pulumi.set(__self__, "parameter_group_family", parameter_group_family)
        if preferred_major_targets and not isinstance(preferred_major_targets, list):
            raise TypeError("Expected argument 'preferred_major_targets' to be a list")
        pulumi.set(__self__, "preferred_major_targets", preferred_major_targets)
        if preferred_upgrade_targets and not isinstance(preferred_upgrade_targets, list):
            raise TypeError("Expected argument 'preferred_upgrade_targets' to be a list")
        pulumi.set(__self__, "preferred_upgrade_targets", preferred_upgrade_targets)
        if preferred_versions and not isinstance(preferred_versions, list):
            raise TypeError("Expected argument 'preferred_versions' to be a list")
        pulumi.set(__self__, "preferred_versions", preferred_versions)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if supported_character_sets and not isinstance(supported_character_sets, list):
            raise TypeError("Expected argument 'supported_character_sets' to be a list")
        pulumi.set(__self__, "supported_character_sets", supported_character_sets)
        if supported_timezones and not isinstance(supported_timezones, list):
            raise TypeError("Expected argument 'supported_timezones' to be a list")
        pulumi.set(__self__, "supported_timezones", supported_timezones)
        if supports_global_databases and not isinstance(supports_global_databases, bool):
            raise TypeError("Expected argument 'supports_global_databases' to be a bool")
        pulumi.set(__self__, "supports_global_databases", supports_global_databases)
        if supports_log_exports_to_cloudwatch and not isinstance(supports_log_exports_to_cloudwatch, bool):
            raise TypeError("Expected argument 'supports_log_exports_to_cloudwatch' to be a bool")
        pulumi.set(__self__, "supports_log_exports_to_cloudwatch", supports_log_exports_to_cloudwatch)
        if supports_read_replica and not isinstance(supports_read_replica, bool):
            raise TypeError("Expected argument 'supports_read_replica' to be a bool")
        pulumi.set(__self__, "supports_read_replica", supports_read_replica)
        if valid_major_targets and not isinstance(valid_major_targets, list):
            raise TypeError("Expected argument 'valid_major_targets' to be a list")
        pulumi.set(__self__, "valid_major_targets", valid_major_targets)
        if valid_minor_targets and not isinstance(valid_minor_targets, list):
            raise TypeError("Expected argument 'valid_minor_targets' to be a list")
        pulumi.set(__self__, "valid_minor_targets", valid_minor_targets)
        if valid_upgrade_targets and not isinstance(valid_upgrade_targets, list):
            raise TypeError("Expected argument 'valid_upgrade_targets' to be a list")
        pulumi.set(__self__, "valid_upgrade_targets", valid_upgrade_targets)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if version_actual and not isinstance(version_actual, str):
            raise TypeError("Expected argument 'version_actual' to be a str")
        pulumi.set(__self__, "version_actual", version_actual)
        if version_description and not isinstance(version_description, str):
            raise TypeError("Expected argument 'version_description' to be a str")
        pulumi.set(__self__, "version_description", version_description)

    @_builtins.property
    @pulumi.getter(name="defaultCharacterSet")
    def default_character_set(self) -> _builtins.str:
        """
        Default character set for the engine version.
        """
        return pulumi.get(self, "default_character_set")

    @_builtins.property
    @pulumi.getter(name="defaultOnly")
    def default_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "default_only")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineDescription")
    def engine_description(self) -> _builtins.str:
        """
        Description of the database engine.
        """
        return pulumi.get(self, "engine_description")

    @_builtins.property
    @pulumi.getter(name="exportableLogTypes")
    def exportable_log_types(self) -> Sequence[_builtins.str]:
        """
        Set of log types that the database engine has available for export to CloudWatch Logs.
        """
        return pulumi.get(self, "exportable_log_types")

    @_builtins.property
    @pulumi.getter(name="hasMajorTarget")
    def has_major_target(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "has_major_target")

    @_builtins.property
    @pulumi.getter(name="hasMinorTarget")
    def has_minor_target(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "has_minor_target")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def latest(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "latest")

    @_builtins.property
    @pulumi.getter(name="parameterGroupFamily")
    def parameter_group_family(self) -> _builtins.str:
        return pulumi.get(self, "parameter_group_family")

    @_builtins.property
    @pulumi.getter(name="preferredMajorTargets")
    def preferred_major_targets(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "preferred_major_targets")

    @_builtins.property
    @pulumi.getter(name="preferredUpgradeTargets")
    def preferred_upgrade_targets(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "preferred_upgrade_targets")

    @_builtins.property
    @pulumi.getter(name="preferredVersions")
    def preferred_versions(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "preferred_versions")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="supportedCharacterSets")
    def supported_character_sets(self) -> Sequence[_builtins.str]:
        """
        Set of character sets supported by this engine version.
        """
        return pulumi.get(self, "supported_character_sets")

    @_builtins.property
    @pulumi.getter(name="supportedTimezones")
    def supported_timezones(self) -> Sequence[_builtins.str]:
        """
        Set of time zones supported by this engine.
        """
        return pulumi.get(self, "supported_timezones")

    @_builtins.property
    @pulumi.getter(name="supportsGlobalDatabases")
    def supports_global_databases(self) -> _builtins.bool:
        """
        Whether the engine version supports global databases.
        """
        return pulumi.get(self, "supports_global_databases")

    @_builtins.property
    @pulumi.getter(name="supportsLogExportsToCloudwatch")
    def supports_log_exports_to_cloudwatch(self) -> _builtins.bool:
        """
        Whether the engine version supports exporting the log types specified by `exportable_log_types` to CloudWatch Logs.
        """
        return pulumi.get(self, "supports_log_exports_to_cloudwatch")

    @_builtins.property
    @pulumi.getter(name="supportsReadReplica")
    def supports_read_replica(self) -> _builtins.bool:
        """
        Whether the database engine version supports read replicas.
        """
        return pulumi.get(self, "supports_read_replica")

    @_builtins.property
    @pulumi.getter(name="validMajorTargets")
    def valid_major_targets(self) -> Sequence[_builtins.str]:
        """
        Set of valid major engine versions that this version can be upgraded to.
        """
        return pulumi.get(self, "valid_major_targets")

    @_builtins.property
    @pulumi.getter(name="validMinorTargets")
    def valid_minor_targets(self) -> Sequence[_builtins.str]:
        """
        Set of valid minor engine versions that this version can be upgraded to.
        """
        return pulumi.get(self, "valid_minor_targets")

    @_builtins.property
    @pulumi.getter(name="validUpgradeTargets")
    def valid_upgrade_targets(self) -> Sequence[_builtins.str]:
        """
        Set of engine versions that this database engine version can be upgraded to.
        """
        return pulumi.get(self, "valid_upgrade_targets")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionActual")
    def version_actual(self) -> _builtins.str:
        """
        Actual engine version returned by the API.
        """
        return pulumi.get(self, "version_actual")

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> _builtins.str:
        """
        Description of the database engine version.
        """
        return pulumi.get(self, "version_description")


class AwaitableGetEngineVersionResult(GetEngineVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEngineVersionResult(
            default_character_set=self.default_character_set,
            default_only=self.default_only,
            engine=self.engine,
            engine_description=self.engine_description,
            exportable_log_types=self.exportable_log_types,
            has_major_target=self.has_major_target,
            has_minor_target=self.has_minor_target,
            id=self.id,
            latest=self.latest,
            parameter_group_family=self.parameter_group_family,
            preferred_major_targets=self.preferred_major_targets,
            preferred_upgrade_targets=self.preferred_upgrade_targets,
            preferred_versions=self.preferred_versions,
            region=self.region,
            supported_character_sets=self.supported_character_sets,
            supported_timezones=self.supported_timezones,
            supports_global_databases=self.supports_global_databases,
            supports_log_exports_to_cloudwatch=self.supports_log_exports_to_cloudwatch,
            supports_read_replica=self.supports_read_replica,
            valid_major_targets=self.valid_major_targets,
            valid_minor_targets=self.valid_minor_targets,
            valid_upgrade_targets=self.valid_upgrade_targets,
            version=self.version,
            version_actual=self.version_actual,
            version_description=self.version_description)


def get_engine_version(default_only: Optional[_builtins.bool] = None,
                       engine: Optional[_builtins.str] = None,
                       has_major_target: Optional[_builtins.bool] = None,
                       has_minor_target: Optional[_builtins.bool] = None,
                       latest: Optional[_builtins.bool] = None,
                       parameter_group_family: Optional[_builtins.str] = None,
                       preferred_major_targets: Optional[Sequence[_builtins.str]] = None,
                       preferred_upgrade_targets: Optional[Sequence[_builtins.str]] = None,
                       preferred_versions: Optional[Sequence[_builtins.str]] = None,
                       region: Optional[_builtins.str] = None,
                       version: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEngineVersionResult:
    """
    Information about a Neptune engine version.

    > **Note:** If AWS returns multiple matching engine versions, this data source will produce a `multiple Neptune engine versions` error. To avoid this, provide additional criteria to narrow the results or use the `latest` argument to select a single version. See the Argument Reference for details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.neptune.get_engine_version(preferred_versions=[
        "1.4.5.0",
        "1.4.4.0",
        "1.4.3.0",
    ])
    ```


    :param _builtins.bool default_only: Whether to return only default engine versions that match all other criteria. AWS may define multiple default versions for a given engine, so using `default_only` alone does not guarantee that only one version will be returned. To ensure a single version is selected, consider combining this with `latest`. Note that default versions are defined by AWS and may not reflect the most recent engine version available.
    :param _builtins.str engine: DB engine. Must be `neptune`. Default is `neptune`.
    :param _builtins.bool has_major_target: Whether to filter for engine versions that have a major target.
    :param _builtins.bool has_minor_target: Whether to filter for engine versions that have a minor target.
    :param _builtins.bool latest: Whether to return only the latest engine version that matches all other criteria. This differs from `default_only`: AWS may define multiple defaults, and the latest version is not always marked as the default. As a result, `default_only` may still return multiple versions, while `latest` selects a single version. The two options can be used together. **Note:** This argument uses a best-effort approach. Because AWS does not consistently provide version dates or standardized identifiers, the result may not always reflect the true latest version.
    :param _builtins.str parameter_group_family: Name of a specific DB parameter group family. An example parameter group family is `neptune1.4`. For some versions, if this is provided, AWS returns no results.
    :param Sequence[_builtins.str] preferred_major_targets: Ordered list of preferred major engine versions.
    :param Sequence[_builtins.str] preferred_upgrade_targets: Ordered list of preferred upgrade engine versions.
    :param Sequence[_builtins.str] preferred_versions: Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str version: Version of the DB engine. For example, `1.0.1.0`, `1.0.2.2`, and `1.0.3.0`. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
    """
    __args__ = dict()
    __args__['defaultOnly'] = default_only
    __args__['engine'] = engine
    __args__['hasMajorTarget'] = has_major_target
    __args__['hasMinorTarget'] = has_minor_target
    __args__['latest'] = latest
    __args__['parameterGroupFamily'] = parameter_group_family
    __args__['preferredMajorTargets'] = preferred_major_targets
    __args__['preferredUpgradeTargets'] = preferred_upgrade_targets
    __args__['preferredVersions'] = preferred_versions
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:neptune/getEngineVersion:getEngineVersion', __args__, opts=opts, typ=GetEngineVersionResult).value

    return AwaitableGetEngineVersionResult(
        default_character_set=pulumi.get(__ret__, 'default_character_set'),
        default_only=pulumi.get(__ret__, 'default_only'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_description=pulumi.get(__ret__, 'engine_description'),
        exportable_log_types=pulumi.get(__ret__, 'exportable_log_types'),
        has_major_target=pulumi.get(__ret__, 'has_major_target'),
        has_minor_target=pulumi.get(__ret__, 'has_minor_target'),
        id=pulumi.get(__ret__, 'id'),
        latest=pulumi.get(__ret__, 'latest'),
        parameter_group_family=pulumi.get(__ret__, 'parameter_group_family'),
        preferred_major_targets=pulumi.get(__ret__, 'preferred_major_targets'),
        preferred_upgrade_targets=pulumi.get(__ret__, 'preferred_upgrade_targets'),
        preferred_versions=pulumi.get(__ret__, 'preferred_versions'),
        region=pulumi.get(__ret__, 'region'),
        supported_character_sets=pulumi.get(__ret__, 'supported_character_sets'),
        supported_timezones=pulumi.get(__ret__, 'supported_timezones'),
        supports_global_databases=pulumi.get(__ret__, 'supports_global_databases'),
        supports_log_exports_to_cloudwatch=pulumi.get(__ret__, 'supports_log_exports_to_cloudwatch'),
        supports_read_replica=pulumi.get(__ret__, 'supports_read_replica'),
        valid_major_targets=pulumi.get(__ret__, 'valid_major_targets'),
        valid_minor_targets=pulumi.get(__ret__, 'valid_minor_targets'),
        valid_upgrade_targets=pulumi.get(__ret__, 'valid_upgrade_targets'),
        version=pulumi.get(__ret__, 'version'),
        version_actual=pulumi.get(__ret__, 'version_actual'),
        version_description=pulumi.get(__ret__, 'version_description'))
def get_engine_version_output(default_only: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              engine: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              has_major_target: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              has_minor_target: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              latest: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              parameter_group_family: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              preferred_major_targets: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              preferred_upgrade_targets: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              preferred_versions: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEngineVersionResult]:
    """
    Information about a Neptune engine version.

    > **Note:** If AWS returns multiple matching engine versions, this data source will produce a `multiple Neptune engine versions` error. To avoid this, provide additional criteria to narrow the results or use the `latest` argument to select a single version. See the Argument Reference for details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.neptune.get_engine_version(preferred_versions=[
        "1.4.5.0",
        "1.4.4.0",
        "1.4.3.0",
    ])
    ```


    :param _builtins.bool default_only: Whether to return only default engine versions that match all other criteria. AWS may define multiple default versions for a given engine, so using `default_only` alone does not guarantee that only one version will be returned. To ensure a single version is selected, consider combining this with `latest`. Note that default versions are defined by AWS and may not reflect the most recent engine version available.
    :param _builtins.str engine: DB engine. Must be `neptune`. Default is `neptune`.
    :param _builtins.bool has_major_target: Whether to filter for engine versions that have a major target.
    :param _builtins.bool has_minor_target: Whether to filter for engine versions that have a minor target.
    :param _builtins.bool latest: Whether to return only the latest engine version that matches all other criteria. This differs from `default_only`: AWS may define multiple defaults, and the latest version is not always marked as the default. As a result, `default_only` may still return multiple versions, while `latest` selects a single version. The two options can be used together. **Note:** This argument uses a best-effort approach. Because AWS does not consistently provide version dates or standardized identifiers, the result may not always reflect the true latest version.
    :param _builtins.str parameter_group_family: Name of a specific DB parameter group family. An example parameter group family is `neptune1.4`. For some versions, if this is provided, AWS returns no results.
    :param Sequence[_builtins.str] preferred_major_targets: Ordered list of preferred major engine versions.
    :param Sequence[_builtins.str] preferred_upgrade_targets: Ordered list of preferred upgrade engine versions.
    :param Sequence[_builtins.str] preferred_versions: Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str version: Version of the DB engine. For example, `1.0.1.0`, `1.0.2.2`, and `1.0.3.0`. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
    """
    __args__ = dict()
    __args__['defaultOnly'] = default_only
    __args__['engine'] = engine
    __args__['hasMajorTarget'] = has_major_target
    __args__['hasMinorTarget'] = has_minor_target
    __args__['latest'] = latest
    __args__['parameterGroupFamily'] = parameter_group_family
    __args__['preferredMajorTargets'] = preferred_major_targets
    __args__['preferredUpgradeTargets'] = preferred_upgrade_targets
    __args__['preferredVersions'] = preferred_versions
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:neptune/getEngineVersion:getEngineVersion', __args__, opts=opts, typ=GetEngineVersionResult)
    return __ret__.apply(lambda __response__: GetEngineVersionResult(
        default_character_set=pulumi.get(__response__, 'default_character_set'),
        default_only=pulumi.get(__response__, 'default_only'),
        engine=pulumi.get(__response__, 'engine'),
        engine_description=pulumi.get(__response__, 'engine_description'),
        exportable_log_types=pulumi.get(__response__, 'exportable_log_types'),
        has_major_target=pulumi.get(__response__, 'has_major_target'),
        has_minor_target=pulumi.get(__response__, 'has_minor_target'),
        id=pulumi.get(__response__, 'id'),
        latest=pulumi.get(__response__, 'latest'),
        parameter_group_family=pulumi.get(__response__, 'parameter_group_family'),
        preferred_major_targets=pulumi.get(__response__, 'preferred_major_targets'),
        preferred_upgrade_targets=pulumi.get(__response__, 'preferred_upgrade_targets'),
        preferred_versions=pulumi.get(__response__, 'preferred_versions'),
        region=pulumi.get(__response__, 'region'),
        supported_character_sets=pulumi.get(__response__, 'supported_character_sets'),
        supported_timezones=pulumi.get(__response__, 'supported_timezones'),
        supports_global_databases=pulumi.get(__response__, 'supports_global_databases'),
        supports_log_exports_to_cloudwatch=pulumi.get(__response__, 'supports_log_exports_to_cloudwatch'),
        supports_read_replica=pulumi.get(__response__, 'supports_read_replica'),
        valid_major_targets=pulumi.get(__response__, 'valid_major_targets'),
        valid_minor_targets=pulumi.get(__response__, 'valid_minor_targets'),
        valid_upgrade_targets=pulumi.get(__response__, 'valid_upgrade_targets'),
        version=pulumi.get(__response__, 'version'),
        version_actual=pulumi.get(__response__, 'version_actual'),
        version_description=pulumi.get(__response__, 'version_description')))
