# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLinkResult',
    'AwaitableGetLinkResult',
    'get_link',
    'get_link_output',
]

@pulumi.output_type
class GetLinkResult:
    """
    A collection of values returned by getLink.
    """
    def __init__(__self__, arn=None, bandwidths=None, description=None, global_network_id=None, id=None, link_id=None, provider_name=None, site_id=None, tags=None, type=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if bandwidths and not isinstance(bandwidths, list):
            raise TypeError("Expected argument 'bandwidths' to be a list")
        pulumi.set(__self__, "bandwidths", bandwidths)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if global_network_id and not isinstance(global_network_id, str):
            raise TypeError("Expected argument 'global_network_id' to be a str")
        pulumi.set(__self__, "global_network_id", global_network_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if link_id and not isinstance(link_id, str):
            raise TypeError("Expected argument 'link_id' to be a str")
        pulumi.set(__self__, "link_id", link_id)
        if provider_name and not isinstance(provider_name, str):
            raise TypeError("Expected argument 'provider_name' to be a str")
        pulumi.set(__self__, "provider_name", provider_name)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the link.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def bandwidths(self) -> Sequence['outputs.GetLinkBandwidthResult']:
        """
        Upload speed and download speed of the link as documented below
        """
        return pulumi.get(self, "bandwidths")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the link.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> _builtins.str:
        return pulumi.get(self, "global_network_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> _builtins.str:
        return pulumi.get(self, "link_id")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> _builtins.str:
        """
        Provider of the link.
        """
        return pulumi.get(self, "provider_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> _builtins.str:
        """
        ID of the site.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value tags for the link.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the link.
        """
        return pulumi.get(self, "type")


class AwaitableGetLinkResult(GetLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLinkResult(
            arn=self.arn,
            bandwidths=self.bandwidths,
            description=self.description,
            global_network_id=self.global_network_id,
            id=self.id,
            link_id=self.link_id,
            provider_name=self.provider_name,
            site_id=self.site_id,
            tags=self.tags,
            type=self.type)


def get_link(global_network_id: Optional[_builtins.str] = None,
             link_id: Optional[_builtins.str] = None,
             tags: Optional[Mapping[str, _builtins.str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLinkResult:
    """
    Provides details about an existing Network Manager link.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_link(global_network_id=global_network_id,
        link_id=link_id)
    ```


    :param _builtins.str global_network_id: ID of the Global Network of the link to retrieve.
    :param _builtins.str link_id: ID of the specific link to retrieve.
    :param Mapping[str, _builtins.str] tags: Key-value tags for the link.
    """
    __args__ = dict()
    __args__['globalNetworkId'] = global_network_id
    __args__['linkId'] = link_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:networkmanager/getLink:getLink', __args__, opts=opts, typ=GetLinkResult).value

    return AwaitableGetLinkResult(
        arn=pulumi.get(__ret__, 'arn'),
        bandwidths=pulumi.get(__ret__, 'bandwidths'),
        description=pulumi.get(__ret__, 'description'),
        global_network_id=pulumi.get(__ret__, 'global_network_id'),
        id=pulumi.get(__ret__, 'id'),
        link_id=pulumi.get(__ret__, 'link_id'),
        provider_name=pulumi.get(__ret__, 'provider_name'),
        site_id=pulumi.get(__ret__, 'site_id'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_link_output(global_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                    link_id: Optional[pulumi.Input[_builtins.str]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLinkResult]:
    """
    Provides details about an existing Network Manager link.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_link(global_network_id=global_network_id,
        link_id=link_id)
    ```


    :param _builtins.str global_network_id: ID of the Global Network of the link to retrieve.
    :param _builtins.str link_id: ID of the specific link to retrieve.
    :param Mapping[str, _builtins.str] tags: Key-value tags for the link.
    """
    __args__ = dict()
    __args__['globalNetworkId'] = global_network_id
    __args__['linkId'] = link_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:networkmanager/getLink:getLink', __args__, opts=opts, typ=GetLinkResult)
    return __ret__.apply(lambda __response__: GetLinkResult(
        arn=pulumi.get(__response__, 'arn'),
        bandwidths=pulumi.get(__response__, 'bandwidths'),
        description=pulumi.get(__response__, 'description'),
        global_network_id=pulumi.get(__response__, 'global_network_id'),
        id=pulumi.get(__response__, 'id'),
        link_id=pulumi.get(__response__, 'link_id'),
        provider_name=pulumi.get(__response__, 'provider_name'),
        site_id=pulumi.get(__response__, 'site_id'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
