# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NotificationConfigurationArgs', 'NotificationConfiguration']

@pulumi.input_type
class NotificationConfigurationArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 aggregation_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NotificationConfiguration resource.
        :param pulumi.Input[_builtins.str] description: Description of the NotificationConfiguration. Length constraints: Minimum length of 0,
               maximum length of 256.
        :param pulumi.Input[_builtins.str] aggregation_duration: Aggregation preference of the NotificationConfiguration. Valid values: `LONG` (
               aggregate notifications for 12 hours), `SHORT` (aggregate notifications for 5 minutes), `NONE` (don't aggregate
               notifications). Default: `NONE`.
        :param pulumi.Input[_builtins.str] name: Name of the NotificationConfiguration. Supports RFC 3986's unreserved characters. Length
               constraints: Minimum length of 1, maximum length of 64. Pattern: `[A-Za-z0-9_\\-]+`.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. A tag is a string-to-string map of key-value pairs. If
               configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those
               defined at the provider-level.
        """
        pulumi.set(__self__, "description", description)
        if aggregation_duration is not None:
            pulumi.set(__self__, "aggregation_duration", aggregation_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Description of the NotificationConfiguration. Length constraints: Minimum length of 0,
        maximum length of 256.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="aggregationDuration")
    def aggregation_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregation preference of the NotificationConfiguration. Valid values: `LONG` (
        aggregate notifications for 12 hours), `SHORT` (aggregate notifications for 5 minutes), `NONE` (don't aggregate
        notifications). Default: `NONE`.
        """
        return pulumi.get(self, "aggregation_duration")

    @aggregation_duration.setter
    def aggregation_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the NotificationConfiguration. Supports RFC 3986's unreserved characters. Length
        constraints: Minimum length of 1, maximum length of 64. Pattern: `[A-Za-z0-9_\\-]+`.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. A tag is a string-to-string map of key-value pairs. If
        configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those
        defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NotificationConfigurationState:
    def __init__(__self__, *,
                 aggregation_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NotificationConfiguration resources.
        :param pulumi.Input[_builtins.str] aggregation_duration: Aggregation preference of the NotificationConfiguration. Valid values: `LONG` (
               aggregate notifications for 12 hours), `SHORT` (aggregate notifications for 5 minutes), `NONE` (don't aggregate
               notifications). Default: `NONE`.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the NotificationConfiguration.
        :param pulumi.Input[_builtins.str] description: Description of the NotificationConfiguration. Length constraints: Minimum length of 0,
               maximum length of 256.
        :param pulumi.Input[_builtins.str] name: Name of the NotificationConfiguration. Supports RFC 3986's unreserved characters. Length
               constraints: Minimum length of 1, maximum length of 64. Pattern: `[A-Za-z0-9_\\-]+`.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. A tag is a string-to-string map of key-value pairs. If
               configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those
               defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags`
               configuration block.
        """
        if aggregation_duration is not None:
            pulumi.set(__self__, "aggregation_duration", aggregation_duration)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="aggregationDuration")
    def aggregation_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregation preference of the NotificationConfiguration. Valid values: `LONG` (
        aggregate notifications for 12 hours), `SHORT` (aggregate notifications for 5 minutes), `NONE` (don't aggregate
        notifications). Default: `NONE`.
        """
        return pulumi.get(self, "aggregation_duration")

    @aggregation_duration.setter
    def aggregation_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_duration", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the NotificationConfiguration.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the NotificationConfiguration. Length constraints: Minimum length of 0,
        maximum length of 256.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the NotificationConfiguration. Supports RFC 3986's unreserved characters. Length
        constraints: Minimum length of 1, maximum length of 64. Pattern: `[A-Za-z0-9_\\-]+`.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. A tag is a string-to-string map of key-value pairs. If
        configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those
        defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags`
        configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:notifications/notificationConfiguration:NotificationConfiguration")
class NotificationConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS User Notifications Notification Configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.notifications.NotificationConfiguration("example",
            name="example",
            description="Example notification configuration",
            tags={
                "Environment": "production",
                "Project": "example",
            })
        ```

        ### With Aggregation Duration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.notifications.NotificationConfiguration("example",
            name="example-aggregation",
            description="Example notification configuration with aggregation",
            aggregation_duration="SHORT",
            tags={
                "Environment": "production",
                "Project": "example",
            })
        ```

        ## Import

        Using `pulumi import`, import User Notifications Notification Configuration using the `arn`. For example:

        ```sh
        $ pulumi import aws:notifications/notificationConfiguration:NotificationConfiguration example arn:aws:notifications::123456789012:configuration/abcdef1234567890abcdef1234567890
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregation_duration: Aggregation preference of the NotificationConfiguration. Valid values: `LONG` (
               aggregate notifications for 12 hours), `SHORT` (aggregate notifications for 5 minutes), `NONE` (don't aggregate
               notifications). Default: `NONE`.
        :param pulumi.Input[_builtins.str] description: Description of the NotificationConfiguration. Length constraints: Minimum length of 0,
               maximum length of 256.
        :param pulumi.Input[_builtins.str] name: Name of the NotificationConfiguration. Supports RFC 3986's unreserved characters. Length
               constraints: Minimum length of 1, maximum length of 64. Pattern: `[A-Za-z0-9_\\-]+`.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. A tag is a string-to-string map of key-value pairs. If
               configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those
               defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS User Notifications Notification Configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.notifications.NotificationConfiguration("example",
            name="example",
            description="Example notification configuration",
            tags={
                "Environment": "production",
                "Project": "example",
            })
        ```

        ### With Aggregation Duration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.notifications.NotificationConfiguration("example",
            name="example-aggregation",
            description="Example notification configuration with aggregation",
            aggregation_duration="SHORT",
            tags={
                "Environment": "production",
                "Project": "example",
            })
        ```

        ## Import

        Using `pulumi import`, import User Notifications Notification Configuration using the `arn`. For example:

        ```sh
        $ pulumi import aws:notifications/notificationConfiguration:NotificationConfiguration example arn:aws:notifications::123456789012:configuration/abcdef1234567890abcdef1234567890
        ```

        :param str resource_name: The name of the resource.
        :param NotificationConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationConfigurationArgs.__new__(NotificationConfigurationArgs)

            __props__.__dict__["aggregation_duration"] = aggregation_duration
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(NotificationConfiguration, __self__).__init__(
            'aws:notifications/notificationConfiguration:NotificationConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregation_duration: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'NotificationConfiguration':
        """
        Get an existing NotificationConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregation_duration: Aggregation preference of the NotificationConfiguration. Valid values: `LONG` (
               aggregate notifications for 12 hours), `SHORT` (aggregate notifications for 5 minutes), `NONE` (don't aggregate
               notifications). Default: `NONE`.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the NotificationConfiguration.
        :param pulumi.Input[_builtins.str] description: Description of the NotificationConfiguration. Length constraints: Minimum length of 0,
               maximum length of 256.
        :param pulumi.Input[_builtins.str] name: Name of the NotificationConfiguration. Supports RFC 3986's unreserved characters. Length
               constraints: Minimum length of 1, maximum length of 64. Pattern: `[A-Za-z0-9_\\-]+`.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. A tag is a string-to-string map of key-value pairs. If
               configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those
               defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags`
               configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationConfigurationState.__new__(_NotificationConfigurationState)

        __props__.__dict__["aggregation_duration"] = aggregation_duration
        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return NotificationConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aggregationDuration")
    def aggregation_duration(self) -> pulumi.Output[_builtins.str]:
        """
        Aggregation preference of the NotificationConfiguration. Valid values: `LONG` (
        aggregate notifications for 12 hours), `SHORT` (aggregate notifications for 5 minutes), `NONE` (don't aggregate
        notifications). Default: `NONE`.
        """
        return pulumi.get(self, "aggregation_duration")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the NotificationConfiguration.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the NotificationConfiguration. Length constraints: Minimum length of 0,
        maximum length of 256.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the NotificationConfiguration. Supports RFC 3986's unreserved characters. Length
        constraints: Minimum length of 1, maximum length of 64. Pattern: `[A-Za-z0-9_\\-]+`.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. A tag is a string-to-string map of key-value pairs. If
        configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those
        defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags`
        configuration block.
        """
        return pulumi.get(self, "tags_all")

