# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationArgs', 'Organization']

@pulumi.input_type
class OrganizationArgs:
    def __init__(__self__, *,
                 aws_service_access_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled_policy_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feature_set: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Organization resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aws_service_access_principals: List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_policy_types: List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `RESOURCE_CONTROL_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
        :param pulumi.Input[_builtins.str] feature_set: Specify "ALL" (default) or "CONSOLIDATED_BILLING".
        """
        if aws_service_access_principals is not None:
            pulumi.set(__self__, "aws_service_access_principals", aws_service_access_principals)
        if enabled_policy_types is not None:
            pulumi.set(__self__, "enabled_policy_types", enabled_policy_types)
        if feature_set is not None:
            pulumi.set(__self__, "feature_set", feature_set)

    @_builtins.property
    @pulumi.getter(name="awsServiceAccessPrincipals")
    def aws_service_access_principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
        """
        return pulumi.get(self, "aws_service_access_principals")

    @aws_service_access_principals.setter
    def aws_service_access_principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "aws_service_access_principals", value)

    @_builtins.property
    @pulumi.getter(name="enabledPolicyTypes")
    def enabled_policy_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `RESOURCE_CONTROL_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
        """
        return pulumi.get(self, "enabled_policy_types")

    @enabled_policy_types.setter
    def enabled_policy_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_policy_types", value)

    @_builtins.property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify "ALL" (default) or "CONSOLIDATED_BILLING".
        """
        return pulumi.get(self, "feature_set")

    @feature_set.setter
    def feature_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_set", value)


@pulumi.input_type
class _OrganizationState:
    def __init__(__self__, *,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationAccountArgs']]]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_service_access_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled_policy_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feature_set: Optional[pulumi.Input[_builtins.str]] = None,
                 master_account_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 master_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 master_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 master_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_master_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationNonMasterAccountArgs']]]] = None,
                 roots: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationRootArgs']]]] = None):
        """
        Input properties used for looking up and filtering Organization resources.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationAccountArgs']]] accounts: List of organization accounts including the master account. For a list excluding the master account, see the `non_master_accounts` attribute. All elements have these attributes:
        :param pulumi.Input[_builtins.str] arn: ARN of the root
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aws_service_access_principals: List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_policy_types: List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `RESOURCE_CONTROL_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
        :param pulumi.Input[_builtins.str] feature_set: Specify "ALL" (default) or "CONSOLIDATED_BILLING".
        :param pulumi.Input[_builtins.str] master_account_arn: ARN of the master account
        :param pulumi.Input[_builtins.str] master_account_email: Email address of the master account
        :param pulumi.Input[_builtins.str] master_account_id: Identifier of the master account
        :param pulumi.Input[_builtins.str] master_account_name: Name of the master account
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationNonMasterAccountArgs']]] non_master_accounts: List of organization accounts excluding the master account. For a list including the master account, see the `accounts` attribute. All elements have these attributes:
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationRootArgs']]] roots: List of organization roots. All elements have these attributes:
        """
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if aws_service_access_principals is not None:
            pulumi.set(__self__, "aws_service_access_principals", aws_service_access_principals)
        if enabled_policy_types is not None:
            pulumi.set(__self__, "enabled_policy_types", enabled_policy_types)
        if feature_set is not None:
            pulumi.set(__self__, "feature_set", feature_set)
        if master_account_arn is not None:
            pulumi.set(__self__, "master_account_arn", master_account_arn)
        if master_account_email is not None:
            pulumi.set(__self__, "master_account_email", master_account_email)
        if master_account_id is not None:
            pulumi.set(__self__, "master_account_id", master_account_id)
        if master_account_name is not None:
            pulumi.set(__self__, "master_account_name", master_account_name)
        if non_master_accounts is not None:
            pulumi.set(__self__, "non_master_accounts", non_master_accounts)
        if roots is not None:
            pulumi.set(__self__, "roots", roots)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationAccountArgs']]]]:
        """
        List of organization accounts including the master account. For a list excluding the master account, see the `non_master_accounts` attribute. All elements have these attributes:
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationAccountArgs']]]]):
        pulumi.set(self, "accounts", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the root
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="awsServiceAccessPrincipals")
    def aws_service_access_principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
        """
        return pulumi.get(self, "aws_service_access_principals")

    @aws_service_access_principals.setter
    def aws_service_access_principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "aws_service_access_principals", value)

    @_builtins.property
    @pulumi.getter(name="enabledPolicyTypes")
    def enabled_policy_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `RESOURCE_CONTROL_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
        """
        return pulumi.get(self, "enabled_policy_types")

    @enabled_policy_types.setter
    def enabled_policy_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_policy_types", value)

    @_builtins.property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify "ALL" (default) or "CONSOLIDATED_BILLING".
        """
        return pulumi.get(self, "feature_set")

    @feature_set.setter
    def feature_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_set", value)

    @_builtins.property
    @pulumi.getter(name="masterAccountArn")
    def master_account_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the master account
        """
        return pulumi.get(self, "master_account_arn")

    @master_account_arn.setter
    def master_account_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_account_arn", value)

    @_builtins.property
    @pulumi.getter(name="masterAccountEmail")
    def master_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the master account
        """
        return pulumi.get(self, "master_account_email")

    @master_account_email.setter
    def master_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_account_email", value)

    @_builtins.property
    @pulumi.getter(name="masterAccountId")
    def master_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the master account
        """
        return pulumi.get(self, "master_account_id")

    @master_account_id.setter
    def master_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_account_id", value)

    @_builtins.property
    @pulumi.getter(name="masterAccountName")
    def master_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the master account
        """
        return pulumi.get(self, "master_account_name")

    @master_account_name.setter
    def master_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_account_name", value)

    @_builtins.property
    @pulumi.getter(name="nonMasterAccounts")
    def non_master_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationNonMasterAccountArgs']]]]:
        """
        List of organization accounts excluding the master account. For a list including the master account, see the `accounts` attribute. All elements have these attributes:
        """
        return pulumi.get(self, "non_master_accounts")

    @non_master_accounts.setter
    def non_master_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationNonMasterAccountArgs']]]]):
        pulumi.set(self, "non_master_accounts", value)

    @_builtins.property
    @pulumi.getter
    def roots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationRootArgs']]]]:
        """
        List of organization roots. All elements have these attributes:
        """
        return pulumi.get(self, "roots")

    @roots.setter
    def roots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationRootArgs']]]]):
        pulumi.set(self, "roots", value)


@pulumi.type_token("aws:organizations/organization:Organization")
class Organization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_service_access_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled_policy_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feature_set: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create an organization.

        !> **WARNING:** When migrating from a `feature_set` of `CONSOLIDATED_BILLING` to `ALL`, the Organization account owner will received an email stating the following: "You started the process to enable all features for your AWS organization. As part of that process, all member accounts that joined your organization by invitation must approve the change. You don’t need approval from member accounts that you directly created from within your AWS organization." After all member accounts have accepted the invitation, the Organization account owner must then finalize the changes via the [AWS Console](https://console.aws.amazon.com/organizations/home#/organization/settings/migration-progress). Until these steps are performed, the provider will perpetually show a difference, and the `DescribeOrganization` API will continue to show the `FeatureSet` as `CONSOLIDATED_BILLING`. See the [AWS Organizations documentation](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html) for more information.

        !> **WARNING:** [Warning from the AWS Docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html): "We recommend that you enable integration between AWS Organizations and the specified AWS service by using the console or commands that are provided by the specified service. Doing so ensures that the service is aware that it can create the resources that are required for the integration. How the service creates those resources in the organization's accounts depends on that service. For more information, see the documentation for the other AWS service."

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        org = aws.organizations.Organization("org",
            aws_service_access_principals=[
                "cloudtrail.amazonaws.com",
                "config.amazonaws.com",
            ],
            feature_set="ALL")
        ```

        ## Import

        Using `pulumi import`, import the AWS organization using the `id`. For example:

        ```sh
        $ pulumi import aws:organizations/organization:Organization my_org o-1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aws_service_access_principals: List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_policy_types: List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `RESOURCE_CONTROL_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
        :param pulumi.Input[_builtins.str] feature_set: Specify "ALL" (default) or "CONSOLIDATED_BILLING".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OrganizationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create an organization.

        !> **WARNING:** When migrating from a `feature_set` of `CONSOLIDATED_BILLING` to `ALL`, the Organization account owner will received an email stating the following: "You started the process to enable all features for your AWS organization. As part of that process, all member accounts that joined your organization by invitation must approve the change. You don’t need approval from member accounts that you directly created from within your AWS organization." After all member accounts have accepted the invitation, the Organization account owner must then finalize the changes via the [AWS Console](https://console.aws.amazon.com/organizations/home#/organization/settings/migration-progress). Until these steps are performed, the provider will perpetually show a difference, and the `DescribeOrganization` API will continue to show the `FeatureSet` as `CONSOLIDATED_BILLING`. See the [AWS Organizations documentation](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html) for more information.

        !> **WARNING:** [Warning from the AWS Docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html): "We recommend that you enable integration between AWS Organizations and the specified AWS service by using the console or commands that are provided by the specified service. Doing so ensures that the service is aware that it can create the resources that are required for the integration. How the service creates those resources in the organization's accounts depends on that service. For more information, see the documentation for the other AWS service."

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        org = aws.organizations.Organization("org",
            aws_service_access_principals=[
                "cloudtrail.amazonaws.com",
                "config.amazonaws.com",
            ],
            feature_set="ALL")
        ```

        ## Import

        Using `pulumi import`, import the AWS organization using the `id`. For example:

        ```sh
        $ pulumi import aws:organizations/organization:Organization my_org o-1234567
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_service_access_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled_policy_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feature_set: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationArgs.__new__(OrganizationArgs)

            __props__.__dict__["aws_service_access_principals"] = aws_service_access_principals
            __props__.__dict__["enabled_policy_types"] = enabled_policy_types
            __props__.__dict__["feature_set"] = feature_set
            __props__.__dict__["accounts"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["master_account_arn"] = None
            __props__.__dict__["master_account_email"] = None
            __props__.__dict__["master_account_id"] = None
            __props__.__dict__["master_account_name"] = None
            __props__.__dict__["non_master_accounts"] = None
            __props__.__dict__["roots"] = None
        super(Organization, __self__).__init__(
            'aws:organizations/organization:Organization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationAccountArgs', 'OrganizationAccountArgsDict']]]]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            aws_service_access_principals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enabled_policy_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            feature_set: Optional[pulumi.Input[_builtins.str]] = None,
            master_account_arn: Optional[pulumi.Input[_builtins.str]] = None,
            master_account_email: Optional[pulumi.Input[_builtins.str]] = None,
            master_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            master_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            non_master_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationNonMasterAccountArgs', 'OrganizationNonMasterAccountArgsDict']]]]] = None,
            roots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationRootArgs', 'OrganizationRootArgsDict']]]]] = None) -> 'Organization':
        """
        Get an existing Organization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrganizationAccountArgs', 'OrganizationAccountArgsDict']]]] accounts: List of organization accounts including the master account. For a list excluding the master account, see the `non_master_accounts` attribute. All elements have these attributes:
        :param pulumi.Input[_builtins.str] arn: ARN of the root
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aws_service_access_principals: List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_policy_types: List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `RESOURCE_CONTROL_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
        :param pulumi.Input[_builtins.str] feature_set: Specify "ALL" (default) or "CONSOLIDATED_BILLING".
        :param pulumi.Input[_builtins.str] master_account_arn: ARN of the master account
        :param pulumi.Input[_builtins.str] master_account_email: Email address of the master account
        :param pulumi.Input[_builtins.str] master_account_id: Identifier of the master account
        :param pulumi.Input[_builtins.str] master_account_name: Name of the master account
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrganizationNonMasterAccountArgs', 'OrganizationNonMasterAccountArgsDict']]]] non_master_accounts: List of organization accounts excluding the master account. For a list including the master account, see the `accounts` attribute. All elements have these attributes:
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrganizationRootArgs', 'OrganizationRootArgsDict']]]] roots: List of organization roots. All elements have these attributes:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationState.__new__(_OrganizationState)

        __props__.__dict__["accounts"] = accounts
        __props__.__dict__["arn"] = arn
        __props__.__dict__["aws_service_access_principals"] = aws_service_access_principals
        __props__.__dict__["enabled_policy_types"] = enabled_policy_types
        __props__.__dict__["feature_set"] = feature_set
        __props__.__dict__["master_account_arn"] = master_account_arn
        __props__.__dict__["master_account_email"] = master_account_email
        __props__.__dict__["master_account_id"] = master_account_id
        __props__.__dict__["master_account_name"] = master_account_name
        __props__.__dict__["non_master_accounts"] = non_master_accounts
        __props__.__dict__["roots"] = roots
        return Organization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> pulumi.Output[Sequence['outputs.OrganizationAccount']]:
        """
        List of organization accounts including the master account. For a list excluding the master account, see the `non_master_accounts` attribute. All elements have these attributes:
        """
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the root
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="awsServiceAccessPrincipals")
    def aws_service_access_principals(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
        """
        return pulumi.get(self, "aws_service_access_principals")

    @_builtins.property
    @pulumi.getter(name="enabledPolicyTypes")
    def enabled_policy_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `RESOURCE_CONTROL_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
        """
        return pulumi.get(self, "enabled_policy_types")

    @_builtins.property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify "ALL" (default) or "CONSOLIDATED_BILLING".
        """
        return pulumi.get(self, "feature_set")

    @_builtins.property
    @pulumi.getter(name="masterAccountArn")
    def master_account_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the master account
        """
        return pulumi.get(self, "master_account_arn")

    @_builtins.property
    @pulumi.getter(name="masterAccountEmail")
    def master_account_email(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of the master account
        """
        return pulumi.get(self, "master_account_email")

    @_builtins.property
    @pulumi.getter(name="masterAccountId")
    def master_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the master account
        """
        return pulumi.get(self, "master_account_id")

    @_builtins.property
    @pulumi.getter(name="masterAccountName")
    def master_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the master account
        """
        return pulumi.get(self, "master_account_name")

    @_builtins.property
    @pulumi.getter(name="nonMasterAccounts")
    def non_master_accounts(self) -> pulumi.Output[Sequence['outputs.OrganizationNonMasterAccount']]:
        """
        List of organization accounts excluding the master account. For a list including the master account, see the `accounts` attribute. All elements have these attributes:
        """
        return pulumi.get(self, "non_master_accounts")

    @_builtins.property
    @pulumi.getter
    def roots(self) -> pulumi.Output[Sequence['outputs.OrganizationRoot']]:
        """
        List of organization roots. All elements have these attributes:
        """
        return pulumi.get(self, "roots")

