# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IngestionArgs', 'Ingestion']

@pulumi.input_type
class IngestionArgs:
    def __init__(__self__, *,
                 data_set_id: pulumi.Input[_builtins.str],
                 ingestion_id: pulumi.Input[_builtins.str],
                 ingestion_type: pulumi.Input[_builtins.str],
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Ingestion resource.
        :param pulumi.Input[_builtins.str] data_set_id: ID of the dataset used in the ingestion.
        :param pulumi.Input[_builtins.str] ingestion_id: ID for the ingestion.
        :param pulumi.Input[_builtins.str] ingestion_type: Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "data_set_id", data_set_id)
        pulumi.set(__self__, "ingestion_id", ingestion_id)
        pulumi.set(__self__, "ingestion_type", ingestion_type)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the dataset used in the ingestion.
        """
        return pulumi.get(self, "data_set_id")

    @data_set_id.setter
    def data_set_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_set_id", value)

    @_builtins.property
    @pulumi.getter(name="ingestionId")
    def ingestion_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID for the ingestion.
        """
        return pulumi.get(self, "ingestion_id")

    @ingestion_id.setter
    def ingestion_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ingestion_id", value)

    @_builtins.property
    @pulumi.getter(name="ingestionType")
    def ingestion_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.

        The following arguments are optional:
        """
        return pulumi.get(self, "ingestion_type")

    @ingestion_type.setter
    def ingestion_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ingestion_type", value)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _IngestionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ingestion resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Ingestion.
        :param pulumi.Input[_builtins.str] data_set_id: ID of the dataset used in the ingestion.
        :param pulumi.Input[_builtins.str] ingestion_id: ID for the ingestion.
        :param pulumi.Input[_builtins.str] ingestion_status: Ingestion status.
        :param pulumi.Input[_builtins.str] ingestion_type: Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if data_set_id is not None:
            pulumi.set(__self__, "data_set_id", data_set_id)
        if ingestion_id is not None:
            pulumi.set(__self__, "ingestion_id", ingestion_id)
        if ingestion_status is not None:
            pulumi.set(__self__, "ingestion_status", ingestion_status)
        if ingestion_type is not None:
            pulumi.set(__self__, "ingestion_type", ingestion_type)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Ingestion.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the dataset used in the ingestion.
        """
        return pulumi.get(self, "data_set_id")

    @data_set_id.setter
    def data_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_set_id", value)

    @_builtins.property
    @pulumi.getter(name="ingestionId")
    def ingestion_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID for the ingestion.
        """
        return pulumi.get(self, "ingestion_id")

    @ingestion_id.setter
    def ingestion_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingestion_id", value)

    @_builtins.property
    @pulumi.getter(name="ingestionStatus")
    def ingestion_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ingestion status.
        """
        return pulumi.get(self, "ingestion_status")

    @ingestion_status.setter
    def ingestion_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingestion_status", value)

    @_builtins.property
    @pulumi.getter(name="ingestionType")
    def ingestion_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.

        The following arguments are optional:
        """
        return pulumi.get(self, "ingestion_type")

    @ingestion_type.setter
    def ingestion_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingestion_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:quicksight/ingestion:Ingestion")
class Ingestion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS QuickSight Ingestion.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.Ingestion("example",
            data_set_id=example_aws_quicksight_data_set["dataSetId"],
            ingestion_id="example-id",
            ingestion_type="FULL_REFRESH")
        ```

        ## Import

        Using `pulumi import`, import QuickSight Ingestion using the AWS account ID, data set ID, and ingestion ID separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:quicksight/ingestion:Ingestion example 123456789012,example-dataset-id,example-ingestion-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_set_id: ID of the dataset used in the ingestion.
        :param pulumi.Input[_builtins.str] ingestion_id: ID for the ingestion.
        :param pulumi.Input[_builtins.str] ingestion_type: Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IngestionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS QuickSight Ingestion.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.Ingestion("example",
            data_set_id=example_aws_quicksight_data_set["dataSetId"],
            ingestion_id="example-id",
            ingestion_type="FULL_REFRESH")
        ```

        ## Import

        Using `pulumi import`, import QuickSight Ingestion using the AWS account ID, data set ID, and ingestion ID separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:quicksight/ingestion:Ingestion example 123456789012,example-dataset-id,example-ingestion-id
        ```

        :param str resource_name: The name of the resource.
        :param IngestionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IngestionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingestion_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IngestionArgs.__new__(IngestionArgs)

            __props__.__dict__["aws_account_id"] = aws_account_id
            if data_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_set_id'")
            __props__.__dict__["data_set_id"] = data_set_id
            if ingestion_id is None and not opts.urn:
                raise TypeError("Missing required property 'ingestion_id'")
            __props__.__dict__["ingestion_id"] = ingestion_id
            if ingestion_type is None and not opts.urn:
                raise TypeError("Missing required property 'ingestion_type'")
            __props__.__dict__["ingestion_type"] = ingestion_type
            __props__.__dict__["region"] = region
            __props__.__dict__["arn"] = None
            __props__.__dict__["ingestion_status"] = None
        super(Ingestion, __self__).__init__(
            'aws:quicksight/ingestion:Ingestion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            ingestion_id: Optional[pulumi.Input[_builtins.str]] = None,
            ingestion_status: Optional[pulumi.Input[_builtins.str]] = None,
            ingestion_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'Ingestion':
        """
        Get an existing Ingestion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Ingestion.
        :param pulumi.Input[_builtins.str] data_set_id: ID of the dataset used in the ingestion.
        :param pulumi.Input[_builtins.str] ingestion_id: ID for the ingestion.
        :param pulumi.Input[_builtins.str] ingestion_status: Ingestion status.
        :param pulumi.Input[_builtins.str] ingestion_type: Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IngestionState.__new__(_IngestionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["data_set_id"] = data_set_id
        __props__.__dict__["ingestion_id"] = ingestion_id
        __props__.__dict__["ingestion_status"] = ingestion_status
        __props__.__dict__["ingestion_type"] = ingestion_type
        __props__.__dict__["region"] = region
        return Ingestion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Ingestion.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the dataset used in the ingestion.
        """
        return pulumi.get(self, "data_set_id")

    @_builtins.property
    @pulumi.getter(name="ingestionId")
    def ingestion_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID for the ingestion.
        """
        return pulumi.get(self, "ingestion_id")

    @_builtins.property
    @pulumi.getter(name="ingestionStatus")
    def ingestion_status(self) -> pulumi.Output[_builtins.str]:
        """
        Ingestion status.
        """
        return pulumi.get(self, "ingestion_status")

    @_builtins.property
    @pulumi.getter(name="ingestionType")
    def ingestion_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.

        The following arguments are optional:
        """
        return pulumi.get(self, "ingestion_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

