# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeyRegistrationArgs', 'KeyRegistration']

@pulumi.input_type
class KeyRegistrationArgs:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_registrations: Optional[pulumi.Input[Sequence[pulumi.Input['KeyRegistrationKeyRegistrationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KeyRegistration resource.
        :param pulumi.Input[Sequence[pulumi.Input['KeyRegistrationKeyRegistrationArgs']]] key_registrations: Registered keys. See key_registration.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if key_registrations is not None:
            pulumi.set(__self__, "key_registrations", key_registrations)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="keyRegistrations")
    def key_registrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyRegistrationKeyRegistrationArgs']]]]:
        """
        Registered keys. See key_registration.
        """
        return pulumi.get(self, "key_registrations")

    @key_registrations.setter
    def key_registrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyRegistrationKeyRegistrationArgs']]]]):
        pulumi.set(self, "key_registrations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _KeyRegistrationState:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_registrations: Optional[pulumi.Input[Sequence[pulumi.Input['KeyRegistrationKeyRegistrationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeyRegistration resources.
        :param pulumi.Input[Sequence[pulumi.Input['KeyRegistrationKeyRegistrationArgs']]] key_registrations: Registered keys. See key_registration.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if key_registrations is not None:
            pulumi.set(__self__, "key_registrations", key_registrations)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="keyRegistrations")
    def key_registrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyRegistrationKeyRegistrationArgs']]]]:
        """
        Registered keys. See key_registration.
        """
        return pulumi.get(self, "key_registrations")

    @key_registrations.setter
    def key_registrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyRegistrationKeyRegistrationArgs']]]]):
        pulumi.set(self, "key_registrations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:quicksight/keyRegistration:KeyRegistration")
class KeyRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_registrations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyRegistrationKeyRegistrationArgs', 'KeyRegistrationKeyRegistrationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Registers customer managed keys in a Amazon QuickSight account.

        > Deletion of this resource clears all CMK registrations from a QuickSight account. QuickSight then uses AWS owned keys to encrypt your resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.KeyRegistration("example", key_registrations=[
            {
                "key_arn": example1["arn"],
            },
            {
                "key_arn": example2["arn"],
                "default_key": True,
            },
        ])
        ```

        ## Import

        Using `pulumi import`, import QuickSight key registration using the AWS account ID. For example:

        ```sh
        $ pulumi import aws:quicksight/keyRegistration:KeyRegistration example "012345678901"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyRegistrationKeyRegistrationArgs', 'KeyRegistrationKeyRegistrationArgsDict']]]] key_registrations: Registered keys. See key_registration.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[KeyRegistrationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Registers customer managed keys in a Amazon QuickSight account.

        > Deletion of this resource clears all CMK registrations from a QuickSight account. QuickSight then uses AWS owned keys to encrypt your resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.KeyRegistration("example", key_registrations=[
            {
                "key_arn": example1["arn"],
            },
            {
                "key_arn": example2["arn"],
                "default_key": True,
            },
        ])
        ```

        ## Import

        Using `pulumi import`, import QuickSight key registration using the AWS account ID. For example:

        ```sh
        $ pulumi import aws:quicksight/keyRegistration:KeyRegistration example "012345678901"
        ```

        :param str resource_name: The name of the resource.
        :param KeyRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_registrations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyRegistrationKeyRegistrationArgs', 'KeyRegistrationKeyRegistrationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyRegistrationArgs.__new__(KeyRegistrationArgs)

            __props__.__dict__["aws_account_id"] = aws_account_id
            __props__.__dict__["key_registrations"] = key_registrations
            __props__.__dict__["region"] = region
        super(KeyRegistration, __self__).__init__(
            'aws:quicksight/keyRegistration:KeyRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_registrations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyRegistrationKeyRegistrationArgs', 'KeyRegistrationKeyRegistrationArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeyRegistration':
        """
        Get an existing KeyRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyRegistrationKeyRegistrationArgs', 'KeyRegistrationKeyRegistrationArgsDict']]]] key_registrations: Registered keys. See key_registration.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyRegistrationState.__new__(_KeyRegistrationState)

        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["key_registrations"] = key_registrations
        __props__.__dict__["region"] = region
        return KeyRegistration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter(name="keyRegistrations")
    def key_registrations(self) -> pulumi.Output[Optional[Sequence['outputs.KeyRegistrationKeyRegistration']]]:
        """
        Registered keys. See key_registration.
        """
        return pulumi.get(self, "key_registrations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

