# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserCustomPermissionArgs', 'UserCustomPermission']

@pulumi.input_type
class UserCustomPermissionArgs:
    def __init__(__self__, *,
                 custom_permissions_name: pulumi.Input[_builtins.str],
                 user_name: pulumi.Input[_builtins.str],
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserCustomPermission resource.
        :param pulumi.Input[_builtins.str] custom_permissions_name: Custom permissions profile name.
        :param pulumi.Input[_builtins.str] user_name: Username of the user.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] namespace: Namespace that the user belongs to. Defaults to `default`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "custom_permissions_name", custom_permissions_name)
        pulumi.set(__self__, "user_name", user_name)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="customPermissionsName")
    def custom_permissions_name(self) -> pulumi.Input[_builtins.str]:
        """
        Custom permissions profile name.
        """
        return pulumi.get(self, "custom_permissions_name")

    @custom_permissions_name.setter
    def custom_permissions_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_permissions_name", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[_builtins.str]:
        """
        Username of the user.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace that the user belongs to. Defaults to `default`.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _UserCustomPermissionState:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_permissions_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserCustomPermission resources.
        :param pulumi.Input[_builtins.str] custom_permissions_name: Custom permissions profile name.
        :param pulumi.Input[_builtins.str] namespace: Namespace that the user belongs to. Defaults to `default`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] user_name: Username of the user.
               
               The following arguments are optional:
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if custom_permissions_name is not None:
            pulumi.set(__self__, "custom_permissions_name", custom_permissions_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="customPermissionsName")
    def custom_permissions_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom permissions profile name.
        """
        return pulumi.get(self, "custom_permissions_name")

    @custom_permissions_name.setter
    def custom_permissions_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_permissions_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace that the user belongs to. Defaults to `default`.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username of the user.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("aws:quicksight/userCustomPermission:UserCustomPermission")
class UserCustomPermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_permissions_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the custom permissions profile for a user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.UserCustomPermission("example",
            user_name=example_aws_quicksight_user["userName"],
            custom_permissions_name=example_aws_quicksight_custom_permissions["customPermissionsName"])
        ```

        ## Import

        Using `pulumi import`, import QuickSight user custom permissions using a comma-delimited string combining the `aws_account_id`, `namespace`, and `user_name`. For example:

        ```sh
        $ pulumi import aws:quicksight/userCustomPermission:UserCustomPermission example 012345678901,default,user1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_permissions_name: Custom permissions profile name.
        :param pulumi.Input[_builtins.str] namespace: Namespace that the user belongs to. Defaults to `default`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] user_name: Username of the user.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserCustomPermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the custom permissions profile for a user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.UserCustomPermission("example",
            user_name=example_aws_quicksight_user["userName"],
            custom_permissions_name=example_aws_quicksight_custom_permissions["customPermissionsName"])
        ```

        ## Import

        Using `pulumi import`, import QuickSight user custom permissions using a comma-delimited string combining the `aws_account_id`, `namespace`, and `user_name`. For example:

        ```sh
        $ pulumi import aws:quicksight/userCustomPermission:UserCustomPermission example 012345678901,default,user1
        ```

        :param str resource_name: The name of the resource.
        :param UserCustomPermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserCustomPermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_permissions_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserCustomPermissionArgs.__new__(UserCustomPermissionArgs)

            __props__.__dict__["aws_account_id"] = aws_account_id
            if custom_permissions_name is None and not opts.urn:
                raise TypeError("Missing required property 'custom_permissions_name'")
            __props__.__dict__["custom_permissions_name"] = custom_permissions_name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["region"] = region
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
        super(UserCustomPermission, __self__).__init__(
            'aws:quicksight/userCustomPermission:UserCustomPermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_permissions_name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserCustomPermission':
        """
        Get an existing UserCustomPermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_permissions_name: Custom permissions profile name.
        :param pulumi.Input[_builtins.str] namespace: Namespace that the user belongs to. Defaults to `default`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] user_name: Username of the user.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserCustomPermissionState.__new__(_UserCustomPermissionState)

        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["custom_permissions_name"] = custom_permissions_name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["region"] = region
        __props__.__dict__["user_name"] = user_name
        return UserCustomPermission(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter(name="customPermissionsName")
    def custom_permissions_name(self) -> pulumi.Output[_builtins.str]:
        """
        Custom permissions profile name.
        """
        return pulumi.get(self, "custom_permissions_name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        Namespace that the user belongs to. Defaults to `default`.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        Username of the user.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_name")

