# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OptionGroupArgs', 'OptionGroup']

@pulumi.input_type
class OptionGroupArgs:
    def __init__(__self__, *,
                 engine_name: pulumi.Input[_builtins.str],
                 major_engine_version: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 option_group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a OptionGroup resource.
        :param pulumi.Input[_builtins.str] engine_name: Specifies the name of the engine that this option group should be associated with.
        :param pulumi.Input[_builtins.str] major_engine_version: Specifies the major version of the engine that this option group should be associated with.
        :param pulumi.Input[_builtins.str] name: Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
        :param pulumi.Input[_builtins.str] option_group_description: Description of the option group. Defaults to "Managed by Pulumi".
        :param pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionArgs']]] options: The options to apply. See `option` Block below for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_destroy: Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "engine_name", engine_name)
        pulumi.set(__self__, "major_engine_version", major_engine_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if option_group_description is None:
            option_group_description = 'Managed by Pulumi'
        if option_group_description is not None:
            pulumi.set(__self__, "option_group_description", option_group_description)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="engineName")
    def engine_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the engine that this option group should be associated with.
        """
        return pulumi.get(self, "engine_name")

    @engine_name.setter
    def engine_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_name", value)

    @_builtins.property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the major version of the engine that this option group should be associated with.
        """
        return pulumi.get(self, "major_engine_version")

    @major_engine_version.setter
    def major_engine_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "major_engine_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="optionGroupDescription")
    def option_group_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the option group. Defaults to "Managed by Pulumi".
        """
        return pulumi.get(self, "option_group_description")

    @option_group_description.setter
    def option_group_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "option_group_description", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionArgs']]]]:
        """
        The options to apply. See `option` Block below for more details.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _OptionGroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 major_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 option_group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering OptionGroup resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the DB option group.
        :param pulumi.Input[_builtins.str] engine_name: Specifies the name of the engine that this option group should be associated with.
        :param pulumi.Input[_builtins.str] major_engine_version: Specifies the major version of the engine that this option group should be associated with.
        :param pulumi.Input[_builtins.str] name: Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
        :param pulumi.Input[_builtins.str] option_group_description: Description of the option group. Defaults to "Managed by Pulumi".
        :param pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionArgs']]] options: The options to apply. See `option` Block below for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_destroy: Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if engine_name is not None:
            pulumi.set(__self__, "engine_name", engine_name)
        if major_engine_version is not None:
            pulumi.set(__self__, "major_engine_version", major_engine_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if option_group_description is None:
            option_group_description = 'Managed by Pulumi'
        if option_group_description is not None:
            pulumi.set(__self__, "option_group_description", option_group_description)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the DB option group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="engineName")
    def engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the engine that this option group should be associated with.
        """
        return pulumi.get(self, "engine_name")

    @engine_name.setter
    def engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_name", value)

    @_builtins.property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the major version of the engine that this option group should be associated with.
        """
        return pulumi.get(self, "major_engine_version")

    @major_engine_version.setter
    def major_engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "major_engine_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="optionGroupDescription")
    def option_group_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the option group. Defaults to "Managed by Pulumi".
        """
        return pulumi.get(self, "option_group_description")

    @option_group_description.setter
    def option_group_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "option_group_description", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionArgs']]]]:
        """
        The options to apply. See `option` Block below for more details.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:rds/optionGroup:OptionGroup")
class OptionGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 major_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 option_group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptionGroupOptionArgs', 'OptionGroupOptionArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an RDS DB option group resource. Documentation of the available options for various RDS engines can be found at:

        * [MariaDB Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MariaDB.Options.html)
        * [Microsoft SQL Server Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.Options.html)
        * [MySQL Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MySQL.Options.html)
        * [Oracle Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.Options.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.OptionGroup("example",
            name="option-group-test",
            option_group_description="Option Group",
            engine_name="sqlserver-ee",
            major_engine_version="11.00",
            options=[
                {
                    "option_name": "Timezone",
                    "option_settings": [{
                        "name": "TIME_ZONE",
                        "value": "UTC",
                    }],
                },
                {
                    "option_name": "SQLSERVER_BACKUP_RESTORE",
                    "option_settings": [{
                        "name": "IAM_ROLE_ARN",
                        "value": example_aws_iam_role["arn"],
                    }],
                },
                {
                    "option_name": "TDE",
                },
            ])
        ```

        > **Note:** Any modifications to the `rds.OptionGroup` are set to happen immediately as we default to applying immediately.

        > **WARNING:** You can perform a destroy on a `rds.OptionGroup`, as long as it is not associated with any Amazon RDS resource. An option group can be associated with a DB instance, a manual DB snapshot, or an automated DB snapshot.

        If you try to delete an option group that is associated with an Amazon RDS resource, an error similar to the following is returned:

        > An error occurred (InvalidOptionGroupStateFault) when calling the DeleteOptionGroup operation: The option group 'optionGroupName' cannot be deleted because it is in use.

        More information about this can be found [here](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithOptionGroups.html#USER_WorkingWithOptionGroups.Delete).

        ## Import

        Using `pulumi import`, import DB option groups using the `name`. For example:

        ```sh
        $ pulumi import aws:rds/optionGroup:OptionGroup example mysql-option-group
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] engine_name: Specifies the name of the engine that this option group should be associated with.
        :param pulumi.Input[_builtins.str] major_engine_version: Specifies the major version of the engine that this option group should be associated with.
        :param pulumi.Input[_builtins.str] name: Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
        :param pulumi.Input[_builtins.str] option_group_description: Description of the option group. Defaults to "Managed by Pulumi".
        :param pulumi.Input[Sequence[pulumi.Input[Union['OptionGroupOptionArgs', 'OptionGroupOptionArgsDict']]]] options: The options to apply. See `option` Block below for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_destroy: Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OptionGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an RDS DB option group resource. Documentation of the available options for various RDS engines can be found at:

        * [MariaDB Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MariaDB.Options.html)
        * [Microsoft SQL Server Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.Options.html)
        * [MySQL Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MySQL.Options.html)
        * [Oracle Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.Options.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.OptionGroup("example",
            name="option-group-test",
            option_group_description="Option Group",
            engine_name="sqlserver-ee",
            major_engine_version="11.00",
            options=[
                {
                    "option_name": "Timezone",
                    "option_settings": [{
                        "name": "TIME_ZONE",
                        "value": "UTC",
                    }],
                },
                {
                    "option_name": "SQLSERVER_BACKUP_RESTORE",
                    "option_settings": [{
                        "name": "IAM_ROLE_ARN",
                        "value": example_aws_iam_role["arn"],
                    }],
                },
                {
                    "option_name": "TDE",
                },
            ])
        ```

        > **Note:** Any modifications to the `rds.OptionGroup` are set to happen immediately as we default to applying immediately.

        > **WARNING:** You can perform a destroy on a `rds.OptionGroup`, as long as it is not associated with any Amazon RDS resource. An option group can be associated with a DB instance, a manual DB snapshot, or an automated DB snapshot.

        If you try to delete an option group that is associated with an Amazon RDS resource, an error similar to the following is returned:

        > An error occurred (InvalidOptionGroupStateFault) when calling the DeleteOptionGroup operation: The option group 'optionGroupName' cannot be deleted because it is in use.

        More information about this can be found [here](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithOptionGroups.html#USER_WorkingWithOptionGroups.Delete).

        ## Import

        Using `pulumi import`, import DB option groups using the `name`. For example:

        ```sh
        $ pulumi import aws:rds/optionGroup:OptionGroup example mysql-option-group
        ```

        :param str resource_name: The name of the resource.
        :param OptionGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OptionGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 major_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 option_group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptionGroupOptionArgs', 'OptionGroupOptionArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OptionGroupArgs.__new__(OptionGroupArgs)

            if engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'engine_name'")
            __props__.__dict__["engine_name"] = engine_name
            if major_engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'major_engine_version'")
            __props__.__dict__["major_engine_version"] = major_engine_version
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            if option_group_description is None:
                option_group_description = 'Managed by Pulumi'
            __props__.__dict__["option_group_description"] = option_group_description
            __props__.__dict__["options"] = options
            __props__.__dict__["region"] = region
            __props__.__dict__["skip_destroy"] = skip_destroy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(OptionGroup, __self__).__init__(
            'aws:rds/optionGroup:OptionGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            engine_name: Optional[pulumi.Input[_builtins.str]] = None,
            major_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            option_group_description: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OptionGroupOptionArgs', 'OptionGroupOptionArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'OptionGroup':
        """
        Get an existing OptionGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the DB option group.
        :param pulumi.Input[_builtins.str] engine_name: Specifies the name of the engine that this option group should be associated with.
        :param pulumi.Input[_builtins.str] major_engine_version: Specifies the major version of the engine that this option group should be associated with.
        :param pulumi.Input[_builtins.str] name: Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
        :param pulumi.Input[_builtins.str] option_group_description: Description of the option group. Defaults to "Managed by Pulumi".
        :param pulumi.Input[Sequence[pulumi.Input[Union['OptionGroupOptionArgs', 'OptionGroupOptionArgsDict']]]] options: The options to apply. See `option` Block below for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_destroy: Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OptionGroupState.__new__(_OptionGroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["engine_name"] = engine_name
        __props__.__dict__["major_engine_version"] = major_engine_version
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["option_group_description"] = option_group_description
        __props__.__dict__["options"] = options
        __props__.__dict__["region"] = region
        __props__.__dict__["skip_destroy"] = skip_destroy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return OptionGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the DB option group.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="engineName")
    def engine_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the engine that this option group should be associated with.
        """
        return pulumi.get(self, "engine_name")

    @_builtins.property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the major version of the engine that this option group should be associated with.
        """
        return pulumi.get(self, "major_engine_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="optionGroupDescription")
    def option_group_description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the option group. Defaults to "Managed by Pulumi".
        """
        return pulumi.get(self, "option_group_description")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Sequence['outputs.OptionGroupOption']]]:
        """
        The options to apply. See `option` Block below for more details.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
        """
        return pulumi.get(self, "skip_destroy")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

