# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterClusterNode',
    'EndpointAccessVpcEndpoint',
    'EndpointAccessVpcEndpointNetworkInterface',
    'IntegrationTimeouts',
    'ParameterGroupParameter',
    'ScheduledActionTargetAction',
    'ScheduledActionTargetActionPauseCluster',
    'ScheduledActionTargetActionResizeCluster',
    'ScheduledActionTargetActionResumeCluster',
    'GetClusterClusterNodeResult',
    'GetDataSharesDataShareResult',
    'GetProducerDataSharesDataShareResult',
]

@pulumi.output_type
class ClusterClusterNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeRole":
            suggest = "node_role"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "publicIpAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_role: Optional[_builtins.str] = None,
                 private_ip_address: Optional[_builtins.str] = None,
                 public_ip_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str node_role: Whether the node is a leader node or a compute node
        :param _builtins.str private_ip_address: The private IP address of a node within a cluster
        :param _builtins.str public_ip_address: The public IP address of a node within a cluster
        """
        if node_role is not None:
            pulumi.set(__self__, "node_role", node_role)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)

    @_builtins.property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> Optional[_builtins.str]:
        """
        Whether the node is a leader node or a compute node
        """
        return pulumi.get(self, "node_role")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[_builtins.str]:
        """
        The private IP address of a node within a cluster
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[_builtins.str]:
        """
        The public IP address of a node within a cluster
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class EndpointAccessVpcEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "vpcEndpointId":
            suggest = "vpc_endpoint_id"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointAccessVpcEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointAccessVpcEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointAccessVpcEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interfaces: Optional[Sequence['outputs.EndpointAccessVpcEndpointNetworkInterface']] = None,
                 vpc_endpoint_id: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None):
        """
        :param Sequence['EndpointAccessVpcEndpointNetworkInterfaceArgs'] network_interfaces: One or more network interfaces of the endpoint. Also known as an interface endpoint. See details below.
        :param _builtins.str vpc_endpoint_id: The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.
        :param _builtins.str vpc_id: The VPC identifier that the endpoint is associated.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.EndpointAccessVpcEndpointNetworkInterface']]:
        """
        One or more network interfaces of the endpoint. Also known as an interface endpoint. See details below.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[_builtins.str]:
        """
        The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The VPC identifier that the endpoint is associated.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class EndpointAccessVpcEndpointNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "networkInterfaceId":
            suggest = "network_interface_id"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointAccessVpcEndpointNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointAccessVpcEndpointNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointAccessVpcEndpointNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[_builtins.str] = None,
                 network_interface_id: Optional[_builtins.str] = None,
                 private_ip_address: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str availability_zone: The Availability Zone.
        :param _builtins.str network_interface_id: The network interface identifier.
        :param _builtins.str private_ip_address: The IPv4 address of the network interface within the subnet.
        :param _builtins.str subnet_id: The subnet identifier.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        """
        The Availability Zone.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[_builtins.str]:
        """
        The network interface identifier.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[_builtins.str]:
        """
        The IPv4 address of the network interface within the subnet.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The subnet identifier.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class IntegrationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class ParameterGroupParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Redshift parameter.
        :param _builtins.str value: The value of the Redshift parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Redshift parameter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the Redshift parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScheduledActionTargetAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pauseCluster":
            suggest = "pause_cluster"
        elif key == "resizeCluster":
            suggest = "resize_cluster"
        elif key == "resumeCluster":
            suggest = "resume_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledActionTargetAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledActionTargetAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledActionTargetAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pause_cluster: Optional['outputs.ScheduledActionTargetActionPauseCluster'] = None,
                 resize_cluster: Optional['outputs.ScheduledActionTargetActionResizeCluster'] = None,
                 resume_cluster: Optional['outputs.ScheduledActionTargetActionResumeCluster'] = None):
        """
        :param 'ScheduledActionTargetActionPauseClusterArgs' pause_cluster: An action that runs a `PauseCluster` API operation. Documented below.
        :param 'ScheduledActionTargetActionResizeClusterArgs' resize_cluster: An action that runs a `ResizeCluster` API operation. Documented below.
        :param 'ScheduledActionTargetActionResumeClusterArgs' resume_cluster: An action that runs a `ResumeCluster` API operation. Documented below.
        """
        if pause_cluster is not None:
            pulumi.set(__self__, "pause_cluster", pause_cluster)
        if resize_cluster is not None:
            pulumi.set(__self__, "resize_cluster", resize_cluster)
        if resume_cluster is not None:
            pulumi.set(__self__, "resume_cluster", resume_cluster)

    @_builtins.property
    @pulumi.getter(name="pauseCluster")
    def pause_cluster(self) -> Optional['outputs.ScheduledActionTargetActionPauseCluster']:
        """
        An action that runs a `PauseCluster` API operation. Documented below.
        """
        return pulumi.get(self, "pause_cluster")

    @_builtins.property
    @pulumi.getter(name="resizeCluster")
    def resize_cluster(self) -> Optional['outputs.ScheduledActionTargetActionResizeCluster']:
        """
        An action that runs a `ResizeCluster` API operation. Documented below.
        """
        return pulumi.get(self, "resize_cluster")

    @_builtins.property
    @pulumi.getter(name="resumeCluster")
    def resume_cluster(self) -> Optional['outputs.ScheduledActionTargetActionResumeCluster']:
        """
        An action that runs a `ResumeCluster` API operation. Documented below.
        """
        return pulumi.get(self, "resume_cluster")


@pulumi.output_type
class ScheduledActionTargetActionPauseCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterIdentifier":
            suggest = "cluster_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledActionTargetActionPauseCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledActionTargetActionPauseCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledActionTargetActionPauseCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_identifier: _builtins.str):
        """
        :param _builtins.str cluster_identifier: The identifier of the cluster to be paused.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)

    @_builtins.property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> _builtins.str:
        """
        The identifier of the cluster to be paused.
        """
        return pulumi.get(self, "cluster_identifier")


@pulumi.output_type
class ScheduledActionTargetActionResizeCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterIdentifier":
            suggest = "cluster_identifier"
        elif key == "clusterType":
            suggest = "cluster_type"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "numberOfNodes":
            suggest = "number_of_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledActionTargetActionResizeCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledActionTargetActionResizeCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledActionTargetActionResizeCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_identifier: _builtins.str,
                 classic: Optional[_builtins.bool] = None,
                 cluster_type: Optional[_builtins.str] = None,
                 node_type: Optional[_builtins.str] = None,
                 number_of_nodes: Optional[_builtins.int] = None):
        """
        :param _builtins.str cluster_identifier: The unique identifier for the cluster to resize.
        :param _builtins.bool classic: A boolean value indicating whether the resize operation is using the classic resize process. Default: `false`.
        :param _builtins.str cluster_type: The new cluster type for the specified cluster.
        :param _builtins.str node_type: The new node type for the nodes you are adding.
        :param _builtins.int number_of_nodes: The new number of nodes for the cluster.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if classic is not None:
            pulumi.set(__self__, "classic", classic)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)

    @_builtins.property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> _builtins.str:
        """
        The unique identifier for the cluster to resize.
        """
        return pulumi.get(self, "cluster_identifier")

    @_builtins.property
    @pulumi.getter
    def classic(self) -> Optional[_builtins.bool]:
        """
        A boolean value indicating whether the resize operation is using the classic resize process. Default: `false`.
        """
        return pulumi.get(self, "classic")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[_builtins.str]:
        """
        The new cluster type for the specified cluster.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[_builtins.str]:
        """
        The new node type for the nodes you are adding.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[_builtins.int]:
        """
        The new number of nodes for the cluster.
        """
        return pulumi.get(self, "number_of_nodes")


@pulumi.output_type
class ScheduledActionTargetActionResumeCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterIdentifier":
            suggest = "cluster_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledActionTargetActionResumeCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledActionTargetActionResumeCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledActionTargetActionResumeCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_identifier: _builtins.str):
        """
        :param _builtins.str cluster_identifier: The identifier of the cluster to be resumed.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)

    @_builtins.property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> _builtins.str:
        """
        The identifier of the cluster to be resumed.
        """
        return pulumi.get(self, "cluster_identifier")


@pulumi.output_type
class GetClusterClusterNodeResult(dict):
    def __init__(__self__, *,
                 node_role: _builtins.str,
                 private_ip_address: _builtins.str,
                 public_ip_address: _builtins.str):
        """
        :param _builtins.str node_role: Whether the node is a leader node or a compute node
        :param _builtins.str private_ip_address: Private IP address of a node within a cluster
        :param _builtins.str public_ip_address: Public IP address of a node within a cluster
        """
        pulumi.set(__self__, "node_role", node_role)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)

    @_builtins.property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> _builtins.str:
        """
        Whether the node is a leader node or a compute node
        """
        return pulumi.get(self, "node_role")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> _builtins.str:
        """
        Private IP address of a node within a cluster
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> _builtins.str:
        """
        Public IP address of a node within a cluster
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class GetDataSharesDataShareResult(dict):
    def __init__(__self__, *,
                 data_share_arn: _builtins.str,
                 managed_by: _builtins.str,
                 producer_arn: _builtins.str):
        """
        :param _builtins.str data_share_arn: ARN (Amazon Resource Name) of the data share.
        :param _builtins.str managed_by: Identifier of a datashare to show its managing entity.
        :param _builtins.str producer_arn: ARN (Amazon Resource Name) of the producer.
        """
        pulumi.set(__self__, "data_share_arn", data_share_arn)
        pulumi.set(__self__, "managed_by", managed_by)
        pulumi.set(__self__, "producer_arn", producer_arn)

    @_builtins.property
    @pulumi.getter(name="dataShareArn")
    def data_share_arn(self) -> _builtins.str:
        """
        ARN (Amazon Resource Name) of the data share.
        """
        return pulumi.get(self, "data_share_arn")

    @_builtins.property
    @pulumi.getter(name="managedBy")
    def managed_by(self) -> _builtins.str:
        """
        Identifier of a datashare to show its managing entity.
        """
        return pulumi.get(self, "managed_by")

    @_builtins.property
    @pulumi.getter(name="producerArn")
    def producer_arn(self) -> _builtins.str:
        """
        ARN (Amazon Resource Name) of the producer.
        """
        return pulumi.get(self, "producer_arn")


@pulumi.output_type
class GetProducerDataSharesDataShareResult(dict):
    def __init__(__self__, *,
                 data_share_arn: _builtins.str,
                 managed_by: _builtins.str,
                 producer_arn: _builtins.str):
        """
        :param _builtins.str data_share_arn: ARN (Amazon Resource Name) of the data share.
        :param _builtins.str managed_by: Identifier of a datashare to show its managing entity.
        :param _builtins.str producer_arn: Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "data_share_arn", data_share_arn)
        pulumi.set(__self__, "managed_by", managed_by)
        pulumi.set(__self__, "producer_arn", producer_arn)

    @_builtins.property
    @pulumi.getter(name="dataShareArn")
    def data_share_arn(self) -> _builtins.str:
        """
        ARN (Amazon Resource Name) of the data share.
        """
        return pulumi.get(self, "data_share_arn")

    @_builtins.property
    @pulumi.getter(name="managedBy")
    def managed_by(self) -> _builtins.str:
        """
        Identifier of a datashare to show its managing entity.
        """
        return pulumi.get(self, "managed_by")

    @_builtins.property
    @pulumi.getter(name="producerArn")
    def producer_arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.

        The following arguments are optional:
        """
        return pulumi.get(self, "producer_arn")


