# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResolverFirewallRulesResult',
    'AwaitableGetResolverFirewallRulesResult',
    'get_resolver_firewall_rules',
    'get_resolver_firewall_rules_output',
]

@pulumi.output_type
class GetResolverFirewallRulesResult:
    """
    A collection of values returned by getResolverFirewallRules.
    """
    def __init__(__self__, action=None, firewall_rule_group_id=None, firewall_rules=None, id=None, priority=None, region=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if firewall_rule_group_id and not isinstance(firewall_rule_group_id, str):
            raise TypeError("Expected argument 'firewall_rule_group_id' to be a str")
        pulumi.set(__self__, "firewall_rule_group_id", firewall_rule_group_id)
        if firewall_rules and not isinstance(firewall_rules, list):
            raise TypeError("Expected argument 'firewall_rules' to be a list")
        pulumi.set(__self__, "firewall_rules", firewall_rules)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="firewallRuleGroupId")
    def firewall_rule_group_id(self) -> _builtins.str:
        return pulumi.get(self, "firewall_rule_group_id")

    @_builtins.property
    @pulumi.getter(name="firewallRules")
    def firewall_rules(self) -> Sequence['outputs.GetResolverFirewallRulesFirewallRuleResult']:
        """
        List with information about the firewall rules. See details below.
        """
        return pulumi.get(self, "firewall_rules")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetResolverFirewallRulesResult(GetResolverFirewallRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolverFirewallRulesResult(
            action=self.action,
            firewall_rule_group_id=self.firewall_rule_group_id,
            firewall_rules=self.firewall_rules,
            id=self.id,
            priority=self.priority,
            region=self.region)


def get_resolver_firewall_rules(action: Optional[_builtins.str] = None,
                                firewall_rule_group_id: Optional[_builtins.str] = None,
                                priority: Optional[_builtins.int] = None,
                                region: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolverFirewallRulesResult:
    """
    `route53_get_resolver_firewall_rules` Provides details about rules in a specific Route53 Resolver Firewall rule group.

    ## Example Usage

    The following example shows how to get Route53 Resolver Firewall rules based on its associated firewall group id.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_firewall_rules(firewall_rule_group_id=example_aws_route53_resolver_firewall_rule_group["id"])
    ```


    :param _builtins.str action: The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list.
    :param _builtins.str firewall_rule_group_id: The unique identifier of the firewall rule group that you want to retrieve the rules for.
    :param _builtins.int priority: The setting that determines the processing order of the rules in a rule group.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['firewallRuleGroupId'] = firewall_rule_group_id
    __args__['priority'] = priority
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:route53/getResolverFirewallRules:getResolverFirewallRules', __args__, opts=opts, typ=GetResolverFirewallRulesResult).value

    return AwaitableGetResolverFirewallRulesResult(
        action=pulumi.get(__ret__, 'action'),
        firewall_rule_group_id=pulumi.get(__ret__, 'firewall_rule_group_id'),
        firewall_rules=pulumi.get(__ret__, 'firewall_rules'),
        id=pulumi.get(__ret__, 'id'),
        priority=pulumi.get(__ret__, 'priority'),
        region=pulumi.get(__ret__, 'region'))
def get_resolver_firewall_rules_output(action: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       firewall_rule_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       priority: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResolverFirewallRulesResult]:
    """
    `route53_get_resolver_firewall_rules` Provides details about rules in a specific Route53 Resolver Firewall rule group.

    ## Example Usage

    The following example shows how to get Route53 Resolver Firewall rules based on its associated firewall group id.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_firewall_rules(firewall_rule_group_id=example_aws_route53_resolver_firewall_rule_group["id"])
    ```


    :param _builtins.str action: The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list.
    :param _builtins.str firewall_rule_group_id: The unique identifier of the firewall rule group that you want to retrieve the rules for.
    :param _builtins.int priority: The setting that determines the processing order of the rules in a rule group.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['firewallRuleGroupId'] = firewall_rule_group_id
    __args__['priority'] = priority
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:route53/getResolverFirewallRules:getResolverFirewallRules', __args__, opts=opts, typ=GetResolverFirewallRulesResult)
    return __ret__.apply(lambda __response__: GetResolverFirewallRulesResult(
        action=pulumi.get(__response__, 'action'),
        firewall_rule_group_id=pulumi.get(__response__, 'firewall_rule_group_id'),
        firewall_rules=pulumi.get(__response__, 'firewall_rules'),
        id=pulumi.get(__response__, 'id'),
        priority=pulumi.get(__response__, 'priority'),
        region=pulumi.get(__response__, 'region')))
