# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProfilesResourceAssociationArgs', 'ProfilesResourceAssociation']

@pulumi.input_type
class ProfilesResourceAssociationArgs:
    def __init__(__self__, *,
                 profile_id: pulumi.Input[_builtins.str],
                 resource_arn: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ProfilesResourceAssociationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ProfilesResourceAssociation resource.
        :param pulumi.Input[_builtins.str] profile_id: ID of the profile associated with the VPC.
        :param pulumi.Input[_builtins.str] resource_arn: Resource ID of the resource to be associated with the profile.
        :param pulumi.Input[_builtins.str] name: Name of the Profile Resource Association.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_properties: Resource properties for the resource to be associated with the profile.
        """
        pulumi.set(__self__, "profile_id", profile_id)
        pulumi.set(__self__, "resource_arn", resource_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_properties is not None:
            pulumi.set(__self__, "resource_properties", resource_properties)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the profile associated with the VPC.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID of the resource to be associated with the profile.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Profile Resource Association.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource properties for the resource to be associated with the profile.
        """
        return pulumi.get(self, "resource_properties")

    @resource_properties.setter
    def resource_properties(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_properties", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ProfilesResourceAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ProfilesResourceAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ProfilesResourceAssociationState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_message: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ProfilesResourceAssociationTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering ProfilesResourceAssociation resources.
        :param pulumi.Input[_builtins.str] name: Name of the Profile Resource Association.
        :param pulumi.Input[_builtins.str] profile_id: ID of the profile associated with the VPC.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_arn: Resource ID of the resource to be associated with the profile.
        :param pulumi.Input[_builtins.str] resource_properties: Resource properties for the resource to be associated with the profile.
        :param pulumi.Input[_builtins.str] resource_type: Type of resource associated with the profile.
        :param pulumi.Input[_builtins.str] status: Status of the Profile Association. Valid values [AWS docs](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_Profile.html)
        :param pulumi.Input[_builtins.str] status_message: Status message of the Profile Resource Association.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if resource_properties is not None:
            pulumi.set(__self__, "resource_properties", resource_properties)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Profile Resource Association.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the profile associated with the VPC.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID of the resource to be associated with the profile.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_arn", value)

    @_builtins.property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource properties for the resource to be associated with the profile.
        """
        return pulumi.get(self, "resource_properties")

    @resource_properties.setter
    def resource_properties(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_properties", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of resource associated with the profile.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the Profile Association. Valid values [AWS docs](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_Profile.html)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status message of the Profile Resource Association.
        """
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_message", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ProfilesResourceAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ProfilesResourceAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:route53/profilesResourceAssociation:ProfilesResourceAssociation")
class ProfilesResourceAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ProfilesResourceAssociationTimeoutsArgs', 'ProfilesResourceAssociationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Route 53 Profiles Resource Association.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Route 53 Profiles Resource Association using the `id`. For example:

        ```sh
        $ pulumi import aws:route53/profilesResourceAssociation:ProfilesResourceAssociation example rpa-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the Profile Resource Association.
        :param pulumi.Input[_builtins.str] profile_id: ID of the profile associated with the VPC.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_arn: Resource ID of the resource to be associated with the profile.
        :param pulumi.Input[_builtins.str] resource_properties: Resource properties for the resource to be associated with the profile.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfilesResourceAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Route 53 Profiles Resource Association.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Route 53 Profiles Resource Association using the `id`. For example:

        ```sh
        $ pulumi import aws:route53/profilesResourceAssociation:ProfilesResourceAssociation example rpa-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param ProfilesResourceAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfilesResourceAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ProfilesResourceAssociationTimeoutsArgs', 'ProfilesResourceAssociationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfilesResourceAssociationArgs.__new__(ProfilesResourceAssociationArgs)

            __props__.__dict__["name"] = name
            if profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_id'")
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["region"] = region
            if resource_arn is None and not opts.urn:
                raise TypeError("Missing required property 'resource_arn'")
            __props__.__dict__["resource_arn"] = resource_arn
            __props__.__dict__["resource_properties"] = resource_properties
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
        super(ProfilesResourceAssociation, __self__).__init__(
            'aws:route53/profilesResourceAssociation:ProfilesResourceAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
            resource_properties: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_message: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['ProfilesResourceAssociationTimeoutsArgs', 'ProfilesResourceAssociationTimeoutsArgsDict']]] = None) -> 'ProfilesResourceAssociation':
        """
        Get an existing ProfilesResourceAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the Profile Resource Association.
        :param pulumi.Input[_builtins.str] profile_id: ID of the profile associated with the VPC.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_arn: Resource ID of the resource to be associated with the profile.
        :param pulumi.Input[_builtins.str] resource_properties: Resource properties for the resource to be associated with the profile.
        :param pulumi.Input[_builtins.str] resource_type: Type of resource associated with the profile.
        :param pulumi.Input[_builtins.str] status: Status of the Profile Association. Valid values [AWS docs](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_Profile.html)
        :param pulumi.Input[_builtins.str] status_message: Status message of the Profile Resource Association.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfilesResourceAssociationState.__new__(_ProfilesResourceAssociationState)

        __props__.__dict__["name"] = name
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_arn"] = resource_arn
        __props__.__dict__["resource_properties"] = resource_properties
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["status"] = status
        __props__.__dict__["status_message"] = status_message
        __props__.__dict__["timeouts"] = timeouts
        return ProfilesResourceAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Profile Resource Association.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the profile associated with the VPC.
        """
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID of the resource to be associated with the profile.
        """
        return pulumi.get(self, "resource_arn")

    @_builtins.property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> pulumi.Output[_builtins.str]:
        """
        Resource properties for the resource to be associated with the profile.
        """
        return pulumi.get(self, "resource_properties")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of resource associated with the profile.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the Profile Association. Valid values [AWS docs](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_Profile.html)
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[_builtins.str]:
        """
        Status message of the Profile Resource Association.
        """
        return pulumi.get(self, "status_message")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ProfilesResourceAssociationTimeouts']]:
        return pulumi.get(self, "timeouts")

