# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketObjectv2Args', 'BucketObjectv2']

@pulumi.input_type
class BucketObjectv2Args:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cache_control: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 content_language: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
                 override_provider: Optional[pulumi.Input['BucketObjectv2OverrideProviderArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 source_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 website_redirect: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketObjectv2 resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
        :param pulumi.Input[_builtins.str] acl: [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`.
        :param pulumi.Input[_builtins.bool] bucket_key_enabled: Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        :param pulumi.Input[_builtins.str] cache_control: Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[_builtins.str] checksum_algorithm: Indicates the algorithm used to create the checksum for the object. If a value is specified and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `CRC32`, `CRC32C`, `CRC64NVME`, `SHA1`, `SHA256`.
        :param pulumi.Input[_builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        :param pulumi.Input[_builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        :param pulumi.Input[_builtins.str] content_disposition: Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[_builtins.str] content_encoding: Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[_builtins.str] content_language: Language the content is in e.g., en-US or en-GB.
        :param pulumi.Input[_builtins.str] content_type: Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"`, also if an object is larger than 16 MB, the AWS Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest (see `source_hash` instead).
        :param pulumi.Input[_builtins.bool] force_destroy: Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        :param pulumi.Input[_builtins.str] key: Name of the object once it is in the bucket.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] kms_key_id: ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `kms.Key` resource, use the `arn` attribute. If referencing the `kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        :param pulumi.Input[_builtins.str] object_lock_legal_hold_status: [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        :param pulumi.Input[_builtins.str] object_lock_mode: Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param pulumi.Input[_builtins.str] object_lock_retain_until_date: Date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        :param pulumi.Input['BucketObjectv2OverrideProviderArgs'] override_provider: Override provider-level configuration options. See Override Provider below for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] server_side_encryption: Server-side encryption of the object in S3. Valid values are `"AES256"`, `"aws:kms"`, `"aws:kms:dsse"`, and `"aws:fsx"`.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: Path to a file that will be read and uploaded as raw bytes for the object content.
        :param pulumi.Input[_builtins.str] source_hash: Triggers updates like `etag` but useful to address `etag` encryption limitations. (The value is only stored in state and not saved by AWS.)
        :param pulumi.Input[_builtins.str] storage_class: [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] website_redirect: Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
               
               If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.
               
               > **Note:** If you specify `content_encoding` you are responsible for encoding the body appropriately. `source`, `content`, and `content_base64` all expect already encoded/compressed bytes.
               
               > **Note:** The provider ignores all leading `/`s in the object's `key` and treats multiple `/`s in the rest of the object's `key` as a single `/`, so values of `/index.html` and `index.html` correspond to the same S3 object as do `first//second///third//` and `first/second/third/`.
        """
        pulumi.set(__self__, "bucket", bucket)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if checksum_algorithm is not None:
            pulumi.set(__self__, "checksum_algorithm", checksum_algorithm)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if object_lock_legal_hold_status is not None:
            pulumi.set(__self__, "object_lock_legal_hold_status", object_lock_legal_hold_status)
        if object_lock_mode is not None:
            pulumi.set(__self__, "object_lock_mode", object_lock_mode)
        if object_lock_retain_until_date is not None:
            pulumi.set(__self__, "object_lock_retain_until_date", object_lock_retain_until_date)
        if override_provider is not None:
            pulumi.set(__self__, "override_provider", override_provider)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_hash is not None:
            pulumi.set(__self__, "source_hash", source_hash)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if website_redirect is not None:
            pulumi.set(__self__, "website_redirect", website_redirect)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        return pulumi.get(self, "bucket_key_enabled")

    @bucket_key_enabled.setter
    def bucket_key_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bucket_key_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @_builtins.property
    @pulumi.getter(name="checksumAlgorithm")
    def checksum_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the algorithm used to create the checksum for the object. If a value is specified and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `CRC32`, `CRC32C`, `CRC64NVME`, `SHA1`, `SHA256`.
        """
        return pulumi.get(self, "checksum_algorithm")

    @checksum_algorithm.setter
    def checksum_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_disposition", value)

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @_builtins.property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language the content is in e.g., en-US or en-GB.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_language", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"`, also if an object is larger than 16 MB, the AWS Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest (see `source_hash` instead).
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the object once it is in the bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `kms.Key` resource, use the `arn` attribute. If referencing the `kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="objectLockLegalHoldStatus")
    def object_lock_legal_hold_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        """
        return pulumi.get(self, "object_lock_legal_hold_status")

    @object_lock_legal_hold_status.setter
    def object_lock_legal_hold_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_legal_hold_status", value)

    @_builtins.property
    @pulumi.getter(name="objectLockMode")
    def object_lock_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "object_lock_mode")

    @object_lock_mode.setter
    def object_lock_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_mode", value)

    @_builtins.property
    @pulumi.getter(name="objectLockRetainUntilDate")
    def object_lock_retain_until_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        """
        return pulumi.get(self, "object_lock_retain_until_date")

    @object_lock_retain_until_date.setter
    def object_lock_retain_until_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_retain_until_date", value)

    @_builtins.property
    @pulumi.getter(name="overrideProvider")
    def override_provider(self) -> Optional[pulumi.Input['BucketObjectv2OverrideProviderArgs']]:
        """
        Override provider-level configuration options. See Override Provider below for more details.
        """
        return pulumi.get(self, "override_provider")

    @override_provider.setter
    def override_provider(self, value: Optional[pulumi.Input['BucketObjectv2OverrideProviderArgs']]):
        pulumi.set(self, "override_provider", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-side encryption of the object in S3. Valid values are `"AES256"`, `"aws:kms"`, `"aws:kms:dsse"`, and `"aws:fsx"`.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_side_encryption", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        Path to a file that will be read and uploaded as raw bytes for the object content.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Triggers updates like `etag` but useful to address `etag` encryption limitations. (The value is only stored in state and not saved by AWS.)
        """
        return pulumi.get(self, "source_hash")

    @source_hash.setter
    def source_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_hash", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="websiteRedirect")
    def website_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).

        If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.

        > **Note:** If you specify `content_encoding` you are responsible for encoding the body appropriately. `source`, `content`, and `content_base64` all expect already encoded/compressed bytes.

        > **Note:** The provider ignores all leading `/`s in the object's `key` and treats multiple `/`s in the rest of the object's `key` as a single `/`, so values of `/index.html` and `index.html` correspond to the same S3 object as do `first//second///third//` and `first/second/third/`.
        """
        return pulumi.get(self, "website_redirect")

    @website_redirect.setter
    def website_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_redirect", value)


@pulumi.input_type
class _BucketObjectv2State:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cache_control: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum_crc32: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum_crc32c: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum_crc64nvme: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum_sha1: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum_sha256: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 content_language: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
                 override_provider: Optional[pulumi.Input['BucketObjectv2OverrideProviderArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 source_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 website_redirect: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketObjectv2 resources.
        :param pulumi.Input[_builtins.str] acl: [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`.
        :param pulumi.Input[_builtins.str] arn: ARN of the object.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
        :param pulumi.Input[_builtins.bool] bucket_key_enabled: Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        :param pulumi.Input[_builtins.str] cache_control: Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[_builtins.str] checksum_algorithm: Indicates the algorithm used to create the checksum for the object. If a value is specified and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `CRC32`, `CRC32C`, `CRC64NVME`, `SHA1`, `SHA256`.
        :param pulumi.Input[_builtins.str] checksum_crc32: The base64-encoded, 32-bit CRC32 checksum of the object.
        :param pulumi.Input[_builtins.str] checksum_crc32c: The base64-encoded, 32-bit CRC32C checksum of the object.
        :param pulumi.Input[_builtins.str] checksum_crc64nvme: The base64-encoded, 64-bit CRC64NVME checksum of the object.
        :param pulumi.Input[_builtins.str] checksum_sha1: The base64-encoded, 160-bit SHA-1 digest of the object.
        :param pulumi.Input[_builtins.str] checksum_sha256: The base64-encoded, 256-bit SHA-256 digest of the object.
        :param pulumi.Input[_builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        :param pulumi.Input[_builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        :param pulumi.Input[_builtins.str] content_disposition: Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[_builtins.str] content_encoding: Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[_builtins.str] content_language: Language the content is in e.g., en-US or en-GB.
        :param pulumi.Input[_builtins.str] content_type: Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"`, also if an object is larger than 16 MB, the AWS Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest (see `source_hash` instead).
        :param pulumi.Input[_builtins.bool] force_destroy: Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        :param pulumi.Input[_builtins.str] key: Name of the object once it is in the bucket.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] kms_key_id: ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `kms.Key` resource, use the `arn` attribute. If referencing the `kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        :param pulumi.Input[_builtins.str] object_lock_legal_hold_status: [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        :param pulumi.Input[_builtins.str] object_lock_mode: Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param pulumi.Input[_builtins.str] object_lock_retain_until_date: Date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        :param pulumi.Input['BucketObjectv2OverrideProviderArgs'] override_provider: Override provider-level configuration options. See Override Provider below for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] server_side_encryption: Server-side encryption of the object in S3. Valid values are `"AES256"`, `"aws:kms"`, `"aws:kms:dsse"`, and `"aws:fsx"`.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: Path to a file that will be read and uploaded as raw bytes for the object content.
        :param pulumi.Input[_builtins.str] source_hash: Triggers updates like `etag` but useful to address `etag` encryption limitations. (The value is only stored in state and not saved by AWS.)
        :param pulumi.Input[_builtins.str] storage_class: [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] version_id: Unique version ID value for the object, if bucket versioning is enabled.
        :param pulumi.Input[_builtins.str] website_redirect: Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
               
               If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.
               
               > **Note:** If you specify `content_encoding` you are responsible for encoding the body appropriately. `source`, `content`, and `content_base64` all expect already encoded/compressed bytes.
               
               > **Note:** The provider ignores all leading `/`s in the object's `key` and treats multiple `/`s in the rest of the object's `key` as a single `/`, so values of `/index.html` and `index.html` correspond to the same S3 object as do `first//second///third//` and `first/second/third/`.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if checksum_algorithm is not None:
            pulumi.set(__self__, "checksum_algorithm", checksum_algorithm)
        if checksum_crc32 is not None:
            pulumi.set(__self__, "checksum_crc32", checksum_crc32)
        if checksum_crc32c is not None:
            pulumi.set(__self__, "checksum_crc32c", checksum_crc32c)
        if checksum_crc64nvme is not None:
            pulumi.set(__self__, "checksum_crc64nvme", checksum_crc64nvme)
        if checksum_sha1 is not None:
            pulumi.set(__self__, "checksum_sha1", checksum_sha1)
        if checksum_sha256 is not None:
            pulumi.set(__self__, "checksum_sha256", checksum_sha256)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if object_lock_legal_hold_status is not None:
            pulumi.set(__self__, "object_lock_legal_hold_status", object_lock_legal_hold_status)
        if object_lock_mode is not None:
            pulumi.set(__self__, "object_lock_mode", object_lock_mode)
        if object_lock_retain_until_date is not None:
            pulumi.set(__self__, "object_lock_retain_until_date", object_lock_retain_until_date)
        if override_provider is not None:
            pulumi.set(__self__, "override_provider", override_provider)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_hash is not None:
            pulumi.set(__self__, "source_hash", source_hash)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if website_redirect is not None:
            pulumi.set(__self__, "website_redirect", website_redirect)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the object.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        return pulumi.get(self, "bucket_key_enabled")

    @bucket_key_enabled.setter
    def bucket_key_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bucket_key_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @_builtins.property
    @pulumi.getter(name="checksumAlgorithm")
    def checksum_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the algorithm used to create the checksum for the object. If a value is specified and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `CRC32`, `CRC32C`, `CRC64NVME`, `SHA1`, `SHA256`.
        """
        return pulumi.get(self, "checksum_algorithm")

    @checksum_algorithm.setter
    def checksum_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="checksumCrc32")
    def checksum_crc32(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded, 32-bit CRC32 checksum of the object.
        """
        return pulumi.get(self, "checksum_crc32")

    @checksum_crc32.setter
    def checksum_crc32(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum_crc32", value)

    @_builtins.property
    @pulumi.getter(name="checksumCrc32c")
    def checksum_crc32c(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded, 32-bit CRC32C checksum of the object.
        """
        return pulumi.get(self, "checksum_crc32c")

    @checksum_crc32c.setter
    def checksum_crc32c(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum_crc32c", value)

    @_builtins.property
    @pulumi.getter(name="checksumCrc64nvme")
    def checksum_crc64nvme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded, 64-bit CRC64NVME checksum of the object.
        """
        return pulumi.get(self, "checksum_crc64nvme")

    @checksum_crc64nvme.setter
    def checksum_crc64nvme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum_crc64nvme", value)

    @_builtins.property
    @pulumi.getter(name="checksumSha1")
    def checksum_sha1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded, 160-bit SHA-1 digest of the object.
        """
        return pulumi.get(self, "checksum_sha1")

    @checksum_sha1.setter
    def checksum_sha1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum_sha1", value)

    @_builtins.property
    @pulumi.getter(name="checksumSha256")
    def checksum_sha256(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded, 256-bit SHA-256 digest of the object.
        """
        return pulumi.get(self, "checksum_sha256")

    @checksum_sha256.setter
    def checksum_sha256(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum_sha256", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_disposition", value)

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @_builtins.property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language the content is in e.g., en-US or en-GB.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_language", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"`, also if an object is larger than 16 MB, the AWS Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest (see `source_hash` instead).
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the object once it is in the bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `kms.Key` resource, use the `arn` attribute. If referencing the `kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="objectLockLegalHoldStatus")
    def object_lock_legal_hold_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        """
        return pulumi.get(self, "object_lock_legal_hold_status")

    @object_lock_legal_hold_status.setter
    def object_lock_legal_hold_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_legal_hold_status", value)

    @_builtins.property
    @pulumi.getter(name="objectLockMode")
    def object_lock_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "object_lock_mode")

    @object_lock_mode.setter
    def object_lock_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_mode", value)

    @_builtins.property
    @pulumi.getter(name="objectLockRetainUntilDate")
    def object_lock_retain_until_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        """
        return pulumi.get(self, "object_lock_retain_until_date")

    @object_lock_retain_until_date.setter
    def object_lock_retain_until_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_retain_until_date", value)

    @_builtins.property
    @pulumi.getter(name="overrideProvider")
    def override_provider(self) -> Optional[pulumi.Input['BucketObjectv2OverrideProviderArgs']]:
        """
        Override provider-level configuration options. See Override Provider below for more details.
        """
        return pulumi.get(self, "override_provider")

    @override_provider.setter
    def override_provider(self, value: Optional[pulumi.Input['BucketObjectv2OverrideProviderArgs']]):
        pulumi.set(self, "override_provider", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-side encryption of the object in S3. Valid values are `"AES256"`, `"aws:kms"`, `"aws:kms:dsse"`, and `"aws:fsx"`.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_side_encryption", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        Path to a file that will be read and uploaded as raw bytes for the object content.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Triggers updates like `etag` but useful to address `etag` encryption limitations. (The value is only stored in state and not saved by AWS.)
        """
        return pulumi.get(self, "source_hash")

    @source_hash.setter
    def source_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_hash", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique version ID value for the object, if bucket versioning is enabled.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)

    @_builtins.property
    @pulumi.getter(name="websiteRedirect")
    def website_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).

        If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.

        > **Note:** If you specify `content_encoding` you are responsible for encoding the body appropriately. `source`, `content`, and `content_base64` all expect already encoded/compressed bytes.

        > **Note:** The provider ignores all leading `/`s in the object's `key` and treats multiple `/`s in the rest of the object's `key` as a single `/`, so values of `/index.html` and `index.html` correspond to the same S3 object as do `first//second///third//` and `first/second/third/`.
        """
        return pulumi.get(self, "website_redirect")

    @website_redirect.setter
    def website_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_redirect", value)


@pulumi.type_token("aws:s3/bucketObjectv2:BucketObjectv2")
class BucketObjectv2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cache_control: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 content_language: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
                 override_provider: Optional[pulumi.Input[Union['BucketObjectv2OverrideProviderArgs', 'BucketObjectv2OverrideProviderArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 source_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 website_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an S3 object resource.

        ## Example Usage

        ### Uploading a file to a bucket

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        object = aws.s3.BucketObjectv2("object",
            bucket="your_bucket_name",
            key="new_object_key",
            source=pulumi.FileAsset("path/to/file"),
            etag=std.filemd5(input="path/to/file").result)
        ```

        ### Encrypting with KMS Key

        ```python
        import pulumi
        import pulumi_aws as aws

        examplekms = aws.kms.Key("examplekms",
            description="KMS key 1",
            deletion_window_in_days=7)
        examplebucket = aws.s3.Bucket("examplebucket", bucket="examplebuckettftest")
        example = aws.s3.BucketAcl("example",
            bucket=examplebucket.id,
            acl="private")
        example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("index.html"),
            kms_key_id=examplekms.arn)
        ```

        ### Server Side Encryption with S3 Default Master Key

        ```python
        import pulumi
        import pulumi_aws as aws

        examplebucket = aws.s3.Bucket("examplebucket", bucket="examplebuckettftest")
        example = aws.s3.BucketAcl("example",
            bucket=examplebucket.id,
            acl="private")
        example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("index.html"),
            server_side_encryption="aws:kms")
        ```

        ### Server Side Encryption with AWS-Managed Key

        ```python
        import pulumi
        import pulumi_aws as aws

        examplebucket = aws.s3.Bucket("examplebucket", bucket="examplebuckettftest")
        example = aws.s3.BucketAcl("example",
            bucket=examplebucket.id,
            acl="private")
        example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("index.html"),
            server_side_encryption="AES256")
        ```

        ### S3 Object Lock

        ```python
        import pulumi
        import pulumi_aws as aws

        examplebucket = aws.s3.Bucket("examplebucket",
            bucket="examplebuckettftest",
            object_lock_enabled=True)
        example = aws.s3.BucketAcl("example",
            bucket=examplebucket.id,
            acl="private")
        example_bucket_versioning = aws.s3.BucketVersioning("example",
            bucket=examplebucket.id,
            versioning_configuration={
                "status": "Enabled",
            })
        examplebucket_object = aws.s3.BucketObjectv2("examplebucket_object",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("important.txt"),
            object_lock_legal_hold_status="ON",
            object_lock_mode="GOVERNANCE",
            object_lock_retain_until_date="2021-12-31T23:59:60Z",
            force_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[example_bucket_versioning]))
        ```

        ### Ignoring Provider `default_tags`

        S3 objects support a [maximum of 10 tags](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-tagging.html).
        If the resource's own `tags` and the provider-level `default_tags` would together lead to more than 10 tags on an S3 object, use the `override_provider` configuration block to suppress any provider-level `default_tags`.

        > S3 objects stored in Amazon S3 Express directory buckets do not support tags, so any provider-level `default_tags` must be suppressed.

        ```python
        import pulumi
        import pulumi_aws as aws

        examplebucket = aws.s3.Bucket("examplebucket", bucket="examplebuckettftest")
        examplebucket_object = aws.s3.BucketObjectv2("examplebucket_object",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("important.txt"),
            tags={
                "Env": "test",
            },
            override_provider={
                "default_tags": {
                    "tags": {},
                },
            })
        ```

        ## Import

        Import using S3 URL syntax:

        __Using `pulumi import` to import__ objects using the `id` or S3 URL. For example:

        Import using the `id`, which is the bucket name and the key together:

        ```sh
        $ pulumi import aws:s3/bucketObjectv2:BucketObjectv2 example some-bucket-name/some/key.txt
        ```
        Import using S3 URL syntax:

        ```sh
        $ pulumi import aws:s3/bucketObjectv2:BucketObjectv2 example s3://some-bucket-name/some/key.txt
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
        :param pulumi.Input[_builtins.bool] bucket_key_enabled: Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        :param pulumi.Input[_builtins.str] cache_control: Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[_builtins.str] checksum_algorithm: Indicates the algorithm used to create the checksum for the object. If a value is specified and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `CRC32`, `CRC32C`, `CRC64NVME`, `SHA1`, `SHA256`.
        :param pulumi.Input[_builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        :param pulumi.Input[_builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        :param pulumi.Input[_builtins.str] content_disposition: Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[_builtins.str] content_encoding: Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[_builtins.str] content_language: Language the content is in e.g., en-US or en-GB.
        :param pulumi.Input[_builtins.str] content_type: Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"`, also if an object is larger than 16 MB, the AWS Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest (see `source_hash` instead).
        :param pulumi.Input[_builtins.bool] force_destroy: Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        :param pulumi.Input[_builtins.str] key: Name of the object once it is in the bucket.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] kms_key_id: ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `kms.Key` resource, use the `arn` attribute. If referencing the `kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        :param pulumi.Input[_builtins.str] object_lock_legal_hold_status: [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        :param pulumi.Input[_builtins.str] object_lock_mode: Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param pulumi.Input[_builtins.str] object_lock_retain_until_date: Date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        :param pulumi.Input[Union['BucketObjectv2OverrideProviderArgs', 'BucketObjectv2OverrideProviderArgsDict']] override_provider: Override provider-level configuration options. See Override Provider below for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] server_side_encryption: Server-side encryption of the object in S3. Valid values are `"AES256"`, `"aws:kms"`, `"aws:kms:dsse"`, and `"aws:fsx"`.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: Path to a file that will be read and uploaded as raw bytes for the object content.
        :param pulumi.Input[_builtins.str] source_hash: Triggers updates like `etag` but useful to address `etag` encryption limitations. (The value is only stored in state and not saved by AWS.)
        :param pulumi.Input[_builtins.str] storage_class: [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] website_redirect: Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
               
               If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.
               
               > **Note:** If you specify `content_encoding` you are responsible for encoding the body appropriately. `source`, `content`, and `content_base64` all expect already encoded/compressed bytes.
               
               > **Note:** The provider ignores all leading `/`s in the object's `key` and treats multiple `/`s in the rest of the object's `key` as a single `/`, so values of `/index.html` and `index.html` correspond to the same S3 object as do `first//second///third//` and `first/second/third/`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketObjectv2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an S3 object resource.

        ## Example Usage

        ### Uploading a file to a bucket

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        object = aws.s3.BucketObjectv2("object",
            bucket="your_bucket_name",
            key="new_object_key",
            source=pulumi.FileAsset("path/to/file"),
            etag=std.filemd5(input="path/to/file").result)
        ```

        ### Encrypting with KMS Key

        ```python
        import pulumi
        import pulumi_aws as aws

        examplekms = aws.kms.Key("examplekms",
            description="KMS key 1",
            deletion_window_in_days=7)
        examplebucket = aws.s3.Bucket("examplebucket", bucket="examplebuckettftest")
        example = aws.s3.BucketAcl("example",
            bucket=examplebucket.id,
            acl="private")
        example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("index.html"),
            kms_key_id=examplekms.arn)
        ```

        ### Server Side Encryption with S3 Default Master Key

        ```python
        import pulumi
        import pulumi_aws as aws

        examplebucket = aws.s3.Bucket("examplebucket", bucket="examplebuckettftest")
        example = aws.s3.BucketAcl("example",
            bucket=examplebucket.id,
            acl="private")
        example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("index.html"),
            server_side_encryption="aws:kms")
        ```

        ### Server Side Encryption with AWS-Managed Key

        ```python
        import pulumi
        import pulumi_aws as aws

        examplebucket = aws.s3.Bucket("examplebucket", bucket="examplebuckettftest")
        example = aws.s3.BucketAcl("example",
            bucket=examplebucket.id,
            acl="private")
        example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("index.html"),
            server_side_encryption="AES256")
        ```

        ### S3 Object Lock

        ```python
        import pulumi
        import pulumi_aws as aws

        examplebucket = aws.s3.Bucket("examplebucket",
            bucket="examplebuckettftest",
            object_lock_enabled=True)
        example = aws.s3.BucketAcl("example",
            bucket=examplebucket.id,
            acl="private")
        example_bucket_versioning = aws.s3.BucketVersioning("example",
            bucket=examplebucket.id,
            versioning_configuration={
                "status": "Enabled",
            })
        examplebucket_object = aws.s3.BucketObjectv2("examplebucket_object",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("important.txt"),
            object_lock_legal_hold_status="ON",
            object_lock_mode="GOVERNANCE",
            object_lock_retain_until_date="2021-12-31T23:59:60Z",
            force_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[example_bucket_versioning]))
        ```

        ### Ignoring Provider `default_tags`

        S3 objects support a [maximum of 10 tags](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-tagging.html).
        If the resource's own `tags` and the provider-level `default_tags` would together lead to more than 10 tags on an S3 object, use the `override_provider` configuration block to suppress any provider-level `default_tags`.

        > S3 objects stored in Amazon S3 Express directory buckets do not support tags, so any provider-level `default_tags` must be suppressed.

        ```python
        import pulumi
        import pulumi_aws as aws

        examplebucket = aws.s3.Bucket("examplebucket", bucket="examplebuckettftest")
        examplebucket_object = aws.s3.BucketObjectv2("examplebucket_object",
            key="someobject",
            bucket=examplebucket.id,
            source=pulumi.FileAsset("important.txt"),
            tags={
                "Env": "test",
            },
            override_provider={
                "default_tags": {
                    "tags": {},
                },
            })
        ```

        ## Import

        Import using S3 URL syntax:

        __Using `pulumi import` to import__ objects using the `id` or S3 URL. For example:

        Import using the `id`, which is the bucket name and the key together:

        ```sh
        $ pulumi import aws:s3/bucketObjectv2:BucketObjectv2 example some-bucket-name/some/key.txt
        ```
        Import using S3 URL syntax:

        ```sh
        $ pulumi import aws:s3/bucketObjectv2:BucketObjectv2 example s3://some-bucket-name/some/key.txt
        ```

        :param str resource_name: The name of the resource.
        :param BucketObjectv2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketObjectv2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cache_control: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 content_language: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
                 override_provider: Optional[pulumi.Input[Union['BucketObjectv2OverrideProviderArgs', 'BucketObjectv2OverrideProviderArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 source_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 website_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketObjectv2Args.__new__(BucketObjectv2Args)

            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["bucket_key_enabled"] = bucket_key_enabled
            __props__.__dict__["cache_control"] = cache_control
            __props__.__dict__["checksum_algorithm"] = checksum_algorithm
            __props__.__dict__["content"] = content
            __props__.__dict__["content_base64"] = content_base64
            __props__.__dict__["content_disposition"] = content_disposition
            __props__.__dict__["content_encoding"] = content_encoding
            __props__.__dict__["content_language"] = content_language
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["etag"] = etag
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["key"] = key
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["object_lock_legal_hold_status"] = object_lock_legal_hold_status
            __props__.__dict__["object_lock_mode"] = object_lock_mode
            __props__.__dict__["object_lock_retain_until_date"] = object_lock_retain_until_date
            __props__.__dict__["override_provider"] = override_provider
            __props__.__dict__["region"] = region
            __props__.__dict__["server_side_encryption"] = server_side_encryption
            __props__.__dict__["source"] = source
            __props__.__dict__["source_hash"] = source_hash
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["tags"] = tags
            __props__.__dict__["website_redirect"] = website_redirect
            __props__.__dict__["arn"] = None
            __props__.__dict__["checksum_crc32"] = None
            __props__.__dict__["checksum_crc32c"] = None
            __props__.__dict__["checksum_crc64nvme"] = None
            __props__.__dict__["checksum_sha1"] = None
            __props__.__dict__["checksum_sha256"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["version_id"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:s3/BucketObject:BucketObject")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(BucketObjectv2, __self__).__init__(
            'aws:s3/bucketObjectv2:BucketObjectv2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cache_control: Optional[pulumi.Input[_builtins.str]] = None,
            checksum_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            checksum_crc32: Optional[pulumi.Input[_builtins.str]] = None,
            checksum_crc32c: Optional[pulumi.Input[_builtins.str]] = None,
            checksum_crc64nvme: Optional[pulumi.Input[_builtins.str]] = None,
            checksum_sha1: Optional[pulumi.Input[_builtins.str]] = None,
            checksum_sha256: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            content_base64: Optional[pulumi.Input[_builtins.str]] = None,
            content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
            content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
            content_language: Optional[pulumi.Input[_builtins.str]] = None,
            content_type: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
            object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
            object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
            override_provider: Optional[pulumi.Input[Union['BucketObjectv2OverrideProviderArgs', 'BucketObjectv2OverrideProviderArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            server_side_encryption: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
            source_hash: Optional[pulumi.Input[_builtins.str]] = None,
            storage_class: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None,
            website_redirect: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketObjectv2':
        """
        Get an existing BucketObjectv2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`.
        :param pulumi.Input[_builtins.str] arn: ARN of the object.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
        :param pulumi.Input[_builtins.bool] bucket_key_enabled: Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        :param pulumi.Input[_builtins.str] cache_control: Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[_builtins.str] checksum_algorithm: Indicates the algorithm used to create the checksum for the object. If a value is specified and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `CRC32`, `CRC32C`, `CRC64NVME`, `SHA1`, `SHA256`.
        :param pulumi.Input[_builtins.str] checksum_crc32: The base64-encoded, 32-bit CRC32 checksum of the object.
        :param pulumi.Input[_builtins.str] checksum_crc32c: The base64-encoded, 32-bit CRC32C checksum of the object.
        :param pulumi.Input[_builtins.str] checksum_crc64nvme: The base64-encoded, 64-bit CRC64NVME checksum of the object.
        :param pulumi.Input[_builtins.str] checksum_sha1: The base64-encoded, 160-bit SHA-1 digest of the object.
        :param pulumi.Input[_builtins.str] checksum_sha256: The base64-encoded, 256-bit SHA-256 digest of the object.
        :param pulumi.Input[_builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        :param pulumi.Input[_builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        :param pulumi.Input[_builtins.str] content_disposition: Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[_builtins.str] content_encoding: Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[_builtins.str] content_language: Language the content is in e.g., en-US or en-GB.
        :param pulumi.Input[_builtins.str] content_type: Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] etag: Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"`, also if an object is larger than 16 MB, the AWS Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest (see `source_hash` instead).
        :param pulumi.Input[_builtins.bool] force_destroy: Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        :param pulumi.Input[_builtins.str] key: Name of the object once it is in the bucket.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] kms_key_id: ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `kms.Key` resource, use the `arn` attribute. If referencing the `kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        :param pulumi.Input[_builtins.str] object_lock_legal_hold_status: [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        :param pulumi.Input[_builtins.str] object_lock_mode: Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param pulumi.Input[_builtins.str] object_lock_retain_until_date: Date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        :param pulumi.Input[Union['BucketObjectv2OverrideProviderArgs', 'BucketObjectv2OverrideProviderArgsDict']] override_provider: Override provider-level configuration options. See Override Provider below for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] server_side_encryption: Server-side encryption of the object in S3. Valid values are `"AES256"`, `"aws:kms"`, `"aws:kms:dsse"`, and `"aws:fsx"`.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: Path to a file that will be read and uploaded as raw bytes for the object content.
        :param pulumi.Input[_builtins.str] source_hash: Triggers updates like `etag` but useful to address `etag` encryption limitations. (The value is only stored in state and not saved by AWS.)
        :param pulumi.Input[_builtins.str] storage_class: [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] version_id: Unique version ID value for the object, if bucket versioning is enabled.
        :param pulumi.Input[_builtins.str] website_redirect: Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
               
               If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.
               
               > **Note:** If you specify `content_encoding` you are responsible for encoding the body appropriately. `source`, `content`, and `content_base64` all expect already encoded/compressed bytes.
               
               > **Note:** The provider ignores all leading `/`s in the object's `key` and treats multiple `/`s in the rest of the object's `key` as a single `/`, so values of `/index.html` and `index.html` correspond to the same S3 object as do `first//second///third//` and `first/second/third/`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketObjectv2State.__new__(_BucketObjectv2State)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["arn"] = arn
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["bucket_key_enabled"] = bucket_key_enabled
        __props__.__dict__["cache_control"] = cache_control
        __props__.__dict__["checksum_algorithm"] = checksum_algorithm
        __props__.__dict__["checksum_crc32"] = checksum_crc32
        __props__.__dict__["checksum_crc32c"] = checksum_crc32c
        __props__.__dict__["checksum_crc64nvme"] = checksum_crc64nvme
        __props__.__dict__["checksum_sha1"] = checksum_sha1
        __props__.__dict__["checksum_sha256"] = checksum_sha256
        __props__.__dict__["content"] = content
        __props__.__dict__["content_base64"] = content_base64
        __props__.__dict__["content_disposition"] = content_disposition
        __props__.__dict__["content_encoding"] = content_encoding
        __props__.__dict__["content_language"] = content_language
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["etag"] = etag
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["key"] = key
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["object_lock_legal_hold_status"] = object_lock_legal_hold_status
        __props__.__dict__["object_lock_mode"] = object_lock_mode
        __props__.__dict__["object_lock_retain_until_date"] = object_lock_retain_until_date
        __props__.__dict__["override_provider"] = override_provider
        __props__.__dict__["region"] = region
        __props__.__dict__["server_side_encryption"] = server_side_encryption
        __props__.__dict__["source"] = source
        __props__.__dict__["source_hash"] = source_hash
        __props__.__dict__["storage_class"] = storage_class
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["website_redirect"] = website_redirect
        return BucketObjectv2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output[_builtins.str]:
        """
        [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, and `bucket-owner-full-control`.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the object.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the bucket to put the file in. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        return pulumi.get(self, "bucket_key_enabled")

    @_builtins.property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        """
        return pulumi.get(self, "cache_control")

    @_builtins.property
    @pulumi.getter(name="checksumAlgorithm")
    def checksum_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates the algorithm used to create the checksum for the object. If a value is specified and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `CRC32`, `CRC32C`, `CRC64NVME`, `SHA1`, `SHA256`.
        """
        return pulumi.get(self, "checksum_algorithm")

    @_builtins.property
    @pulumi.getter(name="checksumCrc32")
    def checksum_crc32(self) -> pulumi.Output[_builtins.str]:
        """
        The base64-encoded, 32-bit CRC32 checksum of the object.
        """
        return pulumi.get(self, "checksum_crc32")

    @_builtins.property
    @pulumi.getter(name="checksumCrc32c")
    def checksum_crc32c(self) -> pulumi.Output[_builtins.str]:
        """
        The base64-encoded, 32-bit CRC32C checksum of the object.
        """
        return pulumi.get(self, "checksum_crc32c")

    @_builtins.property
    @pulumi.getter(name="checksumCrc64nvme")
    def checksum_crc64nvme(self) -> pulumi.Output[_builtins.str]:
        """
        The base64-encoded, 64-bit CRC64NVME checksum of the object.
        """
        return pulumi.get(self, "checksum_crc64nvme")

    @_builtins.property
    @pulumi.getter(name="checksumSha1")
    def checksum_sha1(self) -> pulumi.Output[_builtins.str]:
        """
        The base64-encoded, 160-bit SHA-1 digest of the object.
        """
        return pulumi.get(self, "checksum_sha1")

    @_builtins.property
    @pulumi.getter(name="checksumSha256")
    def checksum_sha256(self) -> pulumi.Output[_builtins.str]:
        """
        The base64-encoded, 256-bit SHA-256 digest of the object.
        """
        return pulumi.get(self, "checksum_sha256")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        """
        return pulumi.get(self, "content_base64")

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        """
        return pulumi.get(self, "content_disposition")

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        """
        return pulumi.get(self, "content_encoding")

    @_builtins.property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Language the content is in e.g., en-US or en-GB.
        """
        return pulumi.get(self, "content_language")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[_builtins.str]:
        """
        Standard MIME type describing the format of the object data, e.g., application/octet-stream. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Triggers updates when the value changes. This attribute is not compatible with KMS encryption, `kms_key_id` or `server_side_encryption = "aws:kms"`, also if an object is larger than 16 MB, the AWS Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest (see `source_hash` instead).
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow the object to be deleted by removing any legal hold on any object version. Default is `false`. This value should be set to `true` only if the bucket has S3 object lock enabled.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the object once it is in the bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the KMS Key to use for object encryption. If the S3 Bucket has server-side encryption enabled, that value will automatically be used. If referencing the `kms.Key` resource, use the `arn` attribute. If referencing the `kms.Alias` data source or resource, use the `target_key_arn` attribute. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of keys/values to provision metadata (will be automatically prefixed by `x-amz-meta-`, note that only lowercase label are currently supported by the AWS Go API).
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="objectLockLegalHoldStatus")
    def object_lock_legal_hold_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        [Legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds) status that you want to apply to the specified object. Valid values are `ON` and `OFF`.
        """
        return pulumi.get(self, "object_lock_legal_hold_status")

    @_builtins.property
    @pulumi.getter(name="objectLockMode")
    def object_lock_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) that you want to apply to this object. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "object_lock_mode")

    @_builtins.property
    @pulumi.getter(name="objectLockRetainUntilDate")
    def object_lock_retain_until_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Date and time, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), when this object's object lock will [expire](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-periods).
        """
        return pulumi.get(self, "object_lock_retain_until_date")

    @_builtins.property
    @pulumi.getter(name="overrideProvider")
    def override_provider(self) -> pulumi.Output[Optional['outputs.BucketObjectv2OverrideProvider']]:
        """
        Override provider-level configuration options. See Override Provider below for more details.
        """
        return pulumi.get(self, "override_provider")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> pulumi.Output[_builtins.str]:
        """
        Server-side encryption of the object in S3. Valid values are `"AES256"`, `"aws:kms"`, `"aws:kms:dsse"`, and `"aws:fsx"`.
        """
        return pulumi.get(self, "server_side_encryption")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        Path to a file that will be read and uploaded as raw bytes for the object content.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Triggers updates like `etag` but useful to address `etag` encryption limitations. (The value is only stored in state and not saved by AWS.)
        """
        return pulumi.get(self, "source_hash")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[_builtins.str]:
        """
        [Storage Class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html#AmazonS3-PutObject-request-header-StorageClass) for the object. Defaults to "`STANDARD`".
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique version ID value for the object, if bucket versioning is enabled.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="websiteRedirect")
    def website_redirect(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Target URL for [website redirect](http://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).

        If no content is provided through `source`, `content` or `content_base64`, then the object will be empty.

        > **Note:** If you specify `content_encoding` you are responsible for encoding the body appropriately. `source`, `content`, and `content_base64` all expect already encoded/compressed bytes.

        > **Note:** The provider ignores all leading `/`s in the object's `key` and treats multiple `/`s in the rest of the object's `key` as a single `/`, so values of `/index.html` and `index.html` correspond to the same S3 object as do `first//second///third//` and `first/second/third/`.
        """
        return pulumi.get(self, "website_redirect")

