# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccessPointResult',
    'AwaitableGetAccessPointResult',
    'get_access_point',
    'get_access_point_output',
]

@pulumi.output_type
class GetAccessPointResult:
    """
    A collection of values returned by getAccessPoint.
    """
    def __init__(__self__, account_id=None, alias=None, arn=None, bucket=None, bucket_account_id=None, data_source_id=None, data_source_type=None, endpoints=None, id=None, name=None, network_origin=None, public_access_block_configurations=None, region=None, tags=None, vpc_configurations=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if bucket_account_id and not isinstance(bucket_account_id, str):
            raise TypeError("Expected argument 'bucket_account_id' to be a str")
        pulumi.set(__self__, "bucket_account_id", bucket_account_id)
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if data_source_type and not isinstance(data_source_type, str):
            raise TypeError("Expected argument 'data_source_type' to be a str")
        pulumi.set(__self__, "data_source_type", data_source_type)
        if endpoints and not isinstance(endpoints, dict):
            raise TypeError("Expected argument 'endpoints' to be a dict")
        pulumi.set(__self__, "endpoints", endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_origin and not isinstance(network_origin, str):
            raise TypeError("Expected argument 'network_origin' to be a str")
        pulumi.set(__self__, "network_origin", network_origin)
        if public_access_block_configurations and not isinstance(public_access_block_configurations, list):
            raise TypeError("Expected argument 'public_access_block_configurations' to be a list")
        pulumi.set(__self__, "public_access_block_configurations", public_access_block_configurations)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_configurations and not isinstance(vpc_configurations, list):
            raise TypeError("Expected argument 'vpc_configurations' to be a list")
        pulumi.set(__self__, "vpc_configurations", vpc_configurations)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def alias(self) -> _builtins.str:
        """
        Access point alias.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        Access point ARN.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Name of the bucket associated with the access point.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bucketAccountId")
    def bucket_account_id(self) -> _builtins.str:
        """
        AWS account ID associated with the S3 bucket associated with the access point.
        """
        return pulumi.get(self, "bucket_account_id")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> _builtins.str:
        """
        Unique identifier for the data source of the access point.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> _builtins.str:
        """
        Type of the data source that the access point is attached to.
        """
        return pulumi.get(self, "data_source_type")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Mapping[str, _builtins.str]:
        """
        VPC endpoint for the access point.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkOrigin")
    def network_origin(self) -> _builtins.str:
        """
        Indicates whether the access point allows access from the public Internet.
        """
        return pulumi.get(self, "network_origin")

    @_builtins.property
    @pulumi.getter(name="publicAccessBlockConfigurations")
    def public_access_block_configurations(self) -> Sequence['outputs.GetAccessPointPublicAccessBlockConfigurationResult']:
        """
        `PublicAccessBlock` configuration for the access point.
        """
        return pulumi.get(self, "public_access_block_configurations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags assigned to the access point.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcConfigurations")
    def vpc_configurations(self) -> Sequence['outputs.GetAccessPointVpcConfigurationResult']:
        """
        VPC configuration for the access point.
        """
        return pulumi.get(self, "vpc_configurations")


class AwaitableGetAccessPointResult(GetAccessPointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessPointResult(
            account_id=self.account_id,
            alias=self.alias,
            arn=self.arn,
            bucket=self.bucket,
            bucket_account_id=self.bucket_account_id,
            data_source_id=self.data_source_id,
            data_source_type=self.data_source_type,
            endpoints=self.endpoints,
            id=self.id,
            name=self.name,
            network_origin=self.network_origin,
            public_access_block_configurations=self.public_access_block_configurations,
            region=self.region,
            tags=self.tags,
            vpc_configurations=self.vpc_configurations)


def get_access_point(account_id: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessPointResult:
    """
    Provides details about a specific S3 access point.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.s3.get_access_point(name="example-access-point")
    ```


    :param _builtins.str account_id: AWS account ID for the account that owns the specified access point.
    :param _builtins.str name: Name of the access point.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:s3/getAccessPoint:getAccessPoint', __args__, opts=opts, typ=GetAccessPointResult).value

    return AwaitableGetAccessPointResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        alias=pulumi.get(__ret__, 'alias'),
        arn=pulumi.get(__ret__, 'arn'),
        bucket=pulumi.get(__ret__, 'bucket'),
        bucket_account_id=pulumi.get(__ret__, 'bucket_account_id'),
        data_source_id=pulumi.get(__ret__, 'data_source_id'),
        data_source_type=pulumi.get(__ret__, 'data_source_type'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network_origin=pulumi.get(__ret__, 'network_origin'),
        public_access_block_configurations=pulumi.get(__ret__, 'public_access_block_configurations'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_configurations=pulumi.get(__ret__, 'vpc_configurations'))
def get_access_point_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            name: Optional[pulumi.Input[_builtins.str]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessPointResult]:
    """
    Provides details about a specific S3 access point.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.s3.get_access_point(name="example-access-point")
    ```


    :param _builtins.str account_id: AWS account ID for the account that owns the specified access point.
    :param _builtins.str name: Name of the access point.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:s3/getAccessPoint:getAccessPoint', __args__, opts=opts, typ=GetAccessPointResult)
    return __ret__.apply(lambda __response__: GetAccessPointResult(
        account_id=pulumi.get(__response__, 'account_id'),
        alias=pulumi.get(__response__, 'alias'),
        arn=pulumi.get(__response__, 'arn'),
        bucket=pulumi.get(__response__, 'bucket'),
        bucket_account_id=pulumi.get(__response__, 'bucket_account_id'),
        data_source_id=pulumi.get(__response__, 'data_source_id'),
        data_source_type=pulumi.get(__response__, 'data_source_type'),
        endpoints=pulumi.get(__response__, 'endpoints'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        network_origin=pulumi.get(__response__, 'network_origin'),
        public_access_block_configurations=pulumi.get(__response__, 'public_access_block_configurations'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_configurations=pulumi.get(__response__, 'vpc_configurations')))
