# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMultiRegionAccessPointResult',
    'AwaitableGetMultiRegionAccessPointResult',
    'get_multi_region_access_point',
    'get_multi_region_access_point_output',
]

@pulumi.output_type
class GetMultiRegionAccessPointResult:
    """
    A collection of values returned by getMultiRegionAccessPoint.
    """
    def __init__(__self__, account_id=None, alias=None, arn=None, created_at=None, domain_name=None, id=None, name=None, public_access_blocks=None, region=None, regions=None, status=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_access_blocks and not isinstance(public_access_blocks, list):
            raise TypeError("Expected argument 'public_access_blocks' to be a list")
        pulumi.set(__self__, "public_access_blocks", public_access_blocks)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def alias(self) -> _builtins.str:
        """
        The alias for the Multi-Region Access Point.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of the Multi-Region Access Point.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Timestamp when the resource has been created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The DNS domain name of the S3 Multi-Region Access Point in the format _`alias`_.accesspoint.s3-global.amazonaws.com. For more information, see the documentation on [Multi-Region Access Point Requests](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRequests.html).
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicAccessBlocks")
    def public_access_blocks(self) -> Sequence['outputs.GetMultiRegionAccessPointPublicAccessBlockResult']:
        """
        Public Access Block of the Multi-Region Access Point. Detailed below.
        """
        return pulumi.get(self, "public_access_blocks")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The name of the region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetMultiRegionAccessPointRegionResult']:
        """
        A collection of the regions and buckets associated with the Multi-Region Access Point.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the Multi-Region Access Point.
        """
        return pulumi.get(self, "status")


class AwaitableGetMultiRegionAccessPointResult(GetMultiRegionAccessPointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMultiRegionAccessPointResult(
            account_id=self.account_id,
            alias=self.alias,
            arn=self.arn,
            created_at=self.created_at,
            domain_name=self.domain_name,
            id=self.id,
            name=self.name,
            public_access_blocks=self.public_access_blocks,
            region=self.region,
            regions=self.regions,
            status=self.status)


def get_multi_region_access_point(account_id: Optional[_builtins.str] = None,
                                  name: Optional[_builtins.str] = None,
                                  region: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMultiRegionAccessPointResult:
    """
    Provides details on a specific S3 Multi-Region Access Point.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.s3control.get_multi_region_access_point(name="example")
    ```


    :param _builtins.str account_id: The AWS account ID of the S3 Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
    :param _builtins.str name: The name of the Multi-Region Access Point.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:s3control/getMultiRegionAccessPoint:getMultiRegionAccessPoint', __args__, opts=opts, typ=GetMultiRegionAccessPointResult).value

    return AwaitableGetMultiRegionAccessPointResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        alias=pulumi.get(__ret__, 'alias'),
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        public_access_blocks=pulumi.get(__ret__, 'public_access_blocks'),
        region=pulumi.get(__ret__, 'region'),
        regions=pulumi.get(__ret__, 'regions'),
        status=pulumi.get(__ret__, 'status'))
def get_multi_region_access_point_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         name: Optional[pulumi.Input[_builtins.str]] = None,
                                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMultiRegionAccessPointResult]:
    """
    Provides details on a specific S3 Multi-Region Access Point.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.s3control.get_multi_region_access_point(name="example")
    ```


    :param _builtins.str account_id: The AWS account ID of the S3 Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
    :param _builtins.str name: The name of the Multi-Region Access Point.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:s3control/getMultiRegionAccessPoint:getMultiRegionAccessPoint', __args__, opts=opts, typ=GetMultiRegionAccessPointResult)
    return __ret__.apply(lambda __response__: GetMultiRegionAccessPointResult(
        account_id=pulumi.get(__response__, 'account_id'),
        alias=pulumi.get(__response__, 'alias'),
        arn=pulumi.get(__response__, 'arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        public_access_blocks=pulumi.get(__response__, 'public_access_blocks'),
        region=pulumi.get(__response__, 'region'),
        regions=pulumi.get(__response__, 'regions'),
        status=pulumi.get(__response__, 'status')))
