# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HubArgs', 'Hub']

@pulumi.input_type
class HubArgs:
    def __init__(__self__, *,
                 hub_description: pulumi.Input[_builtins.str],
                 hub_name: pulumi.Input[_builtins.str],
                 hub_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_search_keywords: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_storage_config: Optional[pulumi.Input['HubS3StorageConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Hub resource.
        :param pulumi.Input[_builtins.str] hub_description: A description of the hub.
        :param pulumi.Input[_builtins.str] hub_name: The name of the hub.
        :param pulumi.Input[_builtins.str] hub_display_name: The display name of the hub.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hub_search_keywords: The searchable keywords for the hub.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['HubS3StorageConfigArgs'] s3_storage_config: The Amazon S3 storage configuration for the hub. See S3 Storage Config details below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "hub_description", hub_description)
        pulumi.set(__self__, "hub_name", hub_name)
        if hub_display_name is not None:
            pulumi.set(__self__, "hub_display_name", hub_display_name)
        if hub_search_keywords is not None:
            pulumi.set(__self__, "hub_search_keywords", hub_search_keywords)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_storage_config is not None:
            pulumi.set(__self__, "s3_storage_config", s3_storage_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="hubDescription")
    def hub_description(self) -> pulumi.Input[_builtins.str]:
        """
        A description of the hub.
        """
        return pulumi.get(self, "hub_description")

    @hub_description.setter
    def hub_description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hub_description", value)

    @_builtins.property
    @pulumi.getter(name="hubName")
    def hub_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the hub.
        """
        return pulumi.get(self, "hub_name")

    @hub_name.setter
    def hub_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hub_name", value)

    @_builtins.property
    @pulumi.getter(name="hubDisplayName")
    def hub_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the hub.
        """
        return pulumi.get(self, "hub_display_name")

    @hub_display_name.setter
    def hub_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hub_display_name", value)

    @_builtins.property
    @pulumi.getter(name="hubSearchKeywords")
    def hub_search_keywords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The searchable keywords for the hub.
        """
        return pulumi.get(self, "hub_search_keywords")

    @hub_search_keywords.setter
    def hub_search_keywords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hub_search_keywords", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3StorageConfig")
    def s3_storage_config(self) -> Optional[pulumi.Input['HubS3StorageConfigArgs']]:
        """
        The Amazon S3 storage configuration for the hub. See S3 Storage Config details below.
        """
        return pulumi.get(self, "s3_storage_config")

    @s3_storage_config.setter
    def s3_storage_config(self, value: Optional[pulumi.Input['HubS3StorageConfigArgs']]):
        pulumi.set(self, "s3_storage_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HubState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_description: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_search_keywords: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_storage_config: Optional[pulumi.Input['HubS3StorageConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Hub resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this Hub.
        :param pulumi.Input[_builtins.str] hub_description: A description of the hub.
        :param pulumi.Input[_builtins.str] hub_display_name: The display name of the hub.
        :param pulumi.Input[_builtins.str] hub_name: The name of the hub.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hub_search_keywords: The searchable keywords for the hub.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['HubS3StorageConfigArgs'] s3_storage_config: The Amazon S3 storage configuration for the hub. See S3 Storage Config details below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if hub_description is not None:
            pulumi.set(__self__, "hub_description", hub_description)
        if hub_display_name is not None:
            pulumi.set(__self__, "hub_display_name", hub_display_name)
        if hub_name is not None:
            pulumi.set(__self__, "hub_name", hub_name)
        if hub_search_keywords is not None:
            pulumi.set(__self__, "hub_search_keywords", hub_search_keywords)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_storage_config is not None:
            pulumi.set(__self__, "s3_storage_config", s3_storage_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this Hub.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="hubDescription")
    def hub_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the hub.
        """
        return pulumi.get(self, "hub_description")

    @hub_description.setter
    def hub_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hub_description", value)

    @_builtins.property
    @pulumi.getter(name="hubDisplayName")
    def hub_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the hub.
        """
        return pulumi.get(self, "hub_display_name")

    @hub_display_name.setter
    def hub_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hub_display_name", value)

    @_builtins.property
    @pulumi.getter(name="hubName")
    def hub_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the hub.
        """
        return pulumi.get(self, "hub_name")

    @hub_name.setter
    def hub_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hub_name", value)

    @_builtins.property
    @pulumi.getter(name="hubSearchKeywords")
    def hub_search_keywords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The searchable keywords for the hub.
        """
        return pulumi.get(self, "hub_search_keywords")

    @hub_search_keywords.setter
    def hub_search_keywords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hub_search_keywords", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3StorageConfig")
    def s3_storage_config(self) -> Optional[pulumi.Input['HubS3StorageConfigArgs']]:
        """
        The Amazon S3 storage configuration for the hub. See S3 Storage Config details below.
        """
        return pulumi.get(self, "s3_storage_config")

    @s3_storage_config.setter
    def s3_storage_config(self, value: Optional[pulumi.Input['HubS3StorageConfigArgs']]):
        pulumi.set(self, "s3_storage_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:sagemaker/hub:Hub")
class Hub(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hub_description: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_search_keywords: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_storage_config: Optional[pulumi.Input[Union['HubS3StorageConfigArgs', 'HubS3StorageConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a SageMaker AI Hub resource.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.Hub("example",
            hub_name="example",
            hub_description="example")
        ```

        ## Import

        Using `pulumi import`, import SageMaker AI Hubs using the `name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/hub:Hub test_hub my-code-repo
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] hub_description: A description of the hub.
        :param pulumi.Input[_builtins.str] hub_display_name: The display name of the hub.
        :param pulumi.Input[_builtins.str] hub_name: The name of the hub.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hub_search_keywords: The searchable keywords for the hub.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['HubS3StorageConfigArgs', 'HubS3StorageConfigArgsDict']] s3_storage_config: The Amazon S3 storage configuration for the hub. See S3 Storage Config details below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HubArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SageMaker AI Hub resource.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.Hub("example",
            hub_name="example",
            hub_description="example")
        ```

        ## Import

        Using `pulumi import`, import SageMaker AI Hubs using the `name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/hub:Hub test_hub my-code-repo
        ```

        :param str resource_name: The name of the resource.
        :param HubArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HubArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hub_description: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_search_keywords: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_storage_config: Optional[pulumi.Input[Union['HubS3StorageConfigArgs', 'HubS3StorageConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HubArgs.__new__(HubArgs)

            if hub_description is None and not opts.urn:
                raise TypeError("Missing required property 'hub_description'")
            __props__.__dict__["hub_description"] = hub_description
            __props__.__dict__["hub_display_name"] = hub_display_name
            if hub_name is None and not opts.urn:
                raise TypeError("Missing required property 'hub_name'")
            __props__.__dict__["hub_name"] = hub_name
            __props__.__dict__["hub_search_keywords"] = hub_search_keywords
            __props__.__dict__["region"] = region
            __props__.__dict__["s3_storage_config"] = s3_storage_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Hub, __self__).__init__(
            'aws:sagemaker/hub:Hub',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            hub_description: Optional[pulumi.Input[_builtins.str]] = None,
            hub_display_name: Optional[pulumi.Input[_builtins.str]] = None,
            hub_name: Optional[pulumi.Input[_builtins.str]] = None,
            hub_search_keywords: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            s3_storage_config: Optional[pulumi.Input[Union['HubS3StorageConfigArgs', 'HubS3StorageConfigArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Hub':
        """
        Get an existing Hub resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this Hub.
        :param pulumi.Input[_builtins.str] hub_description: A description of the hub.
        :param pulumi.Input[_builtins.str] hub_display_name: The display name of the hub.
        :param pulumi.Input[_builtins.str] hub_name: The name of the hub.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hub_search_keywords: The searchable keywords for the hub.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['HubS3StorageConfigArgs', 'HubS3StorageConfigArgsDict']] s3_storage_config: The Amazon S3 storage configuration for the hub. See S3 Storage Config details below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HubState.__new__(_HubState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["hub_description"] = hub_description
        __props__.__dict__["hub_display_name"] = hub_display_name
        __props__.__dict__["hub_name"] = hub_name
        __props__.__dict__["hub_search_keywords"] = hub_search_keywords
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_storage_config"] = s3_storage_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Hub(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this Hub.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="hubDescription")
    def hub_description(self) -> pulumi.Output[_builtins.str]:
        """
        A description of the hub.
        """
        return pulumi.get(self, "hub_description")

    @_builtins.property
    @pulumi.getter(name="hubDisplayName")
    def hub_display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name of the hub.
        """
        return pulumi.get(self, "hub_display_name")

    @_builtins.property
    @pulumi.getter(name="hubName")
    def hub_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the hub.
        """
        return pulumi.get(self, "hub_name")

    @_builtins.property
    @pulumi.getter(name="hubSearchKeywords")
    def hub_search_keywords(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The searchable keywords for the hub.
        """
        return pulumi.get(self, "hub_search_keywords")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3StorageConfig")
    def s3_storage_config(self) -> pulumi.Output[Optional['outputs.HubS3StorageConfig']]:
        """
        The Amazon S3 storage configuration for the hub. See S3 Storage Config details below.
        """
        return pulumi.get(self, "s3_storage_config")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

