# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ImageVersionArgs', 'ImageVersion']

@pulumi.input_type
class ImageVersionArgs:
    def __init__(__self__, *,
                 base_image: pulumi.Input[_builtins.str],
                 image_name: pulumi.Input[_builtins.str],
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 horovod: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_framework: Optional[pulumi.Input[_builtins.str]] = None,
                 processor: Optional[pulumi.Input[_builtins.str]] = None,
                 programming_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 release_notes: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor_guidance: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ImageVersion resource.
        :param pulumi.Input[_builtins.str] base_image: The registry path of the container image on which this image version is based.
        :param pulumi.Input[_builtins.str] image_name: The name of the image. Must be unique to your account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: A list of aliases for the image version.
        :param pulumi.Input[_builtins.bool] horovod: Indicates Horovod compatibility.
        :param pulumi.Input[_builtins.str] job_type: Indicates SageMaker AI job type compatibility. Valid values are: `TRAINING`, `INFERENCE`, and `NOTEBOOK_KERNEL`.
        :param pulumi.Input[_builtins.str] ml_framework: The machine learning framework vended in the image version.
        :param pulumi.Input[_builtins.str] processor: Indicates CPU or GPU compatibility. Valid values are: `CPU` and `GPU`.
        :param pulumi.Input[_builtins.str] programming_lang: The supported programming language and its version.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] release_notes: The maintainer description of the image version.
        :param pulumi.Input[_builtins.str] vendor_guidance: The stability of the image version, specified by the maintainer. Valid values are: `NOT_PROVIDED`, `STABLE`, `TO_BE_ARCHIVED`, and `ARCHIVED`.
        """
        pulumi.set(__self__, "base_image", base_image)
        pulumi.set(__self__, "image_name", image_name)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if horovod is not None:
            pulumi.set(__self__, "horovod", horovod)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if ml_framework is not None:
            pulumi.set(__self__, "ml_framework", ml_framework)
        if processor is not None:
            pulumi.set(__self__, "processor", processor)
        if programming_lang is not None:
            pulumi.set(__self__, "programming_lang", programming_lang)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if release_notes is not None:
            pulumi.set(__self__, "release_notes", release_notes)
        if vendor_guidance is not None:
            pulumi.set(__self__, "vendor_guidance", vendor_guidance)

    @_builtins.property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> pulumi.Input[_builtins.str]:
        """
        The registry path of the container image on which this image version is based.
        """
        return pulumi.get(self, "base_image")

    @base_image.setter
    def base_image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "base_image", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the image. Must be unique to your account.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of aliases for the image version.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "aliases", value)

    @_builtins.property
    @pulumi.getter
    def horovod(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates Horovod compatibility.
        """
        return pulumi.get(self, "horovod")

    @horovod.setter
    def horovod(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "horovod", value)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates SageMaker AI job type compatibility. Valid values are: `TRAINING`, `INFERENCE`, and `NOTEBOOK_KERNEL`.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter(name="mlFramework")
    def ml_framework(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The machine learning framework vended in the image version.
        """
        return pulumi.get(self, "ml_framework")

    @ml_framework.setter
    def ml_framework(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ml_framework", value)

    @_builtins.property
    @pulumi.getter
    def processor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates CPU or GPU compatibility. Valid values are: `CPU` and `GPU`.
        """
        return pulumi.get(self, "processor")

    @processor.setter
    def processor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "processor", value)

    @_builtins.property
    @pulumi.getter(name="programmingLang")
    def programming_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported programming language and its version.
        """
        return pulumi.get(self, "programming_lang")

    @programming_lang.setter
    def programming_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "programming_lang", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="releaseNotes")
    def release_notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintainer description of the image version.
        """
        return pulumi.get(self, "release_notes")

    @release_notes.setter
    def release_notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_notes", value)

    @_builtins.property
    @pulumi.getter(name="vendorGuidance")
    def vendor_guidance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The stability of the image version, specified by the maintainer. Valid values are: `NOT_PROVIDED`, `STABLE`, `TO_BE_ARCHIVED`, and `ARCHIVED`.
        """
        return pulumi.get(self, "vendor_guidance")

    @vendor_guidance.setter
    def vendor_guidance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vendor_guidance", value)


@pulumi.input_type
class _ImageVersionState:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 base_image: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image: Optional[pulumi.Input[_builtins.str]] = None,
                 horovod: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_framework: Optional[pulumi.Input[_builtins.str]] = None,
                 processor: Optional[pulumi.Input[_builtins.str]] = None,
                 programming_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 release_notes: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor_guidance: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ImageVersion resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: A list of aliases for the image version.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this Image Version.
        :param pulumi.Input[_builtins.str] base_image: The registry path of the container image on which this image version is based.
        :param pulumi.Input[_builtins.str] container_image: The registry path of the container image that contains this image version.
        :param pulumi.Input[_builtins.bool] horovod: Indicates Horovod compatibility.
        :param pulumi.Input[_builtins.str] image_name: The name of the image. Must be unique to your account.
        :param pulumi.Input[_builtins.str] job_type: Indicates SageMaker AI job type compatibility. Valid values are: `TRAINING`, `INFERENCE`, and `NOTEBOOK_KERNEL`.
        :param pulumi.Input[_builtins.str] ml_framework: The machine learning framework vended in the image version.
        :param pulumi.Input[_builtins.str] processor: Indicates CPU or GPU compatibility. Valid values are: `CPU` and `GPU`.
        :param pulumi.Input[_builtins.str] programming_lang: The supported programming language and its version.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] release_notes: The maintainer description of the image version.
        :param pulumi.Input[_builtins.str] vendor_guidance: The stability of the image version, specified by the maintainer. Valid values are: `NOT_PROVIDED`, `STABLE`, `TO_BE_ARCHIVED`, and `ARCHIVED`.
        :param pulumi.Input[_builtins.int] version: The version of the image. If not specified, the latest version is described.
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if base_image is not None:
            pulumi.set(__self__, "base_image", base_image)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if horovod is not None:
            pulumi.set(__self__, "horovod", horovod)
        if image_arn is not None:
            pulumi.set(__self__, "image_arn", image_arn)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if ml_framework is not None:
            pulumi.set(__self__, "ml_framework", ml_framework)
        if processor is not None:
            pulumi.set(__self__, "processor", processor)
        if programming_lang is not None:
            pulumi.set(__self__, "programming_lang", programming_lang)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if release_notes is not None:
            pulumi.set(__self__, "release_notes", release_notes)
        if vendor_guidance is not None:
            pulumi.set(__self__, "vendor_guidance", vendor_guidance)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of aliases for the image version.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "aliases", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this Image Version.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry path of the container image on which this image version is based.
        """
        return pulumi.get(self, "base_image")

    @base_image.setter
    def base_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_image", value)

    @_builtins.property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry path of the container image that contains this image version.
        """
        return pulumi.get(self, "container_image")

    @container_image.setter
    def container_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_image", value)

    @_builtins.property
    @pulumi.getter
    def horovod(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates Horovod compatibility.
        """
        return pulumi.get(self, "horovod")

    @horovod.setter
    def horovod(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "horovod", value)

    @_builtins.property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "image_arn")

    @image_arn.setter
    def image_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_arn", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image. Must be unique to your account.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates SageMaker AI job type compatibility. Valid values are: `TRAINING`, `INFERENCE`, and `NOTEBOOK_KERNEL`.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter(name="mlFramework")
    def ml_framework(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The machine learning framework vended in the image version.
        """
        return pulumi.get(self, "ml_framework")

    @ml_framework.setter
    def ml_framework(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ml_framework", value)

    @_builtins.property
    @pulumi.getter
    def processor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates CPU or GPU compatibility. Valid values are: `CPU` and `GPU`.
        """
        return pulumi.get(self, "processor")

    @processor.setter
    def processor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "processor", value)

    @_builtins.property
    @pulumi.getter(name="programmingLang")
    def programming_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported programming language and its version.
        """
        return pulumi.get(self, "programming_lang")

    @programming_lang.setter
    def programming_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "programming_lang", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="releaseNotes")
    def release_notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintainer description of the image version.
        """
        return pulumi.get(self, "release_notes")

    @release_notes.setter
    def release_notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_notes", value)

    @_builtins.property
    @pulumi.getter(name="vendorGuidance")
    def vendor_guidance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The stability of the image version, specified by the maintainer. Valid values are: `NOT_PROVIDED`, `STABLE`, `TO_BE_ARCHIVED`, and `ARCHIVED`.
        """
        return pulumi.get(self, "vendor_guidance")

    @vendor_guidance.setter
    def vendor_guidance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vendor_guidance", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the image. If not specified, the latest version is described.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws:sagemaker/imageVersion:ImageVersion")
class ImageVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 base_image: Optional[pulumi.Input[_builtins.str]] = None,
                 horovod: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_framework: Optional[pulumi.Input[_builtins.str]] = None,
                 processor: Optional[pulumi.Input[_builtins.str]] = None,
                 programming_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 release_notes: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor_guidance: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a SageMaker AI Image Version resource.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.ImageVersion("example",
            image_name=test["id"],
            base_image="012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest")
        ```

        ### With Aliases

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.sagemaker.ImageVersion("test",
            image_name=test_aws_sagemaker_image["id"],
            base_image="012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest",
            aliases=[
                "latest",
                "stable",
            ])
        ```

        ## Import

        Using `pulumi import`, import SageMaker AI Image Versions using a comma-delimited string concatenating `image_name` and `version`. For example:

        ```sh
        $ pulumi import aws:sagemaker/imageVersion:ImageVersion example example-name,1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: A list of aliases for the image version.
        :param pulumi.Input[_builtins.str] base_image: The registry path of the container image on which this image version is based.
        :param pulumi.Input[_builtins.bool] horovod: Indicates Horovod compatibility.
        :param pulumi.Input[_builtins.str] image_name: The name of the image. Must be unique to your account.
        :param pulumi.Input[_builtins.str] job_type: Indicates SageMaker AI job type compatibility. Valid values are: `TRAINING`, `INFERENCE`, and `NOTEBOOK_KERNEL`.
        :param pulumi.Input[_builtins.str] ml_framework: The machine learning framework vended in the image version.
        :param pulumi.Input[_builtins.str] processor: Indicates CPU or GPU compatibility. Valid values are: `CPU` and `GPU`.
        :param pulumi.Input[_builtins.str] programming_lang: The supported programming language and its version.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] release_notes: The maintainer description of the image version.
        :param pulumi.Input[_builtins.str] vendor_guidance: The stability of the image version, specified by the maintainer. Valid values are: `NOT_PROVIDED`, `STABLE`, `TO_BE_ARCHIVED`, and `ARCHIVED`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SageMaker AI Image Version resource.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.ImageVersion("example",
            image_name=test["id"],
            base_image="012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest")
        ```

        ### With Aliases

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.sagemaker.ImageVersion("test",
            image_name=test_aws_sagemaker_image["id"],
            base_image="012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest",
            aliases=[
                "latest",
                "stable",
            ])
        ```

        ## Import

        Using `pulumi import`, import SageMaker AI Image Versions using a comma-delimited string concatenating `image_name` and `version`. For example:

        ```sh
        $ pulumi import aws:sagemaker/imageVersion:ImageVersion example example-name,1
        ```

        :param str resource_name: The name of the resource.
        :param ImageVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 base_image: Optional[pulumi.Input[_builtins.str]] = None,
                 horovod: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_framework: Optional[pulumi.Input[_builtins.str]] = None,
                 processor: Optional[pulumi.Input[_builtins.str]] = None,
                 programming_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 release_notes: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor_guidance: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageVersionArgs.__new__(ImageVersionArgs)

            __props__.__dict__["aliases"] = aliases
            if base_image is None and not opts.urn:
                raise TypeError("Missing required property 'base_image'")
            __props__.__dict__["base_image"] = base_image
            __props__.__dict__["horovod"] = horovod
            if image_name is None and not opts.urn:
                raise TypeError("Missing required property 'image_name'")
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["job_type"] = job_type
            __props__.__dict__["ml_framework"] = ml_framework
            __props__.__dict__["processor"] = processor
            __props__.__dict__["programming_lang"] = programming_lang
            __props__.__dict__["region"] = region
            __props__.__dict__["release_notes"] = release_notes
            __props__.__dict__["vendor_guidance"] = vendor_guidance
            __props__.__dict__["arn"] = None
            __props__.__dict__["container_image"] = None
            __props__.__dict__["image_arn"] = None
            __props__.__dict__["version"] = None
        super(ImageVersion, __self__).__init__(
            'aws:sagemaker/imageVersion:ImageVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            base_image: Optional[pulumi.Input[_builtins.str]] = None,
            container_image: Optional[pulumi.Input[_builtins.str]] = None,
            horovod: Optional[pulumi.Input[_builtins.bool]] = None,
            image_arn: Optional[pulumi.Input[_builtins.str]] = None,
            image_name: Optional[pulumi.Input[_builtins.str]] = None,
            job_type: Optional[pulumi.Input[_builtins.str]] = None,
            ml_framework: Optional[pulumi.Input[_builtins.str]] = None,
            processor: Optional[pulumi.Input[_builtins.str]] = None,
            programming_lang: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            release_notes: Optional[pulumi.Input[_builtins.str]] = None,
            vendor_guidance: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'ImageVersion':
        """
        Get an existing ImageVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: A list of aliases for the image version.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this Image Version.
        :param pulumi.Input[_builtins.str] base_image: The registry path of the container image on which this image version is based.
        :param pulumi.Input[_builtins.str] container_image: The registry path of the container image that contains this image version.
        :param pulumi.Input[_builtins.bool] horovod: Indicates Horovod compatibility.
        :param pulumi.Input[_builtins.str] image_name: The name of the image. Must be unique to your account.
        :param pulumi.Input[_builtins.str] job_type: Indicates SageMaker AI job type compatibility. Valid values are: `TRAINING`, `INFERENCE`, and `NOTEBOOK_KERNEL`.
        :param pulumi.Input[_builtins.str] ml_framework: The machine learning framework vended in the image version.
        :param pulumi.Input[_builtins.str] processor: Indicates CPU or GPU compatibility. Valid values are: `CPU` and `GPU`.
        :param pulumi.Input[_builtins.str] programming_lang: The supported programming language and its version.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] release_notes: The maintainer description of the image version.
        :param pulumi.Input[_builtins.str] vendor_guidance: The stability of the image version, specified by the maintainer. Valid values are: `NOT_PROVIDED`, `STABLE`, `TO_BE_ARCHIVED`, and `ARCHIVED`.
        :param pulumi.Input[_builtins.int] version: The version of the image. If not specified, the latest version is described.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageVersionState.__new__(_ImageVersionState)

        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["arn"] = arn
        __props__.__dict__["base_image"] = base_image
        __props__.__dict__["container_image"] = container_image
        __props__.__dict__["horovod"] = horovod
        __props__.__dict__["image_arn"] = image_arn
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["job_type"] = job_type
        __props__.__dict__["ml_framework"] = ml_framework
        __props__.__dict__["processor"] = processor
        __props__.__dict__["programming_lang"] = programming_lang
        __props__.__dict__["region"] = region
        __props__.__dict__["release_notes"] = release_notes
        __props__.__dict__["vendor_guidance"] = vendor_guidance
        __props__.__dict__["version"] = version
        return ImageVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of aliases for the image version.
        """
        return pulumi.get(self, "aliases")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this Image Version.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> pulumi.Output[_builtins.str]:
        """
        The registry path of the container image on which this image version is based.
        """
        return pulumi.get(self, "base_image")

    @_builtins.property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> pulumi.Output[_builtins.str]:
        """
        The registry path of the container image that contains this image version.
        """
        return pulumi.get(self, "container_image")

    @_builtins.property
    @pulumi.getter
    def horovod(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates Horovod compatibility.
        """
        return pulumi.get(self, "horovod")

    @_builtins.property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "image_arn")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the image. Must be unique to your account.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates SageMaker AI job type compatibility. Valid values are: `TRAINING`, `INFERENCE`, and `NOTEBOOK_KERNEL`.
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter(name="mlFramework")
    def ml_framework(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The machine learning framework vended in the image version.
        """
        return pulumi.get(self, "ml_framework")

    @_builtins.property
    @pulumi.getter
    def processor(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates CPU or GPU compatibility. Valid values are: `CPU` and `GPU`.
        """
        return pulumi.get(self, "processor")

    @_builtins.property
    @pulumi.getter(name="programmingLang")
    def programming_lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The supported programming language and its version.
        """
        return pulumi.get(self, "programming_lang")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="releaseNotes")
    def release_notes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The maintainer description of the image version.
        """
        return pulumi.get(self, "release_notes")

    @_builtins.property
    @pulumi.getter(name="vendorGuidance")
    def vendor_guidance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The stability of the image version, specified by the maintainer. Valid values are: `NOT_PROVIDED`, `STABLE`, `TO_BE_ARCHIVED`, and `ARCHIVED`.
        """
        return pulumi.get(self, "vendor_guidance")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the image. If not specified, the latest version is described.
        """
        return pulumi.get(self, "version")

