# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NotebookInstanceLifecycleConfigurationArgs', 'NotebookInstanceLifecycleConfiguration']

@pulumi.input_type
class NotebookInstanceLifecycleConfigurationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_create: Optional[pulumi.Input[_builtins.str]] = None,
                 on_start: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NotebookInstanceLifecycleConfiguration resource.
        :param pulumi.Input[_builtins.str] name: The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
        :param pulumi.Input[_builtins.str] on_create: A shell script (base64-encoded) that runs only once when the SageMaker AI Notebook Instance is created.
        :param pulumi.Input[_builtins.str] on_start: A shell script (base64-encoded) that runs every time the SageMaker AI Notebook Instance is started including the time it's created.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_create is not None:
            pulumi.set(__self__, "on_create", on_create)
        if on_start is not None:
            pulumi.set(__self__, "on_start", on_start)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onCreate")
    def on_create(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A shell script (base64-encoded) that runs only once when the SageMaker AI Notebook Instance is created.
        """
        return pulumi.get(self, "on_create")

    @on_create.setter
    def on_create(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_create", value)

    @_builtins.property
    @pulumi.getter(name="onStart")
    def on_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A shell script (base64-encoded) that runs every time the SageMaker AI Notebook Instance is started including the time it's created.
        """
        return pulumi.get(self, "on_start")

    @on_start.setter
    def on_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_start", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NotebookInstanceLifecycleConfigurationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_create: Optional[pulumi.Input[_builtins.str]] = None,
                 on_start: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NotebookInstanceLifecycleConfiguration resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this lifecycle configuration.
        :param pulumi.Input[_builtins.str] name: The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
        :param pulumi.Input[_builtins.str] on_create: A shell script (base64-encoded) that runs only once when the SageMaker AI Notebook Instance is created.
        :param pulumi.Input[_builtins.str] on_start: A shell script (base64-encoded) that runs every time the SageMaker AI Notebook Instance is started including the time it's created.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_create is not None:
            pulumi.set(__self__, "on_create", on_create)
        if on_start is not None:
            pulumi.set(__self__, "on_start", on_start)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this lifecycle configuration.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onCreate")
    def on_create(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A shell script (base64-encoded) that runs only once when the SageMaker AI Notebook Instance is created.
        """
        return pulumi.get(self, "on_create")

    @on_create.setter
    def on_create(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_create", value)

    @_builtins.property
    @pulumi.getter(name="onStart")
    def on_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A shell script (base64-encoded) that runs every time the SageMaker AI Notebook Instance is started including the time it's created.
        """
        return pulumi.get(self, "on_start")

    @on_start.setter
    def on_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_start", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:sagemaker/notebookInstanceLifecycleConfiguration:NotebookInstanceLifecycleConfiguration")
class NotebookInstanceLifecycleConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_create: Optional[pulumi.Input[_builtins.str]] = None,
                 on_start: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a lifecycle configuration for SageMaker AI Notebook Instances.

        ## Example Usage

        Usage:

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        lc = aws.sagemaker.NotebookInstanceLifecycleConfiguration("lc",
            name="foo",
            on_create=std.base64encode(input="echo foo").result,
            on_start=std.base64encode(input="echo bar").result)
        ```

        ## Import

        Using `pulumi import`, import models using the `name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/notebookInstanceLifecycleConfiguration:NotebookInstanceLifecycleConfiguration lc foo
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
        :param pulumi.Input[_builtins.str] on_create: A shell script (base64-encoded) that runs only once when the SageMaker AI Notebook Instance is created.
        :param pulumi.Input[_builtins.str] on_start: A shell script (base64-encoded) that runs every time the SageMaker AI Notebook Instance is started including the time it's created.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NotebookInstanceLifecycleConfigurationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a lifecycle configuration for SageMaker AI Notebook Instances.

        ## Example Usage

        Usage:

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        lc = aws.sagemaker.NotebookInstanceLifecycleConfiguration("lc",
            name="foo",
            on_create=std.base64encode(input="echo foo").result,
            on_start=std.base64encode(input="echo bar").result)
        ```

        ## Import

        Using `pulumi import`, import models using the `name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/notebookInstanceLifecycleConfiguration:NotebookInstanceLifecycleConfiguration lc foo
        ```

        :param str resource_name: The name of the resource.
        :param NotebookInstanceLifecycleConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotebookInstanceLifecycleConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_create: Optional[pulumi.Input[_builtins.str]] = None,
                 on_start: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotebookInstanceLifecycleConfigurationArgs.__new__(NotebookInstanceLifecycleConfigurationArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["on_create"] = on_create
            __props__.__dict__["on_start"] = on_start
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(NotebookInstanceLifecycleConfiguration, __self__).__init__(
            'aws:sagemaker/notebookInstanceLifecycleConfiguration:NotebookInstanceLifecycleConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            on_create: Optional[pulumi.Input[_builtins.str]] = None,
            on_start: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'NotebookInstanceLifecycleConfiguration':
        """
        Get an existing NotebookInstanceLifecycleConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this lifecycle configuration.
        :param pulumi.Input[_builtins.str] name: The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
        :param pulumi.Input[_builtins.str] on_create: A shell script (base64-encoded) that runs only once when the SageMaker AI Notebook Instance is created.
        :param pulumi.Input[_builtins.str] on_start: A shell script (base64-encoded) that runs every time the SageMaker AI Notebook Instance is started including the time it's created.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotebookInstanceLifecycleConfigurationState.__new__(_NotebookInstanceLifecycleConfigurationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["name"] = name
        __props__.__dict__["on_create"] = on_create
        __props__.__dict__["on_start"] = on_start
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return NotebookInstanceLifecycleConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this lifecycle configuration.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onCreate")
    def on_create(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A shell script (base64-encoded) that runs only once when the SageMaker AI Notebook Instance is created.
        """
        return pulumi.get(self, "on_create")

    @_builtins.property
    @pulumi.getter(name="onStart")
    def on_start(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A shell script (base64-encoded) that runs every time the SageMaker AI Notebook Instance is started including the time it's created.
        """
        return pulumi.get(self, "on_start")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

