# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkteamArgs', 'Workteam']

@pulumi.input_type
class WorkteamArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 member_definitions: pulumi.Input[Sequence[pulumi.Input['WorkteamMemberDefinitionArgs']]],
                 workteam_name: pulumi.Input[_builtins.str],
                 notification_configuration: Optional[pulumi.Input['WorkteamNotificationConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_access_configuration: Optional[pulumi.Input['WorkteamWorkerAccessConfigurationArgs']] = None,
                 workforce_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Workteam resource.
        :param pulumi.Input[_builtins.str] description: A description of the work team.
        :param pulumi.Input[Sequence[pulumi.Input['WorkteamMemberDefinitionArgs']]] member_definitions: A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
        :param pulumi.Input[_builtins.str] workteam_name: The name of the Workteam (must be unique).
        :param pulumi.Input['WorkteamNotificationConfigurationArgs'] notification_configuration: Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['WorkteamWorkerAccessConfigurationArgs'] worker_access_configuration: Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
        :param pulumi.Input[_builtins.str] workforce_name: The name of the workforce.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "member_definitions", member_definitions)
        pulumi.set(__self__, "workteam_name", workteam_name)
        if notification_configuration is not None:
            pulumi.set(__self__, "notification_configuration", notification_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if worker_access_configuration is not None:
            pulumi.set(__self__, "worker_access_configuration", worker_access_configuration)
        if workforce_name is not None:
            pulumi.set(__self__, "workforce_name", workforce_name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        A description of the work team.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="memberDefinitions")
    def member_definitions(self) -> pulumi.Input[Sequence[pulumi.Input['WorkteamMemberDefinitionArgs']]]:
        """
        A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
        """
        return pulumi.get(self, "member_definitions")

    @member_definitions.setter
    def member_definitions(self, value: pulumi.Input[Sequence[pulumi.Input['WorkteamMemberDefinitionArgs']]]):
        pulumi.set(self, "member_definitions", value)

    @_builtins.property
    @pulumi.getter(name="workteamName")
    def workteam_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Workteam (must be unique).
        """
        return pulumi.get(self, "workteam_name")

    @workteam_name.setter
    def workteam_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workteam_name", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> Optional[pulumi.Input['WorkteamNotificationConfigurationArgs']]:
        """
        Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
        """
        return pulumi.get(self, "notification_configuration")

    @notification_configuration.setter
    def notification_configuration(self, value: Optional[pulumi.Input['WorkteamNotificationConfigurationArgs']]):
        pulumi.set(self, "notification_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workerAccessConfiguration")
    def worker_access_configuration(self) -> Optional[pulumi.Input['WorkteamWorkerAccessConfigurationArgs']]:
        """
        Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
        """
        return pulumi.get(self, "worker_access_configuration")

    @worker_access_configuration.setter
    def worker_access_configuration(self, value: Optional[pulumi.Input['WorkteamWorkerAccessConfigurationArgs']]):
        pulumi.set(self, "worker_access_configuration", value)

    @_builtins.property
    @pulumi.getter(name="workforceName")
    def workforce_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the workforce.
        """
        return pulumi.get(self, "workforce_name")

    @workforce_name.setter
    def workforce_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workforce_name", value)


@pulumi.input_type
class _WorkteamState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 member_definitions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkteamMemberDefinitionArgs']]]] = None,
                 notification_configuration: Optional[pulumi.Input['WorkteamNotificationConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subdomain: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_access_configuration: Optional[pulumi.Input['WorkteamWorkerAccessConfigurationArgs']] = None,
                 workforce_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workteam_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Workteam resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this Workteam.
        :param pulumi.Input[_builtins.str] description: A description of the work team.
        :param pulumi.Input[Sequence[pulumi.Input['WorkteamMemberDefinitionArgs']]] member_definitions: A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
        :param pulumi.Input['WorkteamNotificationConfigurationArgs'] notification_configuration: Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] subdomain: The subdomain for your OIDC Identity Provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['WorkteamWorkerAccessConfigurationArgs'] worker_access_configuration: Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
        :param pulumi.Input[_builtins.str] workforce_name: The name of the workforce.
        :param pulumi.Input[_builtins.str] workteam_name: The name of the Workteam (must be unique).
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if member_definitions is not None:
            pulumi.set(__self__, "member_definitions", member_definitions)
        if notification_configuration is not None:
            pulumi.set(__self__, "notification_configuration", notification_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subdomain is not None:
            pulumi.set(__self__, "subdomain", subdomain)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if worker_access_configuration is not None:
            pulumi.set(__self__, "worker_access_configuration", worker_access_configuration)
        if workforce_name is not None:
            pulumi.set(__self__, "workforce_name", workforce_name)
        if workteam_name is not None:
            pulumi.set(__self__, "workteam_name", workteam_name)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this Workteam.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the work team.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="memberDefinitions")
    def member_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkteamMemberDefinitionArgs']]]]:
        """
        A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
        """
        return pulumi.get(self, "member_definitions")

    @member_definitions.setter
    def member_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkteamMemberDefinitionArgs']]]]):
        pulumi.set(self, "member_definitions", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> Optional[pulumi.Input['WorkteamNotificationConfigurationArgs']]:
        """
        Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
        """
        return pulumi.get(self, "notification_configuration")

    @notification_configuration.setter
    def notification_configuration(self, value: Optional[pulumi.Input['WorkteamNotificationConfigurationArgs']]):
        pulumi.set(self, "notification_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subdomain for your OIDC Identity Provider.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subdomain", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="workerAccessConfiguration")
    def worker_access_configuration(self) -> Optional[pulumi.Input['WorkteamWorkerAccessConfigurationArgs']]:
        """
        Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
        """
        return pulumi.get(self, "worker_access_configuration")

    @worker_access_configuration.setter
    def worker_access_configuration(self, value: Optional[pulumi.Input['WorkteamWorkerAccessConfigurationArgs']]):
        pulumi.set(self, "worker_access_configuration", value)

    @_builtins.property
    @pulumi.getter(name="workforceName")
    def workforce_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the workforce.
        """
        return pulumi.get(self, "workforce_name")

    @workforce_name.setter
    def workforce_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workforce_name", value)

    @_builtins.property
    @pulumi.getter(name="workteamName")
    def workteam_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Workteam (must be unique).
        """
        return pulumi.get(self, "workteam_name")

    @workteam_name.setter
    def workteam_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workteam_name", value)


@pulumi.type_token("aws:sagemaker/workteam:Workteam")
class Workteam(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 member_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkteamMemberDefinitionArgs', 'WorkteamMemberDefinitionArgsDict']]]]] = None,
                 notification_configuration: Optional[pulumi.Input[Union['WorkteamNotificationConfigurationArgs', 'WorkteamNotificationConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_access_configuration: Optional[pulumi.Input[Union['WorkteamWorkerAccessConfigurationArgs', 'WorkteamWorkerAccessConfigurationArgsDict']]] = None,
                 workforce_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workteam_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a SageMaker AI Workteam resource.

        ## Example Usage

        ### Cognito Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.Workteam("example",
            workteam_name="example",
            workforce_name=example_aws_sagemaker_workforce["id"],
            description="example",
            member_definitions=[{
                "cognito_member_definition": {
                    "client_id": example_aws_cognito_user_pool_client["id"],
                    "user_pool": example_aws_cognito_user_pool_domain["userPoolId"],
                    "user_group": example_aws_cognito_user_group["name"],
                },
            }])
        ```

        ### Oidc Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.Workteam("example",
            workteam_name="example",
            workforce_name=example_aws_sagemaker_workforce["id"],
            description="example",
            member_definitions=[{
                "oidc_member_definition": {
                    "groups": ["example"],
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import SageMaker AI Workteams using the `workteam_name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/workteam:Workteam example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the work team.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkteamMemberDefinitionArgs', 'WorkteamMemberDefinitionArgsDict']]]] member_definitions: A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
        :param pulumi.Input[Union['WorkteamNotificationConfigurationArgs', 'WorkteamNotificationConfigurationArgsDict']] notification_configuration: Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['WorkteamWorkerAccessConfigurationArgs', 'WorkteamWorkerAccessConfigurationArgsDict']] worker_access_configuration: Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
        :param pulumi.Input[_builtins.str] workforce_name: The name of the workforce.
        :param pulumi.Input[_builtins.str] workteam_name: The name of the Workteam (must be unique).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkteamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SageMaker AI Workteam resource.

        ## Example Usage

        ### Cognito Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.Workteam("example",
            workteam_name="example",
            workforce_name=example_aws_sagemaker_workforce["id"],
            description="example",
            member_definitions=[{
                "cognito_member_definition": {
                    "client_id": example_aws_cognito_user_pool_client["id"],
                    "user_pool": example_aws_cognito_user_pool_domain["userPoolId"],
                    "user_group": example_aws_cognito_user_group["name"],
                },
            }])
        ```

        ### Oidc Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.Workteam("example",
            workteam_name="example",
            workforce_name=example_aws_sagemaker_workforce["id"],
            description="example",
            member_definitions=[{
                "oidc_member_definition": {
                    "groups": ["example"],
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import SageMaker AI Workteams using the `workteam_name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/workteam:Workteam example example
        ```

        :param str resource_name: The name of the resource.
        :param WorkteamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkteamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 member_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkteamMemberDefinitionArgs', 'WorkteamMemberDefinitionArgsDict']]]]] = None,
                 notification_configuration: Optional[pulumi.Input[Union['WorkteamNotificationConfigurationArgs', 'WorkteamNotificationConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_access_configuration: Optional[pulumi.Input[Union['WorkteamWorkerAccessConfigurationArgs', 'WorkteamWorkerAccessConfigurationArgsDict']]] = None,
                 workforce_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workteam_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkteamArgs.__new__(WorkteamArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if member_definitions is None and not opts.urn:
                raise TypeError("Missing required property 'member_definitions'")
            __props__.__dict__["member_definitions"] = member_definitions
            __props__.__dict__["notification_configuration"] = notification_configuration
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["worker_access_configuration"] = worker_access_configuration
            __props__.__dict__["workforce_name"] = workforce_name
            if workteam_name is None and not opts.urn:
                raise TypeError("Missing required property 'workteam_name'")
            __props__.__dict__["workteam_name"] = workteam_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["subdomain"] = None
            __props__.__dict__["tags_all"] = None
        super(Workteam, __self__).__init__(
            'aws:sagemaker/workteam:Workteam',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            member_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkteamMemberDefinitionArgs', 'WorkteamMemberDefinitionArgsDict']]]]] = None,
            notification_configuration: Optional[pulumi.Input[Union['WorkteamNotificationConfigurationArgs', 'WorkteamNotificationConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            subdomain: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            worker_access_configuration: Optional[pulumi.Input[Union['WorkteamWorkerAccessConfigurationArgs', 'WorkteamWorkerAccessConfigurationArgsDict']]] = None,
            workforce_name: Optional[pulumi.Input[_builtins.str]] = None,
            workteam_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Workteam':
        """
        Get an existing Workteam resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this Workteam.
        :param pulumi.Input[_builtins.str] description: A description of the work team.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkteamMemberDefinitionArgs', 'WorkteamMemberDefinitionArgsDict']]]] member_definitions: A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
        :param pulumi.Input[Union['WorkteamNotificationConfigurationArgs', 'WorkteamNotificationConfigurationArgsDict']] notification_configuration: Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] subdomain: The subdomain for your OIDC Identity Provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['WorkteamWorkerAccessConfigurationArgs', 'WorkteamWorkerAccessConfigurationArgsDict']] worker_access_configuration: Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
        :param pulumi.Input[_builtins.str] workforce_name: The name of the workforce.
        :param pulumi.Input[_builtins.str] workteam_name: The name of the Workteam (must be unique).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkteamState.__new__(_WorkteamState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["member_definitions"] = member_definitions
        __props__.__dict__["notification_configuration"] = notification_configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["subdomain"] = subdomain
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["worker_access_configuration"] = worker_access_configuration
        __props__.__dict__["workforce_name"] = workforce_name
        __props__.__dict__["workteam_name"] = workteam_name
        return Workteam(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this Workteam.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A description of the work team.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="memberDefinitions")
    def member_definitions(self) -> pulumi.Output[Sequence['outputs.WorkteamMemberDefinition']]:
        """
        A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
        """
        return pulumi.get(self, "member_definitions")

    @_builtins.property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Output[Optional['outputs.WorkteamNotificationConfiguration']]:
        """
        Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
        """
        return pulumi.get(self, "notification_configuration")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> pulumi.Output[_builtins.str]:
        """
        The subdomain for your OIDC Identity Provider.
        """
        return pulumi.get(self, "subdomain")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="workerAccessConfiguration")
    def worker_access_configuration(self) -> pulumi.Output['outputs.WorkteamWorkerAccessConfiguration']:
        """
        Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
        """
        return pulumi.get(self, "worker_access_configuration")

    @_builtins.property
    @pulumi.getter(name="workforceName")
    def workforce_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the workforce.
        """
        return pulumi.get(self, "workforce_name")

    @_builtins.property
    @pulumi.getter(name="workteamName")
    def workteam_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Workteam (must be unique).
        """
        return pulumi.get(self, "workteam_name")

