# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStandardsControlAssociationsResult',
    'AwaitableGetStandardsControlAssociationsResult',
    'get_standards_control_associations',
    'get_standards_control_associations_output',
]

@pulumi.output_type
class GetStandardsControlAssociationsResult:
    """
    A collection of values returned by getStandardsControlAssociations.
    """
    def __init__(__self__, id=None, region=None, security_control_id=None, standards_control_associations=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_control_id and not isinstance(security_control_id, str):
            raise TypeError("Expected argument 'security_control_id' to be a str")
        pulumi.set(__self__, "security_control_id", security_control_id)
        if standards_control_associations and not isinstance(standards_control_associations, list):
            raise TypeError("Expected argument 'standards_control_associations' to be a list")
        pulumi.set(__self__, "standards_control_associations", standards_control_associations)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityControlId")
    def security_control_id(self) -> _builtins.str:
        """
        ID of the security control.
        """
        return pulumi.get(self, "security_control_id")

    @_builtins.property
    @pulumi.getter(name="standardsControlAssociations")
    def standards_control_associations(self) -> Sequence['outputs.GetStandardsControlAssociationsStandardsControlAssociationResult']:
        """
        A list that provides the status and other details for each security control that applies to each enabled standard.
        See `standards_control_associations` below.
        """
        return pulumi.get(self, "standards_control_associations")


class AwaitableGetStandardsControlAssociationsResult(GetStandardsControlAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStandardsControlAssociationsResult(
            id=self.id,
            region=self.region,
            security_control_id=self.security_control_id,
            standards_control_associations=self.standards_control_associations)


def get_standards_control_associations(region: Optional[_builtins.str] = None,
                                       security_control_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStandardsControlAssociationsResult:
    """
    Data source for managing an AWS Security Hub Standards Control Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test_account = aws.securityhub.Account("test")
    test = aws.securityhub.get_standards_control_associations(security_control_id="IAM.1")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str security_control_id: The identifier of the control (identified with `SecurityControlId`, `SecurityControlArn`, or a mix of both parameters).
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['securityControlId'] = security_control_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:securityhub/getStandardsControlAssociations:getStandardsControlAssociations', __args__, opts=opts, typ=GetStandardsControlAssociationsResult).value

    return AwaitableGetStandardsControlAssociationsResult(
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        security_control_id=pulumi.get(__ret__, 'security_control_id'),
        standards_control_associations=pulumi.get(__ret__, 'standards_control_associations'))
def get_standards_control_associations_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              security_control_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStandardsControlAssociationsResult]:
    """
    Data source for managing an AWS Security Hub Standards Control Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test_account = aws.securityhub.Account("test")
    test = aws.securityhub.get_standards_control_associations(security_control_id="IAM.1")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str security_control_id: The identifier of the control (identified with `SecurityControlId`, `SecurityControlArn`, or a mix of both parameters).
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['securityControlId'] = security_control_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:securityhub/getStandardsControlAssociations:getStandardsControlAssociations', __args__, opts=opts, typ=GetStandardsControlAssociationsResult)
    return __ret__.apply(lambda __response__: GetStandardsControlAssociationsResult(
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        security_control_id=pulumi.get(__response__, 'security_control_id'),
        standards_control_associations=pulumi.get(__response__, 'standards_control_associations')))
