# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataLakeArgs', 'DataLake']

@pulumi.input_type
class DataLakeArgs:
    def __init__(__self__, *,
                 meta_store_manager_role_arn: pulumi.Input[_builtins.str],
                 configuration: Optional[pulumi.Input['DataLakeConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['DataLakeTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a DataLake resource.
        :param pulumi.Input[_builtins.str] meta_store_manager_role_arn: The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
        :param pulumi.Input['DataLakeConfigurationArgs'] configuration: Specify the Region or Regions that will contribute data to the rollup region.
        :param pulumi.Input[_builtins.str] region: The AWS Regions where Security Lake is automatically enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "meta_store_manager_role_arn", meta_store_manager_role_arn)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="metaStoreManagerRoleArn")
    def meta_store_manager_role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
        """
        return pulumi.get(self, "meta_store_manager_role_arn")

    @meta_store_manager_role_arn.setter
    def meta_store_manager_role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "meta_store_manager_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['DataLakeConfigurationArgs']]:
        """
        Specify the Region or Regions that will contribute data to the rollup region.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['DataLakeConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS Regions where Security Lake is automatically enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DataLakeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DataLakeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _DataLakeState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input['DataLakeConfigurationArgs']] = None,
                 meta_store_manager_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['DataLakeTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering DataLake resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Data Lake.
        :param pulumi.Input['DataLakeConfigurationArgs'] configuration: Specify the Region or Regions that will contribute data to the rollup region.
        :param pulumi.Input[_builtins.str] meta_store_manager_role_arn: The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
        :param pulumi.Input[_builtins.str] region: The AWS Regions where Security Lake is automatically enabled.
        :param pulumi.Input[_builtins.str] s3_bucket_arn: The ARN for the Amazon Security Lake Amazon S3 bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if meta_store_manager_role_arn is not None:
            pulumi.set(__self__, "meta_store_manager_role_arn", meta_store_manager_role_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_bucket_arn is not None:
            pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Data Lake.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['DataLakeConfigurationArgs']]:
        """
        Specify the Region or Regions that will contribute data to the rollup region.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['DataLakeConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="metaStoreManagerRoleArn")
    def meta_store_manager_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
        """
        return pulumi.get(self, "meta_store_manager_role_arn")

    @meta_store_manager_role_arn.setter
    def meta_store_manager_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "meta_store_manager_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS Regions where Security Lake is automatically enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN for the Amazon Security Lake Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @s3_bucket_arn.setter
    def s3_bucket_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_bucket_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DataLakeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DataLakeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:securitylake/dataLake:DataLake")
class DataLake(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['DataLakeConfigurationArgs', 'DataLakeConfigurationArgsDict']]] = None,
                 meta_store_manager_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['DataLakeTimeoutsArgs', 'DataLakeTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Security Lake Data Lake.

        > **NOTE:** The underlying `securitylake.DataLake` must be configured before creating other Security Lake resources. Use a `depends_on` statement.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.DataLake("example",
            meta_store_manager_role_arn=meta_store_manager["arn"],
            configuration={
                "region": "eu-west-1",
                "encryption_configurations": [{
                    "kms_key_id": "S3_MANAGED_KEY",
                }],
                "lifecycle_configuration": {
                    "transitions": [
                        {
                            "days": 31,
                            "storage_class": "STANDARD_IA",
                        },
                        {
                            "days": 80,
                            "storage_class": "ONEZONE_IA",
                        },
                    ],
                    "expiration": {
                        "days": 300,
                    },
                },
            })
        ```

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.DataLake("example",
            meta_store_manager_role_arn=meta_store_manager["arn"],
            configuration={
                "region": "eu-west-1",
                "encryption_configurations": [{
                    "kms_key_id": "S3_MANAGED_KEY",
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import Security Hub standards subscriptions using the standards subscription ARN. For example:

        ```sh
        $ pulumi import aws:securitylake/dataLake:DataLake example arn:aws:securitylake:eu-west-1:123456789012:data-lake/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DataLakeConfigurationArgs', 'DataLakeConfigurationArgsDict']] configuration: Specify the Region or Regions that will contribute data to the rollup region.
        :param pulumi.Input[_builtins.str] meta_store_manager_role_arn: The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
        :param pulumi.Input[_builtins.str] region: The AWS Regions where Security Lake is automatically enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataLakeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Security Lake Data Lake.

        > **NOTE:** The underlying `securitylake.DataLake` must be configured before creating other Security Lake resources. Use a `depends_on` statement.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.DataLake("example",
            meta_store_manager_role_arn=meta_store_manager["arn"],
            configuration={
                "region": "eu-west-1",
                "encryption_configurations": [{
                    "kms_key_id": "S3_MANAGED_KEY",
                }],
                "lifecycle_configuration": {
                    "transitions": [
                        {
                            "days": 31,
                            "storage_class": "STANDARD_IA",
                        },
                        {
                            "days": 80,
                            "storage_class": "ONEZONE_IA",
                        },
                    ],
                    "expiration": {
                        "days": 300,
                    },
                },
            })
        ```

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.DataLake("example",
            meta_store_manager_role_arn=meta_store_manager["arn"],
            configuration={
                "region": "eu-west-1",
                "encryption_configurations": [{
                    "kms_key_id": "S3_MANAGED_KEY",
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import Security Hub standards subscriptions using the standards subscription ARN. For example:

        ```sh
        $ pulumi import aws:securitylake/dataLake:DataLake example arn:aws:securitylake:eu-west-1:123456789012:data-lake/default
        ```

        :param str resource_name: The name of the resource.
        :param DataLakeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataLakeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['DataLakeConfigurationArgs', 'DataLakeConfigurationArgsDict']]] = None,
                 meta_store_manager_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['DataLakeTimeoutsArgs', 'DataLakeTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataLakeArgs.__new__(DataLakeArgs)

            __props__.__dict__["configuration"] = configuration
            if meta_store_manager_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'meta_store_manager_role_arn'")
            __props__.__dict__["meta_store_manager_role_arn"] = meta_store_manager_role_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["s3_bucket_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(DataLake, __self__).__init__(
            'aws:securitylake/dataLake:DataLake',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            configuration: Optional[pulumi.Input[Union['DataLakeConfigurationArgs', 'DataLakeConfigurationArgsDict']]] = None,
            meta_store_manager_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            s3_bucket_arn: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['DataLakeTimeoutsArgs', 'DataLakeTimeoutsArgsDict']]] = None) -> 'DataLake':
        """
        Get an existing DataLake resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Data Lake.
        :param pulumi.Input[Union['DataLakeConfigurationArgs', 'DataLakeConfigurationArgsDict']] configuration: Specify the Region or Regions that will contribute data to the rollup region.
        :param pulumi.Input[_builtins.str] meta_store_manager_role_arn: The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
        :param pulumi.Input[_builtins.str] region: The AWS Regions where Security Lake is automatically enabled.
        :param pulumi.Input[_builtins.str] s3_bucket_arn: The ARN for the Amazon Security Lake Amazon S3 bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataLakeState.__new__(_DataLakeState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["meta_store_manager_role_arn"] = meta_store_manager_role_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_bucket_arn"] = s3_bucket_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return DataLake(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Data Lake.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.DataLakeConfiguration']]:
        """
        Specify the Region or Regions that will contribute data to the rollup region.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="metaStoreManagerRoleArn")
    def meta_store_manager_role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
        """
        return pulumi.get(self, "meta_store_manager_role_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS Regions where Security Lake is automatically enabled.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN for the Amazon Security Lake Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DataLakeTimeouts']]:
        return pulumi.get(self, "timeouts")

