# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ProductProvisioningArtifactParameters',
    'ProvisionedProductOutput',
    'ProvisionedProductProvisioningParameter',
    'ProvisionedProductStackSetProvisioningPreferences',
    'ServiceActionDefinition',
    'GetLaunchPathsSummaryResult',
    'GetLaunchPathsSummaryConstraintSummaryResult',
    'GetPortfolioConstraintsDetailResult',
    'GetProvisioningArtifactsProvisioningArtifactDetailResult',
]

@pulumi.output_type
class ProductProvisioningArtifactParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTemplateValidation":
            suggest = "disable_template_validation"
        elif key == "templatePhysicalId":
            suggest = "template_physical_id"
        elif key == "templateUrl":
            suggest = "template_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProductProvisioningArtifactParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProductProvisioningArtifactParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProductProvisioningArtifactParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 disable_template_validation: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 template_physical_id: Optional[_builtins.str] = None,
                 template_url: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
        :param _builtins.bool disable_template_validation: Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
        :param _builtins.str name: Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
        :param _builtins.str template_physical_id: Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
        :param _builtins.str template_url: Template source as URL of the CloudFormation template in Amazon S3.
        :param _builtins.str type: Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_template_validation is not None:
            pulumi.set(__self__, "disable_template_validation", disable_template_validation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template_physical_id is not None:
            pulumi.set(__self__, "template_physical_id", template_physical_id)
        if template_url is not None:
            pulumi.set(__self__, "template_url", template_url)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableTemplateValidation")
    def disable_template_validation(self) -> Optional[_builtins.bool]:
        """
        Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
        """
        return pulumi.get(self, "disable_template_validation")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="templatePhysicalId")
    def template_physical_id(self) -> Optional[_builtins.str]:
        """
        Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
        """
        return pulumi.get(self, "template_physical_id")

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> Optional[_builtins.str]:
        """
        Template source as URL of the CloudFormation template in Amazon S3.
        """
        return pulumi.get(self, "template_url")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ProvisionedProductOutput(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: The description of the output.
        :param _builtins.str key: The output key.
        :param _builtins.str value: The output value.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the output.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The output key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The output value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProvisionedProductProvisioningParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePreviousValue":
            suggest = "use_previous_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProvisionedProductProvisioningParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProvisionedProductProvisioningParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProvisionedProductProvisioningParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 use_previous_value: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Parameter key.
        :param _builtins.bool use_previous_value: Whether to ignore `value` and keep the previous parameter value. Ignored when initially provisioning a product.
        :param _builtins.str value: Parameter value.
        """
        pulumi.set(__self__, "key", key)
        if use_previous_value is not None:
            pulumi.set(__self__, "use_previous_value", use_previous_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Parameter key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="usePreviousValue")
    def use_previous_value(self) -> Optional[_builtins.bool]:
        """
        Whether to ignore `value` and keep the previous parameter value. Ignored when initially provisioning a product.
        """
        return pulumi.get(self, "use_previous_value")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProvisionedProductStackSetProvisioningPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureToleranceCount":
            suggest = "failure_tolerance_count"
        elif key == "failureTolerancePercentage":
            suggest = "failure_tolerance_percentage"
        elif key == "maxConcurrencyCount":
            suggest = "max_concurrency_count"
        elif key == "maxConcurrencyPercentage":
            suggest = "max_concurrency_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProvisionedProductStackSetProvisioningPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProvisionedProductStackSetProvisioningPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProvisionedProductStackSetProvisioningPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accounts: Optional[Sequence[_builtins.str]] = None,
                 failure_tolerance_count: Optional[_builtins.int] = None,
                 failure_tolerance_percentage: Optional[_builtins.int] = None,
                 max_concurrency_count: Optional[_builtins.int] = None,
                 max_concurrency_percentage: Optional[_builtins.int] = None,
                 regions: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] accounts: One or more AWS accounts that will have access to the provisioned product. The AWS accounts specified should be within the list of accounts in the STACKSET constraint. To get the list of accounts in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all accounts from the STACKSET constraint.
        :param _builtins.int failure_tolerance_count: Number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both. The default value is 0 if no value is specified.
        :param _builtins.int failure_tolerance_percentage: Percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both.
        :param _builtins.int max_concurrency_count: Maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `failure_tolerance_count`. `max_concurrency_count` is at most one more than the `failure_tolerance_count`. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
        :param _builtins.int max_concurrency_percentage: Maximum percentage of accounts in which to perform this operation at one time. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as 1 instead. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
        :param Sequence[_builtins.str] regions: One or more AWS Regions where the provisioned product will be available. The specified regions should be within the list of regions from the STACKSET constraint. To get the list of regions in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all regions from the STACKSET constraint.
        """
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if failure_tolerance_count is not None:
            pulumi.set(__self__, "failure_tolerance_count", failure_tolerance_count)
        if failure_tolerance_percentage is not None:
            pulumi.set(__self__, "failure_tolerance_percentage", failure_tolerance_percentage)
        if max_concurrency_count is not None:
            pulumi.set(__self__, "max_concurrency_count", max_concurrency_count)
        if max_concurrency_percentage is not None:
            pulumi.set(__self__, "max_concurrency_percentage", max_concurrency_percentage)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more AWS accounts that will have access to the provisioned product. The AWS accounts specified should be within the list of accounts in the STACKSET constraint. To get the list of accounts in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all accounts from the STACKSET constraint.
        """
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter(name="failureToleranceCount")
    def failure_tolerance_count(self) -> Optional[_builtins.int]:
        """
        Number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both. The default value is 0 if no value is specified.
        """
        return pulumi.get(self, "failure_tolerance_count")

    @_builtins.property
    @pulumi.getter(name="failureTolerancePercentage")
    def failure_tolerance_percentage(self) -> Optional[_builtins.int]:
        """
        Percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both.
        """
        return pulumi.get(self, "failure_tolerance_percentage")

    @_builtins.property
    @pulumi.getter(name="maxConcurrencyCount")
    def max_concurrency_count(self) -> Optional[_builtins.int]:
        """
        Maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `failure_tolerance_count`. `max_concurrency_count` is at most one more than the `failure_tolerance_count`. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
        """
        return pulumi.get(self, "max_concurrency_count")

    @_builtins.property
    @pulumi.getter(name="maxConcurrencyPercentage")
    def max_concurrency_percentage(self) -> Optional[_builtins.int]:
        """
        Maximum percentage of accounts in which to perform this operation at one time. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as 1 instead. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
        """
        return pulumi.get(self, "max_concurrency_percentage")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more AWS Regions where the provisioned product will be available. The specified regions should be within the list of regions from the STACKSET constraint. To get the list of regions in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all regions from the STACKSET constraint.
        """
        return pulumi.get(self, "regions")


@pulumi.output_type
class ServiceActionDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assumeRole":
            suggest = "assume_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceActionDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceActionDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceActionDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 version: _builtins.str,
                 assume_role: Optional[_builtins.str] = None,
                 parameters: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the SSM document. For example, `AWS-RestartEC2Instance`. If you are using a shared SSM document, you must provide the ARN instead of the name.
        :param _builtins.str version: SSM document version. For example, `1`.
        :param _builtins.str assume_role: ARN of the role that performs the self-service actions on your behalf. For example, `arn:aws:iam::12345678910:role/ActionRole`. To reuse the provisioned product launch role, set to `LAUNCH_ROLE`.
        :param _builtins.str parameters: List of parameters in JSON format. For example: `[{\\"Name\\":\\"InstanceId\\",\\"Type\\":\\"TARGET\\"}]` or `[{\\"Name\\":\\"InstanceId\\",\\"Type\\":\\"TEXT_VALUE\\"}]`.
        :param _builtins.str type: Service action definition type. Valid value is `SSM_AUTOMATION`. Default is `SSM_AUTOMATION`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the SSM document. For example, `AWS-RestartEC2Instance`. If you are using a shared SSM document, you must provide the ARN instead of the name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        SSM document version. For example, `1`.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional[_builtins.str]:
        """
        ARN of the role that performs the self-service actions on your behalf. For example, `arn:aws:iam::12345678910:role/ActionRole`. To reuse the provisioned product launch role, set to `LAUNCH_ROLE`.
        """
        return pulumi.get(self, "assume_role")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[_builtins.str]:
        """
        List of parameters in JSON format. For example: `[{\\"Name\\":\\"InstanceId\\",\\"Type\\":\\"TARGET\\"}]` or `[{\\"Name\\":\\"InstanceId\\",\\"Type\\":\\"TEXT_VALUE\\"}]`.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Service action definition type. Valid value is `SSM_AUTOMATION`. Default is `SSM_AUTOMATION`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLaunchPathsSummaryResult(dict):
    def __init__(__self__, *,
                 constraint_summaries: Sequence['outputs.GetLaunchPathsSummaryConstraintSummaryResult'],
                 name: _builtins.str,
                 path_id: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param Sequence['GetLaunchPathsSummaryConstraintSummaryArgs'] constraint_summaries: Block for constraints on the portfolio-product relationship. See details below.
        :param _builtins.str name: Name of the portfolio to which the path was assigned.
        :param _builtins.str path_id: Identifier of the product path.
        :param Mapping[str, _builtins.str] tags: Tags associated with this product path.
        """
        pulumi.set(__self__, "constraint_summaries", constraint_summaries)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path_id", path_id)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="constraintSummaries")
    def constraint_summaries(self) -> Sequence['outputs.GetLaunchPathsSummaryConstraintSummaryResult']:
        """
        Block for constraints on the portfolio-product relationship. See details below.
        """
        return pulumi.get(self, "constraint_summaries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the portfolio to which the path was assigned.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pathId")
    def path_id(self) -> _builtins.str:
        """
        Identifier of the product path.
        """
        return pulumi.get(self, "path_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags associated with this product path.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetLaunchPathsSummaryConstraintSummaryResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str description: Description of the constraint.
        :param _builtins.str type: Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `STACKSET`, and `TEMPLATE`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the constraint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `STACKSET`, and `TEMPLATE`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPortfolioConstraintsDetailResult(dict):
    def __init__(__self__, *,
                 constraint_id: _builtins.str,
                 description: _builtins.str,
                 owner: _builtins.str,
                 portfolio_id: _builtins.str,
                 product_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str constraint_id: Identifier of the constraint.
        :param _builtins.str description: Description of the constraint.
        :param _builtins.str portfolio_id: Portfolio identifier.
               
               The following arguments are optional:
        :param _builtins.str product_id: Product identifier.
        :param _builtins.str type: Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `STACKSET`, and `TEMPLATE`.
        """
        pulumi.set(__self__, "constraint_id", constraint_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "portfolio_id", portfolio_id)
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="constraintId")
    def constraint_id(self) -> _builtins.str:
        """
        Identifier of the constraint.
        """
        return pulumi.get(self, "constraint_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the constraint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> _builtins.str:
        """
        Portfolio identifier.

        The following arguments are optional:
        """
        return pulumi.get(self, "portfolio_id")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> _builtins.str:
        """
        Product identifier.
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `STACKSET`, and `TEMPLATE`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProvisioningArtifactsProvisioningArtifactDetailResult(dict):
    def __init__(__self__, *,
                 active: _builtins.bool,
                 created_time: _builtins.str,
                 description: _builtins.str,
                 guidance: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.bool active: Indicates whether the product version is active.
        :param _builtins.str created_time: The UTC time stamp of the creation time.
        :param _builtins.str description: The description of the provisioning artifact.
        :param _builtins.str guidance: Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
        :param _builtins.str id: The identifier of the provisioning artifact.
        :param _builtins.str name: The name of the provisioning artifact.
        :param _builtins.str type: The type of provisioning artifact.
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "guidance", guidance)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def active(self) -> _builtins.bool:
        """
        Indicates whether the product version is active.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        The UTC time stamp of the creation time.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the provisioning artifact.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def guidance(self) -> _builtins.str:
        """
        Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
        """
        return pulumi.get(self, "guidance")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The identifier of the provisioning artifact.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the provisioning artifact.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of provisioning artifact.
        """
        return pulumi.get(self, "type")


