# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TemplateArgs', 'Template']

@pulumi.input_type
class TemplateArgs:
    def __init__(__self__, *,
                 quota_code: pulumi.Input[_builtins.str],
                 service_code: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.float],
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Template resource.
        :param pulumi.Input[_builtins.str] quota_code: Quota identifier. To find the quota code for a specific quota, use the servicequotas.ServiceQuota data source.
        :param pulumi.Input[_builtins.str] service_code: Service identifier. To find the service code value for an AWS service, use the servicequotas_get_service data source.
        :param pulumi.Input[_builtins.float] value: The new, increased value for the quota.
        :param pulumi.Input[_builtins.str] aws_region: AWS Region to which the template applies.
        :param pulumi.Input[_builtins.str] region: AWS Region to which the template applies. Use `get_region` instead.
        """
        pulumi.set(__self__, "quota_code", quota_code)
        pulumi.set(__self__, "service_code", service_code)
        pulumi.set(__self__, "value", value)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if region is not None:
            warnings.warn("""region is deprecated. Use get_region instead.""", DeprecationWarning)
            pulumi.log.warn("""region is deprecated: region is deprecated. Use get_region instead.""")
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="quotaCode")
    def quota_code(self) -> pulumi.Input[_builtins.str]:
        """
        Quota identifier. To find the quota code for a specific quota, use the servicequotas.ServiceQuota data source.
        """
        return pulumi.get(self, "quota_code")

    @quota_code.setter
    def quota_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "quota_code", value)

    @_builtins.property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> pulumi.Input[_builtins.str]:
        """
        Service identifier. To find the service code value for an AWS service, use the servicequotas_get_service data source.
        """
        return pulumi.get(self, "service_code")

    @service_code.setter
    def service_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_code", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.float]:
        """
        The new, increased value for the quota.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Region to which the template applies.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use get_region instead.""")
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Region to which the template applies. Use `get_region` instead.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TemplateState:
    def __init__(__self__, *,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 global_quota: Optional[pulumi.Input[_builtins.bool]] = None,
                 quota_code: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_code: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 unit: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.float]] = None):
        """
        Input properties used for looking up and filtering Template resources.
        :param pulumi.Input[_builtins.str] aws_region: AWS Region to which the template applies.
        :param pulumi.Input[_builtins.bool] global_quota: Indicates whether the quota is global.
        :param pulumi.Input[_builtins.str] quota_code: Quota identifier. To find the quota code for a specific quota, use the servicequotas.ServiceQuota data source.
        :param pulumi.Input[_builtins.str] quota_name: Quota name.
        :param pulumi.Input[_builtins.str] region: AWS Region to which the template applies. Use `get_region` instead.
        :param pulumi.Input[_builtins.str] service_code: Service identifier. To find the service code value for an AWS service, use the servicequotas_get_service data source.
        :param pulumi.Input[_builtins.str] service_name: Service name.
        :param pulumi.Input[_builtins.str] unit: Unit of measurement.
        :param pulumi.Input[_builtins.float] value: The new, increased value for the quota.
        """
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if global_quota is not None:
            pulumi.set(__self__, "global_quota", global_quota)
        if quota_code is not None:
            pulumi.set(__self__, "quota_code", quota_code)
        if quota_name is not None:
            pulumi.set(__self__, "quota_name", quota_name)
        if region is not None:
            warnings.warn("""region is deprecated. Use get_region instead.""", DeprecationWarning)
            pulumi.log.warn("""region is deprecated: region is deprecated. Use get_region instead.""")
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_code is not None:
            pulumi.set(__self__, "service_code", service_code)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Region to which the template applies.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @_builtins.property
    @pulumi.getter(name="globalQuota")
    def global_quota(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the quota is global.
        """
        return pulumi.get(self, "global_quota")

    @global_quota.setter
    def global_quota(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "global_quota", value)

    @_builtins.property
    @pulumi.getter(name="quotaCode")
    def quota_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota identifier. To find the quota code for a specific quota, use the servicequotas.ServiceQuota data source.
        """
        return pulumi.get(self, "quota_code")

    @quota_code.setter
    def quota_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_code", value)

    @_builtins.property
    @pulumi.getter(name="quotaName")
    def quota_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Quota name.
        """
        return pulumi.get(self, "quota_name")

    @quota_name.setter
    def quota_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use get_region instead.""")
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Region to which the template applies. Use `get_region` instead.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service identifier. To find the service code value for an AWS service, use the servicequotas_get_service data source.
        """
        return pulumi.get(self, "service_code")

    @service_code.setter
    def service_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_code", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unit of measurement.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The new, increased value for the quota.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("aws:servicequotas/template:Template")
class Template(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_code: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_code: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.float]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Service Quotas Template.

        > Only the management account of an organization can alter Service Quota templates, and this must be done from the `us-east-1` region.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicequotas.Template("example",
            aws_region="us-east-1",
            quota_code="L-2ACBD22F",
            service_code="lambda",
            value=80)
        ```

        ## Import

        Using `pulumi import`, import Service Quotas Template using the `id`. For example:

        ```sh
        $ pulumi import aws:servicequotas/template:Template example us-east-1,L-2ACBD22F,lambda
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_region: AWS Region to which the template applies.
        :param pulumi.Input[_builtins.str] quota_code: Quota identifier. To find the quota code for a specific quota, use the servicequotas.ServiceQuota data source.
        :param pulumi.Input[_builtins.str] region: AWS Region to which the template applies. Use `get_region` instead.
        :param pulumi.Input[_builtins.str] service_code: Service identifier. To find the service code value for an AWS service, use the servicequotas_get_service data source.
        :param pulumi.Input[_builtins.float] value: The new, increased value for the quota.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Service Quotas Template.

        > Only the management account of an organization can alter Service Quota templates, and this must be done from the `us-east-1` region.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicequotas.Template("example",
            aws_region="us-east-1",
            quota_code="L-2ACBD22F",
            service_code="lambda",
            value=80)
        ```

        ## Import

        Using `pulumi import`, import Service Quotas Template using the `id`. For example:

        ```sh
        $ pulumi import aws:servicequotas/template:Template example us-east-1,L-2ACBD22F,lambda
        ```

        :param str resource_name: The name of the resource.
        :param TemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_code: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_code: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplateArgs.__new__(TemplateArgs)

            __props__.__dict__["aws_region"] = aws_region
            if quota_code is None and not opts.urn:
                raise TypeError("Missing required property 'quota_code'")
            __props__.__dict__["quota_code"] = quota_code
            __props__.__dict__["region"] = region
            if service_code is None and not opts.urn:
                raise TypeError("Missing required property 'service_code'")
            __props__.__dict__["service_code"] = service_code
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["global_quota"] = None
            __props__.__dict__["quota_name"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["unit"] = None
        super(Template, __self__).__init__(
            'aws:servicequotas/template:Template',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_region: Optional[pulumi.Input[_builtins.str]] = None,
            global_quota: Optional[pulumi.Input[_builtins.bool]] = None,
            quota_code: Optional[pulumi.Input[_builtins.str]] = None,
            quota_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_code: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            unit: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.float]] = None) -> 'Template':
        """
        Get an existing Template resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_region: AWS Region to which the template applies.
        :param pulumi.Input[_builtins.bool] global_quota: Indicates whether the quota is global.
        :param pulumi.Input[_builtins.str] quota_code: Quota identifier. To find the quota code for a specific quota, use the servicequotas.ServiceQuota data source.
        :param pulumi.Input[_builtins.str] quota_name: Quota name.
        :param pulumi.Input[_builtins.str] region: AWS Region to which the template applies. Use `get_region` instead.
        :param pulumi.Input[_builtins.str] service_code: Service identifier. To find the service code value for an AWS service, use the servicequotas_get_service data source.
        :param pulumi.Input[_builtins.str] service_name: Service name.
        :param pulumi.Input[_builtins.str] unit: Unit of measurement.
        :param pulumi.Input[_builtins.float] value: The new, increased value for the quota.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TemplateState.__new__(_TemplateState)

        __props__.__dict__["aws_region"] = aws_region
        __props__.__dict__["global_quota"] = global_quota
        __props__.__dict__["quota_code"] = quota_code
        __props__.__dict__["quota_name"] = quota_name
        __props__.__dict__["region"] = region
        __props__.__dict__["service_code"] = service_code
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["unit"] = unit
        __props__.__dict__["value"] = value
        return Template(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Output[_builtins.str]:
        """
        AWS Region to which the template applies.
        """
        return pulumi.get(self, "aws_region")

    @_builtins.property
    @pulumi.getter(name="globalQuota")
    def global_quota(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the quota is global.
        """
        return pulumi.get(self, "global_quota")

    @_builtins.property
    @pulumi.getter(name="quotaCode")
    def quota_code(self) -> pulumi.Output[_builtins.str]:
        """
        Quota identifier. To find the quota code for a specific quota, use the servicequotas.ServiceQuota data source.
        """
        return pulumi.get(self, "quota_code")

    @_builtins.property
    @pulumi.getter(name="quotaName")
    def quota_name(self) -> pulumi.Output[_builtins.str]:
        """
        Quota name.
        """
        return pulumi.get(self, "quota_name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use get_region instead.""")
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        AWS Region to which the template applies. Use `get_region` instead.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> pulumi.Output[_builtins.str]:
        """
        Service identifier. To find the service code value for an AWS service, use the servicequotas_get_service data source.
        """
        return pulumi.get(self, "service_code")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def unit(self) -> pulumi.Output[_builtins.str]:
        """
        Unit of measurement.
        """
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.float]:
        """
        The new, increased value for the quota.
        """
        return pulumi.get(self, "value")

