# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountVdmAttributesArgs', 'AccountVdmAttributes']

@pulumi.input_type
class AccountVdmAttributesArgs:
    def __init__(__self__, *,
                 vdm_enabled: pulumi.Input[_builtins.str],
                 dashboard_attributes: Optional[pulumi.Input['AccountVdmAttributesDashboardAttributesArgs']] = None,
                 guardian_attributes: Optional[pulumi.Input['AccountVdmAttributesGuardianAttributesArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccountVdmAttributes resource.
        :param pulumi.Input[_builtins.str] vdm_enabled: Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.
               
               The following arguments are optional:
        :param pulumi.Input['AccountVdmAttributesDashboardAttributesArgs'] dashboard_attributes: Specifies additional settings for your VDM configuration as applicable to the Dashboard.
        :param pulumi.Input['AccountVdmAttributesGuardianAttributesArgs'] guardian_attributes: Specifies additional settings for your VDM configuration as applicable to the Guardian.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "vdm_enabled", vdm_enabled)
        if dashboard_attributes is not None:
            pulumi.set(__self__, "dashboard_attributes", dashboard_attributes)
        if guardian_attributes is not None:
            pulumi.set(__self__, "guardian_attributes", guardian_attributes)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="vdmEnabled")
    def vdm_enabled(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.

        The following arguments are optional:
        """
        return pulumi.get(self, "vdm_enabled")

    @vdm_enabled.setter
    def vdm_enabled(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vdm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dashboardAttributes")
    def dashboard_attributes(self) -> Optional[pulumi.Input['AccountVdmAttributesDashboardAttributesArgs']]:
        """
        Specifies additional settings for your VDM configuration as applicable to the Dashboard.
        """
        return pulumi.get(self, "dashboard_attributes")

    @dashboard_attributes.setter
    def dashboard_attributes(self, value: Optional[pulumi.Input['AccountVdmAttributesDashboardAttributesArgs']]):
        pulumi.set(self, "dashboard_attributes", value)

    @_builtins.property
    @pulumi.getter(name="guardianAttributes")
    def guardian_attributes(self) -> Optional[pulumi.Input['AccountVdmAttributesGuardianAttributesArgs']]:
        """
        Specifies additional settings for your VDM configuration as applicable to the Guardian.
        """
        return pulumi.get(self, "guardian_attributes")

    @guardian_attributes.setter
    def guardian_attributes(self, value: Optional[pulumi.Input['AccountVdmAttributesGuardianAttributesArgs']]):
        pulumi.set(self, "guardian_attributes", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AccountVdmAttributesState:
    def __init__(__self__, *,
                 dashboard_attributes: Optional[pulumi.Input['AccountVdmAttributesDashboardAttributesArgs']] = None,
                 guardian_attributes: Optional[pulumi.Input['AccountVdmAttributesGuardianAttributesArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vdm_enabled: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountVdmAttributes resources.
        :param pulumi.Input['AccountVdmAttributesDashboardAttributesArgs'] dashboard_attributes: Specifies additional settings for your VDM configuration as applicable to the Dashboard.
        :param pulumi.Input['AccountVdmAttributesGuardianAttributesArgs'] guardian_attributes: Specifies additional settings for your VDM configuration as applicable to the Guardian.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] vdm_enabled: Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.
               
               The following arguments are optional:
        """
        if dashboard_attributes is not None:
            pulumi.set(__self__, "dashboard_attributes", dashboard_attributes)
        if guardian_attributes is not None:
            pulumi.set(__self__, "guardian_attributes", guardian_attributes)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vdm_enabled is not None:
            pulumi.set(__self__, "vdm_enabled", vdm_enabled)

    @_builtins.property
    @pulumi.getter(name="dashboardAttributes")
    def dashboard_attributes(self) -> Optional[pulumi.Input['AccountVdmAttributesDashboardAttributesArgs']]:
        """
        Specifies additional settings for your VDM configuration as applicable to the Dashboard.
        """
        return pulumi.get(self, "dashboard_attributes")

    @dashboard_attributes.setter
    def dashboard_attributes(self, value: Optional[pulumi.Input['AccountVdmAttributesDashboardAttributesArgs']]):
        pulumi.set(self, "dashboard_attributes", value)

    @_builtins.property
    @pulumi.getter(name="guardianAttributes")
    def guardian_attributes(self) -> Optional[pulumi.Input['AccountVdmAttributesGuardianAttributesArgs']]:
        """
        Specifies additional settings for your VDM configuration as applicable to the Guardian.
        """
        return pulumi.get(self, "guardian_attributes")

    @guardian_attributes.setter
    def guardian_attributes(self, value: Optional[pulumi.Input['AccountVdmAttributesGuardianAttributesArgs']]):
        pulumi.set(self, "guardian_attributes", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="vdmEnabled")
    def vdm_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.

        The following arguments are optional:
        """
        return pulumi.get(self, "vdm_enabled")

    @vdm_enabled.setter
    def vdm_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vdm_enabled", value)


@pulumi.type_token("aws:sesv2/accountVdmAttributes:AccountVdmAttributes")
class AccountVdmAttributes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_attributes: Optional[pulumi.Input[Union['AccountVdmAttributesDashboardAttributesArgs', 'AccountVdmAttributesDashboardAttributesArgsDict']]] = None,
                 guardian_attributes: Optional[pulumi.Input[Union['AccountVdmAttributesGuardianAttributesArgs', 'AccountVdmAttributesGuardianAttributesArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vdm_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS SESv2 (Simple Email V2) Account VDM Attributes.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sesv2.AccountVdmAttributes("example",
            vdm_enabled="ENABLED",
            dashboard_attributes={
                "engagement_metrics": "ENABLED",
            },
            guardian_attributes={
                "optimized_shared_delivery": "ENABLED",
            })
        ```

        ## Import

        Using `pulumi import`, import SESv2 (Simple Email V2) Account VDM Attributes using the word `ses-account-vdm-attributes`. For example:

        ```sh
        $ pulumi import aws:sesv2/accountVdmAttributes:AccountVdmAttributes example ses-account-vdm-attributes
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AccountVdmAttributesDashboardAttributesArgs', 'AccountVdmAttributesDashboardAttributesArgsDict']] dashboard_attributes: Specifies additional settings for your VDM configuration as applicable to the Dashboard.
        :param pulumi.Input[Union['AccountVdmAttributesGuardianAttributesArgs', 'AccountVdmAttributesGuardianAttributesArgsDict']] guardian_attributes: Specifies additional settings for your VDM configuration as applicable to the Guardian.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] vdm_enabled: Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountVdmAttributesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS SESv2 (Simple Email V2) Account VDM Attributes.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sesv2.AccountVdmAttributes("example",
            vdm_enabled="ENABLED",
            dashboard_attributes={
                "engagement_metrics": "ENABLED",
            },
            guardian_attributes={
                "optimized_shared_delivery": "ENABLED",
            })
        ```

        ## Import

        Using `pulumi import`, import SESv2 (Simple Email V2) Account VDM Attributes using the word `ses-account-vdm-attributes`. For example:

        ```sh
        $ pulumi import aws:sesv2/accountVdmAttributes:AccountVdmAttributes example ses-account-vdm-attributes
        ```

        :param str resource_name: The name of the resource.
        :param AccountVdmAttributesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountVdmAttributesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_attributes: Optional[pulumi.Input[Union['AccountVdmAttributesDashboardAttributesArgs', 'AccountVdmAttributesDashboardAttributesArgsDict']]] = None,
                 guardian_attributes: Optional[pulumi.Input[Union['AccountVdmAttributesGuardianAttributesArgs', 'AccountVdmAttributesGuardianAttributesArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vdm_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountVdmAttributesArgs.__new__(AccountVdmAttributesArgs)

            __props__.__dict__["dashboard_attributes"] = dashboard_attributes
            __props__.__dict__["guardian_attributes"] = guardian_attributes
            __props__.__dict__["region"] = region
            if vdm_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'vdm_enabled'")
            __props__.__dict__["vdm_enabled"] = vdm_enabled
        super(AccountVdmAttributes, __self__).__init__(
            'aws:sesv2/accountVdmAttributes:AccountVdmAttributes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dashboard_attributes: Optional[pulumi.Input[Union['AccountVdmAttributesDashboardAttributesArgs', 'AccountVdmAttributesDashboardAttributesArgsDict']]] = None,
            guardian_attributes: Optional[pulumi.Input[Union['AccountVdmAttributesGuardianAttributesArgs', 'AccountVdmAttributesGuardianAttributesArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            vdm_enabled: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccountVdmAttributes':
        """
        Get an existing AccountVdmAttributes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AccountVdmAttributesDashboardAttributesArgs', 'AccountVdmAttributesDashboardAttributesArgsDict']] dashboard_attributes: Specifies additional settings for your VDM configuration as applicable to the Dashboard.
        :param pulumi.Input[Union['AccountVdmAttributesGuardianAttributesArgs', 'AccountVdmAttributesGuardianAttributesArgsDict']] guardian_attributes: Specifies additional settings for your VDM configuration as applicable to the Guardian.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] vdm_enabled: Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountVdmAttributesState.__new__(_AccountVdmAttributesState)

        __props__.__dict__["dashboard_attributes"] = dashboard_attributes
        __props__.__dict__["guardian_attributes"] = guardian_attributes
        __props__.__dict__["region"] = region
        __props__.__dict__["vdm_enabled"] = vdm_enabled
        return AccountVdmAttributes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dashboardAttributes")
    def dashboard_attributes(self) -> pulumi.Output['outputs.AccountVdmAttributesDashboardAttributes']:
        """
        Specifies additional settings for your VDM configuration as applicable to the Dashboard.
        """
        return pulumi.get(self, "dashboard_attributes")

    @_builtins.property
    @pulumi.getter(name="guardianAttributes")
    def guardian_attributes(self) -> pulumi.Output['outputs.AccountVdmAttributesGuardianAttributes']:
        """
        Specifies additional settings for your VDM configuration as applicable to the Guardian.
        """
        return pulumi.get(self, "guardian_attributes")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="vdmEnabled")
    def vdm_enabled(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.

        The following arguments are optional:
        """
        return pulumi.get(self, "vdm_enabled")

