# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAliasResult',
    'AwaitableGetAliasResult',
    'get_alias',
    'get_alias_output',
]

@pulumi.output_type
class GetAliasResult:
    """
    A collection of values returned by getAlias.
    """
    def __init__(__self__, arn=None, creation_date=None, description=None, id=None, name=None, region=None, routing_configurations=None, statemachine_arn=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routing_configurations and not isinstance(routing_configurations, list):
            raise TypeError("Expected argument 'routing_configurations' to be a list")
        pulumi.set(__self__, "routing_configurations", routing_configurations)
        if statemachine_arn and not isinstance(statemachine_arn, str):
            raise TypeError("Expected argument 'statemachine_arn' to be a str")
        pulumi.set(__self__, "statemachine_arn", statemachine_arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN identifying the State Machine alias.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        Date the state machine Alias was created.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of state machine alias.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routingConfigurations")
    def routing_configurations(self) -> Sequence['outputs.GetAliasRoutingConfigurationResult']:
        """
        Routing Configuration of state machine alias
        """
        return pulumi.get(self, "routing_configurations")

    @_builtins.property
    @pulumi.getter(name="statemachineArn")
    def statemachine_arn(self) -> _builtins.str:
        return pulumi.get(self, "statemachine_arn")


class AwaitableGetAliasResult(GetAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAliasResult(
            arn=self.arn,
            creation_date=self.creation_date,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            routing_configurations=self.routing_configurations,
            statemachine_arn=self.statemachine_arn)


def get_alias(description: Optional[_builtins.str] = None,
              name: Optional[_builtins.str] = None,
              region: Optional[_builtins.str] = None,
              statemachine_arn: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAliasResult:
    """
    Data source for managing an AWS SFN (Step Functions) State Machine Alias.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.sfn.get_alias(name="my_sfn_alias",
        statemachine_arn=sfn_test["arn"])
    ```


    :param _builtins.str description: Description of state machine alias.
    :param _builtins.str name: Name of the State Machine alias.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str statemachine_arn: ARN of the State Machine.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['name'] = name
    __args__['region'] = region
    __args__['statemachineArn'] = statemachine_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:sfn/getAlias:getAlias', __args__, opts=opts, typ=GetAliasResult).value

    return AwaitableGetAliasResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_date=pulumi.get(__ret__, 'creation_date'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        routing_configurations=pulumi.get(__ret__, 'routing_configurations'),
        statemachine_arn=pulumi.get(__ret__, 'statemachine_arn'))
def get_alias_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name: Optional[pulumi.Input[_builtins.str]] = None,
                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     statemachine_arn: Optional[pulumi.Input[_builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAliasResult]:
    """
    Data source for managing an AWS SFN (Step Functions) State Machine Alias.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.sfn.get_alias(name="my_sfn_alias",
        statemachine_arn=sfn_test["arn"])
    ```


    :param _builtins.str description: Description of state machine alias.
    :param _builtins.str name: Name of the State Machine alias.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str statemachine_arn: ARN of the State Machine.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['name'] = name
    __args__['region'] = region
    __args__['statemachineArn'] = statemachine_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:sfn/getAlias:getAlias', __args__, opts=opts, typ=GetAliasResult)
    return __ret__.apply(lambda __response__: GetAliasResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_date=pulumi.get(__response__, 'creation_date'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        routing_configurations=pulumi.get(__response__, 'routing_configurations'),
        statemachine_arn=pulumi.get(__response__, 'statemachine_arn')))
