# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SigningProfileArgs', 'SigningProfile']

@pulumi.input_type
class SigningProfileArgs:
    def __init__(__self__, *,
                 platform_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_validity_period: Optional[pulumi.Input['SigningProfileSignatureValidityPeriodArgs']] = None,
                 signing_material: Optional[pulumi.Input['SigningProfileSigningMaterialArgs']] = None,
                 signing_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SigningProfile resource.
        :param pulumi.Input[_builtins.str] platform_id: The ID of the platform that is used by the target signing profile.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['SigningProfileSignatureValidityPeriodArgs'] signature_validity_period: The validity period for a signing job. See `signature_validity_period` Block below for details.
        :param pulumi.Input['SigningProfileSigningMaterialArgs'] signing_material: The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] signing_parameters: Map of key-value pairs for signing. These can include any information that you want to use during signing.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "platform_id", platform_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if signature_validity_period is not None:
            pulumi.set(__self__, "signature_validity_period", signature_validity_period)
        if signing_material is not None:
            pulumi.set(__self__, "signing_material", signing_material)
        if signing_parameters is not None:
            pulumi.set(__self__, "signing_parameters", signing_parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="platformId")
    def platform_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the platform that is used by the target signing profile.
        """
        return pulumi.get(self, "platform_id")

    @platform_id.setter
    def platform_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "platform_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="signatureValidityPeriod")
    def signature_validity_period(self) -> Optional[pulumi.Input['SigningProfileSignatureValidityPeriodArgs']]:
        """
        The validity period for a signing job. See `signature_validity_period` Block below for details.
        """
        return pulumi.get(self, "signature_validity_period")

    @signature_validity_period.setter
    def signature_validity_period(self, value: Optional[pulumi.Input['SigningProfileSignatureValidityPeriodArgs']]):
        pulumi.set(self, "signature_validity_period", value)

    @_builtins.property
    @pulumi.getter(name="signingMaterial")
    def signing_material(self) -> Optional[pulumi.Input['SigningProfileSigningMaterialArgs']]:
        """
        The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
        """
        return pulumi.get(self, "signing_material")

    @signing_material.setter
    def signing_material(self, value: Optional[pulumi.Input['SigningProfileSigningMaterialArgs']]):
        pulumi.set(self, "signing_material", value)

    @_builtins.property
    @pulumi.getter(name="signingParameters")
    def signing_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of key-value pairs for signing. These can include any information that you want to use during signing.
        """
        return pulumi.get(self, "signing_parameters")

    @signing_parameters.setter
    def signing_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "signing_parameters", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SigningProfileState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 revocation_records: Optional[pulumi.Input[Sequence[pulumi.Input['SigningProfileRevocationRecordArgs']]]] = None,
                 signature_validity_period: Optional[pulumi.Input['SigningProfileSignatureValidityPeriodArgs']] = None,
                 signing_material: Optional[pulumi.Input['SigningProfileSigningMaterialArgs']] = None,
                 signing_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SigningProfile resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) for the signing profile.
        :param pulumi.Input[_builtins.str] platform_display_name: A human-readable name for the signing platform associated with the signing profile.
        :param pulumi.Input[_builtins.str] platform_id: The ID of the platform that is used by the target signing profile.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['SigningProfileRevocationRecordArgs']]] revocation_records: Revocation information for a signing profile. See `revocation_record` Block below for details.
        :param pulumi.Input['SigningProfileSignatureValidityPeriodArgs'] signature_validity_period: The validity period for a signing job. See `signature_validity_period` Block below for details.
        :param pulumi.Input['SigningProfileSigningMaterialArgs'] signing_material: The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] signing_parameters: Map of key-value pairs for signing. These can include any information that you want to use during signing.
        :param pulumi.Input[_builtins.str] status: The status of the target signing profile.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] version: The current version of the signing profile.
        :param pulumi.Input[_builtins.str] version_arn: The signing profile ARN, including the profile version.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if platform_display_name is not None:
            pulumi.set(__self__, "platform_display_name", platform_display_name)
        if platform_id is not None:
            pulumi.set(__self__, "platform_id", platform_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if revocation_records is not None:
            pulumi.set(__self__, "revocation_records", revocation_records)
        if signature_validity_period is not None:
            pulumi.set(__self__, "signature_validity_period", signature_validity_period)
        if signing_material is not None:
            pulumi.set(__self__, "signing_material", signing_material)
        if signing_parameters is not None:
            pulumi.set(__self__, "signing_parameters", signing_parameters)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_arn is not None:
            pulumi.set(__self__, "version_arn", version_arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the signing profile.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="platformDisplayName")
    def platform_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable name for the signing platform associated with the signing profile.
        """
        return pulumi.get(self, "platform_display_name")

    @platform_display_name.setter
    def platform_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_display_name", value)

    @_builtins.property
    @pulumi.getter(name="platformId")
    def platform_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the platform that is used by the target signing profile.
        """
        return pulumi.get(self, "platform_id")

    @platform_id.setter
    def platform_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="revocationRecords")
    def revocation_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SigningProfileRevocationRecordArgs']]]]:
        """
        Revocation information for a signing profile. See `revocation_record` Block below for details.
        """
        return pulumi.get(self, "revocation_records")

    @revocation_records.setter
    def revocation_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SigningProfileRevocationRecordArgs']]]]):
        pulumi.set(self, "revocation_records", value)

    @_builtins.property
    @pulumi.getter(name="signatureValidityPeriod")
    def signature_validity_period(self) -> Optional[pulumi.Input['SigningProfileSignatureValidityPeriodArgs']]:
        """
        The validity period for a signing job. See `signature_validity_period` Block below for details.
        """
        return pulumi.get(self, "signature_validity_period")

    @signature_validity_period.setter
    def signature_validity_period(self, value: Optional[pulumi.Input['SigningProfileSignatureValidityPeriodArgs']]):
        pulumi.set(self, "signature_validity_period", value)

    @_builtins.property
    @pulumi.getter(name="signingMaterial")
    def signing_material(self) -> Optional[pulumi.Input['SigningProfileSigningMaterialArgs']]:
        """
        The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
        """
        return pulumi.get(self, "signing_material")

    @signing_material.setter
    def signing_material(self, value: Optional[pulumi.Input['SigningProfileSigningMaterialArgs']]):
        pulumi.set(self, "signing_material", value)

    @_builtins.property
    @pulumi.getter(name="signingParameters")
    def signing_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of key-value pairs for signing. These can include any information that you want to use during signing.
        """
        return pulumi.get(self, "signing_parameters")

    @signing_parameters.setter
    def signing_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "signing_parameters", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the target signing profile.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current version of the signing profile.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="versionArn")
    def version_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signing profile ARN, including the profile version.
        """
        return pulumi.get(self, "version_arn")

    @version_arn.setter
    def version_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_arn", value)


@pulumi.type_token("aws:signer/signingProfile:SigningProfile")
class SigningProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_validity_period: Optional[pulumi.Input[Union['SigningProfileSignatureValidityPeriodArgs', 'SigningProfileSignatureValidityPeriodArgsDict']]] = None,
                 signing_material: Optional[pulumi.Input[Union['SigningProfileSigningMaterialArgs', 'SigningProfileSigningMaterialArgsDict']]] = None,
                 signing_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates a Signer Signing Profile. A signing profile contains information about the code signing configuration parameters that can be used by a given code signing user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_sp = aws.signer.SigningProfile("test_sp", platform_id="AWSLambda-SHA384-ECDSA")
        prod_sp = aws.signer.SigningProfile("prod_sp",
            platform_id="AWSLambda-SHA384-ECDSA",
            name_prefix="prod_sp_",
            signature_validity_period={
                "value": 5,
                "type": "YEARS",
            },
            tags={
                "tag1": "value1",
                "tag2": "value2",
            })
        ```

        ## Import

        Using `pulumi import`, import Signer signing profiles using the `name`. For example:

        ```sh
        $ pulumi import aws:signer/signingProfile:SigningProfile test_signer_signing_profile test_sp_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] platform_id: The ID of the platform that is used by the target signing profile.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['SigningProfileSignatureValidityPeriodArgs', 'SigningProfileSignatureValidityPeriodArgsDict']] signature_validity_period: The validity period for a signing job. See `signature_validity_period` Block below for details.
        :param pulumi.Input[Union['SigningProfileSigningMaterialArgs', 'SigningProfileSigningMaterialArgsDict']] signing_material: The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] signing_parameters: Map of key-value pairs for signing. These can include any information that you want to use during signing.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SigningProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Signer Signing Profile. A signing profile contains information about the code signing configuration parameters that can be used by a given code signing user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_sp = aws.signer.SigningProfile("test_sp", platform_id="AWSLambda-SHA384-ECDSA")
        prod_sp = aws.signer.SigningProfile("prod_sp",
            platform_id="AWSLambda-SHA384-ECDSA",
            name_prefix="prod_sp_",
            signature_validity_period={
                "value": 5,
                "type": "YEARS",
            },
            tags={
                "tag1": "value1",
                "tag2": "value2",
            })
        ```

        ## Import

        Using `pulumi import`, import Signer signing profiles using the `name`. For example:

        ```sh
        $ pulumi import aws:signer/signingProfile:SigningProfile test_signer_signing_profile test_sp_DdW3Mk1foYL88fajut4mTVFGpuwfd4ACO6ANL0D1uIj7lrn8adK
        ```

        :param str resource_name: The name of the resource.
        :param SigningProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SigningProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_validity_period: Optional[pulumi.Input[Union['SigningProfileSignatureValidityPeriodArgs', 'SigningProfileSignatureValidityPeriodArgsDict']]] = None,
                 signing_material: Optional[pulumi.Input[Union['SigningProfileSigningMaterialArgs', 'SigningProfileSigningMaterialArgsDict']]] = None,
                 signing_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SigningProfileArgs.__new__(SigningProfileArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            if platform_id is None and not opts.urn:
                raise TypeError("Missing required property 'platform_id'")
            __props__.__dict__["platform_id"] = platform_id
            __props__.__dict__["region"] = region
            __props__.__dict__["signature_validity_period"] = signature_validity_period
            __props__.__dict__["signing_material"] = signing_material
            __props__.__dict__["signing_parameters"] = signing_parameters
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["platform_display_name"] = None
            __props__.__dict__["revocation_records"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["version_arn"] = None
        super(SigningProfile, __self__).__init__(
            'aws:signer/signingProfile:SigningProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            platform_display_name: Optional[pulumi.Input[_builtins.str]] = None,
            platform_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            revocation_records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SigningProfileRevocationRecordArgs', 'SigningProfileRevocationRecordArgsDict']]]]] = None,
            signature_validity_period: Optional[pulumi.Input[Union['SigningProfileSignatureValidityPeriodArgs', 'SigningProfileSignatureValidityPeriodArgsDict']]] = None,
            signing_material: Optional[pulumi.Input[Union['SigningProfileSigningMaterialArgs', 'SigningProfileSigningMaterialArgsDict']]] = None,
            signing_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            version_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'SigningProfile':
        """
        Get an existing SigningProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) for the signing profile.
        :param pulumi.Input[_builtins.str] platform_display_name: A human-readable name for the signing platform associated with the signing profile.
        :param pulumi.Input[_builtins.str] platform_id: The ID of the platform that is used by the target signing profile.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SigningProfileRevocationRecordArgs', 'SigningProfileRevocationRecordArgsDict']]]] revocation_records: Revocation information for a signing profile. See `revocation_record` Block below for details.
        :param pulumi.Input[Union['SigningProfileSignatureValidityPeriodArgs', 'SigningProfileSignatureValidityPeriodArgsDict']] signature_validity_period: The validity period for a signing job. See `signature_validity_period` Block below for details.
        :param pulumi.Input[Union['SigningProfileSigningMaterialArgs', 'SigningProfileSigningMaterialArgsDict']] signing_material: The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] signing_parameters: Map of key-value pairs for signing. These can include any information that you want to use during signing.
        :param pulumi.Input[_builtins.str] status: The status of the target signing profile.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] version: The current version of the signing profile.
        :param pulumi.Input[_builtins.str] version_arn: The signing profile ARN, including the profile version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SigningProfileState.__new__(_SigningProfileState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["platform_display_name"] = platform_display_name
        __props__.__dict__["platform_id"] = platform_id
        __props__.__dict__["region"] = region
        __props__.__dict__["revocation_records"] = revocation_records
        __props__.__dict__["signature_validity_period"] = signature_validity_period
        __props__.__dict__["signing_material"] = signing_material
        __props__.__dict__["signing_parameters"] = signing_parameters
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["version"] = version
        __props__.__dict__["version_arn"] = version_arn
        return SigningProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the signing profile.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="platformDisplayName")
    def platform_display_name(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable name for the signing platform associated with the signing profile.
        """
        return pulumi.get(self, "platform_display_name")

    @_builtins.property
    @pulumi.getter(name="platformId")
    def platform_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the platform that is used by the target signing profile.
        """
        return pulumi.get(self, "platform_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="revocationRecords")
    def revocation_records(self) -> pulumi.Output[Sequence['outputs.SigningProfileRevocationRecord']]:
        """
        Revocation information for a signing profile. See `revocation_record` Block below for details.
        """
        return pulumi.get(self, "revocation_records")

    @_builtins.property
    @pulumi.getter(name="signatureValidityPeriod")
    def signature_validity_period(self) -> pulumi.Output['outputs.SigningProfileSignatureValidityPeriod']:
        """
        The validity period for a signing job. See `signature_validity_period` Block below for details.
        """
        return pulumi.get(self, "signature_validity_period")

    @_builtins.property
    @pulumi.getter(name="signingMaterial")
    def signing_material(self) -> pulumi.Output['outputs.SigningProfileSigningMaterial']:
        """
        The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. See `signing_material` Block below for details.
        """
        return pulumi.get(self, "signing_material")

    @_builtins.property
    @pulumi.getter(name="signingParameters")
    def signing_parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of key-value pairs for signing. These can include any information that you want to use during signing.
        """
        return pulumi.get(self, "signing_parameters")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the target signing profile.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A list of tags associated with the signing profile. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The current version of the signing profile.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionArn")
    def version_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The signing profile ARN, including the profile version.
        """
        return pulumi.get(self, "version_arn")

