# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import iam
from .. import iam as _iam
from ._inputs import *

__all__ = ['TopicPolicyArgs', 'TopicPolicy']

@pulumi.input_type
class TopicPolicyArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[_builtins.str],
                 policy: pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TopicPolicy resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the SNS topic
        :param pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']] policy: The fully-formed AWS policy as JSON.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "policy", policy)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the SNS topic
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]:
        """
        The fully-formed AWS policy as JSON.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TopicPolicyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TopicPolicy resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the SNS topic
        :param pulumi.Input[_builtins.str] owner: The AWS Account ID of the SNS topic owner
        :param pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']] policy: The fully-formed AWS policy as JSON.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the SNS topic
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS Account ID of the SNS topic owner
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]]:
        """
        The fully-formed AWS policy as JSON.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:sns/topicPolicy:TopicPolicy")
class TopicPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an SNS topic policy resource

        > **NOTE:** If a Principal is specified as just an AWS account ID rather than an ARN, AWS silently converts it to the ARN for the root user, causing future deployments to differ. To avoid this problem, just specify the full ARN, e.g. `arn:aws:iam::123456789012:root`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.sns.Topic("test", name="my-topic-with-policy")
        sns_topic_policy = test.arn.apply(lambda arn: aws.iam.get_policy_document_output(policy_id="__default_policy_ID",
            statements=[{
                "actions": [
                    "SNS:Subscribe",
                    "SNS:SetTopicAttributes",
                    "SNS:RemovePermission",
                    "SNS:Receive",
                    "SNS:Publish",
                    "SNS:ListSubscriptionsByTopic",
                    "SNS:GetTopicAttributes",
                    "SNS:DeleteTopic",
                    "SNS:AddPermission",
                ],
                "conditions": [{
                    "test": "StringEquals",
                    "variable": "AWS:SourceOwner",
                    "values": [account_id],
                }],
                "effect": "Allow",
                "principals": [{
                    "type": "AWS",
                    "identifiers": ["*"],
                }],
                "resources": [arn],
                "sid": "__default_statement_ID",
            }]))
        default = aws.sns.TopicPolicy("default",
            arn=test.arn,
            policy=sns_topic_policy.json)
        ```

        ## Import

        Using `pulumi import`, import SNS Topic Policy using the topic ARN. For example:

        ```sh
        $ pulumi import aws:sns/topicPolicy:TopicPolicy user_updates arn:aws:sns:us-west-2:123456789012:my-topic
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the SNS topic
        :param pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]] policy: The fully-formed AWS policy as JSON.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TopicPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an SNS topic policy resource

        > **NOTE:** If a Principal is specified as just an AWS account ID rather than an ARN, AWS silently converts it to the ARN for the root user, causing future deployments to differ. To avoid this problem, just specify the full ARN, e.g. `arn:aws:iam::123456789012:root`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.sns.Topic("test", name="my-topic-with-policy")
        sns_topic_policy = test.arn.apply(lambda arn: aws.iam.get_policy_document_output(policy_id="__default_policy_ID",
            statements=[{
                "actions": [
                    "SNS:Subscribe",
                    "SNS:SetTopicAttributes",
                    "SNS:RemovePermission",
                    "SNS:Receive",
                    "SNS:Publish",
                    "SNS:ListSubscriptionsByTopic",
                    "SNS:GetTopicAttributes",
                    "SNS:DeleteTopic",
                    "SNS:AddPermission",
                ],
                "conditions": [{
                    "test": "StringEquals",
                    "variable": "AWS:SourceOwner",
                    "values": [account_id],
                }],
                "effect": "Allow",
                "principals": [{
                    "type": "AWS",
                    "identifiers": ["*"],
                }],
                "resources": [arn],
                "sid": "__default_statement_ID",
            }]))
        default = aws.sns.TopicPolicy("default",
            arn=test.arn,
            policy=sns_topic_policy.json)
        ```

        ## Import

        Using `pulumi import`, import SNS Topic Policy using the topic ARN. For example:

        ```sh
        $ pulumi import aws:sns/topicPolicy:TopicPolicy user_updates arn:aws:sns:us-west-2:123456789012:my-topic
        ```

        :param str resource_name: The name of the resource.
        :param TopicPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicPolicyArgs.__new__(TopicPolicyArgs)

            if arn is None and not opts.urn:
                raise TypeError("Missing required property 'arn'")
            __props__.__dict__["arn"] = arn
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            __props__.__dict__["region"] = region
            __props__.__dict__["owner"] = None
        super(TopicPolicy, __self__).__init__(
            'aws:sns/topicPolicy:TopicPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            policy: Optional[pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'TopicPolicy':
        """
        Get an existing TopicPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the SNS topic
        :param pulumi.Input[_builtins.str] owner: The AWS Account ID of the SNS topic owner
        :param pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]] policy: The fully-formed AWS policy as JSON.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicPolicyState.__new__(_TopicPolicyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["owner"] = owner
        __props__.__dict__["policy"] = policy
        __props__.__dict__["region"] = region
        return TopicPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the SNS topic
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS Account ID of the SNS topic owner
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        The fully-formed AWS policy as JSON.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

