# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TopicSubscriptionArgs', 'TopicSubscription']

@pulumi.input_type
class TopicSubscriptionArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 topic: pulumi.Input[_builtins.str],
                 confirmation_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 delivery_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_auto_confirms: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_policy_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 raw_message_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_role_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TopicSubscription resource.
        :param pulumi.Input[_builtins.str] endpoint: Endpoint to send data to. The contents vary with the protocol. See details below.
        :param pulumi.Input[_builtins.str] protocol: Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
        :param pulumi.Input[_builtins.str] topic: ARN of the SNS topic to subscribe to.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] confirmation_timeout_in_minutes: Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
        :param pulumi.Input[_builtins.str] delivery_policy: JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
        :param pulumi.Input[_builtins.bool] endpoint_auto_confirms: Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
        :param pulumi.Input[_builtins.str] filter_policy: JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
        :param pulumi.Input[_builtins.str] filter_policy_scope: Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
        :param pulumi.Input[_builtins.bool] raw_message_delivery: Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
        :param pulumi.Input[_builtins.str] redrive_policy: JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replay_policy: JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
        :param pulumi.Input[_builtins.str] subscription_role_arn: ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "topic", topic)
        if confirmation_timeout_in_minutes is not None:
            pulumi.set(__self__, "confirmation_timeout_in_minutes", confirmation_timeout_in_minutes)
        if delivery_policy is not None:
            pulumi.set(__self__, "delivery_policy", delivery_policy)
        if endpoint_auto_confirms is not None:
            pulumi.set(__self__, "endpoint_auto_confirms", endpoint_auto_confirms)
        if filter_policy is not None:
            pulumi.set(__self__, "filter_policy", filter_policy)
        if filter_policy_scope is not None:
            pulumi.set(__self__, "filter_policy_scope", filter_policy_scope)
        if raw_message_delivery is not None:
            pulumi.set(__self__, "raw_message_delivery", raw_message_delivery)
        if redrive_policy is not None:
            pulumi.set(__self__, "redrive_policy", redrive_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replay_policy is not None:
            pulumi.set(__self__, "replay_policy", replay_policy)
        if subscription_role_arn is not None:
            pulumi.set(__self__, "subscription_role_arn", subscription_role_arn)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        Endpoint to send data to. The contents vary with the protocol. See details below.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the SNS topic to subscribe to.

        The following arguments are optional:
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic", value)

    @_builtins.property
    @pulumi.getter(name="confirmationTimeoutInMinutes")
    def confirmation_timeout_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
        """
        return pulumi.get(self, "confirmation_timeout_in_minutes")

    @confirmation_timeout_in_minutes.setter
    def confirmation_timeout_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "confirmation_timeout_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
        """
        return pulumi.get(self, "delivery_policy")

    @delivery_policy.setter
    def delivery_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_policy", value)

    @_builtins.property
    @pulumi.getter(name="endpointAutoConfirms")
    def endpoint_auto_confirms(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
        """
        return pulumi.get(self, "endpoint_auto_confirms")

    @endpoint_auto_confirms.setter
    def endpoint_auto_confirms(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "endpoint_auto_confirms", value)

    @_builtins.property
    @pulumi.getter(name="filterPolicy")
    def filter_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
        """
        return pulumi.get(self, "filter_policy")

    @filter_policy.setter
    def filter_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_policy", value)

    @_builtins.property
    @pulumi.getter(name="filterPolicyScope")
    def filter_policy_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
        """
        return pulumi.get(self, "filter_policy_scope")

    @filter_policy_scope.setter
    def filter_policy_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_policy_scope", value)

    @_builtins.property
    @pulumi.getter(name="rawMessageDelivery")
    def raw_message_delivery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
        """
        return pulumi.get(self, "raw_message_delivery")

    @raw_message_delivery.setter
    def raw_message_delivery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "raw_message_delivery", value)

    @_builtins.property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
        """
        return pulumi.get(self, "redrive_policy")

    @redrive_policy.setter
    def redrive_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redrive_policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replayPolicy")
    def replay_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
        """
        return pulumi.get(self, "replay_policy")

    @replay_policy.setter
    def replay_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replay_policy", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionRoleArn")
    def subscription_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
        """
        return pulumi.get(self, "subscription_role_arn")

    @subscription_role_arn.setter
    def subscription_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_role_arn", value)


@pulumi.input_type
class _TopicSubscriptionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 confirmation_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 confirmation_was_authenticated: Optional[pulumi.Input[_builtins.bool]] = None,
                 delivery_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_auto_confirms: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_policy_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_confirmation: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 raw_message_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TopicSubscription resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the subscription.
        :param pulumi.Input[_builtins.int] confirmation_timeout_in_minutes: Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
        :param pulumi.Input[_builtins.bool] confirmation_was_authenticated: Whether the subscription confirmation request was authenticated.
        :param pulumi.Input[_builtins.str] delivery_policy: JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
        :param pulumi.Input[_builtins.str] endpoint: Endpoint to send data to. The contents vary with the protocol. See details below.
        :param pulumi.Input[_builtins.bool] endpoint_auto_confirms: Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
        :param pulumi.Input[_builtins.str] filter_policy: JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
        :param pulumi.Input[_builtins.str] filter_policy_scope: Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
        :param pulumi.Input[_builtins.str] owner_id: AWS account ID of the subscription's owner.
        :param pulumi.Input[_builtins.bool] pending_confirmation: Whether the subscription has not been confirmed.
        :param pulumi.Input[_builtins.str] protocol: Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
        :param pulumi.Input[_builtins.bool] raw_message_delivery: Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
        :param pulumi.Input[_builtins.str] redrive_policy: JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replay_policy: JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
        :param pulumi.Input[_builtins.str] subscription_role_arn: ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
        :param pulumi.Input[_builtins.str] topic: ARN of the SNS topic to subscribe to.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if confirmation_timeout_in_minutes is not None:
            pulumi.set(__self__, "confirmation_timeout_in_minutes", confirmation_timeout_in_minutes)
        if confirmation_was_authenticated is not None:
            pulumi.set(__self__, "confirmation_was_authenticated", confirmation_was_authenticated)
        if delivery_policy is not None:
            pulumi.set(__self__, "delivery_policy", delivery_policy)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if endpoint_auto_confirms is not None:
            pulumi.set(__self__, "endpoint_auto_confirms", endpoint_auto_confirms)
        if filter_policy is not None:
            pulumi.set(__self__, "filter_policy", filter_policy)
        if filter_policy_scope is not None:
            pulumi.set(__self__, "filter_policy_scope", filter_policy_scope)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if pending_confirmation is not None:
            pulumi.set(__self__, "pending_confirmation", pending_confirmation)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if raw_message_delivery is not None:
            pulumi.set(__self__, "raw_message_delivery", raw_message_delivery)
        if redrive_policy is not None:
            pulumi.set(__self__, "redrive_policy", redrive_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replay_policy is not None:
            pulumi.set(__self__, "replay_policy", replay_policy)
        if subscription_role_arn is not None:
            pulumi.set(__self__, "subscription_role_arn", subscription_role_arn)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the subscription.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="confirmationTimeoutInMinutes")
    def confirmation_timeout_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
        """
        return pulumi.get(self, "confirmation_timeout_in_minutes")

    @confirmation_timeout_in_minutes.setter
    def confirmation_timeout_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "confirmation_timeout_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="confirmationWasAuthenticated")
    def confirmation_was_authenticated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the subscription confirmation request was authenticated.
        """
        return pulumi.get(self, "confirmation_was_authenticated")

    @confirmation_was_authenticated.setter
    def confirmation_was_authenticated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "confirmation_was_authenticated", value)

    @_builtins.property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
        """
        return pulumi.get(self, "delivery_policy")

    @delivery_policy.setter
    def delivery_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_policy", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Endpoint to send data to. The contents vary with the protocol. See details below.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="endpointAutoConfirms")
    def endpoint_auto_confirms(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
        """
        return pulumi.get(self, "endpoint_auto_confirms")

    @endpoint_auto_confirms.setter
    def endpoint_auto_confirms(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "endpoint_auto_confirms", value)

    @_builtins.property
    @pulumi.getter(name="filterPolicy")
    def filter_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
        """
        return pulumi.get(self, "filter_policy")

    @filter_policy.setter
    def filter_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_policy", value)

    @_builtins.property
    @pulumi.getter(name="filterPolicyScope")
    def filter_policy_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
        """
        return pulumi.get(self, "filter_policy_scope")

    @filter_policy_scope.setter
    def filter_policy_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter_policy_scope", value)

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS account ID of the subscription's owner.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @_builtins.property
    @pulumi.getter(name="pendingConfirmation")
    def pending_confirmation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the subscription has not been confirmed.
        """
        return pulumi.get(self, "pending_confirmation")

    @pending_confirmation.setter
    def pending_confirmation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pending_confirmation", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="rawMessageDelivery")
    def raw_message_delivery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
        """
        return pulumi.get(self, "raw_message_delivery")

    @raw_message_delivery.setter
    def raw_message_delivery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "raw_message_delivery", value)

    @_builtins.property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
        """
        return pulumi.get(self, "redrive_policy")

    @redrive_policy.setter
    def redrive_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redrive_policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replayPolicy")
    def replay_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
        """
        return pulumi.get(self, "replay_policy")

    @replay_policy.setter
    def replay_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replay_policy", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionRoleArn")
    def subscription_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
        """
        return pulumi.get(self, "subscription_role_arn")

    @subscription_role_arn.setter
    def subscription_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the SNS topic to subscribe to.

        The following arguments are optional:
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic", value)


@pulumi.type_token("aws:sns/topicSubscription:TopicSubscription")
class TopicSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confirmation_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 delivery_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_auto_confirms: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_policy_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 raw_message_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource for subscribing to SNS topics. Requires that an SNS topic exist for the subscription to attach to. This resource allows you to automatically place messages sent to SNS topics in SQS queues, send them as HTTP(S) POST requests to a given endpoint, send SMS messages, or notify devices / applications. The most likely use case for provider users will probably be SQS queues.

        > **NOTE:** If the SNS topic and SQS queue are in different AWS regions, the `sns.TopicSubscription` must use an AWS provider that is in the same region as the SNS topic. If the `sns.TopicSubscription` uses a provider with a different region than the SNS topic, this provider will fail to create the subscription.

        > **NOTE:** Setup of cross-account subscriptions from SNS topics to SQS queues requires the provider to have access to BOTH accounts.

        > **NOTE:** If an SNS topic and SQS queue are in different AWS accounts but the same region, the `sns.TopicSubscription` must use the AWS provider for the account with the SQS queue. If `sns.TopicSubscription` uses a Provider with a different account than the SQS queue, this provider creates the subscription but does not keep state and tries to re-create the subscription at every `apply`.

        > **NOTE:** If an SNS topic and SQS queue are in different AWS accounts and different AWS regions, the subscription needs to be initiated from the account with the SQS queue but in the region of the SNS topic.

        > **NOTE:** You cannot unsubscribe to a subscription that is pending confirmation. If you use `email`, `email-json`, or `http`/`https` (without auto-confirmation enabled), until the subscription is confirmed (e.g., outside of this provider), AWS does not allow this provider to delete / unsubscribe the subscription. If you `destroy` an unconfirmed subscription, this provider will remove the subscription from its state but the subscription will still exist in AWS. However, if you delete an SNS topic, SNS [deletes all the subscriptions](https://docs.aws.amazon.com/sns/latest/dg/sns-delete-subscription-topic.html) associated with the topic. Also, you can import a subscription after confirmation and then have the capability to delete it.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("user_updates", name="user-updates-topic")
        sqs_queue_policy = aws.iam.get_policy_document_output(policy_id="arn:aws:sqs:us-west-2:123456789012:user_updates_queue/SQSDefaultPolicy",
            statements=[{
                "sid": "user_updates_sqs_target",
                "effect": "Allow",
                "principals": [{
                    "type": "Service",
                    "identifiers": ["sns.amazonaws.com"],
                }],
                "actions": ["SQS:SendMessage"],
                "resources": ["arn:aws:sqs:us-west-2:123456789012:user-updates-queue"],
                "conditions": [{
                    "test": "ArnEquals",
                    "variable": "aws:SourceArn",
                    "values": [user_updates.arn],
                }],
            }])
        user_updates_queue = aws.sqs.Queue("user_updates_queue",
            name="user-updates-queue",
            policy=sqs_queue_policy.json)
        user_updates_sqs_target = aws.sns.TopicSubscription("user_updates_sqs_target",
            topic=user_updates.arn,
            protocol="sqs",
            endpoint=user_updates_queue.arn)
        ```

        ### Example Cross-account Subscription

        You can subscribe SNS topics to SQS queues in different Amazon accounts and regions:

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        sns = config.get_object("sns")
        if sns is None:
            sns = {
                "account-id": "111111111111",
                "displayName": "example",
                "name": "example-sns-topic",
                "region": "us-west-1",
                "role-name": "service/service",
            }
        sqs = config.get_object("sqs")
        if sqs is None:
            sqs = {
                "account-id": "222222222222",
                "name": "example-sqs-queue",
                "region": "us-east-1",
                "role-name": "service/service",
            }
        sns_topic_policy = aws.iam.get_policy_document(policy_id="__default_policy_ID",
            statements=[
                {
                    "actions": [
                        "SNS:Subscribe",
                        "SNS:SetTopicAttributes",
                        "SNS:RemovePermission",
                        "SNS:Publish",
                        "SNS:ListSubscriptionsByTopic",
                        "SNS:GetTopicAttributes",
                        "SNS:DeleteTopic",
                        "SNS:AddPermission",
                    ],
                    "conditions": [{
                        "test": "StringEquals",
                        "variable": "AWS:SourceOwner",
                        "values": [sns["account-id"]],
                    }],
                    "effect": "Allow",
                    "principals": [{
                        "type": "AWS",
                        "identifiers": ["*"],
                    }],
                    "resources": [f"arn:aws:sns:{sns['region']}:{sns['account-id']}:{sns['name']}"],
                    "sid": "__default_statement_ID",
                },
                {
                    "actions": [
                        "SNS:Subscribe",
                        "SNS:Receive",
                    ],
                    "conditions": [{
                        "test": "StringLike",
                        "variable": "SNS:Endpoint",
                        "values": [f"arn:aws:sqs:{sqs['region']}:{sqs['account-id']}:{sqs['name']}"],
                    }],
                    "effect": "Allow",
                    "principals": [{
                        "type": "AWS",
                        "identifiers": ["*"],
                    }],
                    "resources": [f"arn:aws:sns:{sns['region']}:{sns['account-id']}:{sns['name']}"],
                    "sid": "__console_sub_0",
                },
            ])
        sqs_queue_policy = aws.iam.get_policy_document(policy_id=f"arn:aws:sqs:{sqs['region']}:{sqs['account-id']}:{sqs['name']}/SQSDefaultPolicy",
            statements=[{
                "sid": "example-sns-topic",
                "effect": "Allow",
                "principals": [{
                    "type": "AWS",
                    "identifiers": ["*"],
                }],
                "actions": ["SQS:SendMessage"],
                "resources": [f"arn:aws:sqs:{sqs['region']}:{sqs['account-id']}:{sqs['name']}"],
                "conditions": [{
                    "test": "ArnEquals",
                    "variable": "aws:SourceArn",
                    "values": [f"arn:aws:sns:{sns['region']}:{sns['account-id']}:{sns['name']}"],
                }],
            }])
        sns_topic = aws.sns.Topic("sns_topic",
            name=sns["name"],
            display_name=sns["display_name"],
            policy=sns_topic_policy.json)
        sqs_queue = aws.sqs.Queue("sqs_queue",
            name=sqs["name"],
            policy=sqs_queue_policy.json)
        sns_topic_topic_subscription = aws.sns.TopicSubscription("sns_topic",
            topic=sns_topic.arn,
            protocol="sqs",
            endpoint=sqs_queue.arn)
        ```

        ### Example with Delivery Policy

        This example demonstrates how to define a `delivery_policy` for an HTTPS subscription. Unlike the `sns.Topic` resource, the `delivery_policy` for `sns.TopicSubscription` should not be wrapped in an `"http"` object.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_with_delivery_policy = aws.sns.TopicSubscription("example_with_delivery_policy",
            topic="arn:aws:sns:us-west-2:123456789012:my-topic",
            protocol="https",
            endpoint="https://example.com/endpoint",
            raw_message_delivery=True,
            delivery_policy=\"\"\"{
          "healthyRetryPolicy": {
            "minDelayTarget": 20,
            "maxDelayTarget": 20,
            "numRetries": 3,
            "numMaxDelayRetries": 0,
            "numNoDelayRetries": 0,
            "numMinDelayRetries": 0,
            "backoffFunction": "linear"
          },
          "sicklyRetryPolicy": null,
          "throttlePolicy": null,
          "requestPolicy": {
            "headerContentType": "text/plain; application/json"
          },
          "guaranteed": false
        }
        \"\"\")
        ```

        ## Import

        Using `pulumi import`, import SNS Topic Subscriptions using the subscription `arn`. For example:

        ```sh
        $ pulumi import aws:sns/topicSubscription:TopicSubscription user_updates_sqs_target arn:aws:sns:us-west-2:123456789012:my-topic:8a21d249-4329-4871-acc6-7be709c6ea7f
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] confirmation_timeout_in_minutes: Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
        :param pulumi.Input[_builtins.str] delivery_policy: JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
        :param pulumi.Input[_builtins.str] endpoint: Endpoint to send data to. The contents vary with the protocol. See details below.
        :param pulumi.Input[_builtins.bool] endpoint_auto_confirms: Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
        :param pulumi.Input[_builtins.str] filter_policy: JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
        :param pulumi.Input[_builtins.str] filter_policy_scope: Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
        :param pulumi.Input[_builtins.str] protocol: Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
        :param pulumi.Input[_builtins.bool] raw_message_delivery: Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
        :param pulumi.Input[_builtins.str] redrive_policy: JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replay_policy: JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
        :param pulumi.Input[_builtins.str] subscription_role_arn: ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
        :param pulumi.Input[_builtins.str] topic: ARN of the SNS topic to subscribe to.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TopicSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for subscribing to SNS topics. Requires that an SNS topic exist for the subscription to attach to. This resource allows you to automatically place messages sent to SNS topics in SQS queues, send them as HTTP(S) POST requests to a given endpoint, send SMS messages, or notify devices / applications. The most likely use case for provider users will probably be SQS queues.

        > **NOTE:** If the SNS topic and SQS queue are in different AWS regions, the `sns.TopicSubscription` must use an AWS provider that is in the same region as the SNS topic. If the `sns.TopicSubscription` uses a provider with a different region than the SNS topic, this provider will fail to create the subscription.

        > **NOTE:** Setup of cross-account subscriptions from SNS topics to SQS queues requires the provider to have access to BOTH accounts.

        > **NOTE:** If an SNS topic and SQS queue are in different AWS accounts but the same region, the `sns.TopicSubscription` must use the AWS provider for the account with the SQS queue. If `sns.TopicSubscription` uses a Provider with a different account than the SQS queue, this provider creates the subscription but does not keep state and tries to re-create the subscription at every `apply`.

        > **NOTE:** If an SNS topic and SQS queue are in different AWS accounts and different AWS regions, the subscription needs to be initiated from the account with the SQS queue but in the region of the SNS topic.

        > **NOTE:** You cannot unsubscribe to a subscription that is pending confirmation. If you use `email`, `email-json`, or `http`/`https` (without auto-confirmation enabled), until the subscription is confirmed (e.g., outside of this provider), AWS does not allow this provider to delete / unsubscribe the subscription. If you `destroy` an unconfirmed subscription, this provider will remove the subscription from its state but the subscription will still exist in AWS. However, if you delete an SNS topic, SNS [deletes all the subscriptions](https://docs.aws.amazon.com/sns/latest/dg/sns-delete-subscription-topic.html) associated with the topic. Also, you can import a subscription after confirmation and then have the capability to delete it.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("user_updates", name="user-updates-topic")
        sqs_queue_policy = aws.iam.get_policy_document_output(policy_id="arn:aws:sqs:us-west-2:123456789012:user_updates_queue/SQSDefaultPolicy",
            statements=[{
                "sid": "user_updates_sqs_target",
                "effect": "Allow",
                "principals": [{
                    "type": "Service",
                    "identifiers": ["sns.amazonaws.com"],
                }],
                "actions": ["SQS:SendMessage"],
                "resources": ["arn:aws:sqs:us-west-2:123456789012:user-updates-queue"],
                "conditions": [{
                    "test": "ArnEquals",
                    "variable": "aws:SourceArn",
                    "values": [user_updates.arn],
                }],
            }])
        user_updates_queue = aws.sqs.Queue("user_updates_queue",
            name="user-updates-queue",
            policy=sqs_queue_policy.json)
        user_updates_sqs_target = aws.sns.TopicSubscription("user_updates_sqs_target",
            topic=user_updates.arn,
            protocol="sqs",
            endpoint=user_updates_queue.arn)
        ```

        ### Example Cross-account Subscription

        You can subscribe SNS topics to SQS queues in different Amazon accounts and regions:

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        sns = config.get_object("sns")
        if sns is None:
            sns = {
                "account-id": "111111111111",
                "displayName": "example",
                "name": "example-sns-topic",
                "region": "us-west-1",
                "role-name": "service/service",
            }
        sqs = config.get_object("sqs")
        if sqs is None:
            sqs = {
                "account-id": "222222222222",
                "name": "example-sqs-queue",
                "region": "us-east-1",
                "role-name": "service/service",
            }
        sns_topic_policy = aws.iam.get_policy_document(policy_id="__default_policy_ID",
            statements=[
                {
                    "actions": [
                        "SNS:Subscribe",
                        "SNS:SetTopicAttributes",
                        "SNS:RemovePermission",
                        "SNS:Publish",
                        "SNS:ListSubscriptionsByTopic",
                        "SNS:GetTopicAttributes",
                        "SNS:DeleteTopic",
                        "SNS:AddPermission",
                    ],
                    "conditions": [{
                        "test": "StringEquals",
                        "variable": "AWS:SourceOwner",
                        "values": [sns["account-id"]],
                    }],
                    "effect": "Allow",
                    "principals": [{
                        "type": "AWS",
                        "identifiers": ["*"],
                    }],
                    "resources": [f"arn:aws:sns:{sns['region']}:{sns['account-id']}:{sns['name']}"],
                    "sid": "__default_statement_ID",
                },
                {
                    "actions": [
                        "SNS:Subscribe",
                        "SNS:Receive",
                    ],
                    "conditions": [{
                        "test": "StringLike",
                        "variable": "SNS:Endpoint",
                        "values": [f"arn:aws:sqs:{sqs['region']}:{sqs['account-id']}:{sqs['name']}"],
                    }],
                    "effect": "Allow",
                    "principals": [{
                        "type": "AWS",
                        "identifiers": ["*"],
                    }],
                    "resources": [f"arn:aws:sns:{sns['region']}:{sns['account-id']}:{sns['name']}"],
                    "sid": "__console_sub_0",
                },
            ])
        sqs_queue_policy = aws.iam.get_policy_document(policy_id=f"arn:aws:sqs:{sqs['region']}:{sqs['account-id']}:{sqs['name']}/SQSDefaultPolicy",
            statements=[{
                "sid": "example-sns-topic",
                "effect": "Allow",
                "principals": [{
                    "type": "AWS",
                    "identifiers": ["*"],
                }],
                "actions": ["SQS:SendMessage"],
                "resources": [f"arn:aws:sqs:{sqs['region']}:{sqs['account-id']}:{sqs['name']}"],
                "conditions": [{
                    "test": "ArnEquals",
                    "variable": "aws:SourceArn",
                    "values": [f"arn:aws:sns:{sns['region']}:{sns['account-id']}:{sns['name']}"],
                }],
            }])
        sns_topic = aws.sns.Topic("sns_topic",
            name=sns["name"],
            display_name=sns["display_name"],
            policy=sns_topic_policy.json)
        sqs_queue = aws.sqs.Queue("sqs_queue",
            name=sqs["name"],
            policy=sqs_queue_policy.json)
        sns_topic_topic_subscription = aws.sns.TopicSubscription("sns_topic",
            topic=sns_topic.arn,
            protocol="sqs",
            endpoint=sqs_queue.arn)
        ```

        ### Example with Delivery Policy

        This example demonstrates how to define a `delivery_policy` for an HTTPS subscription. Unlike the `sns.Topic` resource, the `delivery_policy` for `sns.TopicSubscription` should not be wrapped in an `"http"` object.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_with_delivery_policy = aws.sns.TopicSubscription("example_with_delivery_policy",
            topic="arn:aws:sns:us-west-2:123456789012:my-topic",
            protocol="https",
            endpoint="https://example.com/endpoint",
            raw_message_delivery=True,
            delivery_policy=\"\"\"{
          "healthyRetryPolicy": {
            "minDelayTarget": 20,
            "maxDelayTarget": 20,
            "numRetries": 3,
            "numMaxDelayRetries": 0,
            "numNoDelayRetries": 0,
            "numMinDelayRetries": 0,
            "backoffFunction": "linear"
          },
          "sicklyRetryPolicy": null,
          "throttlePolicy": null,
          "requestPolicy": {
            "headerContentType": "text/plain; application/json"
          },
          "guaranteed": false
        }
        \"\"\")
        ```

        ## Import

        Using `pulumi import`, import SNS Topic Subscriptions using the subscription `arn`. For example:

        ```sh
        $ pulumi import aws:sns/topicSubscription:TopicSubscription user_updates_sqs_target arn:aws:sns:us-west-2:123456789012:my-topic:8a21d249-4329-4871-acc6-7be709c6ea7f
        ```

        :param str resource_name: The name of the resource.
        :param TopicSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confirmation_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 delivery_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_auto_confirms: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_policy_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 raw_message_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicSubscriptionArgs.__new__(TopicSubscriptionArgs)

            __props__.__dict__["confirmation_timeout_in_minutes"] = confirmation_timeout_in_minutes
            __props__.__dict__["delivery_policy"] = delivery_policy
            if endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint'")
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["endpoint_auto_confirms"] = endpoint_auto_confirms
            __props__.__dict__["filter_policy"] = filter_policy
            __props__.__dict__["filter_policy_scope"] = filter_policy_scope
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["raw_message_delivery"] = raw_message_delivery
            __props__.__dict__["redrive_policy"] = redrive_policy
            __props__.__dict__["region"] = region
            __props__.__dict__["replay_policy"] = replay_policy
            __props__.__dict__["subscription_role_arn"] = subscription_role_arn
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__.__dict__["topic"] = topic
            __props__.__dict__["arn"] = None
            __props__.__dict__["confirmation_was_authenticated"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["pending_confirmation"] = None
        super(TopicSubscription, __self__).__init__(
            'aws:sns/topicSubscription:TopicSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            confirmation_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            confirmation_was_authenticated: Optional[pulumi.Input[_builtins.bool]] = None,
            delivery_policy: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_auto_confirms: Optional[pulumi.Input[_builtins.bool]] = None,
            filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
            filter_policy_scope: Optional[pulumi.Input[_builtins.str]] = None,
            owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            pending_confirmation: Optional[pulumi.Input[_builtins.bool]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            raw_message_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
            redrive_policy: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replay_policy: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            topic: Optional[pulumi.Input[_builtins.str]] = None) -> 'TopicSubscription':
        """
        Get an existing TopicSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the subscription.
        :param pulumi.Input[_builtins.int] confirmation_timeout_in_minutes: Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
        :param pulumi.Input[_builtins.bool] confirmation_was_authenticated: Whether the subscription confirmation request was authenticated.
        :param pulumi.Input[_builtins.str] delivery_policy: JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
        :param pulumi.Input[_builtins.str] endpoint: Endpoint to send data to. The contents vary with the protocol. See details below.
        :param pulumi.Input[_builtins.bool] endpoint_auto_confirms: Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
        :param pulumi.Input[_builtins.str] filter_policy: JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
        :param pulumi.Input[_builtins.str] filter_policy_scope: Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
        :param pulumi.Input[_builtins.str] owner_id: AWS account ID of the subscription's owner.
        :param pulumi.Input[_builtins.bool] pending_confirmation: Whether the subscription has not been confirmed.
        :param pulumi.Input[_builtins.str] protocol: Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
        :param pulumi.Input[_builtins.bool] raw_message_delivery: Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
        :param pulumi.Input[_builtins.str] redrive_policy: JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replay_policy: JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
        :param pulumi.Input[_builtins.str] subscription_role_arn: ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
        :param pulumi.Input[_builtins.str] topic: ARN of the SNS topic to subscribe to.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicSubscriptionState.__new__(_TopicSubscriptionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["confirmation_timeout_in_minutes"] = confirmation_timeout_in_minutes
        __props__.__dict__["confirmation_was_authenticated"] = confirmation_was_authenticated
        __props__.__dict__["delivery_policy"] = delivery_policy
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["endpoint_auto_confirms"] = endpoint_auto_confirms
        __props__.__dict__["filter_policy"] = filter_policy
        __props__.__dict__["filter_policy_scope"] = filter_policy_scope
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["pending_confirmation"] = pending_confirmation
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["raw_message_delivery"] = raw_message_delivery
        __props__.__dict__["redrive_policy"] = redrive_policy
        __props__.__dict__["region"] = region
        __props__.__dict__["replay_policy"] = replay_policy
        __props__.__dict__["subscription_role_arn"] = subscription_role_arn
        __props__.__dict__["topic"] = topic
        return TopicSubscription(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the subscription.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="confirmationTimeoutInMinutes")
    def confirmation_timeout_in_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
        """
        return pulumi.get(self, "confirmation_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="confirmationWasAuthenticated")
    def confirmation_was_authenticated(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the subscription confirmation request was authenticated.
        """
        return pulumi.get(self, "confirmation_was_authenticated")

    @_builtins.property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
        """
        return pulumi.get(self, "delivery_policy")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Endpoint to send data to. The contents vary with the protocol. See details below.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="endpointAutoConfirms")
    def endpoint_auto_confirms(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
        """
        return pulumi.get(self, "endpoint_auto_confirms")

    @_builtins.property
    @pulumi.getter(name="filterPolicy")
    def filter_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
        """
        return pulumi.get(self, "filter_policy")

    @_builtins.property
    @pulumi.getter(name="filterPolicyScope")
    def filter_policy_scope(self) -> pulumi.Output[_builtins.str]:
        """
        Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
        """
        return pulumi.get(self, "filter_policy_scope")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[_builtins.str]:
        """
        AWS account ID of the subscription's owner.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter(name="pendingConfirmation")
    def pending_confirmation(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the subscription has not been confirmed.
        """
        return pulumi.get(self, "pending_confirmation")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="rawMessageDelivery")
    def raw_message_delivery(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
        """
        return pulumi.get(self, "raw_message_delivery")

    @_builtins.property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
        """
        return pulumi.get(self, "redrive_policy")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replayPolicy")
    def replay_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
        """
        return pulumi.get(self, "replay_policy")

    @_builtins.property
    @pulumi.getter(name="subscriptionRoleArn")
    def subscription_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
        """
        return pulumi.get(self, "subscription_role_arn")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the SNS topic to subscribe to.

        The following arguments are optional:
        """
        return pulumi.get(self, "topic")

