# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContactsRotationArgs', 'ContactsRotation']

@pulumi.input_type
class ContactsRotationArgs:
    def __init__(__self__, *,
                 contact_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 time_zone_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence: Optional[pulumi.Input['ContactsRotationRecurrenceArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ContactsRotation resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_ids: Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
        :param pulumi.Input[_builtins.str] time_zone_id: The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
        :param pulumi.Input[_builtins.str] name: The name for the rotation.
        :param pulumi.Input['ContactsRotationRecurrenceArgs'] recurrence: Information about when an on-call rotation is in effect and how long the rotation period lasts. Exactly one of either `daily_settings`, `monthly_settings`, or `weekly_settings` must be populated. See Recurrence for more details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] start_time: The date and time, in RFC 3339 format, that the rotation goes into effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "contact_ids", contact_ids)
        pulumi.set(__self__, "time_zone_id", time_zone_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="contactIds")
    def contact_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
        """
        return pulumi.get(self, "contact_ids")

    @contact_ids.setter
    def contact_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "contact_ids", value)

    @_builtins.property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
        """
        return pulumi.get(self, "time_zone_id")

    @time_zone_id.setter
    def time_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_zone_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the rotation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['ContactsRotationRecurrenceArgs']]:
        """
        Information about when an on-call rotation is in effect and how long the rotation period lasts. Exactly one of either `daily_settings`, `monthly_settings`, or `weekly_settings` must be populated. See Recurrence for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['ContactsRotationRecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time, in RFC 3339 format, that the rotation goes into effect.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ContactsRotationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 contact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence: Optional[pulumi.Input['ContactsRotationRecurrenceArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContactsRotation resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the rotation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_ids: Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
        :param pulumi.Input[_builtins.str] name: The name for the rotation.
        :param pulumi.Input['ContactsRotationRecurrenceArgs'] recurrence: Information about when an on-call rotation is in effect and how long the rotation period lasts. Exactly one of either `daily_settings`, `monthly_settings`, or `weekly_settings` must be populated. See Recurrence for more details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] start_time: The date and time, in RFC 3339 format, that the rotation goes into effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] time_zone_id: The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if contact_ids is not None:
            pulumi.set(__self__, "contact_ids", contact_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if time_zone_id is not None:
            pulumi.set(__self__, "time_zone_id", time_zone_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the rotation.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="contactIds")
    def contact_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
        """
        return pulumi.get(self, "contact_ids")

    @contact_ids.setter
    def contact_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "contact_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the rotation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['ContactsRotationRecurrenceArgs']]:
        """
        Information about when an on-call rotation is in effect and how long the rotation period lasts. Exactly one of either `daily_settings`, `monthly_settings`, or `weekly_settings` must be populated. See Recurrence for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['ContactsRotationRecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time, in RFC 3339 format, that the rotation goes into effect.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
        """
        return pulumi.get(self, "time_zone_id")

    @time_zone_id.setter
    def time_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone_id", value)


@pulumi.type_token("aws:ssm/contactsRotation:ContactsRotation")
class ContactsRotation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence: Optional[pulumi.Input[Union['ContactsRotationRecurrenceArgs', 'ContactsRotationRecurrenceArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.ContactsRotation("example",
            contact_ids=[example_aws_ssmcontacts_contact["arn"]],
            name="rotation",
            recurrence={
                "number_of_on_calls": 1,
                "recurrence_multiplier": 1,
                "daily_settings": [{
                    "hour_of_day": 9,
                    "minute_of_hour": 0,
                }],
            },
            time_zone_id="Australia/Sydney",
            opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
        ```

        ### Usage with Weekly Settings and Shift Coverages Fields

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.ContactsRotation("example",
            contact_ids=[example_aws_ssmcontacts_contact["arn"]],
            name="rotation",
            recurrence={
                "number_of_on_calls": 1,
                "recurrence_multiplier": 1,
                "weekly_settings": [
                    {
                        "day_of_week": "WED",
                        "hand_off_time": {
                            "hour_of_day": 4,
                            "minute_of_hour": 25,
                        },
                    },
                    {
                        "day_of_week": "FRI",
                        "hand_off_time": {
                            "hour_of_day": 15,
                            "minute_of_hour": 57,
                        },
                    },
                ],
                "shift_coverages": [{
                    "map_block_key": "MON",
                    "coverage_times": [{
                        "start": {
                            "hour_of_day": 1,
                            "minute_of_hour": 0,
                        },
                        "end": {
                            "hour_of_day": 23,
                            "minute_of_hour": 0,
                        },
                    }],
                }],
            },
            start_time="2023-07-20T02:21:49+00:00",
            time_zone_id="Australia/Sydney",
            tags={
                "key1": "tag1",
                "key2": "tag2",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
        ```

        ### Usage with Monthly Settings Fields

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.ContactsRotation("example",
            contact_ids=[example_aws_ssmcontacts_contact["arn"]],
            name="rotation",
            recurrence={
                "number_of_on_calls": 1,
                "recurrence_multiplier": 1,
                "monthly_settings": [
                    {
                        "day_of_month": 20,
                        "hand_off_time": {
                            "hour_of_day": 8,
                            "minute_of_hour": 0,
                        },
                    },
                    {
                        "day_of_month": 13,
                        "hand_off_time": {
                            "hour_of_day": 12,
                            "minute_of_hour": 34,
                        },
                    },
                ],
            },
            time_zone_id="Australia/Sydney",
            opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
        ```

        ## Import

        Using `pulumi import`, import CodeGuru Profiler Profiling Group using the `arn`. For example:

        ```sh
        $ pulumi import aws:ssm/contactsRotation:ContactsRotation example arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_ids: Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
        :param pulumi.Input[_builtins.str] name: The name for the rotation.
        :param pulumi.Input[Union['ContactsRotationRecurrenceArgs', 'ContactsRotationRecurrenceArgsDict']] recurrence: Information about when an on-call rotation is in effect and how long the rotation period lasts. Exactly one of either `daily_settings`, `monthly_settings`, or `weekly_settings` must be populated. See Recurrence for more details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] start_time: The date and time, in RFC 3339 format, that the rotation goes into effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] time_zone_id: The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContactsRotationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.ContactsRotation("example",
            contact_ids=[example_aws_ssmcontacts_contact["arn"]],
            name="rotation",
            recurrence={
                "number_of_on_calls": 1,
                "recurrence_multiplier": 1,
                "daily_settings": [{
                    "hour_of_day": 9,
                    "minute_of_hour": 0,
                }],
            },
            time_zone_id="Australia/Sydney",
            opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
        ```

        ### Usage with Weekly Settings and Shift Coverages Fields

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.ContactsRotation("example",
            contact_ids=[example_aws_ssmcontacts_contact["arn"]],
            name="rotation",
            recurrence={
                "number_of_on_calls": 1,
                "recurrence_multiplier": 1,
                "weekly_settings": [
                    {
                        "day_of_week": "WED",
                        "hand_off_time": {
                            "hour_of_day": 4,
                            "minute_of_hour": 25,
                        },
                    },
                    {
                        "day_of_week": "FRI",
                        "hand_off_time": {
                            "hour_of_day": 15,
                            "minute_of_hour": 57,
                        },
                    },
                ],
                "shift_coverages": [{
                    "map_block_key": "MON",
                    "coverage_times": [{
                        "start": {
                            "hour_of_day": 1,
                            "minute_of_hour": 0,
                        },
                        "end": {
                            "hour_of_day": 23,
                            "minute_of_hour": 0,
                        },
                    }],
                }],
            },
            start_time="2023-07-20T02:21:49+00:00",
            time_zone_id="Australia/Sydney",
            tags={
                "key1": "tag1",
                "key2": "tag2",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
        ```

        ### Usage with Monthly Settings Fields

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.ContactsRotation("example",
            contact_ids=[example_aws_ssmcontacts_contact["arn"]],
            name="rotation",
            recurrence={
                "number_of_on_calls": 1,
                "recurrence_multiplier": 1,
                "monthly_settings": [
                    {
                        "day_of_month": 20,
                        "hand_off_time": {
                            "hour_of_day": 8,
                            "minute_of_hour": 0,
                        },
                    },
                    {
                        "day_of_month": 13,
                        "hand_off_time": {
                            "hour_of_day": 12,
                            "minute_of_hour": 34,
                        },
                    },
                ],
            },
            time_zone_id="Australia/Sydney",
            opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
        ```

        ## Import

        Using `pulumi import`, import CodeGuru Profiler Profiling Group using the `arn`. For example:

        ```sh
        $ pulumi import aws:ssm/contactsRotation:ContactsRotation example arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example
        ```

        :param str resource_name: The name of the resource.
        :param ContactsRotationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContactsRotationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence: Optional[pulumi.Input[Union['ContactsRotationRecurrenceArgs', 'ContactsRotationRecurrenceArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContactsRotationArgs.__new__(ContactsRotationArgs)

            if contact_ids is None and not opts.urn:
                raise TypeError("Missing required property 'contact_ids'")
            __props__.__dict__["contact_ids"] = contact_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["recurrence"] = recurrence
            __props__.__dict__["region"] = region
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["tags"] = tags
            if time_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone_id'")
            __props__.__dict__["time_zone_id"] = time_zone_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(ContactsRotation, __self__).__init__(
            'aws:ssm/contactsRotation:ContactsRotation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            contact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            recurrence: Optional[pulumi.Input[Union['ContactsRotationRecurrenceArgs', 'ContactsRotationRecurrenceArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ContactsRotation':
        """
        Get an existing ContactsRotation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the rotation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_ids: Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
        :param pulumi.Input[_builtins.str] name: The name for the rotation.
        :param pulumi.Input[Union['ContactsRotationRecurrenceArgs', 'ContactsRotationRecurrenceArgsDict']] recurrence: Information about when an on-call rotation is in effect and how long the rotation period lasts. Exactly one of either `daily_settings`, `monthly_settings`, or `weekly_settings` must be populated. See Recurrence for more details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] start_time: The date and time, in RFC 3339 format, that the rotation goes into effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] time_zone_id: The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContactsRotationState.__new__(_ContactsRotationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["contact_ids"] = contact_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["recurrence"] = recurrence
        __props__.__dict__["region"] = region
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["time_zone_id"] = time_zone_id
        return ContactsRotation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the rotation.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="contactIds")
    def contact_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
        """
        return pulumi.get(self, "contact_ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the rotation.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> pulumi.Output[Optional['outputs.ContactsRotationRecurrence']]:
        """
        Information about when an on-call rotation is in effect and how long the rotation period lasts. Exactly one of either `daily_settings`, `monthly_settings`, or `weekly_settings` must be populated. See Recurrence for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "recurrence")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The date and time, in RFC 3339 format, that the rotation goes into effect.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
        """
        return pulumi.get(self, "time_zone_id")

