# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetReplicationSetResult',
    'AwaitableGetReplicationSetResult',
    'get_replication_set',
    'get_replication_set_output',
]

@pulumi.output_type
class GetReplicationSetResult:
    """
    A collection of values returned by getReplicationSet.
    """
    def __init__(__self__, arn=None, created_by=None, deletion_protected=None, id=None, last_modified_by=None, region=None, regions=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if deletion_protected and not isinstance(deletion_protected, bool):
            raise TypeError("Expected argument 'deletion_protected' to be a bool")
        pulumi.set(__self__, "deletion_protected", deletion_protected)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified_by and not isinstance(last_modified_by, str):
            raise TypeError("Expected argument 'last_modified_by' to be a str")
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        if region and not isinstance(region, list):
            raise TypeError("Expected argument 'region' to be a list")
        pulumi.set(__self__, "region", region)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) of the replication set.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The ARN of the user who created the replication set.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="deletionProtected")
    def deletion_protected(self) -> _builtins.bool:
        """
        If `true`, the last remaining Region in a replication set can’t be deleted.
        """
        return pulumi.get(self, "deletion_protected")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> _builtins.str:
        """
        The ARN of the user who last modified the replication set.
        """
        return pulumi.get(self, "last_modified_by")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use regions instead.""")
    def region(self) -> Sequence['outputs.GetReplicationSetRegionResult']:
        """
        (**Deprecated**) The replication set's Regions. Use `regions` instead.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetReplicationSetRegionResult']:
        """
        The replication set's Regions.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the Region.
        * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        All tags applied to the replication set.
        """
        return pulumi.get(self, "tags")


class AwaitableGetReplicationSetResult(GetReplicationSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicationSetResult(
            arn=self.arn,
            created_by=self.created_by,
            deletion_protected=self.deletion_protected,
            id=self.id,
            last_modified_by=self.last_modified_by,
            region=self.region,
            regions=self.regions,
            status=self.status,
            tags=self.tags)


def get_replication_set(tags: Optional[Mapping[str, _builtins.str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicationSetResult:
    """
    > **NOTE:** The AWS Region specified by a provider must always be one of the Regions specified for the replication set.

    Use this data source to manage a replication set in AWS Systems Manager Incident Manager.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssmincidents.get_replication_set()
    ```


    :param Mapping[str, _builtins.str] tags: All tags applied to the replication set.
    """
    __args__ = dict()
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ssmincidents/getReplicationSet:getReplicationSet', __args__, opts=opts, typ=GetReplicationSetResult).value

    return AwaitableGetReplicationSetResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_by=pulumi.get(__ret__, 'created_by'),
        deletion_protected=pulumi.get(__ret__, 'deletion_protected'),
        id=pulumi.get(__ret__, 'id'),
        last_modified_by=pulumi.get(__ret__, 'last_modified_by'),
        region=pulumi.get(__ret__, 'region'),
        regions=pulumi.get(__ret__, 'regions'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_replication_set_output(tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReplicationSetResult]:
    """
    > **NOTE:** The AWS Region specified by a provider must always be one of the Regions specified for the replication set.

    Use this data source to manage a replication set in AWS Systems Manager Incident Manager.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssmincidents.get_replication_set()
    ```


    :param Mapping[str, _builtins.str] tags: All tags applied to the replication set.
    """
    __args__ = dict()
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ssmincidents/getReplicationSet:getReplicationSet', __args__, opts=opts, typ=GetReplicationSetResult)
    return __ret__.apply(lambda __response__: GetReplicationSetResult(
        arn=pulumi.get(__response__, 'arn'),
        created_by=pulumi.get(__response__, 'created_by'),
        deletion_protected=pulumi.get(__response__, 'deletion_protected'),
        id=pulumi.get(__response__, 'id'),
        last_modified_by=pulumi.get(__response__, 'last_modified_by'),
        region=pulumi.get(__response__, 'region'),
        regions=pulumi.get(__response__, 'regions'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
