# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicationSetArgs', 'ReplicationSet']

@pulumi.input_type
class ReplicationSetArgs:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ReplicationSet resource.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]] region: The replication set's Regions. Use `regions` instead.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]] regions: The replication set's Regions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).
               
               > **NOTE:** The Region specified by a provider must always be one of the Regions specified for the replication set. This is especially important when you perform complex update operations.
               
               > **NOTE:** After a replication set is created, you can add or delete only one Region at a time.
               
               > **NOTE:** Incident Manager does not support updating the customer managed key associated with a replication set. Instead, for a replication set with multiple Regions, you must first delete a Region from the replication set, then re-add it with a different customer managed key in separate deploy operations. For a replication set with only one Region, the entire replication set must be deleted and recreated. To do this, comment out the replication set and all response plans, and then run the deploy command to recreate the replication set with the new customer managed key.
               
               > **NOTE:** You must either use AWS-owned keys on all regions of a replication set, or customer managed keys. To change between an AWS owned key and a customer managed key, a replication set and it associated data must be deleted and recreated.
               
               > **NOTE:** If possible, create all the customer managed keys you need (using the deploy command) before you create the replication set, or create the keys and replication set in the same deploy command. Otherwise, to delete a replication set, you must run one deploy command to delete the replication set and another to delete the AWS KMS keys used by the replication set. Deleting the AWS KMS keys before deleting the replication set results in an error. In that case, you must manually reenable the deleted key using the AWS Management Console before you can delete the replication set.
        """
        if region is not None:
            warnings.warn("""region is deprecated. Use regions instead.""", DeprecationWarning)
            pulumi.log.warn("""region is deprecated: region is deprecated. Use regions instead.""")
        if region is not None:
            pulumi.set(__self__, "region", region)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use regions instead.""")
    def region(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]]:
        """
        The replication set's Regions. Use `regions` instead.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]]:
        """
        The replication set's Regions.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).

        > **NOTE:** The Region specified by a provider must always be one of the Regions specified for the replication set. This is especially important when you perform complex update operations.

        > **NOTE:** After a replication set is created, you can add or delete only one Region at a time.

        > **NOTE:** Incident Manager does not support updating the customer managed key associated with a replication set. Instead, for a replication set with multiple Regions, you must first delete a Region from the replication set, then re-add it with a different customer managed key in separate deploy operations. For a replication set with only one Region, the entire replication set must be deleted and recreated. To do this, comment out the replication set and all response plans, and then run the deploy command to recreate the replication set with the new customer managed key.

        > **NOTE:** You must either use AWS-owned keys on all regions of a replication set, or customer managed keys. To change between an AWS owned key and a customer managed key, a replication set and it associated data must be deleted and recreated.

        > **NOTE:** If possible, create all the customer managed keys you need (using the deploy command) before you create the replication set, or create the keys and replication set in the same deploy command. Otherwise, to delete a replication set, you must run one deploy command to delete the replication set and another to delete the AWS KMS keys used by the replication set. Deleting the AWS KMS keys before deleting the replication set results in an error. In that case, you must manually reenable the deleted key using the AWS Management Console before you can delete the replication set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ReplicationSetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_modified_by: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ReplicationSet resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the replication set.
        :param pulumi.Input[_builtins.str] created_by: The ARN of the user who created the replication set.
        :param pulumi.Input[_builtins.bool] deletion_protected: If `true`, the last region in a replication set cannot be deleted.
        :param pulumi.Input[_builtins.str] last_modified_by: A timestamp showing when the replication set was last modified.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]] region: The replication set's Regions. Use `regions` instead.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]] regions: The replication set's Regions.
        :param pulumi.Input[_builtins.str] status: The current status of the Region.
               * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).
               
               > **NOTE:** The Region specified by a provider must always be one of the Regions specified for the replication set. This is especially important when you perform complex update operations.
               
               > **NOTE:** After a replication set is created, you can add or delete only one Region at a time.
               
               > **NOTE:** Incident Manager does not support updating the customer managed key associated with a replication set. Instead, for a replication set with multiple Regions, you must first delete a Region from the replication set, then re-add it with a different customer managed key in separate deploy operations. For a replication set with only one Region, the entire replication set must be deleted and recreated. To do this, comment out the replication set and all response plans, and then run the deploy command to recreate the replication set with the new customer managed key.
               
               > **NOTE:** You must either use AWS-owned keys on all regions of a replication set, or customer managed keys. To change between an AWS owned key and a customer managed key, a replication set and it associated data must be deleted and recreated.
               
               > **NOTE:** If possible, create all the customer managed keys you need (using the deploy command) before you create the replication set, or create the keys and replication set in the same deploy command. Otherwise, to delete a replication set, you must run one deploy command to delete the replication set and another to delete the AWS KMS keys used by the replication set. Deleting the AWS KMS keys before deleting the replication set results in an error. In that case, you must manually reenable the deleted key using the AWS Management Console before you can delete the replication set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if deletion_protected is not None:
            pulumi.set(__self__, "deletion_protected", deletion_protected)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if region is not None:
            warnings.warn("""region is deprecated. Use regions instead.""", DeprecationWarning)
            pulumi.log.warn("""region is deprecated: region is deprecated. Use regions instead.""")
        if region is not None:
            pulumi.set(__self__, "region", region)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the replication set.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the user who created the replication set.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtected")
    def deletion_protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, the last region in a replication set cannot be deleted.
        """
        return pulumi.get(self, "deletion_protected")

    @deletion_protected.setter
    def deletion_protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protected", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A timestamp showing when the replication set was last modified.
        """
        return pulumi.get(self, "last_modified_by")

    @last_modified_by.setter
    def last_modified_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_by", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use regions instead.""")
    def region(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]]:
        """
        The replication set's Regions. Use `regions` instead.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]]:
        """
        The replication set's Regions.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationSetRegionArgs']]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the Region.
        * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).

        > **NOTE:** The Region specified by a provider must always be one of the Regions specified for the replication set. This is especially important when you perform complex update operations.

        > **NOTE:** After a replication set is created, you can add or delete only one Region at a time.

        > **NOTE:** Incident Manager does not support updating the customer managed key associated with a replication set. Instead, for a replication set with multiple Regions, you must first delete a Region from the replication set, then re-add it with a different customer managed key in separate deploy operations. For a replication set with only one Region, the entire replication set must be deleted and recreated. To do this, comment out the replication set and all response plans, and then run the deploy command to recreate the replication set with the new customer managed key.

        > **NOTE:** You must either use AWS-owned keys on all regions of a replication set, or customer managed keys. To change between an AWS owned key and a customer managed key, a replication set and it associated data must be deleted and recreated.

        > **NOTE:** If possible, create all the customer managed keys you need (using the deploy command) before you create the replication set, or create the keys and replication set in the same deploy command. Otherwise, to delete a replication set, you must run one deploy command to delete the replication set and another to delete the AWS KMS keys used by the replication set. Deleting the AWS KMS keys before deleting the replication set results in an error. In that case, you must manually reenable the deleted key using the AWS Management Console before you can delete the replication set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:ssmincidents/replicationSet:ReplicationSet")
class ReplicationSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource for managing a replication set in AWS Systems Manager Incident Manager.

        > **NOTE:** Deleting a replication set also deletes all Incident Manager related data including response plans, incident records, contacts and escalation plans.

        ## Example Usage

        ### Basic Usage

        Create a replication set.

        ```python
        import pulumi
        import pulumi_aws as aws

        replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName",
            regions=[{
                "name": "us-west-2",
            }],
            tags={
                "exampleTag": "exampleValue",
            })
        ```

        Add a Region to a replication set. (You can add only one Region at a time.)

        ```python
        import pulumi
        import pulumi_aws as aws

        replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName", regions=[
            {
                "name": "us-west-2",
            },
            {
                "name": "ap-southeast-2",
            },
        ])
        ```

        Delete a Region from a replication set. (You can delete only one Region at a time.)

        ```python
        import pulumi
        import pulumi_aws as aws

        replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName", regions=[{
            "name": "us-west-2",
        }])
        ```

        ## Basic Usage with an AWS Customer Managed Key

        Create a replication set with an AWS Key Management Service (AWS KMS) customer manager key:

        ```python
        import pulumi
        import pulumi_aws as aws

        example_key = aws.kms.Key("example_key")
        replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName",
            regions=[{
                "name": "us-west-2",
                "kms_key_arn": example_key.arn,
            }],
            tags={
                "exampleTag": "exampleValue",
            })
        ```

        ## Import

        Using `pulumi import`, import an Incident Manager replication. For example:

        ```sh
        $ pulumi import aws:ssmincidents/replicationSet:ReplicationSet replicationSetName import
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]] region: The replication set's Regions. Use `regions` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]] regions: The replication set's Regions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).
               
               > **NOTE:** The Region specified by a provider must always be one of the Regions specified for the replication set. This is especially important when you perform complex update operations.
               
               > **NOTE:** After a replication set is created, you can add or delete only one Region at a time.
               
               > **NOTE:** Incident Manager does not support updating the customer managed key associated with a replication set. Instead, for a replication set with multiple Regions, you must first delete a Region from the replication set, then re-add it with a different customer managed key in separate deploy operations. For a replication set with only one Region, the entire replication set must be deleted and recreated. To do this, comment out the replication set and all response plans, and then run the deploy command to recreate the replication set with the new customer managed key.
               
               > **NOTE:** You must either use AWS-owned keys on all regions of a replication set, or customer managed keys. To change between an AWS owned key and a customer managed key, a replication set and it associated data must be deleted and recreated.
               
               > **NOTE:** If possible, create all the customer managed keys you need (using the deploy command) before you create the replication set, or create the keys and replication set in the same deploy command. Otherwise, to delete a replication set, you must run one deploy command to delete the replication set and another to delete the AWS KMS keys used by the replication set. Deleting the AWS KMS keys before deleting the replication set results in an error. In that case, you must manually reenable the deleted key using the AWS Management Console before you can delete the replication set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ReplicationSetArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for managing a replication set in AWS Systems Manager Incident Manager.

        > **NOTE:** Deleting a replication set also deletes all Incident Manager related data including response plans, incident records, contacts and escalation plans.

        ## Example Usage

        ### Basic Usage

        Create a replication set.

        ```python
        import pulumi
        import pulumi_aws as aws

        replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName",
            regions=[{
                "name": "us-west-2",
            }],
            tags={
                "exampleTag": "exampleValue",
            })
        ```

        Add a Region to a replication set. (You can add only one Region at a time.)

        ```python
        import pulumi
        import pulumi_aws as aws

        replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName", regions=[
            {
                "name": "us-west-2",
            },
            {
                "name": "ap-southeast-2",
            },
        ])
        ```

        Delete a Region from a replication set. (You can delete only one Region at a time.)

        ```python
        import pulumi
        import pulumi_aws as aws

        replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName", regions=[{
            "name": "us-west-2",
        }])
        ```

        ## Basic Usage with an AWS Customer Managed Key

        Create a replication set with an AWS Key Management Service (AWS KMS) customer manager key:

        ```python
        import pulumi
        import pulumi_aws as aws

        example_key = aws.kms.Key("example_key")
        replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName",
            regions=[{
                "name": "us-west-2",
                "kms_key_arn": example_key.arn,
            }],
            tags={
                "exampleTag": "exampleValue",
            })
        ```

        ## Import

        Using `pulumi import`, import an Incident Manager replication. For example:

        ```sh
        $ pulumi import aws:ssmincidents/replicationSet:ReplicationSet replicationSetName import
        ```

        :param str resource_name: The name of the resource.
        :param ReplicationSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationSetArgs.__new__(ReplicationSetArgs)

            __props__.__dict__["region"] = region
            __props__.__dict__["regions"] = regions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["deletion_protected"] = None
            __props__.__dict__["last_modified_by"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(ReplicationSet, __self__).__init__(
            'aws:ssmincidents/replicationSet:ReplicationSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protected: Optional[pulumi.Input[_builtins.bool]] = None,
            last_modified_by: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ReplicationSet':
        """
        Get an existing ReplicationSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the replication set.
        :param pulumi.Input[_builtins.str] created_by: The ARN of the user who created the replication set.
        :param pulumi.Input[_builtins.bool] deletion_protected: If `true`, the last region in a replication set cannot be deleted.
        :param pulumi.Input[_builtins.str] last_modified_by: A timestamp showing when the replication set was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]] region: The replication set's Regions. Use `regions` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationSetRegionArgs', 'ReplicationSetRegionArgsDict']]]] regions: The replication set's Regions.
        :param pulumi.Input[_builtins.str] status: The current status of the Region.
               * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).
               
               > **NOTE:** The Region specified by a provider must always be one of the Regions specified for the replication set. This is especially important when you perform complex update operations.
               
               > **NOTE:** After a replication set is created, you can add or delete only one Region at a time.
               
               > **NOTE:** Incident Manager does not support updating the customer managed key associated with a replication set. Instead, for a replication set with multiple Regions, you must first delete a Region from the replication set, then re-add it with a different customer managed key in separate deploy operations. For a replication set with only one Region, the entire replication set must be deleted and recreated. To do this, comment out the replication set and all response plans, and then run the deploy command to recreate the replication set with the new customer managed key.
               
               > **NOTE:** You must either use AWS-owned keys on all regions of a replication set, or customer managed keys. To change between an AWS owned key and a customer managed key, a replication set and it associated data must be deleted and recreated.
               
               > **NOTE:** If possible, create all the customer managed keys you need (using the deploy command) before you create the replication set, or create the keys and replication set in the same deploy command. Otherwise, to delete a replication set, you must run one deploy command to delete the replication set and another to delete the AWS KMS keys used by the replication set. Deleting the AWS KMS keys before deleting the replication set results in an error. In that case, you must manually reenable the deleted key using the AWS Management Console before you can delete the replication set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicationSetState.__new__(_ReplicationSetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["deletion_protected"] = deletion_protected
        __props__.__dict__["last_modified_by"] = last_modified_by
        __props__.__dict__["region"] = region
        __props__.__dict__["regions"] = regions
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return ReplicationSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the replication set.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the user who created the replication set.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="deletionProtected")
    def deletion_protected(self) -> pulumi.Output[_builtins.bool]:
        """
        If `true`, the last region in a replication set cannot be deleted.
        """
        return pulumi.get(self, "deletion_protected")

    @_builtins.property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> pulumi.Output[_builtins.str]:
        """
        A timestamp showing when the replication set was last modified.
        """
        return pulumi.get(self, "last_modified_by")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use regions instead.""")
    def region(self) -> pulumi.Output[Sequence['outputs.ReplicationSetRegion']]:
        """
        The replication set's Regions. Use `regions` instead.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence['outputs.ReplicationSetRegion']]:
        """
        The replication set's Regions.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the Region.
        * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).

        > **NOTE:** The Region specified by a provider must always be one of the Regions specified for the replication set. This is especially important when you perform complex update operations.

        > **NOTE:** After a replication set is created, you can add or delete only one Region at a time.

        > **NOTE:** Incident Manager does not support updating the customer managed key associated with a replication set. Instead, for a replication set with multiple Regions, you must first delete a Region from the replication set, then re-add it with a different customer managed key in separate deploy operations. For a replication set with only one Region, the entire replication set must be deleted and recreated. To do this, comment out the replication set and all response plans, and then run the deploy command to recreate the replication set with the new customer managed key.

        > **NOTE:** You must either use AWS-owned keys on all regions of a replication set, or customer managed keys. To change between an AWS owned key and a customer managed key, a replication set and it associated data must be deleted and recreated.

        > **NOTE:** If possible, create all the customer managed keys you need (using the deploy command) before you create the replication set, or create the keys and replication set in the same deploy command. Otherwise, to delete a replication set, you must run one deploy command to delete the replication set and another to delete the AWS KMS keys used by the replication set. Deleting the AWS KMS keys before deleting the replication set results in an error. In that case, you must manually reenable the deleted key using the AWS Management Console before you can delete the replication set.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

