# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteServerEndpointArgs', 'RouteServerEndpoint']

@pulumi.input_type
class RouteServerEndpointArgs:
    def __init__(__self__, *,
                 route_server_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerEndpointTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a RouteServerEndpoint resource.
        :param pulumi.Input[_builtins.str] route_server_id: The ID of the route server for which to create an endpoint.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet in which to create the route server endpoint.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "route_server_id", route_server_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the route server for which to create an endpoint.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_server_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the subnet in which to create the route server endpoint.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerEndpointTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerEndpointTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _RouteServerEndpointState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 eni_address: Optional[pulumi.Input[_builtins.str]] = None,
                 eni_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerEndpointTimeoutsArgs']] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteServerEndpoint resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the route server endpoint.
        :param pulumi.Input[_builtins.str] eni_address: The IP address of the Elastic network interface for the endpoint.
        :param pulumi.Input[_builtins.str] eni_id: The ID of the Elastic network interface for the endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] route_server_endpoint_id: The unique identifier of the route server endpoint.
        :param pulumi.Input[_builtins.str] route_server_id: The ID of the route server for which to create an endpoint.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet in which to create the route server endpoint.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC containing the endpoint.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if eni_address is not None:
            pulumi.set(__self__, "eni_address", eni_address)
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_server_endpoint_id is not None:
            pulumi.set(__self__, "route_server_endpoint_id", route_server_endpoint_id)
        if route_server_id is not None:
            pulumi.set(__self__, "route_server_id", route_server_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the route server endpoint.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="eniAddress")
    def eni_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the Elastic network interface for the endpoint.
        """
        return pulumi.get(self, "eni_address")

    @eni_address.setter
    def eni_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eni_address", value)

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Elastic network interface for the endpoint.
        """
        return pulumi.get(self, "eni_id")

    @eni_id.setter
    def eni_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eni_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routeServerEndpointId")
    def route_server_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the route server endpoint.
        """
        return pulumi.get(self, "route_server_endpoint_id")

    @route_server_endpoint_id.setter
    def route_server_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_server_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the route server for which to create an endpoint.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_server_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subnet in which to create the route server endpoint.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerEndpointTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerEndpointTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC containing the endpoint.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws:vpc/routeServerEndpoint:RouteServerEndpoint")
class RouteServerEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerEndpointTimeoutsArgs', 'RouteServerEndpointTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource for managing a VPC (Virtual Private Cloud) Route Server Endpoint.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServerEndpoint("test",
            route_server_id=example["routeServerId"],
            subnet_id=main["id"],
            tags={
                "Name": "Endpoint A",
            })
        ```

        ## Import

        Using `pulumi import`, import VPC (Virtual Private Cloud) Route Server Endpoint using the `route_server_endpoint_id`. For example:

        ```sh
        $ pulumi import aws:vpc/routeServerEndpoint:RouteServerEndpoint example rse-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] route_server_id: The ID of the route server for which to create an endpoint.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet in which to create the route server endpoint.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for managing a VPC (Virtual Private Cloud) Route Server Endpoint.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpc.RouteServerEndpoint("test",
            route_server_id=example["routeServerId"],
            subnet_id=main["id"],
            tags={
                "Name": "Endpoint A",
            })
        ```

        ## Import

        Using `pulumi import`, import VPC (Virtual Private Cloud) Route Server Endpoint using the `route_server_endpoint_id`. For example:

        ```sh
        $ pulumi import aws:vpc/routeServerEndpoint:RouteServerEndpoint example rse-12345678
        ```

        :param str resource_name: The name of the resource.
        :param RouteServerEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerEndpointTimeoutsArgs', 'RouteServerEndpointTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerEndpointArgs.__new__(RouteServerEndpointArgs)

            __props__.__dict__["region"] = region
            if route_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_server_id'")
            __props__.__dict__["route_server_id"] = route_server_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["eni_address"] = None
            __props__.__dict__["eni_id"] = None
            __props__.__dict__["route_server_endpoint_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        super(RouteServerEndpoint, __self__).__init__(
            'aws:vpc/routeServerEndpoint:RouteServerEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            eni_address: Optional[pulumi.Input[_builtins.str]] = None,
            eni_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            route_server_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['RouteServerEndpointTimeoutsArgs', 'RouteServerEndpointTimeoutsArgsDict']]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouteServerEndpoint':
        """
        Get an existing RouteServerEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the route server endpoint.
        :param pulumi.Input[_builtins.str] eni_address: The IP address of the Elastic network interface for the endpoint.
        :param pulumi.Input[_builtins.str] eni_id: The ID of the Elastic network interface for the endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] route_server_endpoint_id: The unique identifier of the route server endpoint.
        :param pulumi.Input[_builtins.str] route_server_id: The ID of the route server for which to create an endpoint.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet in which to create the route server endpoint.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC containing the endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteServerEndpointState.__new__(_RouteServerEndpointState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["eni_address"] = eni_address
        __props__.__dict__["eni_id"] = eni_id
        __props__.__dict__["region"] = region
        __props__.__dict__["route_server_endpoint_id"] = route_server_endpoint_id
        __props__.__dict__["route_server_id"] = route_server_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["vpc_id"] = vpc_id
        return RouteServerEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the route server endpoint.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="eniAddress")
    def eni_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the Elastic network interface for the endpoint.
        """
        return pulumi.get(self, "eni_address")

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Elastic network interface for the endpoint.
        """
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeServerEndpointId")
    def route_server_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the route server endpoint.
        """
        return pulumi.get(self, "route_server_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the route server for which to create an endpoint.
        """
        return pulumi.get(self, "route_server_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the subnet in which to create the route server endpoint.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.RouteServerEndpointTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC containing the endpoint.
        """
        return pulumi.get(self, "vpc_id")

