# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteServerPropagationArgs', 'RouteServerPropagation']

@pulumi.input_type
class RouteServerPropagationArgs:
    def __init__(__self__, *,
                 route_server_id: pulumi.Input[_builtins.str],
                 route_table_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerPropagationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a RouteServerPropagation resource.
        :param pulumi.Input[_builtins.str] route_server_id: The unique identifier for the route server to be associated.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the route table to which route server will propagate routes.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "route_server_id", route_server_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier for the route server to be associated.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_server_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the route table to which route server will propagate routes.

        The following arguments are optional:
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerPropagationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerPropagationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _RouteServerPropagationState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['RouteServerPropagationTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering RouteServerPropagation resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] route_server_id: The unique identifier for the route server to be associated.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the route table to which route server will propagate routes.
               
               The following arguments are optional:
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_server_id is not None:
            pulumi.set(__self__, "route_server_id", route_server_id)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the route server to be associated.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_server_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the route table to which route server will propagate routes.

        The following arguments are optional:
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RouteServerPropagationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RouteServerPropagationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:vpc/routeServerPropagation:RouteServerPropagation")
class RouteServerPropagation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerPropagationTimeoutsArgs', 'RouteServerPropagationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource for managing propagation between VPC (Virtual Private Cloud) route server and a route table.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpc.RouteServerPropagation("example",
            route_server_id=example_aws_vpc_route_server["routeServerId"],
            route_table_id=example_aws_route_table["id"])
        ```

        ## Import

        Using `pulumi import`, to  to import VPC (Virtual Private Cloud) Route Server Propagation using the associated resource ID and route table ID separated by a comma (,). For example:

        ```sh
        $ pulumi import aws:vpc/routeServerPropagation:RouteServerPropagation example rs-12345678,rtb-656c65616e6f72
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] route_server_id: The unique identifier for the route server to be associated.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the route table to which route server will propagate routes.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerPropagationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for managing propagation between VPC (Virtual Private Cloud) route server and a route table.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpc.RouteServerPropagation("example",
            route_server_id=example_aws_vpc_route_server["routeServerId"],
            route_table_id=example_aws_route_table["id"])
        ```

        ## Import

        Using `pulumi import`, to  to import VPC (Virtual Private Cloud) Route Server Propagation using the associated resource ID and route table ID separated by a comma (,). For example:

        ```sh
        $ pulumi import aws:vpc/routeServerPropagation:RouteServerPropagation example rs-12345678,rtb-656c65616e6f72
        ```

        :param str resource_name: The name of the resource.
        :param RouteServerPropagationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerPropagationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['RouteServerPropagationTimeoutsArgs', 'RouteServerPropagationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerPropagationArgs.__new__(RouteServerPropagationArgs)

            __props__.__dict__["region"] = region
            if route_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_server_id'")
            __props__.__dict__["route_server_id"] = route_server_id
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["timeouts"] = timeouts
        super(RouteServerPropagation, __self__).__init__(
            'aws:vpc/routeServerPropagation:RouteServerPropagation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['RouteServerPropagationTimeoutsArgs', 'RouteServerPropagationTimeoutsArgsDict']]] = None) -> 'RouteServerPropagation':
        """
        Get an existing RouteServerPropagation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] route_server_id: The unique identifier for the route server to be associated.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the route table to which route server will propagate routes.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteServerPropagationState.__new__(_RouteServerPropagationState)

        __props__.__dict__["region"] = region
        __props__.__dict__["route_server_id"] = route_server_id
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["timeouts"] = timeouts
        return RouteServerPropagation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the route server to be associated.
        """
        return pulumi.get(self, "route_server_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the route table to which route server will propagate routes.

        The following arguments are optional:
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.RouteServerPropagationTimeouts']]:
        return pulumi.get(self, "timeouts")

