# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ByteMatchSetByteMatchTuple',
    'ByteMatchSetByteMatchTupleFieldToMatch',
    'GeoMatchSetGeoMatchConstraint',
    'IpSetIpSetDescriptor',
    'RateBasedRulePredicate',
    'RegexMatchSetRegexMatchTuple',
    'RegexMatchSetRegexMatchTupleFieldToMatch',
    'RuleGroupActivatedRule',
    'RuleGroupActivatedRuleAction',
    'RulePredicate',
    'SizeConstraintSetSizeConstraint',
    'SizeConstraintSetSizeConstraintFieldToMatch',
    'SqlInjectionMatchSetSqlInjectionMatchTuple',
    'SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatch',
    'WebAclDefaultAction',
    'WebAclLoggingConfiguration',
    'WebAclLoggingConfigurationRedactedFields',
    'WebAclLoggingConfigurationRedactedFieldsFieldToMatch',
    'WebAclRule',
    'WebAclRuleAction',
    'WebAclRuleOverrideAction',
    'XssMatchSetXssMatchTuple',
    'XssMatchSetXssMatchTupleFieldToMatch',
]

@pulumi.output_type
class ByteMatchSetByteMatchTuple(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "positionalConstraint":
            suggest = "positional_constraint"
        elif key == "textTransformation":
            suggest = "text_transformation"
        elif key == "targetString":
            suggest = "target_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ByteMatchSetByteMatchTuple. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ByteMatchSetByteMatchTuple.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ByteMatchSetByteMatchTuple.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.ByteMatchSetByteMatchTupleFieldToMatch',
                 positional_constraint: _builtins.str,
                 text_transformation: _builtins.str,
                 target_string: Optional[_builtins.str] = None):
        """
        :param 'ByteMatchSetByteMatchTupleFieldToMatchArgs' field_to_match: Settings for the ByteMatchTuple. FieldToMatch documented below.
        :param _builtins.str positional_constraint: Within the portion of a web request that you want to search.
        :param _builtins.str text_transformation: The formatting way for web request.
               
               FieldToMatch(field_to_match) support following:
        :param _builtins.str target_string: The value that you want AWS WAF to search for. The maximum length of the value is 50 bytes.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "positional_constraint", positional_constraint)
        pulumi.set(__self__, "text_transformation", text_transformation)
        if target_string is not None:
            pulumi.set(__self__, "target_string", target_string)

    @_builtins.property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.ByteMatchSetByteMatchTupleFieldToMatch':
        """
        Settings for the ByteMatchTuple. FieldToMatch documented below.
        """
        return pulumi.get(self, "field_to_match")

    @_builtins.property
    @pulumi.getter(name="positionalConstraint")
    def positional_constraint(self) -> _builtins.str:
        """
        Within the portion of a web request that you want to search.
        """
        return pulumi.get(self, "positional_constraint")

    @_builtins.property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> _builtins.str:
        """
        The formatting way for web request.

        FieldToMatch(field_to_match) support following:
        """
        return pulumi.get(self, "text_transformation")

    @_builtins.property
    @pulumi.getter(name="targetString")
    def target_string(self) -> Optional[_builtins.str]:
        """
        The value that you want AWS WAF to search for. The maximum length of the value is 50 bytes.
        """
        return pulumi.get(self, "target_string")


@pulumi.output_type
class ByteMatchSetByteMatchTupleFieldToMatch(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 data: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The part of the web request that you want AWS WAF to search for a specified string.
        :param _builtins.str data: When the value of Type is HEADER, enter the name of the header that you want AWS WAF to search, for example, User-Agent or Referer. If the value of Type is any other value, omit Data.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The part of the web request that you want AWS WAF to search for a specified string.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        """
        When the value of Type is HEADER, enter the name of the header that you want AWS WAF to search, for example, User-Agent or Referer. If the value of Type is any other value, omit Data.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class GeoMatchSetGeoMatchConstraint(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: The type of geographical area you want AWS WAF to search for. Currently Country is the only valid value.
        :param _builtins.str value: The country that you want AWS WAF to search for.
               This is the two-letter country code, e.g., `US`, `CA`, `RU`, `CN`, etc.
               See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchConstraint.html) for all supported values.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of geographical area you want AWS WAF to search for. Currently Country is the only valid value.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The country that you want AWS WAF to search for.
        This is the two-letter country code, e.g., `US`, `CA`, `RU`, `CN`, etc.
        See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchConstraint.html) for all supported values.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IpSetIpSetDescriptor(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: The string like IPV4 or IPV6.
        :param _builtins.str value: The CIDR notation.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The string like IPV4 or IPV6.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The CIDR notation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RateBasedRulePredicate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataId":
            suggest = "data_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RateBasedRulePredicate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RateBasedRulePredicate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RateBasedRulePredicate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_id: _builtins.str,
                 negated: _builtins.bool,
                 type: _builtins.str):
        """
        :param _builtins.str data_id: A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
        :param _builtins.bool negated: Set this to `false` if you want to allow, block, or count requests
               based on the settings in the specified `ByteMatchSet`, `IPSet`, `SqlInjectionMatchSet`, `XssMatchSet`, or `SizeConstraintSet`.
               For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
               If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses _except_ `192.0.2.44`.
        :param _builtins.str type: The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
        """
        pulumi.set(__self__, "data_id", data_id)
        pulumi.set(__self__, "negated", negated)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="dataId")
    def data_id(self) -> _builtins.str:
        """
        A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
        """
        return pulumi.get(self, "data_id")

    @_builtins.property
    @pulumi.getter
    def negated(self) -> _builtins.bool:
        """
        Set this to `false` if you want to allow, block, or count requests
        based on the settings in the specified `ByteMatchSet`, `IPSet`, `SqlInjectionMatchSet`, `XssMatchSet`, or `SizeConstraintSet`.
        For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
        If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses _except_ `192.0.2.44`.
        """
        return pulumi.get(self, "negated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RegexMatchSetRegexMatchTuple(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "regexPatternSetId":
            suggest = "regex_pattern_set_id"
        elif key == "textTransformation":
            suggest = "text_transformation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegexMatchSetRegexMatchTuple. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegexMatchSetRegexMatchTuple.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegexMatchSetRegexMatchTuple.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.RegexMatchSetRegexMatchTupleFieldToMatch',
                 regex_pattern_set_id: _builtins.str,
                 text_transformation: _builtins.str):
        """
        :param 'RegexMatchSetRegexMatchTupleFieldToMatchArgs' field_to_match: The part of a web request that you want to search, such as a specified header or a query string.
        :param _builtins.str regex_pattern_set_id: The ID of a Regex Pattern Set.
        :param _builtins.str text_transformation: Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
               e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
               for all supported values.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "regex_pattern_set_id", regex_pattern_set_id)
        pulumi.set(__self__, "text_transformation", text_transformation)

    @_builtins.property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.RegexMatchSetRegexMatchTupleFieldToMatch':
        """
        The part of a web request that you want to search, such as a specified header or a query string.
        """
        return pulumi.get(self, "field_to_match")

    @_builtins.property
    @pulumi.getter(name="regexPatternSetId")
    def regex_pattern_set_id(self) -> _builtins.str:
        """
        The ID of a Regex Pattern Set.
        """
        return pulumi.get(self, "regex_pattern_set_id")

    @_builtins.property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> _builtins.str:
        """
        Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
        e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
        for all supported values.
        """
        return pulumi.get(self, "text_transformation")


@pulumi.output_type
class RegexMatchSetRegexMatchTupleFieldToMatch(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 data: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The part of the web request that you want AWS WAF to search for a specified string.
               e.g., `HEADER`, `METHOD` or `BODY`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
               for all supported values.
        :param _builtins.str data: When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
               If `type` is any other value, omit this field.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The part of the web request that you want AWS WAF to search for a specified string.
        e.g., `HEADER`, `METHOD` or `BODY`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
        for all supported values.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        """
        When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
        If `type` is any other value, omit this field.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class RuleGroupActivatedRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupActivatedRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupActivatedRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupActivatedRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'outputs.RuleGroupActivatedRuleAction',
                 priority: _builtins.int,
                 rule_id: _builtins.str,
                 type: Optional[_builtins.str] = None):
        """
        :param 'RuleGroupActivatedRuleActionArgs' action: Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.
        :param _builtins.int priority: Specifies the order in which the rules are evaluated. Rules with a lower value are evaluated before rules with a higher value.
        :param _builtins.str rule_id: The ID of a rule
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_id", rule_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> 'outputs.RuleGroupActivatedRuleAction':
        """
        Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Specifies the order in which the rules are evaluated. Rules with a lower value are evaluated before rules with a higher value.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.str:
        """
        The ID of a rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class RuleGroupActivatedRuleAction(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class RulePredicate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataId":
            suggest = "data_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulePredicate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulePredicate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulePredicate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_id: _builtins.str,
                 negated: _builtins.bool,
                 type: _builtins.str):
        pulumi.set(__self__, "data_id", data_id)
        pulumi.set(__self__, "negated", negated)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="dataId")
    def data_id(self) -> _builtins.str:
        return pulumi.get(self, "data_id")

    @_builtins.property
    @pulumi.getter
    def negated(self) -> _builtins.bool:
        return pulumi.get(self, "negated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class SizeConstraintSetSizeConstraint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformation":
            suggest = "text_transformation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SizeConstraintSetSizeConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SizeConstraintSetSizeConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SizeConstraintSetSizeConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison_operator: _builtins.str,
                 field_to_match: 'outputs.SizeConstraintSetSizeConstraintFieldToMatch',
                 size: _builtins.int,
                 text_transformation: _builtins.str):
        """
        :param _builtins.str comparison_operator: The type of comparison you want to perform.
               e.g., `EQ`, `NE`, `LT`, `GT`.
               See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for all supported values.
        :param 'SizeConstraintSetSizeConstraintFieldToMatchArgs' field_to_match: Specifies where in a web request to look for the size constraint.
        :param _builtins.int size: The size in bytes that you want to compare against the size of the specified `field_to_match`.
               Valid values are between 0 - 21474836480 bytes (0 - 20 GB).
        :param _builtins.str text_transformation: Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
               If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
               e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation)
               for all supported values.
               **Note:** if you choose `BODY` as `type`, you must choose `NONE` because CloudFront forwards only the first 8192 bytes for inspection.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "text_transformation", text_transformation)

    @_builtins.property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> _builtins.str:
        """
        The type of comparison you want to perform.
        e.g., `EQ`, `NE`, `LT`, `GT`.
        See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for all supported values.
        """
        return pulumi.get(self, "comparison_operator")

    @_builtins.property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.SizeConstraintSetSizeConstraintFieldToMatch':
        """
        Specifies where in a web request to look for the size constraint.
        """
        return pulumi.get(self, "field_to_match")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size in bytes that you want to compare against the size of the specified `field_to_match`.
        Valid values are between 0 - 21474836480 bytes (0 - 20 GB).
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> _builtins.str:
        """
        Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
        If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
        e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation)
        for all supported values.
        **Note:** if you choose `BODY` as `type`, you must choose `NONE` because CloudFront forwards only the first 8192 bytes for inspection.
        """
        return pulumi.get(self, "text_transformation")


@pulumi.output_type
class SizeConstraintSetSizeConstraintFieldToMatch(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 data: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The part of the web request that you want AWS WAF to search for a specified string.
               e.g., `HEADER`, `METHOD` or `BODY`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
               for all supported values.
        :param _builtins.str data: When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
               If `type` is any other value, omit this field.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The part of the web request that you want AWS WAF to search for a specified string.
        e.g., `HEADER`, `METHOD` or `BODY`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
        for all supported values.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        """
        When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
        If `type` is any other value, omit this field.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class SqlInjectionMatchSetSqlInjectionMatchTuple(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformation":
            suggest = "text_transformation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlInjectionMatchSetSqlInjectionMatchTuple. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlInjectionMatchSetSqlInjectionMatchTuple.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlInjectionMatchSetSqlInjectionMatchTuple.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatch',
                 text_transformation: _builtins.str):
        """
        :param 'SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs' field_to_match: Specifies where in a web request to look for snippets of malicious SQL code.
        :param _builtins.str text_transformation: Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
               If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
               e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
               See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_regional_SqlInjectionMatchTuple.html#WAF-Type-regional_SqlInjectionMatchTuple-TextTransformation)
               for all supported values.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformation", text_transformation)

    @_builtins.property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatch':
        """
        Specifies where in a web request to look for snippets of malicious SQL code.
        """
        return pulumi.get(self, "field_to_match")

    @_builtins.property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> _builtins.str:
        """
        Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
        If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
        e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
        See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_regional_SqlInjectionMatchTuple.html#WAF-Type-regional_SqlInjectionMatchTuple-TextTransformation)
        for all supported values.
        """
        return pulumi.get(self, "text_transformation")


@pulumi.output_type
class SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatch(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 data: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The part of the web request that you want AWS WAF to search for a specified string.
               e.g., `HEADER`, `METHOD` or `BODY`.
               See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_regional_FieldToMatch.html)
               for all supported values.
        :param _builtins.str data: When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
               If `type` is any other value, omit this field.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The part of the web request that you want AWS WAF to search for a specified string.
        e.g., `HEADER`, `METHOD` or `BODY`.
        See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_regional_FieldToMatch.html)
        for all supported values.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        """
        When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
        If `type` is any other value, omit this field.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class WebAclDefaultAction(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        """
        :param _builtins.str type: Specifies how you want AWS WAF Regional to respond to requests that match the settings in a ruleE.g., `ALLOW`, `BLOCK` or `COUNT`
        """
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies how you want AWS WAF Regional to respond to requests that match the settings in a ruleE.g., `ALLOW`, `BLOCK` or `COUNT`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WebAclLoggingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDestination":
            suggest = "log_destination"
        elif key == "redactedFields":
            suggest = "redacted_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclLoggingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclLoggingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclLoggingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_destination: _builtins.str,
                 redacted_fields: Optional['outputs.WebAclLoggingConfigurationRedactedFields'] = None):
        """
        :param _builtins.str log_destination: Amazon Resource Name (ARN) of Kinesis Firehose Delivery Stream
        :param 'WebAclLoggingConfigurationRedactedFieldsArgs' redacted_fields: Configuration block containing parts of the request that you want redacted from the logs. Detailed below.
        """
        pulumi.set(__self__, "log_destination", log_destination)
        if redacted_fields is not None:
            pulumi.set(__self__, "redacted_fields", redacted_fields)

    @_builtins.property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of Kinesis Firehose Delivery Stream
        """
        return pulumi.get(self, "log_destination")

    @_builtins.property
    @pulumi.getter(name="redactedFields")
    def redacted_fields(self) -> Optional['outputs.WebAclLoggingConfigurationRedactedFields']:
        """
        Configuration block containing parts of the request that you want redacted from the logs. Detailed below.
        """
        return pulumi.get(self, "redacted_fields")


@pulumi.output_type
class WebAclLoggingConfigurationRedactedFields(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatches":
            suggest = "field_to_matches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclLoggingConfigurationRedactedFields. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclLoggingConfigurationRedactedFields.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclLoggingConfigurationRedactedFields.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_matches: Sequence['outputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatch']):
        """
        :param Sequence['WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs'] field_to_matches: Set of configuration blocks for fields to redact. Detailed below.
        """
        pulumi.set(__self__, "field_to_matches", field_to_matches)

    @_builtins.property
    @pulumi.getter(name="fieldToMatches")
    def field_to_matches(self) -> Sequence['outputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatch']:
        """
        Set of configuration blocks for fields to redact. Detailed below.
        """
        return pulumi.get(self, "field_to_matches")


@pulumi.output_type
class WebAclLoggingConfigurationRedactedFieldsFieldToMatch(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 data: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The part of the web request that you want AWS WAF to search for a specified stringE.g., `HEADER` or `METHOD`
        :param _builtins.str data: When the value of `type` is `HEADER`, enter the name of the header that you want the WAF to search, for example, `User-Agent` or `Referer`. If the value of `type` is any other value, omit `data`.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The part of the web request that you want AWS WAF to search for a specified stringE.g., `HEADER` or `METHOD`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        """
        When the value of `type` is `HEADER`, enter the name of the header that you want the WAF to search, for example, `User-Agent` or `Referer`. If the value of `type` is any other value, omit `data`.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class WebAclRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "overrideAction":
            suggest = "override_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 priority: _builtins.int,
                 rule_id: _builtins.str,
                 action: Optional['outputs.WebAclRuleAction'] = None,
                 override_action: Optional['outputs.WebAclRuleOverrideAction'] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int priority: Specifies the order in which the rules in a WebACL are evaluated.
               Rules with a lower value are evaluated before rules with a higher value.
        :param _builtins.str rule_id: ID of the associated WAF (Regional) rule (e.g., `wafregional.Rule`). WAF (Global) rules cannot be used.
        :param 'WebAclRuleActionArgs' action: Configuration block of the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.  Not used if `type` is `GROUP`. Detailed below.
        :param 'WebAclRuleOverrideActionArgs' override_action: Configuration block of the override the action that a group requests CloudFront or AWS WAF takes when a web request matches the conditions in the rule.  Only used if `type` is `GROUP`. Detailed below.
        :param _builtins.str type: The rule type, either `REGULAR`, as defined by [Rule](http://docs.aws.amazon.com/waf/latest/APIReference/API_Rule.html), `RATE_BASED`, as defined by [RateBasedRule](http://docs.aws.amazon.com/waf/latest/APIReference/API_RateBasedRule.html), or `GROUP`, as defined by [RuleGroup](https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleGroup.html). The default is REGULAR. If you add a RATE_BASED rule, you need to set `type` as `RATE_BASED`. If you add a GROUP rule, you need to set `type` as `GROUP`.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_id", rule_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if override_action is not None:
            pulumi.set(__self__, "override_action", override_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Specifies the order in which the rules in a WebACL are evaluated.
        Rules with a lower value are evaluated before rules with a higher value.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.str:
        """
        ID of the associated WAF (Regional) rule (e.g., `wafregional.Rule`). WAF (Global) rules cannot be used.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional['outputs.WebAclRuleAction']:
        """
        Configuration block of the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.  Not used if `type` is `GROUP`. Detailed below.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="overrideAction")
    def override_action(self) -> Optional['outputs.WebAclRuleOverrideAction']:
        """
        Configuration block of the override the action that a group requests CloudFront or AWS WAF takes when a web request matches the conditions in the rule.  Only used if `type` is `GROUP`. Detailed below.
        """
        return pulumi.get(self, "override_action")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The rule type, either `REGULAR`, as defined by [Rule](http://docs.aws.amazon.com/waf/latest/APIReference/API_Rule.html), `RATE_BASED`, as defined by [RateBasedRule](http://docs.aws.amazon.com/waf/latest/APIReference/API_RateBasedRule.html), or `GROUP`, as defined by [RuleGroup](https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleGroup.html). The default is REGULAR. If you add a RATE_BASED rule, you need to set `type` as `RATE_BASED`. If you add a GROUP rule, you need to set `type` as `GROUP`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WebAclRuleAction(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        """
        :param _builtins.str type: Specifies how you want AWS WAF Regional to respond to requests that match the settings in a rule. Valid values for `action` are `ALLOW`, `BLOCK` or `COUNT`. Valid values for `override_action` are `COUNT` and `NONE`.
        """
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies how you want AWS WAF Regional to respond to requests that match the settings in a rule. Valid values for `action` are `ALLOW`, `BLOCK` or `COUNT`. Valid values for `override_action` are `COUNT` and `NONE`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WebAclRuleOverrideAction(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class XssMatchSetXssMatchTuple(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformation":
            suggest = "text_transformation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in XssMatchSetXssMatchTuple. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        XssMatchSetXssMatchTuple.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        XssMatchSetXssMatchTuple.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.XssMatchSetXssMatchTupleFieldToMatch',
                 text_transformation: _builtins.str):
        """
        :param 'XssMatchSetXssMatchTupleFieldToMatchArgs' field_to_match: Specifies where in a web request to look for cross-site scripting attacks.
        :param _builtins.str text_transformation: Which text transformation, if any, to perform on the web request before inspecting the request for cross-site scripting attacks.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformation", text_transformation)

    @_builtins.property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.XssMatchSetXssMatchTupleFieldToMatch':
        """
        Specifies where in a web request to look for cross-site scripting attacks.
        """
        return pulumi.get(self, "field_to_match")

    @_builtins.property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> _builtins.str:
        """
        Which text transformation, if any, to perform on the web request before inspecting the request for cross-site scripting attacks.
        """
        return pulumi.get(self, "text_transformation")


@pulumi.output_type
class XssMatchSetXssMatchTupleFieldToMatch(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 data: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The part of the web request that you want AWS WAF to search for a specified stringE.g., `HEADER` or `METHOD`
        :param _builtins.str data: When the value of `type` is `HEADER`, enter the name of the header that you want the WAF to search, for example, `User-Agent` or `Referer`. If the value of `type` is any other value, omit `data`.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The part of the web request that you want AWS WAF to search for a specified stringE.g., `HEADER` or `METHOD`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        """
        When the value of `type` is `HEADER`, enter the name of the header that you want the WAF to search, for example, `User-Agent` or `Referer`. If the value of `type` is any other value, omit `data`.
        """
        return pulumi.get(self, "data")


