# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WebAclAssociationArgs', 'WebAclAssociation']

@pulumi.input_type
class WebAclAssociationArgs:
    def __init__(__self__, *,
                 resource_arn: pulumi.Input[_builtins.str],
                 web_acl_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WebAclAssociation resource.
        :param pulumi.Input[_builtins.str] resource_arn: ARN of the resource to associate with. For example, an Application Load Balancer or API Gateway Stage.
        :param pulumi.Input[_builtins.str] web_acl_id: The ID of the WAF Regional WebACL to create an association.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "resource_arn", resource_arn)
        pulumi.set(__self__, "web_acl_id", web_acl_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the resource to associate with. For example, an Application Load Balancer or API Gateway Stage.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_arn", value)

    @_builtins.property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the WAF Regional WebACL to create an association.
        """
        return pulumi.get(self, "web_acl_id")

    @web_acl_id.setter
    def web_acl_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "web_acl_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _WebAclAssociationState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 web_acl_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WebAclAssociation resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_arn: ARN of the resource to associate with. For example, an Application Load Balancer or API Gateway Stage.
        :param pulumi.Input[_builtins.str] web_acl_id: The ID of the WAF Regional WebACL to create an association.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the resource to associate with. For example, an Application Load Balancer or API Gateway Stage.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_arn", value)

    @_builtins.property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the WAF Regional WebACL to create an association.
        """
        return pulumi.get(self, "web_acl_id")

    @web_acl_id.setter
    def web_acl_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_acl_id", value)


@pulumi.type_token("aws:wafregional/webAclAssociation:WebAclAssociation")
class WebAclAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 web_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an association with WAF Regional Web ACL.

        > **Note:** An Application Load Balancer can only be associated with one WAF Regional WebACL.

        ## Example Usage

        ### Application Load Balancer Association

        ```python
        import pulumi
        import pulumi_aws as aws

        ipset = aws.wafregional.IpSet("ipset",
            name="tfIPSet",
            ip_set_descriptors=[{
                "type": "IPV4",
                "value": "192.0.7.0/24",
            }])
        foo = aws.wafregional.Rule("foo",
            name="tfWAFRule",
            metric_name="tfWAFRule",
            predicates=[{
                "data_id": ipset.id,
                "negated": False,
                "type": "IPMatch",
            }])
        foo_web_acl = aws.wafregional.WebAcl("foo",
            name="foo",
            metric_name="foo",
            default_action={
                "type": "ALLOW",
            },
            rules=[{
                "action": {
                    "type": "BLOCK",
                },
                "priority": 1,
                "rule_id": foo.id,
            }])
        foo_vpc = aws.ec2.Vpc("foo", cidr_block="10.1.0.0/16")
        available = aws.get_availability_zones()
        foo_subnet = aws.ec2.Subnet("foo",
            vpc_id=foo_vpc.id,
            cidr_block="10.1.1.0/24",
            availability_zone=available.names[0])
        bar = aws.ec2.Subnet("bar",
            vpc_id=foo_vpc.id,
            cidr_block="10.1.2.0/24",
            availability_zone=available.names[1])
        foo_load_balancer = aws.alb.LoadBalancer("foo",
            internal=True,
            subnets=[
                foo_subnet.id,
                bar.id,
            ])
        foo_web_acl_association = aws.wafregional.WebAclAssociation("foo",
            resource_arn=foo_load_balancer.arn,
            web_acl_id=foo_web_acl.id)
        ```

        ## Import

        Using `pulumi import`, import WAF Regional Web ACL Association using their `web_acl_id:resource_arn`. For example:

        ```sh
        $ pulumi import aws:wafregional/webAclAssociation:WebAclAssociation foo web_acl_id:resource_arn
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_arn: ARN of the resource to associate with. For example, an Application Load Balancer or API Gateway Stage.
        :param pulumi.Input[_builtins.str] web_acl_id: The ID of the WAF Regional WebACL to create an association.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebAclAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an association with WAF Regional Web ACL.

        > **Note:** An Application Load Balancer can only be associated with one WAF Regional WebACL.

        ## Example Usage

        ### Application Load Balancer Association

        ```python
        import pulumi
        import pulumi_aws as aws

        ipset = aws.wafregional.IpSet("ipset",
            name="tfIPSet",
            ip_set_descriptors=[{
                "type": "IPV4",
                "value": "192.0.7.0/24",
            }])
        foo = aws.wafregional.Rule("foo",
            name="tfWAFRule",
            metric_name="tfWAFRule",
            predicates=[{
                "data_id": ipset.id,
                "negated": False,
                "type": "IPMatch",
            }])
        foo_web_acl = aws.wafregional.WebAcl("foo",
            name="foo",
            metric_name="foo",
            default_action={
                "type": "ALLOW",
            },
            rules=[{
                "action": {
                    "type": "BLOCK",
                },
                "priority": 1,
                "rule_id": foo.id,
            }])
        foo_vpc = aws.ec2.Vpc("foo", cidr_block="10.1.0.0/16")
        available = aws.get_availability_zones()
        foo_subnet = aws.ec2.Subnet("foo",
            vpc_id=foo_vpc.id,
            cidr_block="10.1.1.0/24",
            availability_zone=available.names[0])
        bar = aws.ec2.Subnet("bar",
            vpc_id=foo_vpc.id,
            cidr_block="10.1.2.0/24",
            availability_zone=available.names[1])
        foo_load_balancer = aws.alb.LoadBalancer("foo",
            internal=True,
            subnets=[
                foo_subnet.id,
                bar.id,
            ])
        foo_web_acl_association = aws.wafregional.WebAclAssociation("foo",
            resource_arn=foo_load_balancer.arn,
            web_acl_id=foo_web_acl.id)
        ```

        ## Import

        Using `pulumi import`, import WAF Regional Web ACL Association using their `web_acl_id:resource_arn`. For example:

        ```sh
        $ pulumi import aws:wafregional/webAclAssociation:WebAclAssociation foo web_acl_id:resource_arn
        ```

        :param str resource_name: The name of the resource.
        :param WebAclAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAclAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 web_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAclAssociationArgs.__new__(WebAclAssociationArgs)

            __props__.__dict__["region"] = region
            if resource_arn is None and not opts.urn:
                raise TypeError("Missing required property 'resource_arn'")
            __props__.__dict__["resource_arn"] = resource_arn
            if web_acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'web_acl_id'")
            __props__.__dict__["web_acl_id"] = web_acl_id
        super(WebAclAssociation, __self__).__init__(
            'aws:wafregional/webAclAssociation:WebAclAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
            web_acl_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WebAclAssociation':
        """
        Get an existing WebAclAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_arn: ARN of the resource to associate with. For example, an Application Load Balancer or API Gateway Stage.
        :param pulumi.Input[_builtins.str] web_acl_id: The ID of the WAF Regional WebACL to create an association.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebAclAssociationState.__new__(_WebAclAssociationState)

        __props__.__dict__["region"] = region
        __props__.__dict__["resource_arn"] = resource_arn
        __props__.__dict__["web_acl_id"] = web_acl_id
        return WebAclAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the resource to associate with. For example, an Application Load Balancer or API Gateway Stage.
        """
        return pulumi.get(self, "resource_arn")

    @_builtins.property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the WAF Regional WebACL to create an association.
        """
        return pulumi.get(self, "web_acl_id")

