# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WebAclRuleGroupAssociationArgs', 'WebAclRuleGroupAssociation']

@pulumi.input_type
class WebAclRuleGroupAssociationArgs:
    def __init__(__self__, *,
                 priority: pulumi.Input[_builtins.int],
                 rule_name: pulumi.Input[_builtins.str],
                 web_acl_arn: pulumi.Input[_builtins.str],
                 managed_rule_group: Optional[pulumi.Input['WebAclRuleGroupAssociationManagedRuleGroupArgs']] = None,
                 override_action: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_group_reference: Optional[pulumi.Input['WebAclRuleGroupAssociationRuleGroupReferenceArgs']] = None,
                 timeouts: Optional[pulumi.Input['WebAclRuleGroupAssociationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a WebAclRuleGroupAssociation resource.
        :param pulumi.Input[_builtins.int] priority: Priority of the rule within the Web ACL. Rules are evaluated in order of priority, with lower numbers evaluated first.
        :param pulumi.Input[_builtins.str] rule_name: Name of the rule to create in the Web ACL that references the rule group. Must be between 1 and 128 characters.
        :param pulumi.Input[_builtins.str] web_acl_arn: ARN of the Web ACL to associate the Rule Group with.
               
               The following arguments are optional:
        :param pulumi.Input['WebAclRuleGroupAssociationManagedRuleGroupArgs'] managed_rule_group: Managed Rule Group configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `rule_group_reference`. See below.
        :param pulumi.Input[_builtins.str] override_action: Override action for the rule group. Valid values are `none` and `count`. Defaults to `none`. When set to `count`, the actions defined in the rule group rules are overridden to count matches instead of blocking or allowing requests.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['WebAclRuleGroupAssociationRuleGroupReferenceArgs'] rule_group_reference: Custom Rule Group reference configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `managed_rule_group`. See below.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "web_acl_arn", web_acl_arn)
        if managed_rule_group is not None:
            pulumi.set(__self__, "managed_rule_group", managed_rule_group)
        if override_action is not None:
            pulumi.set(__self__, "override_action", override_action)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_group_reference is not None:
            pulumi.set(__self__, "rule_group_reference", rule_group_reference)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        Priority of the rule within the Web ACL. Rules are evaluated in order of priority, with lower numbers evaluated first.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the rule to create in the Web ACL that references the rule group. Must be between 1 and 128 characters.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="webAclArn")
    def web_acl_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the Web ACL to associate the Rule Group with.

        The following arguments are optional:
        """
        return pulumi.get(self, "web_acl_arn")

    @web_acl_arn.setter
    def web_acl_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "web_acl_arn", value)

    @_builtins.property
    @pulumi.getter(name="managedRuleGroup")
    def managed_rule_group(self) -> Optional[pulumi.Input['WebAclRuleGroupAssociationManagedRuleGroupArgs']]:
        """
        Managed Rule Group configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `rule_group_reference`. See below.
        """
        return pulumi.get(self, "managed_rule_group")

    @managed_rule_group.setter
    def managed_rule_group(self, value: Optional[pulumi.Input['WebAclRuleGroupAssociationManagedRuleGroupArgs']]):
        pulumi.set(self, "managed_rule_group", value)

    @_builtins.property
    @pulumi.getter(name="overrideAction")
    def override_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override action for the rule group. Valid values are `none` and `count`. Defaults to `none`. When set to `count`, the actions defined in the rule group rules are overridden to count matches instead of blocking or allowing requests.
        """
        return pulumi.get(self, "override_action")

    @override_action.setter
    def override_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "override_action", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="ruleGroupReference")
    def rule_group_reference(self) -> Optional[pulumi.Input['WebAclRuleGroupAssociationRuleGroupReferenceArgs']]:
        """
        Custom Rule Group reference configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `managed_rule_group`. See below.
        """
        return pulumi.get(self, "rule_group_reference")

    @rule_group_reference.setter
    def rule_group_reference(self, value: Optional[pulumi.Input['WebAclRuleGroupAssociationRuleGroupReferenceArgs']]):
        pulumi.set(self, "rule_group_reference", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['WebAclRuleGroupAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['WebAclRuleGroupAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _WebAclRuleGroupAssociationState:
    def __init__(__self__, *,
                 managed_rule_group: Optional[pulumi.Input['WebAclRuleGroupAssociationManagedRuleGroupArgs']] = None,
                 override_action: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_group_reference: Optional[pulumi.Input['WebAclRuleGroupAssociationRuleGroupReferenceArgs']] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['WebAclRuleGroupAssociationTimeoutsArgs']] = None,
                 web_acl_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WebAclRuleGroupAssociation resources.
        :param pulumi.Input['WebAclRuleGroupAssociationManagedRuleGroupArgs'] managed_rule_group: Managed Rule Group configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `rule_group_reference`. See below.
        :param pulumi.Input[_builtins.str] override_action: Override action for the rule group. Valid values are `none` and `count`. Defaults to `none`. When set to `count`, the actions defined in the rule group rules are overridden to count matches instead of blocking or allowing requests.
        :param pulumi.Input[_builtins.int] priority: Priority of the rule within the Web ACL. Rules are evaluated in order of priority, with lower numbers evaluated first.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['WebAclRuleGroupAssociationRuleGroupReferenceArgs'] rule_group_reference: Custom Rule Group reference configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `managed_rule_group`. See below.
        :param pulumi.Input[_builtins.str] rule_name: Name of the rule to create in the Web ACL that references the rule group. Must be between 1 and 128 characters.
        :param pulumi.Input[_builtins.str] web_acl_arn: ARN of the Web ACL to associate the Rule Group with.
               
               The following arguments are optional:
        """
        if managed_rule_group is not None:
            pulumi.set(__self__, "managed_rule_group", managed_rule_group)
        if override_action is not None:
            pulumi.set(__self__, "override_action", override_action)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_group_reference is not None:
            pulumi.set(__self__, "rule_group_reference", rule_group_reference)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if web_acl_arn is not None:
            pulumi.set(__self__, "web_acl_arn", web_acl_arn)

    @_builtins.property
    @pulumi.getter(name="managedRuleGroup")
    def managed_rule_group(self) -> Optional[pulumi.Input['WebAclRuleGroupAssociationManagedRuleGroupArgs']]:
        """
        Managed Rule Group configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `rule_group_reference`. See below.
        """
        return pulumi.get(self, "managed_rule_group")

    @managed_rule_group.setter
    def managed_rule_group(self, value: Optional[pulumi.Input['WebAclRuleGroupAssociationManagedRuleGroupArgs']]):
        pulumi.set(self, "managed_rule_group", value)

    @_builtins.property
    @pulumi.getter(name="overrideAction")
    def override_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override action for the rule group. Valid values are `none` and `count`. Defaults to `none`. When set to `count`, the actions defined in the rule group rules are overridden to count matches instead of blocking or allowing requests.
        """
        return pulumi.get(self, "override_action")

    @override_action.setter
    def override_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "override_action", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority of the rule within the Web ACL. Rules are evaluated in order of priority, with lower numbers evaluated first.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="ruleGroupReference")
    def rule_group_reference(self) -> Optional[pulumi.Input['WebAclRuleGroupAssociationRuleGroupReferenceArgs']]:
        """
        Custom Rule Group reference configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `managed_rule_group`. See below.
        """
        return pulumi.get(self, "rule_group_reference")

    @rule_group_reference.setter
    def rule_group_reference(self, value: Optional[pulumi.Input['WebAclRuleGroupAssociationRuleGroupReferenceArgs']]):
        pulumi.set(self, "rule_group_reference", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rule to create in the Web ACL that references the rule group. Must be between 1 and 128 characters.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['WebAclRuleGroupAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['WebAclRuleGroupAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="webAclArn")
    def web_acl_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Web ACL to associate the Rule Group with.

        The following arguments are optional:
        """
        return pulumi.get(self, "web_acl_arn")

    @web_acl_arn.setter
    def web_acl_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_acl_arn", value)


@pulumi.type_token("aws:wafv2/webAclRuleGroupAssociation:WebAclRuleGroupAssociation")
class WebAclRuleGroupAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_rule_group: Optional[pulumi.Input[Union['WebAclRuleGroupAssociationManagedRuleGroupArgs', 'WebAclRuleGroupAssociationManagedRuleGroupArgsDict']]] = None,
                 override_action: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_group_reference: Optional[pulumi.Input[Union['WebAclRuleGroupAssociationRuleGroupReferenceArgs', 'WebAclRuleGroupAssociationRuleGroupReferenceArgsDict']]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['WebAclRuleGroupAssociationTimeoutsArgs', 'WebAclRuleGroupAssociationTimeoutsArgsDict']]] = None,
                 web_acl_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Associates a WAFv2 Rule Group (custom or managed) with a Web ACL by adding a rule that references the Rule Group. Use this resource to apply the rules defined in a Rule Group to a Web ACL without duplicating rule definitions.

        This resource supports both:

        - **Custom Rule Groups**: User-created rule groups that you manage within your AWS account
        - **Managed Rule Groups**: Pre-configured rule groups provided by AWS or third-party vendors

        !> **Warning:** Verify the rule names in your `rule_action_override`s carefully. With managed rule groups, WAF silently ignores any override that uses an invalid rule name. With customer-owned rule groups, invalid rule names in your overrides will cause web ACL updates to fail. An invalid rule name is any name that doesn't exactly match the case-sensitive name of an existing rule in the rule group.

        !> **Warning:** Using this resource will cause the associated Web ACL resource to show configuration drift in the `rule` argument unless you add `lifecycle { ignore_changes = [rule] }` to the Web ACL resource configuration. This is because this resource modifies the Web ACL's rules outside of the Web ACL resource's direct management.

        > **Note:** This resource creates a rule within the Web ACL that references the entire Rule Group. The rule group's individual rules are evaluated as a unit when requests are processed by the Web ACL.

        ## Example Usage

        ### Custom Rule Group - Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.wafv2.RuleGroup("example",
            name="example-rule-group",
            scope="REGIONAL",
            capacity=10,
            rules=[{
                "name": "block-suspicious-requests",
                "priority": 1,
                "action": {
                    "block": {},
                },
                "statement": {
                    "geo_match_statement": {
                        "country_codes": [
                            "CN",
                            "RU",
                        ],
                    },
                },
                "visibility_config": {
                    "cloudwatch_metrics_enabled": True,
                    "metric_name": "block-suspicious-requests",
                    "sampled_requests_enabled": True,
                },
            }],
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-rule-group",
                "sampled_requests_enabled": True,
            })
        example_web_acl = aws.wafv2.WebAcl("example",
            name="example-web-acl",
            scope="REGIONAL",
            default_action={
                "allow": {},
            },
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-web-acl",
                "sampled_requests_enabled": True,
            })
        example_web_acl_rule_group_association = aws.wafv2.WebAclRuleGroupAssociation("example",
            rule_name="example-rule-group-rule",
            priority=100,
            web_acl_arn=example_web_acl.arn,
            rule_group_reference={
                "arn": example.arn,
            })
        ```

        ### Managed Rule Group - Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.wafv2.WebAcl("example",
            name="example-web-acl",
            scope="REGIONAL",
            default_action={
                "allow": {},
            },
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-web-acl",
                "sampled_requests_enabled": True,
            })
        managed_example = aws.wafv2.WebAclRuleGroupAssociation("managed_example",
            rule_name="aws-common-rule-set",
            priority=50,
            web_acl_arn=example.arn,
            managed_rule_group={
                "name": "AWSManagedRulesCommonRuleSet",
                "vendor_name": "AWS",
            })
        ```

        ### Managed Rule Group - With Version

        ```python
        import pulumi
        import pulumi_aws as aws

        managed_versioned = aws.wafv2.WebAclRuleGroupAssociation("managed_versioned",
            rule_name="aws-common-rule-set-versioned",
            priority=60,
            web_acl_arn=example["arn"],
            managed_rule_group={
                "name": "AWSManagedRulesCommonRuleSet",
                "vendor_name": "AWS",
                "version": "Version_1.0",
            })
        ```

        ### Managed Rule Group - With Rule Action Overrides

        ```python
        import pulumi
        import pulumi_aws as aws

        managed_with_overrides = aws.wafv2.WebAclRuleGroupAssociation("managed_with_overrides",
            rule_name="aws-common-rule-set-with-overrides",
            priority=70,
            web_acl_arn=example["arn"],
            managed_rule_group={
                "name": "AWSManagedRulesCommonRuleSet",
                "vendor_name": "AWS",
                "rule_action_overrides": [
                    {
                        "name": "GenericRFI_BODY",
                        "action_to_use": {
                            "count": {
                                "custom_request_handling": {
                                    "insert_headers": [{
                                        "name": "X-RFI-Override",
                                        "value": "counted",
                                    }],
                                },
                            },
                        },
                    },
                    {
                        "name": "SizeRestrictions_BODY",
                        "action_to_use": {
                            "captcha": {},
                        },
                    },
                ],
            })
        ```

        ### Custom Rule Group - With Override Action

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.wafv2.WebAclRuleGroupAssociation("example",
            rule_name="example-rule-group-rule",
            priority=100,
            web_acl_arn=example_aws_wafv2_web_acl["arn"],
            override_action="count",
            rule_group_reference={
                "arn": example_aws_wafv2_rule_group["arn"],
            })
        ```

        ### Custom Rule Group - With Rule Action Overrides

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.wafv2.RuleGroup("example",
            name="example-rule-group",
            scope="REGIONAL",
            capacity=10,
            rules=[
                {
                    "name": "geo-block-rule",
                    "priority": 1,
                    "action": {
                        "block": {},
                    },
                    "statement": {
                        "geo_match_statement": {
                            "country_codes": [
                                "CN",
                                "RU",
                            ],
                        },
                    },
                    "visibility_config": {
                        "cloudwatch_metrics_enabled": True,
                        "metric_name": "geo-block-rule",
                        "sampled_requests_enabled": True,
                    },
                },
                {
                    "name": "rate-limit-rule",
                    "priority": 2,
                    "action": {
                        "block": {},
                    },
                    "statement": {
                        "rate_based_statement": {
                            "limit": 1000,
                            "aggregate_key_type": "IP",
                        },
                    },
                    "visibility_config": {
                        "cloudwatch_metrics_enabled": True,
                        "metric_name": "rate-limit-rule",
                        "sampled_requests_enabled": True,
                    },
                },
            ],
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-rule-group",
                "sampled_requests_enabled": True,
            })
        example_web_acl = aws.wafv2.WebAcl("example",
            name="example-web-acl",
            scope="REGIONAL",
            default_action={
                "allow": {},
            },
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-web-acl",
                "sampled_requests_enabled": True,
            })
        example_web_acl_rule_group_association = aws.wafv2.WebAclRuleGroupAssociation("example",
            rule_name="example-rule-group-rule",
            priority=100,
            web_acl_arn=example_web_acl.arn,
            rule_group_reference={
                "arn": example.arn,
                "rule_action_overrides": [
                    {
                        "name": "geo-block-rule",
                        "action_to_use": {
                            "count": {
                                "custom_request_handling": {
                                    "insert_headers": [{
                                        "name": "X-Geo-Block-Override",
                                        "value": "counted",
                                    }],
                                },
                            },
                        },
                    },
                    {
                        "name": "rate-limit-rule",
                        "action_to_use": {
                            "captcha": {
                                "custom_request_handling": {
                                    "insert_headers": [{
                                        "name": "X-Rate-Limit-Override",
                                        "value": "captcha-required",
                                    }],
                                },
                            },
                        },
                    },
                ],
            })
        ```

        ### Custom Rule Group - CloudFront Web ACL

        ```python
        import pulumi
        import pulumi_aws as aws

        cloudfront_example = aws.wafv2.RuleGroup("cloudfront_example",
            name="cloudfront-rule-group",
            scope="CLOUDFRONT",
            capacity=10,
            rules=[{
                "name": "rate-limit",
                "priority": 1,
                "action": {
                    "block": {},
                },
                "statement": {
                    "rate_based_statement": {
                        "limit": 2000,
                        "aggregate_key_type": "IP",
                    },
                },
                "visibility_config": {
                    "cloudwatch_metrics_enabled": True,
                    "metric_name": "rate-limit",
                    "sampled_requests_enabled": True,
                },
            }],
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "cloudfront-rule-group",
                "sampled_requests_enabled": True,
            })
        cloudfront_example_web_acl = aws.wafv2.WebAcl("cloudfront_example",
            name="cloudfront-web-acl",
            scope="CLOUDFRONT",
            default_action={
                "allow": {},
            },
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "cloudfront-web-acl",
                "sampled_requests_enabled": True,
            })
        cloudfront_example_web_acl_rule_group_association = aws.wafv2.WebAclRuleGroupAssociation("cloudfront_example",
            rule_name="cloudfront-rule-group-rule",
            priority=50,
            web_acl_arn=cloudfront_example_web_acl.arn,
            rule_group_reference={
                "arn": cloudfront_example.arn,
            })
        ```

        ## Import

        Using `pulumi import`, import WAFv2 web ACL custom rule group associations using `WebACLARN,RuleGroupARN,RuleName`. For example:

        ```sh
        $ pulumi import aws:wafv2/webAclRuleGroupAssociation:WebAclRuleGroupAssociation example "arn:aws:wafv2:us-east-1:123456789012:regional/webacl/example-web-acl/12345678-1234-1234-1234-123456789012,arn:aws:wafv2:us-east-1:123456789012:regional/rulegroup/example-rule-group/87654321-4321-4321-4321-210987654321,example-rule-group-rule"
        ```
        Using `pulumi import`, import WAFv2 web ACL managed rule group associations using `WebACLARN,VendorName:RuleGroupName[:Version],RuleName`. For example:

        ```sh
        $ pulumi import aws:wafv2/webAclRuleGroupAssociation:WebAclRuleGroupAssociation managed_example "arn:aws:wafv2:us-east-1:123456789012:regional/webacl/example-web-acl/12345678-1234-1234-1234-123456789012,AWS:AWSManagedRulesCommonRuleSet,aws-common-rule-set"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WebAclRuleGroupAssociationManagedRuleGroupArgs', 'WebAclRuleGroupAssociationManagedRuleGroupArgsDict']] managed_rule_group: Managed Rule Group configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `rule_group_reference`. See below.
        :param pulumi.Input[_builtins.str] override_action: Override action for the rule group. Valid values are `none` and `count`. Defaults to `none`. When set to `count`, the actions defined in the rule group rules are overridden to count matches instead of blocking or allowing requests.
        :param pulumi.Input[_builtins.int] priority: Priority of the rule within the Web ACL. Rules are evaluated in order of priority, with lower numbers evaluated first.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['WebAclRuleGroupAssociationRuleGroupReferenceArgs', 'WebAclRuleGroupAssociationRuleGroupReferenceArgsDict']] rule_group_reference: Custom Rule Group reference configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `managed_rule_group`. See below.
        :param pulumi.Input[_builtins.str] rule_name: Name of the rule to create in the Web ACL that references the rule group. Must be between 1 and 128 characters.
        :param pulumi.Input[_builtins.str] web_acl_arn: ARN of the Web ACL to associate the Rule Group with.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebAclRuleGroupAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates a WAFv2 Rule Group (custom or managed) with a Web ACL by adding a rule that references the Rule Group. Use this resource to apply the rules defined in a Rule Group to a Web ACL without duplicating rule definitions.

        This resource supports both:

        - **Custom Rule Groups**: User-created rule groups that you manage within your AWS account
        - **Managed Rule Groups**: Pre-configured rule groups provided by AWS or third-party vendors

        !> **Warning:** Verify the rule names in your `rule_action_override`s carefully. With managed rule groups, WAF silently ignores any override that uses an invalid rule name. With customer-owned rule groups, invalid rule names in your overrides will cause web ACL updates to fail. An invalid rule name is any name that doesn't exactly match the case-sensitive name of an existing rule in the rule group.

        !> **Warning:** Using this resource will cause the associated Web ACL resource to show configuration drift in the `rule` argument unless you add `lifecycle { ignore_changes = [rule] }` to the Web ACL resource configuration. This is because this resource modifies the Web ACL's rules outside of the Web ACL resource's direct management.

        > **Note:** This resource creates a rule within the Web ACL that references the entire Rule Group. The rule group's individual rules are evaluated as a unit when requests are processed by the Web ACL.

        ## Example Usage

        ### Custom Rule Group - Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.wafv2.RuleGroup("example",
            name="example-rule-group",
            scope="REGIONAL",
            capacity=10,
            rules=[{
                "name": "block-suspicious-requests",
                "priority": 1,
                "action": {
                    "block": {},
                },
                "statement": {
                    "geo_match_statement": {
                        "country_codes": [
                            "CN",
                            "RU",
                        ],
                    },
                },
                "visibility_config": {
                    "cloudwatch_metrics_enabled": True,
                    "metric_name": "block-suspicious-requests",
                    "sampled_requests_enabled": True,
                },
            }],
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-rule-group",
                "sampled_requests_enabled": True,
            })
        example_web_acl = aws.wafv2.WebAcl("example",
            name="example-web-acl",
            scope="REGIONAL",
            default_action={
                "allow": {},
            },
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-web-acl",
                "sampled_requests_enabled": True,
            })
        example_web_acl_rule_group_association = aws.wafv2.WebAclRuleGroupAssociation("example",
            rule_name="example-rule-group-rule",
            priority=100,
            web_acl_arn=example_web_acl.arn,
            rule_group_reference={
                "arn": example.arn,
            })
        ```

        ### Managed Rule Group - Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.wafv2.WebAcl("example",
            name="example-web-acl",
            scope="REGIONAL",
            default_action={
                "allow": {},
            },
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-web-acl",
                "sampled_requests_enabled": True,
            })
        managed_example = aws.wafv2.WebAclRuleGroupAssociation("managed_example",
            rule_name="aws-common-rule-set",
            priority=50,
            web_acl_arn=example.arn,
            managed_rule_group={
                "name": "AWSManagedRulesCommonRuleSet",
                "vendor_name": "AWS",
            })
        ```

        ### Managed Rule Group - With Version

        ```python
        import pulumi
        import pulumi_aws as aws

        managed_versioned = aws.wafv2.WebAclRuleGroupAssociation("managed_versioned",
            rule_name="aws-common-rule-set-versioned",
            priority=60,
            web_acl_arn=example["arn"],
            managed_rule_group={
                "name": "AWSManagedRulesCommonRuleSet",
                "vendor_name": "AWS",
                "version": "Version_1.0",
            })
        ```

        ### Managed Rule Group - With Rule Action Overrides

        ```python
        import pulumi
        import pulumi_aws as aws

        managed_with_overrides = aws.wafv2.WebAclRuleGroupAssociation("managed_with_overrides",
            rule_name="aws-common-rule-set-with-overrides",
            priority=70,
            web_acl_arn=example["arn"],
            managed_rule_group={
                "name": "AWSManagedRulesCommonRuleSet",
                "vendor_name": "AWS",
                "rule_action_overrides": [
                    {
                        "name": "GenericRFI_BODY",
                        "action_to_use": {
                            "count": {
                                "custom_request_handling": {
                                    "insert_headers": [{
                                        "name": "X-RFI-Override",
                                        "value": "counted",
                                    }],
                                },
                            },
                        },
                    },
                    {
                        "name": "SizeRestrictions_BODY",
                        "action_to_use": {
                            "captcha": {},
                        },
                    },
                ],
            })
        ```

        ### Custom Rule Group - With Override Action

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.wafv2.WebAclRuleGroupAssociation("example",
            rule_name="example-rule-group-rule",
            priority=100,
            web_acl_arn=example_aws_wafv2_web_acl["arn"],
            override_action="count",
            rule_group_reference={
                "arn": example_aws_wafv2_rule_group["arn"],
            })
        ```

        ### Custom Rule Group - With Rule Action Overrides

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.wafv2.RuleGroup("example",
            name="example-rule-group",
            scope="REGIONAL",
            capacity=10,
            rules=[
                {
                    "name": "geo-block-rule",
                    "priority": 1,
                    "action": {
                        "block": {},
                    },
                    "statement": {
                        "geo_match_statement": {
                            "country_codes": [
                                "CN",
                                "RU",
                            ],
                        },
                    },
                    "visibility_config": {
                        "cloudwatch_metrics_enabled": True,
                        "metric_name": "geo-block-rule",
                        "sampled_requests_enabled": True,
                    },
                },
                {
                    "name": "rate-limit-rule",
                    "priority": 2,
                    "action": {
                        "block": {},
                    },
                    "statement": {
                        "rate_based_statement": {
                            "limit": 1000,
                            "aggregate_key_type": "IP",
                        },
                    },
                    "visibility_config": {
                        "cloudwatch_metrics_enabled": True,
                        "metric_name": "rate-limit-rule",
                        "sampled_requests_enabled": True,
                    },
                },
            ],
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-rule-group",
                "sampled_requests_enabled": True,
            })
        example_web_acl = aws.wafv2.WebAcl("example",
            name="example-web-acl",
            scope="REGIONAL",
            default_action={
                "allow": {},
            },
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "example-web-acl",
                "sampled_requests_enabled": True,
            })
        example_web_acl_rule_group_association = aws.wafv2.WebAclRuleGroupAssociation("example",
            rule_name="example-rule-group-rule",
            priority=100,
            web_acl_arn=example_web_acl.arn,
            rule_group_reference={
                "arn": example.arn,
                "rule_action_overrides": [
                    {
                        "name": "geo-block-rule",
                        "action_to_use": {
                            "count": {
                                "custom_request_handling": {
                                    "insert_headers": [{
                                        "name": "X-Geo-Block-Override",
                                        "value": "counted",
                                    }],
                                },
                            },
                        },
                    },
                    {
                        "name": "rate-limit-rule",
                        "action_to_use": {
                            "captcha": {
                                "custom_request_handling": {
                                    "insert_headers": [{
                                        "name": "X-Rate-Limit-Override",
                                        "value": "captcha-required",
                                    }],
                                },
                            },
                        },
                    },
                ],
            })
        ```

        ### Custom Rule Group - CloudFront Web ACL

        ```python
        import pulumi
        import pulumi_aws as aws

        cloudfront_example = aws.wafv2.RuleGroup("cloudfront_example",
            name="cloudfront-rule-group",
            scope="CLOUDFRONT",
            capacity=10,
            rules=[{
                "name": "rate-limit",
                "priority": 1,
                "action": {
                    "block": {},
                },
                "statement": {
                    "rate_based_statement": {
                        "limit": 2000,
                        "aggregate_key_type": "IP",
                    },
                },
                "visibility_config": {
                    "cloudwatch_metrics_enabled": True,
                    "metric_name": "rate-limit",
                    "sampled_requests_enabled": True,
                },
            }],
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "cloudfront-rule-group",
                "sampled_requests_enabled": True,
            })
        cloudfront_example_web_acl = aws.wafv2.WebAcl("cloudfront_example",
            name="cloudfront-web-acl",
            scope="CLOUDFRONT",
            default_action={
                "allow": {},
            },
            visibility_config={
                "cloudwatch_metrics_enabled": True,
                "metric_name": "cloudfront-web-acl",
                "sampled_requests_enabled": True,
            })
        cloudfront_example_web_acl_rule_group_association = aws.wafv2.WebAclRuleGroupAssociation("cloudfront_example",
            rule_name="cloudfront-rule-group-rule",
            priority=50,
            web_acl_arn=cloudfront_example_web_acl.arn,
            rule_group_reference={
                "arn": cloudfront_example.arn,
            })
        ```

        ## Import

        Using `pulumi import`, import WAFv2 web ACL custom rule group associations using `WebACLARN,RuleGroupARN,RuleName`. For example:

        ```sh
        $ pulumi import aws:wafv2/webAclRuleGroupAssociation:WebAclRuleGroupAssociation example "arn:aws:wafv2:us-east-1:123456789012:regional/webacl/example-web-acl/12345678-1234-1234-1234-123456789012,arn:aws:wafv2:us-east-1:123456789012:regional/rulegroup/example-rule-group/87654321-4321-4321-4321-210987654321,example-rule-group-rule"
        ```
        Using `pulumi import`, import WAFv2 web ACL managed rule group associations using `WebACLARN,VendorName:RuleGroupName[:Version],RuleName`. For example:

        ```sh
        $ pulumi import aws:wafv2/webAclRuleGroupAssociation:WebAclRuleGroupAssociation managed_example "arn:aws:wafv2:us-east-1:123456789012:regional/webacl/example-web-acl/12345678-1234-1234-1234-123456789012,AWS:AWSManagedRulesCommonRuleSet,aws-common-rule-set"
        ```

        :param str resource_name: The name of the resource.
        :param WebAclRuleGroupAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAclRuleGroupAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_rule_group: Optional[pulumi.Input[Union['WebAclRuleGroupAssociationManagedRuleGroupArgs', 'WebAclRuleGroupAssociationManagedRuleGroupArgsDict']]] = None,
                 override_action: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_group_reference: Optional[pulumi.Input[Union['WebAclRuleGroupAssociationRuleGroupReferenceArgs', 'WebAclRuleGroupAssociationRuleGroupReferenceArgsDict']]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['WebAclRuleGroupAssociationTimeoutsArgs', 'WebAclRuleGroupAssociationTimeoutsArgsDict']]] = None,
                 web_acl_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAclRuleGroupAssociationArgs.__new__(WebAclRuleGroupAssociationArgs)

            __props__.__dict__["managed_rule_group"] = managed_rule_group
            __props__.__dict__["override_action"] = override_action
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["region"] = region
            __props__.__dict__["rule_group_reference"] = rule_group_reference
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["timeouts"] = timeouts
            if web_acl_arn is None and not opts.urn:
                raise TypeError("Missing required property 'web_acl_arn'")
            __props__.__dict__["web_acl_arn"] = web_acl_arn
        super(WebAclRuleGroupAssociation, __self__).__init__(
            'aws:wafv2/webAclRuleGroupAssociation:WebAclRuleGroupAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_rule_group: Optional[pulumi.Input[Union['WebAclRuleGroupAssociationManagedRuleGroupArgs', 'WebAclRuleGroupAssociationManagedRuleGroupArgsDict']]] = None,
            override_action: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rule_group_reference: Optional[pulumi.Input[Union['WebAclRuleGroupAssociationRuleGroupReferenceArgs', 'WebAclRuleGroupAssociationRuleGroupReferenceArgsDict']]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['WebAclRuleGroupAssociationTimeoutsArgs', 'WebAclRuleGroupAssociationTimeoutsArgsDict']]] = None,
            web_acl_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'WebAclRuleGroupAssociation':
        """
        Get an existing WebAclRuleGroupAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WebAclRuleGroupAssociationManagedRuleGroupArgs', 'WebAclRuleGroupAssociationManagedRuleGroupArgsDict']] managed_rule_group: Managed Rule Group configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `rule_group_reference`. See below.
        :param pulumi.Input[_builtins.str] override_action: Override action for the rule group. Valid values are `none` and `count`. Defaults to `none`. When set to `count`, the actions defined in the rule group rules are overridden to count matches instead of blocking or allowing requests.
        :param pulumi.Input[_builtins.int] priority: Priority of the rule within the Web ACL. Rules are evaluated in order of priority, with lower numbers evaluated first.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['WebAclRuleGroupAssociationRuleGroupReferenceArgs', 'WebAclRuleGroupAssociationRuleGroupReferenceArgsDict']] rule_group_reference: Custom Rule Group reference configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `managed_rule_group`. See below.
        :param pulumi.Input[_builtins.str] rule_name: Name of the rule to create in the Web ACL that references the rule group. Must be between 1 and 128 characters.
        :param pulumi.Input[_builtins.str] web_acl_arn: ARN of the Web ACL to associate the Rule Group with.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebAclRuleGroupAssociationState.__new__(_WebAclRuleGroupAssociationState)

        __props__.__dict__["managed_rule_group"] = managed_rule_group
        __props__.__dict__["override_action"] = override_action
        __props__.__dict__["priority"] = priority
        __props__.__dict__["region"] = region
        __props__.__dict__["rule_group_reference"] = rule_group_reference
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["web_acl_arn"] = web_acl_arn
        return WebAclRuleGroupAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="managedRuleGroup")
    def managed_rule_group(self) -> pulumi.Output[Optional['outputs.WebAclRuleGroupAssociationManagedRuleGroup']]:
        """
        Managed Rule Group configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `rule_group_reference`. See below.
        """
        return pulumi.get(self, "managed_rule_group")

    @_builtins.property
    @pulumi.getter(name="overrideAction")
    def override_action(self) -> pulumi.Output[_builtins.str]:
        """
        Override action for the rule group. Valid values are `none` and `count`. Defaults to `none`. When set to `count`, the actions defined in the rule group rules are overridden to count matches instead of blocking or allowing requests.
        """
        return pulumi.get(self, "override_action")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        Priority of the rule within the Web ACL. Rules are evaluated in order of priority, with lower numbers evaluated first.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="ruleGroupReference")
    def rule_group_reference(self) -> pulumi.Output[Optional['outputs.WebAclRuleGroupAssociationRuleGroupReference']]:
        """
        Custom Rule Group reference configuration. One of `rule_group_reference` or `managed_rule_group` is required. Conflicts with `managed_rule_group`. See below.
        """
        return pulumi.get(self, "rule_group_reference")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the rule to create in the Web ACL that references the rule group. Must be between 1 and 128 characters.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.WebAclRuleGroupAssociationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="webAclArn")
    def web_acl_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Web ACL to associate the Rule Group with.

        The following arguments are optional:
        """
        return pulumi.get(self, "web_acl_arn")

