# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserAccessLoggingSettingsAssociationArgs', 'UserAccessLoggingSettingsAssociation']

@pulumi.input_type
class UserAccessLoggingSettingsAssociationArgs:
    def __init__(__self__, *,
                 portal_arn: pulumi.Input[_builtins.str],
                 user_access_logging_settings_arn: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserAccessLoggingSettingsAssociation resource.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal to associate with the user access logging settings. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] user_access_logging_settings_arn: ARN of the user access logging settings to associate with the portal. Forces replacement if changed.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "portal_arn", portal_arn)
        pulumi.set(__self__, "user_access_logging_settings_arn", user_access_logging_settings_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the portal to associate with the user access logging settings. Forces replacement if changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "portal_arn")

    @portal_arn.setter
    def portal_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "portal_arn", value)

    @_builtins.property
    @pulumi.getter(name="userAccessLoggingSettingsArn")
    def user_access_logging_settings_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the user access logging settings to associate with the portal. Forces replacement if changed.
        """
        return pulumi.get(self, "user_access_logging_settings_arn")

    @user_access_logging_settings_arn.setter
    def user_access_logging_settings_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_access_logging_settings_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _UserAccessLoggingSettingsAssociationState:
    def __init__(__self__, *,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_access_logging_settings_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserAccessLoggingSettingsAssociation resources.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal to associate with the user access logging settings. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] user_access_logging_settings_arn: ARN of the user access logging settings to associate with the portal. Forces replacement if changed.
        """
        if portal_arn is not None:
            pulumi.set(__self__, "portal_arn", portal_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if user_access_logging_settings_arn is not None:
            pulumi.set(__self__, "user_access_logging_settings_arn", user_access_logging_settings_arn)

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the portal to associate with the user access logging settings. Forces replacement if changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "portal_arn")

    @portal_arn.setter
    def portal_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="userAccessLoggingSettingsArn")
    def user_access_logging_settings_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the user access logging settings to associate with the portal. Forces replacement if changed.
        """
        return pulumi.get(self, "user_access_logging_settings_arn")

    @user_access_logging_settings_arn.setter
    def user_access_logging_settings_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_access_logging_settings_arn", value)


@pulumi.type_token("aws:workspacesweb/userAccessLoggingSettingsAssociation:UserAccessLoggingSettingsAssociation")
class UserAccessLoggingSettingsAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_access_logging_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS WorkSpaces Web User Access Logging Settings Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.Portal("example", display_name="example")
        example_stream = aws.kinesis.Stream("example",
            name="amazon-workspaces-web-example",
            shard_count=1)
        example_user_access_logging_settings = aws.workspacesweb.UserAccessLoggingSettings("example", kinesis_stream_arn=example_stream.arn)
        example_user_access_logging_settings_association = aws.workspacesweb.UserAccessLoggingSettingsAssociation("example",
            user_access_logging_settings_arn=example_user_access_logging_settings.user_access_logging_settings_arn,
            portal_arn=example.portal_arn)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal to associate with the user access logging settings. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] user_access_logging_settings_arn: ARN of the user access logging settings to associate with the portal. Forces replacement if changed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserAccessLoggingSettingsAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS WorkSpaces Web User Access Logging Settings Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.workspacesweb.Portal("example", display_name="example")
        example_stream = aws.kinesis.Stream("example",
            name="amazon-workspaces-web-example",
            shard_count=1)
        example_user_access_logging_settings = aws.workspacesweb.UserAccessLoggingSettings("example", kinesis_stream_arn=example_stream.arn)
        example_user_access_logging_settings_association = aws.workspacesweb.UserAccessLoggingSettingsAssociation("example",
            user_access_logging_settings_arn=example_user_access_logging_settings.user_access_logging_settings_arn,
            portal_arn=example.portal_arn)
        ```

        :param str resource_name: The name of the resource.
        :param UserAccessLoggingSettingsAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserAccessLoggingSettingsAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_access_logging_settings_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserAccessLoggingSettingsAssociationArgs.__new__(UserAccessLoggingSettingsAssociationArgs)

            if portal_arn is None and not opts.urn:
                raise TypeError("Missing required property 'portal_arn'")
            __props__.__dict__["portal_arn"] = portal_arn
            __props__.__dict__["region"] = region
            if user_access_logging_settings_arn is None and not opts.urn:
                raise TypeError("Missing required property 'user_access_logging_settings_arn'")
            __props__.__dict__["user_access_logging_settings_arn"] = user_access_logging_settings_arn
        super(UserAccessLoggingSettingsAssociation, __self__).__init__(
            'aws:workspacesweb/userAccessLoggingSettingsAssociation:UserAccessLoggingSettingsAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            portal_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            user_access_logging_settings_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserAccessLoggingSettingsAssociation':
        """
        Get an existing UserAccessLoggingSettingsAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] portal_arn: ARN of the portal to associate with the user access logging settings. Forces replacement if changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] user_access_logging_settings_arn: ARN of the user access logging settings to associate with the portal. Forces replacement if changed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserAccessLoggingSettingsAssociationState.__new__(_UserAccessLoggingSettingsAssociationState)

        __props__.__dict__["portal_arn"] = portal_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["user_access_logging_settings_arn"] = user_access_logging_settings_arn
        return UserAccessLoggingSettingsAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the portal to associate with the user access logging settings. Forces replacement if changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "portal_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="userAccessLoggingSettingsArn")
    def user_access_logging_settings_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the user access logging settings to associate with the portal. Forces replacement if changed.
        """
        return pulumi.get(self, "user_access_logging_settings_arn")

