import unittest
from unittest.mock import patch, MagicMock
from nlannuzel.sgrain.rain import RainAreas
from nlannuzel.sgrain.geo import Location
from nlannuzel.sgrain.graph import Pixel, Color
import datetime

@patch("urllib.request.urlopen")
def mock_load_image(rain, test_image, mock_urlopen):
    # dpsri_70km_2025101516e300000dBR.dpsri.png
    # image from 2025/10/15 16:30
    test_images = {
        'basic': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\xd9\x00\x00\x00x\x08\x06\x00\x00\x00\x7f\xfeW=\x00\x00\x03oIDATx\xda\xed\xdd1n\x13A\x14\x06`wT\x14\x1c#\x07@B\xa2B\x08\xc4y\xe8\x91\x90\xa8\xc8\x05\x90(\x91\xb8\x00M$\x1a:\n\xba\x144(w\x08\r\xf5\xb2\xffz\x9f\xbd@\x12\xe2x\'v\x92\xef\xb3Fk\xc7\xa41\xf9\xfdffgv\x17\x0b\xd8\x85\xe3\xef\x9d\x0f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x86z\xf7\xde\xbd\xa8`\xafCvz\xba\xd9\xefw\x9dPC\xd3\x90\x01\xc0\xfe\xd1\x05\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x87=y\xd0\x98K@\x00\x00\x00l\xc6%\x17\xa0\xa1\xcc\x06\x1e\x7f\xef\x04\xcd\x97\x16-}\xfe\xd2\r\xcd\xf4;\xcc(\xd5\xab*X\x02\x96\xa9\xf77\xaf\x96?\x03\xb6\xacZ\t\xd4\xb7\x07\xcbV\xc1\xca\xf1\xf5\xb3\xe51\xfff\xda\x9d\x046\xac`\t\xd7\x87\x87\xeb\x90U5K\xc8\x8e\x0e\x96\xef\xe5\x08\xcc4H\xaf\xaebBV\xe1K\xfbuo\x19\xb6ie\x03\xae \x01{\xfbh]\xc1\xd2*diy\x9e\xf7u\x1d\xe1\x8a*`iy\x9e\x96\xa0\xd51A\xfbq\xbf\xb3.\x11\xae\xda]\xac\x80U\x05\xab\x80U\x17Rw\x11\xb6\x08X\xdat"\xa4\x02\x97`9I\r\x17\x84\xe7\xb2j\x9cU\x93\x1fy-X\x00\xdc\xadj\x88?\x06`[\x19Gd\xd0\x0e4\xa8X5\x1b&d\xb0e\xa5\xaaY\xb0\x1ckkF-\t\xaa\x95\t\xc0\x16\x01\xabuuYy\xd0?\x9evO\xd6\xab\xc6\x8f\x0e\xba\x17\xdd\xf3\xa1Y\x95`\x0c\xcc\xa6rB\xb4V\x88\xf7\xd5*A\x1aO\xa1.\x03Wk\xed\xfa\xf7\xba\xee\xf1\xb2\xa2\xe5w\xea\x84\xaa\xf5v\xf0\x9f*V]\xc3\x84\xa6\x7f\x0c!\xfb\xd4\x87\xec\xebb8\x0e\x15-a\xeb\xc3\x95\xe7\xab\xd7\xb5\x8d\xe3\xac\x90\t\x1e\xfc\x15\xb2\xac\xa3\xeb\x83\xb3\xaab\x87\x93\xf6r1T\xb0\xbc\x97\x80\xe5\xf9P\xe5\xf2\xa8\xa0\x01\xe7\xa8*\x96\xee\xe0\xd8E\xecN&\xe1\xca\xf1\xe3\xf8\xb3\xb1\xca\xad\xc6k\xf5H7\xd38\x02\xceQ\xeb\xe9R\xc92\xe6\xfa9\x86\xeap\x0c\xd6\xc9\xba\xdbX!\x1b\x026\x8e\xdd\x86J\x96\x90\x01\x17Lz$h\xb5\xdfi\x9c\xaa\xef\xc6j\xb5\nU\x1e\x15\xac\xda\xf7\x94p\xa6\x99m\x9c\x8f\x1e\xc1-\xaefi\x93)\xfc\xd5t\xfdtF\xb1\xa6\xf7\xcd*\xb6\x1b\x1f\xfb\xc2\xba\xc5\xdf\x9eu\x01\xce\xfc\'\xf7!\x1a\x82\x95G\xc6j\xe3\xcc\xe2j\x93a^\xeb"\xc2\x06\xdf\x9e\x15\xb4\xb4\x84\xa7o5\xee\x1aZ]\xe2\xac\xae#X\x977s\xfd@\xd8"tc\x97\xf1\x8fq\x82\xf1B\xfb\xcf^\x17\xfc\x8eH\x17\xf1\xbcs_\xfe\x08\xa0AU\xe3\xfa\xc6\xc6\x00\x00\x00\x00\x00\xb0C\xa6\xaa\xa11\xe7\xdf\x00\xa0\xd4"e]P\x8c\xb3\x1a\xa9\xdd\x01B\xc6\xde\xc9\xde\xb0\xdb\x12\xec\x04M\xc8\xd8;\xd3U\xf6-\xf6\x85\xb5\xfe\xa3\xaf\x8d\xa6\xb0\xf7\xd5\xac\xd5\xc6\xcb\xdai\r\xaaY\x83JV\x9b\x0fU\x1a\x00\x80\x1ba\xdbn\xdb\xf4b;\xc0\x19r\xb5\xa9]\x07\x15\xb8$\xd5\xccg\n7\xae+_\xf7\x87\xab+9\xcf\xd1\xf3\xe0\x8e\x8f\xf1\xf87d\xd3\x80\xf9|\x11\xb4\x99\xc7\xcbu\x97\xd3\x9c\xb7\x142h0\x1eK\xa8V7\x106>cW\xdf\xf6@#u\xdf4\xdf\xf0\xd08h\xc6)\xd0\xc0\xf4\x1ehn\xfe\x0e3K\xa8j\xc6\r\x98Q\xba\x855\xad==\x7f\x04\xcc\x1c\xb4\xba\x7f\xb2;zBc\xaa\x18\x00\xc0L~\x03>\xe7\x90\n\xb3\xf2\xfe\xcd\x00\x00\x00\x00IEND\xaeB`\x82',
        'big_blob': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\xd9\x00\x00\x00x\x08\x06\x00\x00\x00\x7f\xfeW=\x00\x00\x18;IDATx\xda\xed]\xbd\xce\xe4Z\x11\xfc2"\x02\x1e\x83\x07@B\xba\xd1\xd5\x15\x88\x97BB"\x82\x17@"\xe4%\x90H\xc8\xc9\x08Hx\x89\x1b\x11\x7f\xacw\xb7\xf7\xf6\xd6VU\xf7\xf1\xd8\x1e\x8f}\xce\xca\xda\xdd\xef\x9b\x1f\x8f\xe7\x94\xbb\xbb\xba\xbb\xfa\xed\xed\x15\xd6\xfb\xfb\xfb\xdb\xbf\xff\xf3\xfe\xf6\x8f\x7f\xfet,\xff\xcf\xc7\x8f?~:\x96\xc7\xc6\xbf\xf3s\xfe\xf2\xd7O\xc7\x1f\x7f\xff\xfe\xf6\xf7_~x\xdc\x87?\x7f\xfa\xf5\xa7\xff/\xbf_\x1e\xbf\xe7Z^\x1f\xcf;\xce7\xff\x1e\xcfw9\xe2y{\x9f\xe3#k9\xbf\xb8\xbeq\xc4\xff\xf1s\xc4\x11\x9f}\xed\x9e\xc0\xef8\xef\x8d\xb8\x86\xcb\xfb\xff\xe17\xdf\x1eq^\xf1\x1d\xc4\xeb\xc5w\x91\x7f\xbe\xbc^^\xcbk\xe7\xbf\xf3\x8a\xcf\xf9R+_L\x04\x93\x03d\xbe\xd0\xf8\xe5/ \xfb\xef\xcf?]\xec\xb8\xd0G\x00,\x00\xedn\x16q\xbe\xec\x06R}\xf6g}?q\xcdqS/7\xb18\xf2\xc6\x8ec\xed\xe7\xc87\xa4\xfc\xdd\xe6\xd7f\xe0\xc2\x1b@\x00=\xdf\x983\xb8\xcet\x9d\x0f\x05[\xd7\xea\xe5\r\x8bw\xd6\xb0`\xcb\x81w\xa9=\x16Z&\xb6)\xf2\xefb\x03 \xb8\xe28\xd3\xf7\x91\xadI\xde\xdc\x7f\xfb\xd5O\x07\x82,n.\xa3\x9bxy<\x02K\x1d\xcaz\xe5s\xc8\xef\x9fAU\xdd\xc0o\xbd\xd0\x85\xc0\r\x9d\xdd\xaex\xdcQnT\xbc?\x03Yl\x8a\xfc3\xe6R\x9e\xe5\xee\x8a\x96\x04?[\xb6`h\xc9\xc25w\x9f\x83}\xce\xec\r(\xe00\x901\x00*\xef\xe5v\x96k\x0b\x80e\xcbpD\xdc\xc5\x00\x86_.\x02-\xbbU\xe1\xbe\xae\xbd\xd3\x1f\t0\x15o-\xffVV$\x03L}6\xe6\xb2e\x0b\xa6\x00\xe6\xac\x1b\xde\xcc\xd0\x8a\xcd5\x000F\x1ad\xdf\xfb\x19\x1b\x92mF\xfc\xd2\x11dG\x92\x1c#\xd7%6;Z\x8a\x0c2\x16\x07w\xc8\x9b\xec\xe6\xa3{\\Y0\xbci\xb1sCW|\xae\x8d@\xf6l\x8b\xc0XQ\xc6 \xb2\xcdx\xc49\x8f\x12*\x99\xe0`V\nI\x1c\xf6\x99\xd1\xfdE\x068\xbf\x0e\xc6y\x8a\xe0p\xb1\x18\xb3\xb6\xd3\x8amD\xe7b<s\x067K1\x86\xcf8gee;\x164?7\xdf\x1c0\xe6\xc5\x1b^\xde\xe4\xc8H\xb2\xd7\xca\xa0q\x00d.!Z\xbc\x8e\xab:\xd7\x00\xd3u6\x80\xb9\x80>6\xed\x91\xe7\x9a\xdd>\xdc\xa8]W*\x03\xe4\x11\x90\xb1\xd8\t-\x18\xa64X\x1e\x91\x01\x13Y\xcd\xad\xe9\xf93\xb1\xbd\x87\x03\xed\x8c\x00;\x13q\xa1,\xc8# c@\xcb. \xc6dh\xc9\x10,\x19H\xf1<\x06\xb0\xfc<\x15\xe7\xa2%\xdcb\x7f\xe4\xbdv\x8b\x18\x0f\x99\xa8\t0~m\xd8&e\xf1`7\xd6T\xae\x1e\x8b\xc9\xd8\xe6F \xaaxN\xb9\x88*\x01\x8d\xe9\x03fm\xb7\xa86\xc1<\xe1\xa3\xc4\xd2\x04\xd8\x0b.\x05\xaa\x88O\x90u\x1b\x89\xc9X\x85\x07\x12\x0c\x0c`\x99\xf4\xc0R2\xb4\x80\xc8\xc6\xe2\xfb1\xa2c\x01\x95K\x82w\xf2t\xb1\xf2\xe7\xca7\x1f\x062U*\xf7\xf2\xee\xe4t\x11=\x10\x96\r\xe5J\x8a\x94;\xe7\xae#\xbam\x8a2\xcf\x16\x08c!VW\x8an\xa2b\x0cY\xa2;W\x97TU&\x9d\xcf\xc8n\x00\xf8xV\x8e\x15\x9f\x0bkh_~#M\xc6H[w\xcc\x1f\xb1\x9c\x16\xc6;X0\x8b\x85\xb2A.Ty\xa9x-|\rU\xb8\x9d\x0ff\x91\x18\x98\x96\x1aT<\xf2\xe3Y\x89\xdah\xa5\xc9\x1aw\x1c-\xdc%6\xd3\\_\xdf\x81\xf3&\xc6jx\x8cqX\xc7\x02\xcb5*\xc2\x04I\x06e9p\xe3\xa9\\a\xd4="p\x14\xb8\xfe\xf5\x8b\xaf\x1f\x83\xe7\xc1,)\xdb?\x8f\x86\x1c\x98\xf3\xcb7\xb1\xb9.\x96\xbe@\xc6\x8f\x01\x8b\xb5\x061+\x95\xe34\x968fD\x83s\x1b\x95\x05C\xc02\xf0\xb0#\x80\x96YD\x96|fI\xf7\xf8\xdc[\xdd\xa4\xf3\xf5\xc7\x1b\xcc\\\x17\x02\x98J\xd0\x06P\xdc\x17\x8f\x1b\x047 \xba{\x0ed\x0chU}!\xb3b\xd9\xf5\xabb/U\x11\xd2\x01\xdc\x96 \xcb\xd7s\x82l\x07\xb7\xf5h\xf2\x85\xf5UUu\x83\xaev\xb0{\xee\x0ed\xd9\x9a\xb9\x92\'\x8c\x15s\x1c\xd6\x05\x19\x02\xbb\xaa\xbcgM\xb3[}g3l9(u\xd0\xedy\xdb\n`\x8c\xd8`@\x1b\xa1\xadG\xc0]Y\xb3\x0c8d\x07\xf1\xff\xe8\x02"\xc0\x18\xd0\xf2k\xe5\xbf;\x96\xf5\xcc\x95A\xa7\xda\xdcw=\x87\\\x92\xc46\xae\xaa\x90\xdf\xaa\x94\x08c+E\xad#\xc8\x14X2\x89\xb1\x1c\n`\xcaet\x8f\xef\x80l\xbat\'d\x14\x9f\xe1\x1a"\xc0X\x83\xa4\xab@g \x1bM\xe4\xa3\xb4\x03\x82\x8cY+\x97\xeb\n\x80\x05\xb8:VL1\x8e\xcc\xba\xb1\xd4\x05#c&\xc8NJ6\x9c\x01`\xce=\xc2\x16\x14\xc6\xae!\xdbX\xe5\x90X\xfb\n\xab|gd\x04\x82\rA\xc3\x80\x83\x9f\r\x1f\xc7\xac[\x15\x93)\x11\xa6\xb9&\xc8d\x03\xa3\x03YT\x9e\xb3\xfcT\xae\xb4\xa8\xaa\xd3Y\x05\x04V\xbe;rC\xe5\xd6*\x92\x03\xad#\xfeL\xfd\xce\x01\x8c\x81l\xc6d\'%9\x9e\x1d\x87u\xac\x18\x93;`94\xd5&\xc4$\x1d\xd8fU\xd5\xefN\xd4&\x83\xcc\xb1\x85\x1d9\x01\x05@\xc5*\xaaZ\xc3\xb9\x9e\x04\xa8\xb3\xc4\x82\xb9\x07\x8c\xc5*\xea.\x8e1\x10c!+\x99:V\x01\x822v\x8a\x84Q\xac#+\x9bR\xf9.U\x82\x15\xd7\xa2[\xb3\x88\x9fi\x02\xed\x00\xf7\xcbi\x1b\x9e\xe9\xc2\xabX\x8c\xc50(}\x87\xc4\x82b\xddT\xa73+"f\xe4\x07\xb3\xb0,\xae\xaar]\xca\xd2:K\x8en\'\xeb\xa4vm4\x13d;\xac\\\xdd\xa0\xbe\x8c\xb3\\\xf8\n`\xb8\xb9\x02(\x01\xb0E\xc4u9r\x99R\xe5f\xa2\xab\xe9\x1a*\x15\xa9\xa1\nz;\x00C\x10`\'\xb5J\x010\x90\xb1\x9e4\xf6\xbd?\xd25\xfdL2\xec\xb4\xee`\x0e\xd6UW\xefY\xd2\x04\xd8V\xa2\xa8lU9\x11\x00C\x90\xe5M\xcf\\MV\x9a\xd4\x11\xafaV+\xd7"\xe2{b\xd2ZI\x99\xb3\xdc \xab\xc4w c\xfds\xce\x9b\x19\xfd\x8eTA\xf4-\xdd\xc4\xd8\xb0\xf1\xa5\xe6/\xe4l\xe2\xa1#\x8c\x9c\xcb?\xb9;\x7f\x96\xa3s`bq^\xe5\x0e2\x80\xa9j\r&O\x8e\xcaV\xecZ\xe0\xe7d Sb\xb7*\x1e\xed\x80\x8c\xa9Tgw=\xce\xf3\x96\xf4;\xba\x0bg\x92\nc%K\xce\x82\xb9\r\xce@\xe6\xac\x8a\xd30\xcc\x07s\xfd\xba\xbd^*\x0f\x86V\x8cI\x15d9\xba\x1co\xa2\xb5f7\x0c\x17w\xa2FgW\x1e/\xa7S\x98\x0b\xbb\x9c\xcf\xff~vS\x90\x9d-\xd8U\xf2\xe2.\xbe\xe9T\xa8#\x9006r\xd5"\xf83F2\xb0\xbe\xae\n\\\xae\xf7Kip\xb0*\x97\x0c\xb0|\x04\xb9Si\xe53\x90\x8d\xd4x2\xc0/\xef\xbf\x80*\xfe\xfe\xf0\xe7\x87\xf7\xefo\xe8.\x9e\x81\x8aw\x96K\x91\x08\x9d\x1a>\xb4Xy#wZF\x14!\xe2\\\xd18\xb25Q\xbd`\xf1<\x060\xd5f\x83C&\xb2\xd5` \xabj\x1f\xf35~\x84\xc6G\xd0\x87\xd5\xfa\x0c\xac|L"\xe4\x19\x16\x0b\xe3\x0cV\xff\xc7,K\xb7X\x96\x81\xacb\xfe:\x96\r\xc1\x927y\x17`\x8c\t\xc5\xf8\xa8\x02\x99\x03\x1a\xba\xc2\xca-~t\xe6\x1b\x03\xd9\xc7\xb3\xfe\xee\xe3\xf1\xbb\xf7\xdfN\x90=-/W\xe9\xbc\xabM^%r]\xc1lE\xb1\xab\xaa\xf5|\xb0\xb4\x01Z3\x15\x03\xb2\\\x1d\xabJa\x1d\x03L\xab\x841\xa8\x8b\x15\tWM\x9d\xd3\x96C=\xf2w\xf7\x19d\x0b\xa0"\t\xb0\x80\xec\xe3\xa0\xc9\xdb\xc5dg \\T5\x85+?Z\xe3:\xa2KVY\xc7j\x98\x83\xb3f\xb8\x991VC+S\x81\x0ce\xd5\xb2*\x16~\xeex\xfd\x0c2v\xe4Xm\x0b\x90e/$\xce#Y\xb2\x8f\x16,\xdew\xae\x03\x13\xca,\xd0v\x15\x13\x9d\xc3Q\xfaL\x9fPY5W\x01\xe2hs\x050\x16/\xe5\xcd\xce\xaa;\x98\xf0\xcd\xf2o\x956\x88\xcd\xfd9\x16\x92 \x8b8m+W1\xc7\xf6\xcbk%\x8b\xba\x80\xeb\x8b\x15\x8b\xefc\xae\x83A\xa6\x86$\xb8r)\xb4N.\xd6q\xed\xff8\xb3MU\xcd\xab|X\xc7U\xcc\xb1ZX\x97\xbc\xf9\x11dJ\xb8G\xb1x\xac\xfd\x05\x89\x17\x16\xa3\xe58p\xabyu\xe1\xca\xe66\x9c\xf8\xdc\xcb\xbf\xe3\xbd\xe6:8&\xeb$y\x91\xfaf.\x18#\x1e\x18\xd0*\xddxW\xb9\x81\xc0V\xe7\xc0\xacV\x06X\x1c\xe8."\xd0\x14\xbb\xc8@\xe6bU\x15\x1f\xb2\x01\x14\x8f\x82\x0c\x0b\xb6s\x1c<\xbb\xae7\xa0\xdfQ\xdb\xa3\xdb\xf4\xa86\xb8\xcbC1FO\xdd\xb1\xb1XXU58\x9d\x0e\xac\xc8\xa8\x04F\x1d\xd0\x18\xbd\xceb?\xe6*\xaa\x98\xb5cmY\x9e.S\xf9[\x14 (\x95\xe6\xa8\x1e\xfa\xf8\xfa\xb3\xa8q\x9c\xc0`\xd2\xcc\x1d\x1f_\x8d\xdbu\x89gG$(\x90a- \x03Y\xb6h\xac]\xc6\x95V\xa9\xbe\xb0\xee\xf9\xa9b`\xd6\xb5\xad\xceA\xb5\xbaT\xd5\'\xb9\xd6\xf3Q\x97\xd1\xd5\xc1~\x05\xe0Y=<^\x91\xa16\xae\xbb\x96n\xa65\xa3\xa6\x9d\x9b\x88\x9b\x97U\xd8\xab\x8avVE\x8f\xa4\x07kca@C\x9d\x91\x1c#"\x95\xce\xc0\xaf\xe6\xc9e-\x11\xf6\xfe\xb9\xaes-\xc8\x96\xe7\xc5\xf5Y\xbb\xd0#@O\xe1\xcb^\x98\xfd4\xbdx*\xe2\x025\xfb\xb9R>b"\xa4l\x03\xe5\x98LY1V\xaf\xe7\x00\x86z\xf7n|R<\x0f\x01U\x11)X\xee\xe4\xce)\xcf(S\xbd{\xf9z)\xedD$\x1d*\x91\x1dL\xd2?BL\xb0\xceq\xa9\x1d\x82"\x8f\x13l:\x1f\x12w?6\xcaG\x15\x97\xb2)\xa0\xae\'+o\x9aL\x8b\xbb\xc4oU\xd1\xd0Q\x19F-\x0e\'\x18\xca\x9e\x8fU+\xdd|\x94\xd3\x15\xc9U\xee\xec\x86\x91]]U\xed\xaf\x12\xf6\xf9<\xb7\xd8\x1fJ\xda\xe0K\xe0\xb6\xb5\x9a\xea\x95YA\x1c\x14\x1eU\xe9\xd9\x05r\x03\x16\\\xfbE~\xbd|\xd7e\x8c"\xb3b\x8c\xa2V\xc5\xc7n\xd62\xcb\xab)\xeb\xe5\xfa\xb2\xb6Jy(\xd2&\xbb\x8b\xac\xe5\x85\xd5`n\xe9.\xb2\xf3\xa5\x02=\xac\xd9l\x02\xed\xdbJ\r\xe6\x16\xb1;\xbc\xea F7\xb3\xd3]\xec\x04@+\x80aG1{?\xa6\x97QI\xb9\xb1\xe7\xee\xd1&\xc4nPX)\x83\xfa\xf9,\xfeS\x154y\x86\xf4\x1e \xfb\xea&\xa3\xc4\x1e\xf7\x02\xda+M\xc5d\x03\xc6\xc3EY\xbe\xccj\xc8\x81K<\xabd\xb4\xeb2V\xb3\xb8\x18\xc0p\x93Vc`\xab\xdf\xb9\xa9){\xee\x95\x0c2\x9cD\x13\xf4y.\xaf\xca\xd5\x1d\xca\xed\xdd\xba9\x17]\xc6o,\xb9\x02\xd9\x96(g\xf9\xa4W\x00\x1aZ\x82,\x03\x10.bgZ\x89\xa2\xbf;GW\x84\x86\xb5\xee\xab!{*\x1e\xab\xa6\xb0(\x99\xeb\xbd\xf2\x90\xc8\xe0!\xc0Xo\x19z\x18L"n\xeb\x041\x1b\x98\xf8M2m\x94\x8e~4\xaf\xf4\x88h\xc93\xe9\xfbj\xe3*7\xab\xdb#\xc6\nu\x95\x88\xa7\x12\xa0\xa9\xa6X\xaa\xea\x0f6\xc7\x8c=vTtf\xf4\xfb\xcd\xdd\n\x08\xb4\xcc*\xb2\xee\xe8\xe5`z\'\xf9z\xe1\xfc\xe7C\x96\x9b6\xbfE\x01%\x9b\xa7\xfbJ\xb1\x1f\x82\x8c\xa9\xf0\xaa\xb8\xa53\xef\xd8\rH``\xadX\xbf\nP\x8au\xc4M\x8c\x823\x8f\x10d#\x9eKX)\xf63\xb4\xac\xac\x84\n\x15\xbbP\xc2{\xaf\x18\xf2!\x90=jm\x985{\xa5T\x81\xd2\x80w S\xe3\x82F,\x98\xabrP.\xa8\xb2<\x8a\xf5\xc2\\\x8fJ\xfe\xa2\xd2\xf0\xa8\xcb\x9f\xdb|Fo\xdc\xac\xb1\x95\xe9If\x10\xb1j\x10\x9c!}8\xc8*\x05Y%o\xd5\x05\xcb\xab\xb8\x86\xec|\xb3\xff\x8f\x15\x07\xaar\xc2\xcd\xcbZ\x0b\xb4\x8a\xa0p\n\xbf.\xd6f\x134\xd5\xeb\x8e\x02\x0c\xbb\x9b\xd7\x10%9!\x8d\x8d\x9aX\x0f\x89\xfdi\xd8\xca3\xaa\xe3\xb1\xd9r\xb2Xq\xb2\x8aJ\xbd"\xdd\xcf\xf2\\\x0ed\xdd~0\xa7;QuC\xbb ^\xb9\x83\x0e`\x9d\xe4\xafs1\xd7\x10W#\x13d\xd8\x1eE\x161\xaa\xfa3\xc0X\x1e\r\x07p<\x1dd\xf8\xa5\xc4E\xaf@v\x15\xa0\xb1\xf8\x84\x8d\x8b\xedT\xb2W=a\x19x\x95\x90\x8dj\xb0\xac,\x98#+\xd8\xa1*,0\xef\xd6\xb1^\xdd\xb0\xa1\xb3r\xf7\xf1\x02\xb0\xe5\x0f2\x89\xb9\xe2\x86\xc9:l\xd9G\xb6\t\xc8\xf0.~\x07K\xc6\x06\xdc1k\x85\x9bY\t\xbcT\xc7\x88%\xeb\x90\x1dN\xf7\xdd1\xba\x0c`\x95t\xb9J\xc5t\x00\x88\x84Xg\xff \xc8\x94\x9c\x00\xa3\xf8Ye\xca\x96{\xb6\x05\xd8\ndw\x99\x86\x81\x95\x11\x8aHpV\xac#\xbd\xf6(\xd0*yqL\xd8vH\'5\x1e\xc9\xc5\xe6,\xc6S\xbduY\xafC\x1d\xd5\x1eU]\xe0\x8c\x98a\x9e\xc7^\x89\xf3\xd6\xeb)\xd7\xa2\x02\xd9\xd5J\xb0\x90\xc5R*\xb4\x15\xb3\xc8t\xe0\xbbr\x02\x15\x95\xefd\xd4\xdcM\xaf\x1a\xf0\x97\xbfW7\xa4\x01\xab\xf9\xd9\xfb\xe5\xf7a\xc5\xb3\xb8\x7f\xc2\xe28\xa0\x85%S\xc320G\xc84C\xaa6\xa4C)j\x8c\xc9\xaa\xe1iW\x02Y\xb4\xb4T\x15\x11j\xb8^\xd5\x0f\xd6q#;b8j\xa0\xc2\xa3\xf2f.1\xed\n\x16\x1c\xb0Y\x8e\x11\xc1\x9a\xab0\x10lYGC\xcd\xc5V\xf5\xa2\xddk\x12\xe7y8\xc8\xaa\xe3\xaa s\xb9"7\x90\xc1u\x0bwt\xe1+Y75^\xa8\xb3\xa1:U\x19lF\x80\x92\xaecR\x01\x8a\xa5e\x153\x8e\xfdd\x93\\\x94\xf8k\x8e\x91\xd9,\xb5\x11\xe6sW\x909\xd7P]\x8c+\x82\xac\xaa.\x18\xa9G\xec\x80,\xb7\xb10\xed\xfa\x91AyU\x1e\xacCD\xe0\x8d\xd6\xc5\x9f\x08DF\xa4\xa0\xcb\xa8\xac$K\x97 \r\x9f\xbd\x047Es\x8dU?t\xe0\x08k.ts\x97\xae\xda\x12\xc3\xac\x99\xaa\xc2\x18\xad\x9a\xef\x0cc@yi\xd5\x1b\xa54\xdd\xbbs\xb6\x90M\xad\xdcB\xd4\xb2\xc0\xc1\xee\x9d\xbc\x9b\x02\x19\x03\xbaSV\xce\x85\xbe\xcc-\x1d\xb1J{\x14:\xb7*\x1d\xaaz\xc33\x0c*?\xd2\x92)\x12\xc2):!\x13\xe6@\xe7\x84s\x9c\xeb\xe8\x12\xd3\xcc\xb5W\x89v%\xba\x8a\x96\xcdM\xc2\xac\xd8ZW\xb6\x87\xa0tqnN<;\xf5\xb0\xd1\x9b\xea\xd3\xa4\xdb\\P{Ek\x967\x86kK\xe9\xc8e\xe7\t&# \xeb\xc6h\x8a\xfeW\xf4>\xf6d\xb9\xe1\xeb\x15\xf9A\xbb\x7f\xc5\xe6en\xa2\xbaac\x12Y\xdd\xb0BijK\xcf\xe5\x94\xfa\x88W\x06Y\xa5M\xdf\xd1!\x1c\x9d\xdf\xc5@\xe7\xf4*r\xa1l%j\x8a\xb2k\xe8Z)\x8b\xc3$\x14\x10\x9c\xaa\x07\xcc\xa5\x04T\xce\x0e\x89\x0e&+\x90\x85C\xb7\x0e\x93N\xb9!\xd7\x0e\xb1~5\x90\xb9:\xc4\x0e\xc8:\x03\xf2:q[w\xc2f\x9e\xe4R\xb5\xb9Tq\xb8\xfb\x99KFg\xc97\x970w\xd5\'\xcb\xb5G\x90-?[\xd3\x0f\x16\xe7\xec\xf6\xf1%\x0c\xc6+|\x90n-bU\xd5\xc1\xf4\x12\xbbq\x18\xb3n#\xee\xa5S\x0fV.[\xce\x959m\xc9\xaa\xd0\xb7\x93\x1f\xabbz\xd6\xf9\x1c\x9f{\xad\x15S%f\x97\x01\x95\x92\x1f8\xe3\xf9V\xe3\x82\x9c\xfb\xe6F\xbf\x8e\x82\x0c)\xfe\x0e#\x89:\x87U}\xa3"@Xr\xb7\xaae\xac\xd2\x02L%XyD\xa8\xb9\x98\xaf\xef\xdaX\x8c\xe9\x85\xbc\xa2\xb7%}]\'Ap\xa6\xc5\xa8{\xa6\x16\xe5\x98?\x07N\xa5\x97\xa8\\J7\xae\x96\x813\xc0\xc5(\xef\x9cDV\x85\xdf,.s@S\xa4A\xee\x1f\xcb\xd7\x13A\xa6n\xbc\xcc\xba\x8e\xb4\xa9\xb8\xa4|\x87\xb2\x7f\t\x90U\x00{vq\xb1\xd3\xb4gV\x8c\x89\x8b*\xd5\xa8l\xcd0\x9eRc}\xdc\xb4J\x07,|\r\xa6mQU\x8aT\xe0\xaa\x1az\xd9\x86\xcd\xe5i9\x89\x8c\xdd\xd5\xca":\xe1\xa5Go\xd0\x97p\x13Y\x9eM\x05\xdb\xdd\xbe\xa4\xbd\xe4\xbb\\K\x0b\xce%\xae\xd4{+\xe6/\x80\x10\x03\xeb\xd4\xd8U6L\xcf\xc5yL\xcc\xb3\xa2\xf6s\x82]%\x8bU\xce,\x17\xf6\xa2\xa4\x00\x96\xa6\xb1\xcedu\xb3U1\x9a\x02\xdf\xa3\x92\x18\x97\x88\xc5\x9c:\x15\xbbH\xca\xaf\xdf\xf2\xce\xc3J|T="\xb3dl\xf8\xb7\x02\x1a#$\xd4 s7\x0eV1\x908|"\xe7\x90\\\xc2\x1a\xabX\x9c\x1e\xa4\xab\xd6\xc8]\xf3\xaa\x8f+_\x07f\xc9\x18\xf9Ru\x12\xdc\x81|[Mz\x1c\xf5\xdc\x0e\xc3\xa4\n\x80]5\xfd\x08\x18*:\xbfz\x1dW\xdf\xe8\xd8\xc8`\xde:B\xa6X\xc91R\x10\xad\xe6;\xe3\xc0\xbe|\xee\x0ed\xaf*\xb2t\n\x90\x9d\xe15\x909\x1c\x91o\xeb\x92\x16\xdd\xc3\xc5]\xec\xdf\xaa\xef\x8cY\xcf\xc8\x1f\x85\xb5\xc6\x11G8\x1d\x85uv;uc\x06BW1\x9f\xcf\x135\x0fUc)\xba\x86\xaf\xb2O\xe7Jn\xa2R\x94rI\xe7*\xd7\xd5\x05W5g\xb9\xa2\xea\xab\xdf\xa1\x1c\x1a\xab\\W3\xbe\xf0z(\x85,Ur\xc5b1\x1cS\x84\xad)\x95\xe0\xed\x11Vm\xf7>\xb2\xab\x82\x89\xd1\xc3j\xb8\xb7",\xba%R]\xe2\xa2:\xaa\xa43NsQ\x8fe\xa4G\xa5\xd9\x98\xe3\'U\xe9\x8fU\xf7\xac~\x11\xa5\x1bpz\xa7\xb2f\n`{\xb3\xcf\xb1/\xa6%[ygR\x82\x9d\xaa$\xaa\x0b\xaeQ\xd0\xb8\xd1\xae\x0e\x90j|m\xfe\xbd\x1b\xca\xaeXEe\xe52\xf5\xef\\GU4\x8c\xe9\x0f\xc7rfW\xd5\xd1\xf7G\x11ss=x\x11\xf3\x9d\xb5\xab$\xe5j\r;\x00\xc3#O\xc6\x0c\xad\xc0\x0e\xe9\x91\x9f\x83\xc0\x0cpE* \xb3\x8b\nd80\x83m~7\x9f\xd9Q\xfc\xce\x8a\xb1\xf3a\x9d\x01G[\x94I\xb0lp\x01Y\xbc\xc1*\'*0)\xda\x9c\xfd\x9b\x81\xab\xcb@2\x8a~\x01X\x80,\x03+~\x9e\x7f\x97A\xa6F*)\xb5\xe3\x8aMT\tm\xd6\x8b\xa6@\xe6\x06cL\x8bra\x90u\\\xc2\xcauc\xee_\x1e\xe3\xc3rhN\xd9*??\xff\xc9\xc0b \xcbIkU\xed\xe1b2\xac\xfc@\x0f\x80\x01\x16-\x1a+\xacvVu\xad>\xfe\\\'X\xb9\xb8\xb43\xb9r$\x8f\x85`R\xb1\x98\x9a\xe7\xcc\xd2\x04,\x1f\x97\x81\xa4\x80\xe6b2\'\x88\xca\xe24\xdc\xfcN[\xc3\t\r1\xb6\xd2\xe9r\x9c%6\xda#\'{y\x909K\xe6\x12\xcc\xa3\xc9\xe2\x8a\xc0p\x1d\xcd*\x0f\x17\xe0\xa9@\x96\xe3\xb5\xc8GUb\xa9J\xeeN\r\x10t\xf3\xa3\x95\xdb\xa9\xc6\xdf\xb2)\xa0g% f\xbc\xd6\xc8\x89\xa9I+\xae\xe8w\x14`\x15)\xd2i\xb2\xcc\x13J\xf2\xc1\x00\xc6\x1e\x83\x96LM\xe1T#i\x99\xdaU\x8e\x97\x14\xf9\xa1\xf2kJ\xabR\xa9S\x9d\x99F\xbf\xbc5z\xc4M\xc4\x98\xa2S\xc9\xa1\xac\xd2#\x00c9,F|(\x90}\xf8\xf3\xc3\xfb\xf7\x1ad\xcc]d\xad7Ju\x0bUv\xe3\x1a2}\x0ed(UK\r\x12\x1b\xaaA\xf4\xca\x8ag\xb7\x01XG\x13q\xa4\x0e\xb1\xaa\x84\x1f\x01\x99*\xf2\x05\x80Y+\xd6\xa9\xa3T\x96,\xab\x10+\xe2!{\x03\x0c`\xca\x92a\xcfX\xa7\x7fl\xae\x17r\x11U\xf1oe\xc9\xd6\xb4\xf9g\xeb\xd7\x89\xe5\xd0r1z~\r\xc8\\|\x88\xb1 +qr\xae\x92\x1b\xd4\xce\xf4\x10\xb1hXU\xe0L\x0b\xf6\xc2D\x87j\xdb\xe8\xe8\xd4\xb3\xb2)W\xb0\xdba\x1a]\xbb\x8bs\xff0&s\xed1\xd5\xcd\x01S\x06\xd9\xb29\x90\xb1\xced7/-\xbb\x89\x8c\xb5\x9bn\xe2\xc5,\x19\x0b\xd2\x15\x85\xdf\x05\x99j7qM\x9c\xacl\xcb\x95[\xb9\x98K\x01\xcd\xd50F{I\x10\x0ch\xe1\xab\xc0>w.8\xad\xc7\xac\xe6[\x01\xec\xaan\xe2r\x8dn\x17\x93U\xfda#\x12\xda\x95|\x9b\xeaPf\xf3\xa3\xb35\xeb\x82m4\xf6\xcb1\x97\x9a}\xdd\x11\xa4Y\x9eS\x01\xac\x02\xd9\x1d\xe2\xaf\xc5\xdb\xb8\x8d5S3\x9e]2\xba\x1b\x8b\xa1\x8c\x80\xb3"l\xdcQe\xc9\xd6\xd4E\xaa\xf8+\x93\x15y\x00\xdf(%\x9d\x13\xfan\x80\xbc\x9b*3\xdd\xc2\x8b\x01\x8c\xc5fN;\xb1\xd2\xa4\xef\xd66\xaa\xbc\x94\x12\xe5\xe9\xb2\x84\xd5\xcf\x11dl\xe3?\xb2\xd9\x95V\x87\x02\x99\xb2f{\xad\xb5B\xa7sm\xe4*\xbaY\xce\x95<v\xb7\xdd%w\xfe2\x80\xe1yt\x95\xafFd\xe0\xb0\xfb\x98\xe5\xab\x9c\xbbV\xc9\xa79K\x86\xd5\x1cn6\xf5\xd5\xd6r\xcdoIz\xb8Js57L\x8d\x9c\xed\xc6l\xca}RE\xb3\x99\xfewDIUsY\xb9\xa9\xa8\xc3\xb1\x96\xb1\xad\x1a:U\xd9\xd4\xd9\x01\xf6\xc8\xf9\xc5u\xcf\x16u\xf9\x0e.\x05*\x9c\xa5\xe6,\x18#\x1e:\xb3\x9c+Q\x1bUQ\xd1U\xc0\xea\x8c\xafU\xeen\xa5\x94\x85:\x1cjC\xb1\xdf\xb1.\xe7\xaa\xf6\x91Y\xb4;\xac\xe53_\xd2\xa2\xe1\xb0of\xbd\xdc\xb0\x08\xd7\xb8\xe9\x06\xf8\xa9\x92%\xa7\xe4\xa4rw\x8a\xa5S\x05\xb8# CwQY\x15\x15?)\x86\x16[\\\xd84\xcc+\x83,\xae\xc5-\\Fd\x11\xd5FV\xc5\xc1\x9d\xee\xe8\xce\xfcf\xd5\xd6\xcft0\\\xc5\x84\x02\x17\xca%t\xf4\xefq\xd0\xc4\x88\xeb\x86\xd7\xd5\xe9-\xaa\x9b\\\xfe\xdc\xce\r}\xd5Xm\xab\x99h/\t\xb4\xce\xb0tU\x8d\xbff0\xba"6\x18\xc00\xad\xe0f\x9fu\xfa\xcd*\x11\x9d\xad@\xd6\x91\xe7V\xf3\xc4\x1d\x9d\xff\xaaV\xee\xb6\x8d\xa5\xa8\xe5\xa1\xc0\xc6\x80\xa7\xc4^TGo\xe5\n\xb2\x9e,T\xccb=Z\xddX\xac\xa2\xf1\x99\x0b;\xd2F\xc2\xce\xd3i\xdfWJSs]\x94\xc2W\xa3Y\x19\xd0:\xd6D\xf5D\xa99\xcbJ\x85\t7p5\x8e\x96\xe5\xd6\x18\x01\x83\x92\x03\x8c\xbe\xef\xcc\x1c`*_9\x91\x8d\x95\x1bS\xed\xf7\xc6KY\x0e6\xbd\x84\x91\x15J\xfa\xcc\r3g\x83\xf5\x94\xcb\x14V\x971\x9fL\x87\xa3j\xcbQ\r\x9ak\xe9t\xf786D\xfd\xca\xba\x85\xb7\x8a\xbf\xb6"G\xd6\x80EM\x19a\x83\xcd\x99\xec\xb4bF\xb1\x81\x92\xb9\xa0q\xc4t\x98\xaa\x10\x99\xb9\xb6{\xc9\xadE\xe10\xdb\x88\xd3\xbam\x97\x8f{\x19\xa0U\xb3\xafF\xc79)\xf0v\x86d\xa04\x02\x1bO\x84L\x1eZ\xb4\x91d\xf4\x9e C+\x96\xafM\xbe\xe1\xcc\x9b\xfd\xfb\xbd/\xc0H\x13!\x93\xfdV \xabH\x1aE,0k\x1a\xee\xe5H\xb5\x07\xb3\xccG\xdcQq(;\n\xe6,\x7f/\xe7\x18\xeb\xca\xed!\x93\x04\x02\xe0t\\\x1c&\xfd\x8d@\xabF\xa4f+\xa8f7\xb3I)\xcbfTy\xb2<\x92\x08\x07\xf2\xe1\xeb\x1d\xbd\xb9\xd8\xe7\xba\xe3M|\xae\x15q^\xb8{h1\xaa\x8d\xacb9|\x0f5,\x03sg1\x8f\x8c-\x8c-\xdd9m\xc9\xf2\xe21\xf7\xcd\xbc\x06\x0f\x83ld3\xe7X\xa5c=s\x0e\x10\xa9}\x05\xb0<\x14\xfd\x19\xad\xfew\xa8\xc0\x9f\xeb \xb6\x92\x89\xc6l}Gcr\xe3\xacW,[/un\xd3\xba\xccuj\x80\xb1$\xb4\x1a\xfd\xb3\xc7{g\xca\x9f1\x86\x18\x7f\xb1\xae\xe8)^3\xd7\xa9\x01\x86\xd6\xcbQ\xf7[ndtO\xb3;\x86\xa0\xc2\xb9_s\xcdu\xfa\xe5TtU\xe9\xd4\x1e \x0bP\xbbs\xc39\xd0\xcf\xb4Xk\xb4D\xe6\xba\xe1r\xed\x1e\x15\xc8\x8e\xbe\x01\xa0\x85}\xb6K\x18\xee\xed\\s\xb5\\De\xc1\xaa\xd2\xab\xadW\xde\xb4\xaa\xf3`\x0e\xd3;\xef~\x9a\'E\xde_mb6\xf6g\xef\xa4cN^\xe7\xd20d\x1d\x97s\x9c\xeb\x9ca\xc7\xd374\xab)|v\xae%\xd7\x1827Q\xb9\x8b{\xb9\x85X\xb5\x11 \xc3~\xb6\x19\x0b\x9d3\xae?\x85\xe5\xaa\nv\x8f\x06\x1cZ3\x16\x8b\x1dA\x89\xab\xc2e\xd6\t\x10\xe7zW\x91\xd1\xb3}\xbe\xcc\x00\x9f\x0e`\xac\x87\xebH\x901%,\xd5\x90y\x86M\x84\x12\x07S\xc9\xf7\\V\xec\xb0\xbe4\xec\xb0e\xbdW\xaa\xc5\xfd(K\xc6\x80^\xb9\x89g\xfaB\xf1\x1a\xeeu~KI\xd7\\}\xf2lWK\x86E\xae\xa3\xc73\x00\xc6\x14\xb0\x9e\x00\xb2\xf7\xf7\xef\xde\x97c\x159\xb2\xb6\xe2=\x13;\xe5\t\xbe},P^\xa6\x80\xbe\xff\xf9m\x82\x0e\xb9\x85|\xd3\xdb\x8d\xf8p\x12\x00\xd8\xa4\xc8J\x95\xbaU\xed[\xdf\x08\x98@\x0e\xb2\x8ag,O\xca\xe7?\xeb\x13\x9f\x070\x04\xd9\xe1\x00S\x89]F(\x1c\xd5{\xc4b/\xa6\x07r$\xd9\xb1\x85\xbb;\xd7\xc5Q\x8d1M\x052\x16\x7f=\xfb\\]!\xf0\x99\xd7\xa4\xf0o`2\xb3eP\xe0r\xf2iG\xdf\x0cP[\x83)\x00O\xe9\xb3\xb9\x1e\\\xff\x07c\x07U\x8b71\xca\'\x00\x00\x00\x00IEND\xaeB`\x82',
    }
    test_times = {
        'basic': [1970, 1, 1, 0, 0],
        'big_blob': [1971, 1, 1, 0, 0],
    }
    year, month, day, hour, minute = test_times[test_image]
    dt = datetime.datetime(year, month, day, hour, minute)

    mock_response = MagicMock()
    mock_response.read.side_effect = [test_images[test_image], '']  # copyfileobj() calls read() multiple times so we use side_effect instead of return_value to avoid a endless loop
    mock_urlopen.return_value.__enter__.return_value = mock_response

    rain.load_image(dt)

class TestRain(unittest.TestCase):
    def test_round(self):
        rain = RainAreas()

        self.assertEqual(len(rain.color_scale), 32)

        sx = 217 / (rain.bottom_right.lon - rain.top_left.lon)
        sy = 120 / (rain.top_left.lat - rain.bottom_right.lat)
        error = abs(1 - sx/sy)
        self.assertTrue( error < 2/100 )

        rounded = rain.round_to_previous_5_min(datetime.datetime(year = 2025, month = 10, day = 11, hour = 12, minute = 13))
        self.assertEqual( rounded.year  , 2025)
        self.assertEqual( rounded.month , 10)
        self.assertEqual( rounded.day   , 11)
        self.assertEqual( rounded.hour  , 12)
        self.assertEqual( rounded.minute, 10)

        rounded = rain.round_to_previous_5_min(datetime.datetime(year = 2025, month = 10, day = 11, hour = 12, minute = 20))
        self.assertEqual( rounded.year  , 2025)
        self.assertEqual( rounded.month , 10)
        self.assertEqual( rounded.day   , 11)
        self.assertEqual( rounded.hour  , 12)
        self.assertEqual( rounded.minute, 20)

    def test_location_to_pixel(self):
        rain = RainAreas()
        mock_load_image(rain, 'basic')
        location1 = Location(1.313383, 103.815203)
        pixel = rain.location_to_pixel(location1)
        location2 = rain.pixel_to_location(pixel)
        self.assertAlmostEqual(location1.lon, location2.lon, 3)
        self.assertAlmostEqual(location1.lat, location2.lat, 3)

    def test_intensity_at_basic(self):
        rain = RainAreas()
        mock_load_image(rain, 'basic')
        p = Pixel(91, 66)
        location = rain.pixel_to_location(p)
        rain.intensity_map.set_color_at(p.i, p.j, Color.grey(1))
        self.assertEqual(rain.intensity_at(location), 1)
        self.assertAlmostEqual(rain.intensity_at(location, 1), 1/9)
        self.assertAlmostEqual(rain.intensity_at(location, 2), 1/25)

    def test_intensity_at_big(self):
        rain = RainAreas()
        mock_load_image(rain, 'big_blob')
        rain.remove_noise()

    def test_noise(self):
        rain = RainAreas()
        mock_load_image(rain, 'basic')

        def count_blobs_of_size(n):
            count = 0
            for blob in rain.filter_blobs(lambda blob:len(blob)==n):
                count += 1
            return count

        initial_blobs_count = 40
        noise_count = 23
        self.assertEqual(len(rain.blobs), initial_blobs_count)
        self.assertEqual(count_blobs_of_size( 186 ),  1          )
        self.assertEqual(count_blobs_of_size(  92 ),  1          )
        self.assertEqual(count_blobs_of_size(  24 ),  1          )
        self.assertEqual(count_blobs_of_size(  16 ),  1          )
        self.assertEqual(count_blobs_of_size(   7 ),  2          )
        self.assertEqual(count_blobs_of_size(   6 ),  1          )
        self.assertEqual(count_blobs_of_size(   3 ),  3          )
        self.assertEqual(count_blobs_of_size(   2 ),  7          )
        self.assertEqual(count_blobs_of_size(   1 ), noise_count )  # noise

        rain.remove_noise()
        self.assertEqual(len(rain.blobs), initial_blobs_count - noise_count)
        self.assertEqual(count_blobs_of_size( 186 ), 1 )
        self.assertEqual(count_blobs_of_size(  92 ), 1 )
        self.assertEqual(count_blobs_of_size(  24 ), 1 )
        self.assertEqual(count_blobs_of_size(  16 ), 1 )
        self.assertEqual(count_blobs_of_size(   7 ), 2 )
        self.assertEqual(count_blobs_of_size(   6 ), 1 )
        self.assertEqual(count_blobs_of_size(   3 ), 3 )
        self.assertEqual(count_blobs_of_size(   2 ), 7 )
        self.assertEqual(count_blobs_of_size(   1 ), 0 )  # gone!

    def test_rain_distance(self):
        rain = RainAreas()
        mock_load_image(rain, 'big_blob')
        pixel_next_to_small_blob = Pixel(193, 78)
        location = rain.pixel_to_location(pixel_next_to_small_blob)
        d = location.distance_to(rain.nearest_rain_location(location))
        self.assertAlmostEqual(d, 0.30, 2)  # 300m is about 1 pixel
        d = location.distance_to(rain.nearest_rain_location(location, min_size = 20))
        self.assertAlmostEqual(d, 2.98, 2)  # now further away

if __name__ == '__main__':
    unittest.main()
