# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.reference_model import ReferenceModel
from typing import Optional, Set
from typing_extensions import Self

class AccessPdfPayloadModel(BaseModel):
    """
    AccessPdfPayloadModel
    """ # noqa: E501
    username: StrictStr
    dataset: StrictStr
    filename: StrictStr
    references: Optional[ReferenceModel] = None
    task_name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["username", "dataset", "filename", "references", "task_name"]

    @field_validator('task_name')
    def task_name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['search', 'chat', 'data_extraction', 'report_copilot', 'text2sparql', 'sparql2text', 'chatbot']):
            raise ValueError("must be one of enum values ('search', 'chat', 'data_extraction', 'report_copilot', 'text2sparql', 'sparql2text', 'chatbot')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccessPdfPayloadModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of references
        if self.references:
            _dict['references'] = self.references.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccessPdfPayloadModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "filename": obj.get("filename"),
            "references": ReferenceModel.from_dict(obj["references"]) if obj.get("references") is not None else None,
            "task_name": obj.get("task_name")
        })
        return _obj


