# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.search_metadata_filter import SearchMetadataFilter
from typing import Optional, Set
from typing_extensions import Self

class ChatbotChatPayload(BaseModel):
    """
    ChatbotChatPayload
    """ # noqa: E501
    question: StrictStr
    username: StrictStr
    conversation_id: StrictStr
    llm_choice: StrictStr = Field(description="LLM Choice of chatbot playground, set per user.")
    image_urls: Optional[List[Dict[str, Any]]] = None
    parent_message_id: Optional[StrictStr] = None
    is_regenerate: Optional[StrictBool] = None
    system_message: Optional[StrictStr] = None
    addon_system_message: Optional[StrictStr] = Field(default=None, description="The add-on system-message to be placed before/after system-message section, if system-message is None, this will be the system-message")
    additional_fields: Optional[Dict[str, Any]] = None
    bypass_guardrail: Optional[StrictBool] = None
    origin: Optional[StrictStr] = Field(default=None, description="The origin of the request")
    oauth_token: Optional[StrictStr] = Field(default=None, description="The oauth token")
    agentic_chatbot_enabled: Optional[StrictBool] = Field(default=None, description="Whether to enable agentic chatbot")
    current_time: Optional[StrictStr] = Field(default=None, description="The current time in ISO 8601 format, e.g., 2023-10-05T14:48:00Z")
    auto_filters: Optional[StrictBool] = Field(default=None, description="Determines whether the auto filters should be used for the response.")
    filters: Optional[List[List[SearchMetadataFilter]]] = None
    __properties: ClassVar[List[str]] = ["question", "username", "conversation_id", "llm_choice", "image_urls", "parent_message_id", "is_regenerate", "system_message", "addon_system_message", "additional_fields", "bypass_guardrail", "origin", "oauth_token", "agentic_chatbot_enabled", "current_time", "auto_filters", "filters"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatbotChatPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list of list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item_filters if _inner_item is not None]
                    )
            _dict['filters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatbotChatPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "question": obj.get("question"),
            "username": obj.get("username"),
            "conversation_id": obj.get("conversation_id"),
            "llm_choice": obj.get("llm_choice"),
            "image_urls": obj.get("image_urls"),
            "parent_message_id": obj.get("parent_message_id"),
            "is_regenerate": obj.get("is_regenerate"),
            "system_message": obj.get("system_message"),
            "addon_system_message": obj.get("addon_system_message"),
            "additional_fields": obj.get("additional_fields"),
            "bypass_guardrail": obj.get("bypass_guardrail"),
            "origin": obj.get("origin"),
            "oauth_token": obj.get("oauth_token"),
            "agentic_chatbot_enabled": obj.get("agentic_chatbot_enabled"),
            "current_time": obj.get("current_time"),
            "auto_filters": obj.get("auto_filters"),
            "filters": [
                    [SearchMetadataFilter.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["filters"]
                ] if obj.get("filters") is not None else None
        })
        return _obj


