# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.aggregations_group import AggregationsGroup
from qanswer_sdk.models.content_item import ContentItem
from qanswer_sdk.models.source import Source
from typing import Optional, Set
from typing_extensions import Self

class ConversationMessage(BaseModel):
    """
    ConversationMessage
    """ # noqa: E501
    role: StrictStr
    contents: List[ContentItem]
    message_id: StrictStr
    parent_message_id: Optional[StrictStr] = None
    timestamp: Optional[StrictStr] = None
    feedback: Optional[StrictInt] = None
    origin: Optional[StrictStr] = None
    sources: Optional[List[Source]] = Field(default=None, description="All sources referenced in the response")
    all_sources: Optional[List[Source]] = Field(default=None, description="All retrieved sources passed to the llm")
    task_category: StrictStr
    interface_origin: Optional[StrictStr] = None
    comment: Optional[StrictStr] = None
    llm_choice: Optional[StrictStr] = None
    prompt_used: Optional[StrictStr] = None
    mode: Optional[StrictStr] = None
    is_input_data_cropped: Optional[StrictBool] = None
    aggs: Optional[List[AggregationsGroup]] = None
    expanded_question: Optional[StrictStr] = None
    prompt_type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["role", "contents", "message_id", "parent_message_id", "timestamp", "feedback", "origin", "sources", "all_sources", "task_category", "interface_origin", "comment", "llm_choice", "prompt_used", "mode", "is_input_data_cropped", "aggs", "expanded_question", "prompt_type"]

    @field_validator('role')
    def role_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['assistant', 'user']):
            raise ValueError("must be one of enum values ('assistant', 'user')")
        return value

    @field_validator('task_category')
    def task_category_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['text', 'sparql', 'sql', 'sparql2text', 'sparqlvisualize', 'undefined', 'typing', 'user_joined', 'user_left', 'human_takeover_proposed', 'human_takeover_accepted', 'human_takeover_rejected', 'thinking']):
            raise ValueError("must be one of enum values ('text', 'sparql', 'sql', 'sparql2text', 'sparqlvisualize', 'undefined', 'typing', 'user_joined', 'user_left', 'human_takeover_proposed', 'human_takeover_accepted', 'human_takeover_rejected', 'thinking')")
        return value

    @field_validator('mode')
    def mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['rag', 'full-context']):
            raise ValueError("must be one of enum values ('rag', 'full-context')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConversationMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in contents (list)
        _items = []
        if self.contents:
            for _item_contents in self.contents:
                if _item_contents:
                    _items.append(_item_contents.to_dict())
            _dict['contents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sources (list)
        _items = []
        if self.sources:
            for _item_sources in self.sources:
                if _item_sources:
                    _items.append(_item_sources.to_dict())
            _dict['sources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in all_sources (list)
        _items = []
        if self.all_sources:
            for _item_all_sources in self.all_sources:
                if _item_all_sources:
                    _items.append(_item_all_sources.to_dict())
            _dict['all_sources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aggs (list)
        _items = []
        if self.aggs:
            for _item_aggs in self.aggs:
                if _item_aggs:
                    _items.append(_item_aggs.to_dict())
            _dict['aggs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConversationMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "role": obj.get("role"),
            "contents": [ContentItem.from_dict(_item) for _item in obj["contents"]] if obj.get("contents") is not None else None,
            "message_id": obj.get("message_id"),
            "parent_message_id": obj.get("parent_message_id"),
            "timestamp": obj.get("timestamp"),
            "feedback": obj.get("feedback"),
            "origin": obj.get("origin"),
            "sources": [Source.from_dict(_item) for _item in obj["sources"]] if obj.get("sources") is not None else None,
            "all_sources": [Source.from_dict(_item) for _item in obj["all_sources"]] if obj.get("all_sources") is not None else None,
            "task_category": obj.get("task_category"),
            "interface_origin": obj.get("interface_origin"),
            "comment": obj.get("comment"),
            "llm_choice": obj.get("llm_choice"),
            "prompt_used": obj.get("prompt_used"),
            "mode": obj.get("mode"),
            "is_input_data_cropped": obj.get("is_input_data_cropped"),
            "aggs": [AggregationsGroup.from_dict(_item) for _item in obj["aggs"]] if obj.get("aggs") is not None else None,
            "expanded_question": obj.get("expanded_question"),
            "prompt_type": obj.get("prompt_type")
        })
        return _obj


