# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.autocompletion_config import AutocompletionConfig
from qanswer_sdk.models.index_config import IndexConfig
from qanswer_sdk.models.ranker_config import RankerConfig
from qanswer_sdk.models.ui_mappings import UIMappings
from qanswer_sdk.models.uri_mapping import UriMapping
from typing import Optional, Set
from typing_extensions import Self

class DatasetConfigRequest(BaseModel):
    """
    DatasetConfigRequest
    """ # noqa: E501
    dataset: Optional[StrictStr] = None
    properties: Optional[List[StrictStr]] = None
    type: Optional[List[StrictStr]] = None
    subclass: Optional[List[StrictStr]] = None
    lucene_only: Optional[StrictBool] = Field(default=None, alias="luceneOnly")
    username: Optional[StrictStr] = None
    lang: Optional[List[StrictStr]] = None
    stop_words: Optional[Dict[str, List[StrictStr]]] = Field(default=None, alias="stopWords")
    number_triples: Optional[StrictInt] = Field(default=None, alias="numberTriples")
    recursive_iteration: Optional[StrictInt] = Field(default=None, alias="recursiveIteration")
    feature_types: Optional[List[StrictStr]] = Field(default=None, alias="featureTypes")
    visualization_order: Optional[List[StrictStr]] = Field(default=None, alias="visualizationOrder")
    type_properties: Optional[List[StrictStr]] = Field(default=None, alias="typeProperties")
    ui_mappings: Optional[UIMappings] = Field(default=None, alias="uiMappings")
    property_mappings: Optional[Dict[str, List[UriMapping]]] = Field(default=None, alias="propertyMappings")
    instance_mappings: Optional[Dict[str, List[UriMapping]]] = Field(default=None, alias="instanceMappings")
    properties_properties_expansion: Optional[Dict[str, StrictStr]] = Field(default=None, alias="propertiesPropertiesExpansion")
    properties_modifiers_expansion: Optional[Dict[str, StrictStr]] = Field(default=None, alias="propertiesModifiersExpansion")
    ranker_config: Optional[RankerConfig] = Field(default=None, alias="rankerConfig")
    autocompletion_config: Optional[AutocompletionConfig] = Field(default=None, alias="autocompletionConfig")
    index_config: Optional[IndexConfig] = Field(default=None, alias="indexConfig")
    __properties: ClassVar[List[str]] = ["dataset", "properties", "type", "subclass", "luceneOnly", "username", "lang", "stopWords", "numberTriples", "recursiveIteration", "featureTypes", "visualizationOrder", "typeProperties", "uiMappings", "propertyMappings", "instanceMappings", "propertiesPropertiesExpansion", "propertiesModifiersExpansion", "rankerConfig", "autocompletionConfig", "indexConfig"]

    @field_validator('visualization_order')
    def visualization_order_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['SIMPLE', 'LIST', 'FACET', 'IMAGES', 'TABLE', 'MAP', 'TIME_SERIES', 'TIME', 'TIMEOUT']):
                raise ValueError("each list item must be one of ('SIMPLE', 'LIST', 'FACET', 'IMAGES', 'TABLE', 'MAP', 'TIME_SERIES', 'TIME', 'TIMEOUT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetConfigRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ui_mappings
        if self.ui_mappings:
            _dict['uiMappings'] = self.ui_mappings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in property_mappings (dict of array)
        _field_dict_of_array = {}
        if self.property_mappings:
            for _key_property_mappings in self.property_mappings:
                if self.property_mappings[_key_property_mappings] is not None:
                    _field_dict_of_array[_key_property_mappings] = [
                        _item.to_dict() for _item in self.property_mappings[_key_property_mappings]
                    ]
            _dict['propertyMappings'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in instance_mappings (dict of array)
        _field_dict_of_array = {}
        if self.instance_mappings:
            for _key_instance_mappings in self.instance_mappings:
                if self.instance_mappings[_key_instance_mappings] is not None:
                    _field_dict_of_array[_key_instance_mappings] = [
                        _item.to_dict() for _item in self.instance_mappings[_key_instance_mappings]
                    ]
            _dict['instanceMappings'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of ranker_config
        if self.ranker_config:
            _dict['rankerConfig'] = self.ranker_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of autocompletion_config
        if self.autocompletion_config:
            _dict['autocompletionConfig'] = self.autocompletion_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of index_config
        if self.index_config:
            _dict['indexConfig'] = self.index_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetConfigRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dataset": obj.get("dataset"),
            "properties": obj.get("properties"),
            "type": obj.get("type"),
            "subclass": obj.get("subclass"),
            "luceneOnly": obj.get("luceneOnly"),
            "username": obj.get("username"),
            "lang": obj.get("lang"),
            "stopWords": obj.get("stopWords"),
            "numberTriples": obj.get("numberTriples"),
            "recursiveIteration": obj.get("recursiveIteration"),
            "featureTypes": obj.get("featureTypes"),
            "visualizationOrder": obj.get("visualizationOrder"),
            "typeProperties": obj.get("typeProperties"),
            "uiMappings": UIMappings.from_dict(obj["uiMappings"]) if obj.get("uiMappings") is not None else None,
            "propertyMappings": dict(
                (_k,
                        [UriMapping.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("propertyMappings", {}).items()
            ),
            "instanceMappings": dict(
                (_k,
                        [UriMapping.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("instanceMappings", {}).items()
            ),
            "propertiesPropertiesExpansion": obj.get("propertiesPropertiesExpansion"),
            "propertiesModifiersExpansion": obj.get("propertiesModifiersExpansion"),
            "rankerConfig": RankerConfig.from_dict(obj["rankerConfig"]) if obj.get("rankerConfig") is not None else None,
            "autocompletionConfig": AutocompletionConfig.from_dict(obj["autocompletionConfig"]) if obj.get("autocompletionConfig") is not None else None,
            "indexConfig": IndexConfig.from_dict(obj["indexConfig"]) if obj.get("indexConfig") is not None else None
        })
        return _obj


