# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from qanswer_sdk.models.widget_configs import WidgetConfigs
from typing import Optional, Set
from typing_extensions import Self

class DatasetSchema(BaseModel):
    """
    DatasetSchema
    """ # noqa: E501
    id: StrictInt
    dataset: StrictStr
    username: StrictStr
    index_hash: Optional[StrictStr] = None
    do_ocr: Optional[StrictBool] = None
    language: Optional[StrictStr] = None
    is_updating: Optional[StrictBool] = None
    use_reader: Optional[StrictBool] = None
    use_ranker: Optional[StrictBool] = None
    use_fallback: Optional[StrictBool] = None
    top_k_retriever: Optional[StrictInt] = None
    top_k_reader: Optional[StrictInt] = None
    top_k_ranker: Optional[StrictInt] = None
    return_no_ans: Optional[StrictBool] = None
    no_ans_boost: Optional[Union[StrictFloat, StrictInt]] = None
    max_seq_len: Optional[StrictInt] = None
    doc_stride: Optional[StrictInt] = None
    max_ans_len: Optional[StrictInt] = None
    weight_title: Optional[Union[StrictFloat, StrictInt]] = None
    weight_text: Optional[Union[StrictFloat, StrictInt]] = None
    split_by: Optional[StrictStr] = None
    split_len: Optional[StrictInt] = None
    split_overlap: Optional[StrictInt] = None
    llm_choice: Optional[StrictStr] = None
    bot_name: Optional[StrictStr] = None
    bot_description: Optional[StrictStr] = None
    bot_mode: Optional[StrictStr] = None
    bot_knowledge: Optional[StrictStr] = None
    bot_answer_length: Optional[StrictStr] = None
    bot_seed: Optional[StrictInt] = None
    bot_temperature: Optional[Union[StrictFloat, StrictInt]] = None
    prompt: Optional[StrictStr] = None
    number_of_references: Optional[StrictInt] = None
    stream_speed: Optional[Union[StrictFloat, StrictInt]] = None
    initial_message: Optional[StrictStr] = None
    track_geo: Optional[StrictBool] = None
    creation_date: Optional[StrictStr] = None
    use_training: Optional[StrictBool] = None
    embedding_model: Optional[StrictStr] = None
    data_storage_preference: Optional[StrictStr] = None
    logs_visibility_policy: Optional[StrictStr] = None
    dataset_type: Optional[StrictStr] = None
    widget_configs: WidgetConfigs
    n_tokens: Optional[StrictInt] = None
    embedding_model_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["id", "dataset", "username", "index_hash", "do_ocr", "language", "is_updating", "use_reader", "use_ranker", "use_fallback", "top_k_retriever", "top_k_reader", "top_k_ranker", "return_no_ans", "no_ans_boost", "max_seq_len", "doc_stride", "max_ans_len", "weight_title", "weight_text", "split_by", "split_len", "split_overlap", "llm_choice", "bot_name", "bot_description", "bot_mode", "bot_knowledge", "bot_answer_length", "bot_seed", "bot_temperature", "prompt", "number_of_references", "stream_speed", "initial_message", "track_geo", "creation_date", "use_training", "embedding_model", "data_storage_preference", "logs_visibility_policy", "dataset_type", "widget_configs", "n_tokens", "embedding_model_id"]

    @field_validator('data_storage_preference')
    def data_storage_preference_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['store_all', 'discard_all', 'store_anonymized']):
            raise ValueError("must be one of enum values ('store_all', 'discard_all', 'store_anonymized')")
        return value

    @field_validator('logs_visibility_policy')
    def logs_visibility_policy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['show_all', 'show_private', 'show_owner']):
            raise ValueError("must be one of enum values ('show_all', 'show_private', 'show_owner')")
        return value

    @field_validator('dataset_type')
    def dataset_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['default', 'chatbot_playground', 'document_playground']):
            raise ValueError("must be one of enum values ('default', 'chatbot_playground', 'document_playground')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of widget_configs
        if self.widget_configs:
            _dict['widget_configs'] = self.widget_configs.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "dataset": obj.get("dataset"),
            "username": obj.get("username"),
            "index_hash": obj.get("index_hash"),
            "do_ocr": obj.get("do_ocr"),
            "language": obj.get("language"),
            "is_updating": obj.get("is_updating"),
            "use_reader": obj.get("use_reader"),
            "use_ranker": obj.get("use_ranker"),
            "use_fallback": obj.get("use_fallback"),
            "top_k_retriever": obj.get("top_k_retriever"),
            "top_k_reader": obj.get("top_k_reader"),
            "top_k_ranker": obj.get("top_k_ranker"),
            "return_no_ans": obj.get("return_no_ans"),
            "no_ans_boost": obj.get("no_ans_boost"),
            "max_seq_len": obj.get("max_seq_len"),
            "doc_stride": obj.get("doc_stride"),
            "max_ans_len": obj.get("max_ans_len"),
            "weight_title": obj.get("weight_title"),
            "weight_text": obj.get("weight_text"),
            "split_by": obj.get("split_by"),
            "split_len": obj.get("split_len"),
            "split_overlap": obj.get("split_overlap"),
            "llm_choice": obj.get("llm_choice"),
            "bot_name": obj.get("bot_name"),
            "bot_description": obj.get("bot_description"),
            "bot_mode": obj.get("bot_mode"),
            "bot_knowledge": obj.get("bot_knowledge"),
            "bot_answer_length": obj.get("bot_answer_length"),
            "bot_seed": obj.get("bot_seed"),
            "bot_temperature": obj.get("bot_temperature"),
            "prompt": obj.get("prompt"),
            "number_of_references": obj.get("number_of_references"),
            "stream_speed": obj.get("stream_speed"),
            "initial_message": obj.get("initial_message"),
            "track_geo": obj.get("track_geo"),
            "creation_date": obj.get("creation_date"),
            "use_training": obj.get("use_training"),
            "embedding_model": obj.get("embedding_model"),
            "data_storage_preference": obj.get("data_storage_preference"),
            "logs_visibility_policy": obj.get("logs_visibility_policy"),
            "dataset_type": obj.get("dataset_type"),
            "widget_configs": WidgetConfigs.from_dict(obj["widget_configs"]) if obj.get("widget_configs") is not None else None,
            "n_tokens": obj.get("n_tokens"),
            "embedding_model_id": obj.get("embedding_model_id")
        })
        return _obj


