# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DocumentMetadata(BaseModel):
    """
    DocumentMetadata
    """ # noqa: E501
    file_name: Optional[StrictStr] = Field(default=None, alias="fileName")
    original_file_name: Optional[StrictStr] = Field(default=None, alias="originalFileName")
    file_extension: Optional[StrictStr] = Field(default=None, alias="fileExtension")
    file_id: Optional[StrictStr] = Field(default=None, alias="fileId")
    connector_type: Optional[StrictStr] = Field(default=None, alias="connectorType")
    connector_id: Optional[StrictInt] = Field(default=None, alias="connectorId")
    source: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    title: Optional[StrictStr] = None
    additional_fields: Optional[Dict[str, StrictStr]] = Field(default=None, alias="additionalFields")
    do_ocr: Optional[StrictBool] = Field(default=None, alias="doOCR")
    do_llm: Optional[StrictBool] = Field(default=None, alias="doLLM")
    __properties: ClassVar[List[str]] = ["fileName", "originalFileName", "fileExtension", "fileId", "connectorType", "connectorId", "source", "displayName", "title", "additionalFields", "doOCR", "doLLM"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fileName": obj.get("fileName"),
            "originalFileName": obj.get("originalFileName"),
            "fileExtension": obj.get("fileExtension"),
            "fileId": obj.get("fileId"),
            "connectorType": obj.get("connectorType"),
            "connectorId": obj.get("connectorId"),
            "source": obj.get("source"),
            "displayName": obj.get("displayName"),
            "title": obj.get("title"),
            "additionalFields": obj.get("additionalFields"),
            "doOCR": obj.get("doOCR"),
            "doLLM": obj.get("doLLM")
        })
        return _obj


