# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FileFolderModel(BaseModel):
    """
    FileFolderModel
    """ # noqa: E501
    id: StrictStr = Field(description="File/Folder ID")
    name: StrictStr = Field(description="File/Folder name")
    original_file_name: Optional[StrictStr] = Field(default=None, description="Original file name")
    size: Optional[StrictInt] = Field(default=None, description="Size in bytes")
    created: Optional[StrictStr] = Field(default=None, description="Creation date")
    modified: Optional[StrictStr] = Field(default=None, description="Last modified date")
    download_url: Optional[StrictStr] = Field(default=None, description="Download URL", alias="downloadUrl")
    source: Optional[StrictStr] = Field(default=None, description="Source URL")
    drive_id: Optional[StrictStr] = Field(default=None, description="Drive ID")
    site_id: Optional[StrictStr] = Field(default=None, description="Site ID")
    notebook_id: Optional[StrictStr] = Field(default=None, description="Notebook ID")
    section_id: Optional[StrictStr] = Field(default=None, description="Section ID")
    type: Optional[StrictStr] = Field(default=None, description="Type of file/folder")
    is_shared: Optional[StrictBool] = Field(default=None, description="Whether the file is shared or not")
    __properties: ClassVar[List[str]] = ["id", "name", "original_file_name", "size", "created", "modified", "downloadUrl", "source", "drive_id", "site_id", "notebook_id", "section_id", "type", "is_shared"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileFolderModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileFolderModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "original_file_name": obj.get("original_file_name"),
            "size": obj.get("size"),
            "created": obj.get("created"),
            "modified": obj.get("modified"),
            "downloadUrl": obj.get("downloadUrl"),
            "source": obj.get("source"),
            "drive_id": obj.get("drive_id"),
            "site_id": obj.get("site_id"),
            "notebook_id": obj.get("notebook_id"),
            "section_id": obj.get("section_id"),
            "type": obj.get("type"),
            "is_shared": obj.get("is_shared")
        })
        return _obj


