# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FileModel(BaseModel):
    """
    FileModel
    """ # noqa: E501
    account_id: StrictStr
    file_id: StrictStr
    username: StrictStr
    dataset: StrictStr
    display_name: StrictStr
    file_name: StrictStr
    original_file_name: StrictStr
    file_extension: StrictStr
    session_id: Optional[StrictStr] = None
    connector_id: StrictInt
    connector_type: StrictStr
    source: Optional[StrictStr] = None
    status: StrictStr
    failure_reason: Optional[StrictStr] = None
    usage: Optional[StrictInt] = None
    content_empty: Optional[StrictBool] = None
    content_modified: Optional[StrictBool] = None
    creation_date: Optional[StrictStr] = None
    last_modified: Optional[StrictStr] = None
    size: Optional[StrictInt] = Field(default=None, description="Size in bytes")
    n_tokens: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["account_id", "file_id", "username", "dataset", "display_name", "file_name", "original_file_name", "file_extension", "session_id", "connector_id", "connector_type", "source", "status", "failure_reason", "usage", "content_empty", "content_modified", "creation_date", "last_modified", "size", "n_tokens"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Submitted', 'Uploaded', 'Converted', 'Indexed', 'QuotaExceeded', 'Failed', 'MalwareDetected', 'NeedsToBeUploaded']):
            raise ValueError("must be one of enum values ('Submitted', 'Uploaded', 'Converted', 'Indexed', 'QuotaExceeded', 'Failed', 'MalwareDetected', 'NeedsToBeUploaded')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "account_id": obj.get("account_id"),
            "file_id": obj.get("file_id"),
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "display_name": obj.get("display_name"),
            "file_name": obj.get("file_name"),
            "original_file_name": obj.get("original_file_name"),
            "file_extension": obj.get("file_extension"),
            "session_id": obj.get("session_id"),
            "connector_id": obj.get("connector_id"),
            "connector_type": obj.get("connector_type"),
            "source": obj.get("source"),
            "status": obj.get("status"),
            "failure_reason": obj.get("failure_reason"),
            "usage": obj.get("usage"),
            "content_empty": obj.get("content_empty"),
            "content_modified": obj.get("content_modified"),
            "creation_date": obj.get("creation_date"),
            "last_modified": obj.get("last_modified"),
            "size": obj.get("size"),
            "n_tokens": obj.get("n_tokens")
        })
        return _obj


