# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from qanswer_sdk.models.logo import Logo
from typing import Optional, Set
from typing_extensions import Self

class Llm(BaseModel):
    """
    Llm
    """ # noqa: E501
    id: Optional[StrictInt] = None
    python_id: Optional[StrictInt] = Field(default=None, alias="pythonId")
    name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    cost_input_token: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="costInputToken")
    cost_output_token: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="costOutputToken")
    sensitivity_level: Optional[StrictStr] = Field(default=None, alias="sensitivityLevel")
    is_active: Optional[StrictBool] = Field(default=None, alias="isActive")
    logo: Optional[Logo] = None
    organization_llms: Optional[List[OrganizationLlm]] = Field(default=None, alias="organizationLlms")
    user_chatbot_settings: Optional[List[UserChatbotSetting]] = Field(default=None, alias="userChatbotSettings")
    __properties: ClassVar[List[str]] = ["id", "pythonId", "name", "displayName", "costInputToken", "costOutputToken", "sensitivityLevel", "isActive", "logo", "organizationLlms", "userChatbotSettings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Llm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of logo
        if self.logo:
            _dict['logo'] = self.logo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in organization_llms (list)
        _items = []
        if self.organization_llms:
            for _item_organization_llms in self.organization_llms:
                if _item_organization_llms:
                    _items.append(_item_organization_llms.to_dict())
            _dict['organizationLlms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in user_chatbot_settings (list)
        _items = []
        if self.user_chatbot_settings:
            for _item_user_chatbot_settings in self.user_chatbot_settings:
                if _item_user_chatbot_settings:
                    _items.append(_item_user_chatbot_settings.to_dict())
            _dict['userChatbotSettings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Llm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "pythonId": obj.get("pythonId"),
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "costInputToken": obj.get("costInputToken"),
            "costOutputToken": obj.get("costOutputToken"),
            "sensitivityLevel": obj.get("sensitivityLevel"),
            "isActive": obj.get("isActive"),
            "logo": Logo.from_dict(obj["logo"]) if obj.get("logo") is not None else None,
            "organizationLlms": [OrganizationLlm.from_dict(_item) for _item in obj["organizationLlms"]] if obj.get("organizationLlms") is not None else None,
            "userChatbotSettings": [UserChatbotSetting.from_dict(_item) for _item in obj["userChatbotSettings"]] if obj.get("userChatbotSettings") is not None else None
        })
        return _obj

from qanswer_sdk.models.organization_llm import OrganizationLlm
from qanswer_sdk.models.user_chatbot_setting import UserChatbotSetting
# TODO: Rewrite to not use raise_errors
Llm.model_rebuild(raise_errors=False)

